/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.internal;

import zigen.plugin.db.core.TableConstraintColumn;
import zigen.plugin.db.core.TableFKColumn;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.ui.internal.TreeNode;

public class Constraint
extends TreeNode {
    public static final String PRIMARY_KEY = "PRIMARY KEY";
    public static final String FOREGIN_KEY = "FOREGIN KEY";
    private String name;
    private String type = "PRIMARY KEY";
    private String paramater;

    public Constraint(TablePKColumn[] pks) {
        if (pks instanceof TableFKColumn[]) {
            this.type = FOREGIN_KEY;
            this.configure((TableFKColumn[])pks);
        } else {
            this.type = PRIMARY_KEY;
            this.configure(pks);
        }
    }

    public Constraint(TableConstraintColumn[] cons) {
        this.configure(cons);
    }

    private void configure(TablePKColumn[] pks) {
        if (pks != null && pks.length > 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            i = 0;
            while (i < pks.length) {
                TablePKColumn pkc = pks[i];
                if (i == 0) {
                    this.name = pkc.getName();
                    sb.append("(");
                    sb.append(pkc.getColumnName());
                } else {
                    sb.append(", " + pkc.getColumnName());
                }
                ++i;
            }
            sb.append(")");
            this.paramater = sb.toString();
        }
    }

    private void configure(TableFKColumn[] fks) {
        if (fks != null && fks.length > 0) {
            boolean cascade = false;
            StringBuffer sb = new StringBuffer();
            StringBuffer sb2 = new StringBuffer();
            int i = 0;
            i = 0;
            while (i < fks.length) {
                TableFKColumn column = fks[i];
                cascade = column.isCasucade();
                if (i == 0) {
                    this.name = column.getName();
                    sb.append("(");
                    sb.append(column.getColumnName());
                    sb2.append(" REFERENCES ");
                    if (column.getPkSchema() != null) {
                        sb2.append(column.getPkSchema());
                        sb2.append(".");
                    }
                    sb2.append(column.getPkTableName());
                    sb2.append(" ");
                    sb2.append("(");
                    sb2.append(column.getPkColumnName());
                } else {
                    sb.append(", " + column.getColumnName());
                    sb2.append(", " + column.getColumnName());
                }
                ++i;
            }
            sb.append(")");
            sb2.append(")");
            if (cascade) {
                sb2.append(" ON DELETE CASCADE");
            }
            this.paramater = String.valueOf(sb.toString()) + sb2.toString();
        }
    }

    private void configure(TableConstraintColumn[] cons) {
        if (cons != null && cons.length > 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            i = 0;
            while (i < cons.length) {
                TableConstraintColumn column = cons[i];
                if (i == 0) {
                    if (column.getColumnName() == null && !"".equals(column.getSearch_condition())) {
                        this.name = column.getName();
                        this.type = "CHECK";
                        this.paramater = "(" + column.getSearch_condition() + ")";
                        return;
                    }
                    this.name = column.getName();
                    this.type = column.isNonUnique() ? "NONUNIQUE" : "UNIQUE";
                    sb.append("(");
                    sb.append(column.getColumnName());
                } else {
                    sb.append(", " + column.getColumnName());
                }
                ++i;
            }
            sb.append(")");
            this.paramater = sb.toString();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getParamater() {
        return this.paramater;
    }

    public String getType() {
        return this.type;
    }
}

