/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.sql;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.commands.ICommandService;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.IStatusChangeListener;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.csv.CreateCSVForQueryAction;
import zigen.plugin.db.ui.actions.CopyRecordDataAction;
import zigen.plugin.db.ui.actions.GlobalAction;
import zigen.plugin.db.ui.actions.SelectAllRecordAction;
import zigen.plugin.db.ui.editors.IQueryViewEditor;
import zigen.plugin.db.ui.editors.ITableViewEditor;
import zigen.plugin.db.ui.editors.TableViewContentProvider;
import zigen.plugin.db.ui.editors.TableViewLabelProvider;
import zigen.plugin.db.ui.editors.TextCellEditor;
import zigen.plugin.db.ui.editors.event.TableKeyAdapter;
import zigen.plugin.db.ui.editors.event.TableKeyEventHandler;
import zigen.plugin.db.ui.editors.event.TableSortListener;
import zigen.plugin.db.ui.editors.internal.CellEditorType;
import zigen.plugin.db.ui.editors.sql.SQLSourceViewer2;
import zigen.plugin.db.ui.editors.sql.SqlEditor;
import zigen.plugin.db.ui.editors.sql.SqlEditorContributor;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.jobs.ChangeColorJob;
import zigen.plugin.db.ui.views.StatusLineContributionItem;
import zigen.plugin.db.ui.views.internal.SQLOutinePage;
import zigen.plugin.db.ui.views.internal.SQLToolBarForSqlEditor;

public class SqlEditor2
extends SqlEditor
implements ITableViewEditor,
IQueryViewEditor,
IStatusChangeListener,
IDocumentListener {
    private ImageCacher ic = ImageCacher.getInstance();
    private Table table;
    private TableViewer viewer;
    private TableElement[] elements;
    private String query;
    private TableSortListener sortListener;
    protected StatusLineContributionItem responseTimeItem;
    protected String responseTime;
    protected SelectAllRecordAction selectAllRecordAction;
    protected CopyRecordDataAction copyAction;
    protected CreateCSVForQueryAction createCSVForQueryAction;
    protected ChangeColorJob changeColorJob;
    protected Label infoLabel;
    TableKeyEventHandler handler;
    CellEditor[] cellEditors;
    SashForm sash;
    int[] defaultWeight = new int[]{700, 300};
    boolean isFocusResultView = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.setDirty(true);
    }

    public void createPartControl(Composite parent) {
        this.sash = new SashForm(parent, 512);
        super.createPartControl((Composite)this.sash);
        this.createResultPartControl();
        this.makeActions();
        this.getSqlViewer().getDocument().addDocumentListener((IDocumentListener)this);
    }

    private void makeActions() {
        this.selectAllRecordAction = new SelectAllRecordAction();
        this.copyAction = new CopyRecordDataAction();
        this.createCSVForQueryAction = new CreateCSVForQueryAction();
        this.selectAllRecordAction.setActiveEditor(this);
        this.copyAction.setActiveEditor(this);
        this.createCSVForQueryAction.setActiveEditor(this);
    }

    public int getOffset() {
        return this.getSourceViewer().getTextWidget().getCaretOffset();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        FormLayout layout = new FormLayout();
        parent.setLayout((Layout)layout);
        this.toolBar = new SQLToolBarForSqlEditor((IEditorPart)this);
        this.toolBar.createPartControl(parent);
        Composite sqlComposite = new Composite(parent, 0);
        sqlComposite.setLayout((Layout)new FillLayout());
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.toolBar.getCoolBar(), 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        sqlComposite.setLayoutData((Object)data);
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        SQLSourceViewer2 viewer = new SQLSourceViewer2(sqlComposite, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        viewer.setSqlEditor(this);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        viewer.getTextWidget().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                IActionBars bars = SqlEditor2.this.getEditorSite().getActionBars();
                SqlEditor2.this.setGlobalActionForEditor(bars);
                bars.updateActionBars();
                SqlEditor2.this.isFocusResultView = false;
            }
        });
        return viewer;
    }

    public void createResultPartControl() {
        this.table = new Table((Composite)this.sash, 68354);
        GridData gridData2 = new GridData(1808);
        this.table.setLayoutData((Object)gridData2);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setFont(DbPlugin.getDefaultFont());
        this.viewer = new TableViewer(this.table);
        this.setHeaderColumn(this.table);
        this.viewer.setContentProvider((IContentProvider)new TableViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableViewLabelProvider());
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B) {
                    int row = SqlEditor2.this.handler.getSelectedRow();
                    SqlEditor2.this.handler.editTableElement(row, 1);
                }
            }
        });
        this.table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (SqlEditor2.this.table.getSelectionIndex() == -1) {
                    SqlEditor2.this.table.select(0);
                    SqlEditor2.this.table.notifyListeners(13, null);
                }
                IActionBars bars = SqlEditor2.this.getEditorSite().getActionBars();
                SqlEditor2.this.setGlobalActionForResultView(bars);
                bars.updateActionBars();
                SqlEditor2.this.isFocusResultView = true;
            }

            public void focusLost(FocusEvent e) {
                SqlEditor2.this.table.deselectAll();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                SqlEditor2.this.selectionChangeHandler(e);
            }
        });
        this.viewer.setInput((Object)this.elements);
        this.changeColorJob = new ChangeColorJob(this.table);
        this.changeColorJob.setPriority(30);
        this.changeColorJob.setUser(false);
        this.changeColorJob.schedule();
        this.handler = new TableKeyEventHandler(this);
        this.setCellModify(this.viewer, this.handler);
        this.columnsPack(this.table);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.table.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                int[] weight = SqlEditor2.this.sash.getWeights();
                if (weight[0] != 1000) {
                    SqlEditor2.this.defaultWeight = SqlEditor2.this.sash.getWeights();
                }
            }

            public void controlResized(ControlEvent e) {
            }
        });
        if (this.elements == null) {
            this.setResultVisible(false);
        } else {
            this.setResultVisible(true);
        }
        this.hookContextMenu();
    }

    void setGlobalActionForEditor(IActionBars bars) {
        bars.clearGlobalActionHandlers();
        this.copyAction.refresh();
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new GlobalAction((TextViewer)this.sqlViewer, 4));
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)new GlobalAction((TextViewer)this.sqlViewer, 7));
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)new GlobalAction((TextViewer)this.sqlViewer, 7));
        bars.setGlobalActionHandler("zigen.plugin.db.actions.SQLExecuteAction", (IAction)new GlobalAction((TextViewer)this.sqlViewer, 1003));
        bars.setGlobalActionHandler("zigen.plugin.db.actions.SQLCurrentExecuteAction", (IAction)new GlobalAction((TextViewer)this.sqlViewer, 1004));
        bars.setGlobalActionHandler("zigen.plugin.db.actions.SQLSelectedExecuteAction", (IAction)new GlobalAction((TextViewer)this.sqlViewer, 1005));
        bars.updateActionBars();
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.commands.ICommandService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICommandService commandService = (ICommandService)iWorkbenchPartSite.getService((Class)clazz);
        Command copy = commandService.getCommand("org.eclipse.ui.edit.copy");
        copy.setHandler((IHandler)new ActionHandler((IAction)new GlobalAction((TextViewer)this.sqlViewer, 4)));
        Command select = commandService.getCommand("org.eclipse.ui.edit.selectAll");
        select.setHandler((IHandler)new ActionHandler((IAction)new GlobalAction((TextViewer)this.sqlViewer, 7)));
    }

    void setGlobalActionForResultView(IActionBars bars) {
        bars.clearGlobalActionHandlers();
        this.copyAction.refresh();
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.selectAllRecordAction);
        bars.updateActionBars();
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.commands.ICommandService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICommandService commandService = (ICommandService)iWorkbenchPartSite.getService((Class)clazz);
        Command copy = commandService.getCommand("org.eclipse.ui.edit.copy");
        copy.setHandler((IHandler)new ActionHandler((IAction)this.copyAction));
        Command select = commandService.getCommand("org.eclipse.ui.edit.selectAll");
        select.setHandler((IHandler)new ActionHandler((IAction)this.selectAllRecordAction));
    }

    private void setCellModify(TableViewer viewer, TableKeyEventHandler handler) {
        if (this.elements == null) {
            return;
        }
        final IActionBars bars = this.getEditorSite().getActionBars();
        TableElement element = this.elements[0];
        int size = element.getColumns().length + 1;
        String[] properties = new String[size];
        element.getColumns();
        this.cellEditors = new CellEditor[size];
        TableKeyAdapter keyAdapter = new TableKeyAdapter(handler);
        int i = 0;
        while (i < this.cellEditors.length) {
            properties[i] = String.valueOf(i);
            if (i > 0) {
                TextCellEditor cellEditor = new TextCellEditor(this.table, i);
                if (cellEditor.getControl() instanceof Text) {
                    Text txt = (Text)cellEditor.getControl();
                    txt.setEditable(false);
                }
                cellEditor.getControl().addKeyListener((KeyListener)keyAdapter);
                cellEditor.getControl().addTraverseListener((TraverseListener)keyAdapter);
                cellEditor.getControl().addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusGained(FocusEvent e) {
                        bars.clearGlobalActionHandlers();
                        bars.updateActionBars();
                    }

                    public void focusLost(FocusEvent e) {
                    }
                });
                this.cellEditors[i] = cellEditor;
            }
            ++i;
        }
        viewer.setColumnProperties(properties);
        viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                int index = Integer.parseInt(property);
                if (element instanceof TableElement) {
                    TableElement elem = (TableElement)element;
                    Object obj = elem.getItems()[index - 1];
                    if (obj != null) {
                        if (obj instanceof String) {
                            return (String)obj;
                        }
                        return CellEditorType.getDataTypeName(elem.getColumns()[index]);
                    }
                    return "";
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
            }
        });
        viewer.setCellEditors(this.cellEditors);
    }

    public void refleshAction() {
        this.copyAction.refresh();
    }

    void selectionChangeHandler(SelectionChangedEvent event) {
        this.refleshAction();
    }

    private void setHeaderColumn(Table table) {
        if (this.elements != null) {
            TableColumn row = new TableColumn(table, 131072);
            this.sortListener = new TableSortListener(this, 0);
            row.addSelectionListener((SelectionListener)this.sortListener);
            row.pack();
            TableElement element = this.elements[0];
            zigen.plugin.db.core.TableColumn[] columns = element.getColumns();
            int i = 0;
            while (i < columns.length) {
                zigen.plugin.db.core.TableColumn tColumn = columns[i];
                TableColumn col = new TableColumn(table, 16384);
                col.setText(tColumn.getColumnName());
                col.addSelectionListener((SelectionListener)new TableSortListener(this, i + 1));
                col.pack();
                ++i;
            }
        }
    }

    private void columnsPack(Table table) {
        table.setVisible(false);
        TableColumn[] cols = table.getColumns();
        int i = 0;
        while (i < cols.length) {
            cols[i].pack();
            ++i;
        }
        table.setVisible(true);
    }

    public void changeColumnColor() {
        throw new UnsupportedOperationException("\u672a\u5b9f\u88c5\u3067\u3059");
    }

    public void changeColumnColor(Column column) {
        throw new UnsupportedOperationException("\u672a\u5b9f\u88c5\u3067\u3059");
    }

    public void editTableElement(Object element, int column) {
        throw new UnsupportedOperationException("\u672a\u5b9f\u88c5\u3067\u3059");
    }

    public String getCondition() {
        throw new UnsupportedOperationException("\u672a\u5b9f\u88c5\u3067\u3059");
    }

    public IDBConfig getDBConfig() {
        return super.getConfig();
    }

    public TableElement getHeaderTableElement() {
        if (this.elements.length > 0) {
            return this.elements[0];
        }
        return null;
    }

    public ITable getTableNode() {
        return null;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void setEnabled(boolean enabled) {
        throw new UnsupportedOperationException("\u672a\u5b9f\u88c5\u3067\u3059");
    }

    public void setTotalCount(int dispCount, long totalCount) {
    }

    public void setResultVisible(boolean visibled) {
        if (visibled) {
            this.sash.setWeights(this.defaultWeight);
        } else {
            int[] nArray = new int[2];
            nArray[0] = 100;
            this.sash.setWeights(nArray);
        }
    }

    public void update(String query, TableElement[] elements, String responseTime, boolean isReload) {
        try {
            this.query = query;
            this.elements = elements;
            this.table.dispose();
            this.createResultPartControl();
            this.sash.layout(true);
            this.sash.getParent().layout(true);
            int dispCnt = elements.length - 1;
            this.setTotalCount(dispCnt, -1L);
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    public String getQuery() {
        return this.query;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (SqlEditor2.this.isFocusResultView) {
                    SqlEditor2.this.getContributor().fillContextMenuForResultView(manager);
                } else {
                    SqlEditor2.this.getContributor().fillContextMenu(manager);
                }
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.add((IContributionItem)new Separator());
    }

    private SqlEditorContributor getContributor() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof SqlEditorContributor) {
            return (SqlEditorContributor)contributor;
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            if (this.outlinePage == null) {
                this.outlinePage = new SQLOutinePage(this);
            }
            return this.outlinePage;
        }
        return super.getAdapter(adapter);
    }

    public int getRecordLimit() {
        return 0;
    }

    public int getRecordOffset() {
        return 0;
    }
}

