/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.internal.wizard;

import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.editors.event.TextSelectionListener;
import zigen.plugin.db.ui.editors.internal.wizard.DefaultWizardPage;
import zigen.plugin.db.ui.editors.internal.wizard.Messages;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class ColumnWizardPage
extends DefaultWizardPage {
    public static final String MSG_DSC = "";
    protected ISQLCreatorFactory factory;
    protected ITable table;
    private Column column;
    private Column newColumn;
    Text txtColumnName;
    Text txtColumnComment;
    Text txtDefualtt;
    Combo cmbColumnType;
    Text txtColumnSize;
    Button chkNotNull;
    boolean isAddColumn = false;

    public ColumnWizardPage(ISQLCreatorFactory factory, ITable table, Column column, boolean isAddColumn) {
        super("wizardPage");
        if (isAddColumn) {
            super.setTitle(Messages.getString("ColumnWizardPage1.2"));
        } else {
            super.setTitle(Messages.getString("ColumnWizardPage1.3"));
        }
        this.factory = factory;
        this.table = table;
        this.column = column;
        this.isAddColumn = isAddColumn;
    }

    public void createControl(Composite parent) {
        Composite container = this.createDefaultComposite(parent);
        this.createNameConstrol(container);
        this.setControl((Control)container);
    }

    protected void createNameConstrol(Composite container) {
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("ColumnWizardPage1.4"));
        GridData gd = new GridData(768);
        this.txtColumnName = new Text(composite, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.txtColumnName.setLayoutData((Object)gd);
        this.txtColumnName.setText(this.column.getName());
        this.txtColumnName.addFocusListener((FocusListener)new TextSelectionListener());
        if (!this.isAddColumn & 6 == DBType.getType(this.table.getDbConfig())) {
            this.txtColumnName.setEnabled(false);
        }
        label = new Label(composite, 0);
        label.setText(Messages.getString("ColumnWizardPage1.5"));
        this.txtColumnComment = new Text(composite, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.txtColumnComment.setLayoutData((Object)gd);
        if (this.factory.supportsRemarks()) {
            this.txtColumnComment.setText(this.column.getRemarks());
            this.txtColumnComment.addFocusListener((FocusListener)new TextSelectionListener());
        } else {
            this.txtColumnComment.setEnabled(false);
        }
        label = new Label(composite, 0);
        label.setText(Messages.getString("ColumnWizardPage1.6"));
        this.cmbColumnType = new Combo(composite, 0);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.cmbColumnType.setLayoutData((Object)gd);
        this.cmbColumnType.setVisibleItemCount(20);
        int i = 0;
        while (i < this.factory.getSupportColumnType().length) {
            this.cmbColumnType.add(this.factory.getSupportColumnType()[i]);
            ++i;
        }
        this.cmbColumnType.setText(this.column.getTypeName());
        if (this.cmbColumnType.getSelectionIndex() > 0) {
            this.cmbColumnType.add(this.column.getTypeName());
        }
        if (!this.isAddColumn && !this.factory.supportsModifyColumnType()) {
            this.cmbColumnType.setEnabled(false);
        }
        label = new Label(composite, 0);
        label.setText(Messages.getString("ColumnWizardPage1.7"));
        this.txtColumnSize = new Text(composite, 2048);
        this.txtColumnSize.addFocusListener((FocusListener)new TextSelectionListener());
        gd = new GridData();
        gd.widthHint = 100;
        this.txtColumnSize.setLayoutData((Object)gd);
        this.txtColumnSize.setText(this.column.getSize());
        if (!this.isAddColumn && !this.factory.supportsModifyColumnSize(this.cmbColumnType.getText())) {
            this.txtColumnSize.setEnabled(false);
        }
        this.chkNotNull = new Button(composite, 32);
        this.chkNotNull.setText(Messages.getString("ColumnWizardPage1.8"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.chkNotNull.setLayoutData((Object)gd);
        this.chkNotNull.setSelection(this.column.isNotNull());
        label = new Label(composite, 0);
        label.setText(Messages.getString("ColumnWizardPage1.9"));
        this.txtDefualtt = new Text(composite, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.txtDefualtt.setLayoutData((Object)gd);
        this.txtDefualtt.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
            }
        });
        this.txtDefualtt.setText(this.column.getDefaultValue());
        this.txtDefualtt.addFocusListener((FocusListener)new TextSelectionListener());
        new Label(composite, 0);
        Label label2 = new Label(composite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.txtDefualtt.setLayoutData((Object)gd);
        label2.setLayoutData((Object)gd);
        label2.setText(Messages.getString("ColumnWizardPage1.10"));
        this.txtColumnName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColumnWizardPage.this.validate();
            }
        });
        this.txtColumnComment.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColumnWizardPage.this.validate();
            }
        });
        this.cmbColumnType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnWizardPage.this.validate();
                if (ColumnWizardPage.this.txtColumnSize != null) {
                    ColumnWizardPage.this.txtColumnSize.setEnabled(ColumnWizardPage.this.factory.isVisibleColumnSize(ColumnWizardPage.this.cmbColumnType.getText()));
                }
            }
        });
        this.cmbColumnType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColumnWizardPage.this.validate();
                if (ColumnWizardPage.this.txtColumnSize != null) {
                    ColumnWizardPage.this.txtColumnSize.setEnabled(ColumnWizardPage.this.factory.isVisibleColumnSize(ColumnWizardPage.this.cmbColumnType.getText()));
                }
            }
        });
        this.txtColumnSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColumnWizardPage.this.validate();
            }
        });
        this.chkNotNull.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnWizardPage.this.validate();
            }
        });
        this.txtDefualtt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColumnWizardPage.this.validate();
            }
        });
        this.cmbColumnType.notifyListeners(13, null);
    }

    protected void createOptionControl(Composite container) {
    }

    private void validate() {
        if (MSG_DSC.equals(this.txtColumnName.getText())) {
            this.updateStatus(Messages.getString("ColumnWizardPage1.12"));
        } else if (MSG_DSC.equals(this.cmbColumnType.getText())) {
            this.updateStatus(Messages.getString("ColumnWizardPage1.14"));
        } else if (this.modified()) {
            this.updateStatus(null);
        } else {
            this.setPageComplete(false);
        }
    }

    private boolean modified() {
        return !this.column.getName().equals(this.txtColumnName.getText().trim()) || !this.column.getRemarks().equals(this.txtColumnComment.getText().trim()) || !this.column.getTypeName().equals(this.cmbColumnType.getText()) || !this.column.getSize().equals(this.txtColumnSize.getText().trim()) || this.column.isNotNull() != this.chkNotNull.getSelection() || !this.column.getDefaultValue().equals(this.txtDefualtt.getText().trim());
    }

    protected void setHeaderColumn(Table table) {
        TableColumn col1 = new TableColumn(table, 0);
        col1.setText("dummy");
        col1.pack();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setDescription(MSG_DSC);
        }
    }
}

