/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.internal.wizard;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.MatchingCharacterPainter;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.editors.event.TextSelectionListener;
import zigen.plugin.db.ui.editors.internal.wizard.DefaultWizardPage;
import zigen.plugin.db.ui.editors.internal.wizard.Messages;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.util.LineNumberRulerColumnUtil;
import zigen.plugin.db.ui.util.StyledTextUtil;
import zigen.plugin.db.ui.views.internal.ColorManager;
import zigen.plugin.db.ui.views.internal.SQLCharacterPairMatcher;
import zigen.plugin.db.ui.views.internal.SQLCodeConfiguration;
import zigen.plugin.db.ui.views.internal.SQLDocument;

public class CheckWizardPage
extends DefaultWizardPage {
    public static final String MSG_DSC = Messages.getString("CheckWizardPage.0");
    private static final String MSG_REQUIRE_NAME = Messages.getString("CheckWizardPage.1");
    private static final String MSG_REQUIRE_CHECK = Messages.getString("CheckWizardPage.2");
    protected ISQLCreatorFactory factory;
    protected ITable tableNode;
    protected Text txtConstraintName;
    protected SourceViewer sqlViewer;
    protected LineNumberRulerColumn rulerCol;
    protected SQLCodeConfiguration sqlConfiguration;
    protected ColorManager colorManager = new ColorManager();

    public CheckWizardPage(ISQLCreatorFactory factory, ITable table) {
        super("wizardPage");
        this.setTitle(Messages.getString("CheckWizardPage.4"));
        this.factory = factory;
        this.tableNode = table;
    }

    public void createControl(Composite parent) {
        Composite container = this.createDefaultComposite(parent);
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("CheckWizardPage.5"));
        this.txtConstraintName = new Text(composite, 2048);
        GridData gd = new GridData(768);
        this.txtConstraintName.setLayoutData((Object)gd);
        this.txtConstraintName.setText("");
        this.txtConstraintName.addFocusListener((FocusListener)new TextSelectionListener());
        this.txtConstraintName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if ("".equals(CheckWizardPage.this.txtConstraintName.getText())) {
                    CheckWizardPage.this.updateStatus(MSG_REQUIRE_NAME);
                } else if ("".equals(CheckWizardPage.this.sqlViewer.getDocument().get().trim())) {
                    CheckWizardPage.this.updateStatus(MSG_REQUIRE_CHECK);
                } else {
                    CheckWizardPage.this.updateStatus(null);
                }
            }
        });
        Composite main = new Composite(container, 2048);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        main.setLayoutData((Object)gd);
        main.setLayout((Layout)new FillLayout());
        CompositeRuler ruler = new CompositeRuler();
        this.rulerCol = new LineNumberRulerColumn();
        LineNumberRulerColumnUtil.changeColor(this.colorManager, this.rulerCol);
        ruler.addDecorator(0, (IVerticalRulerColumn)this.rulerCol);
        this.sqlViewer = new SourceViewer(main, (IVerticalRuler)ruler, 2818);
        this.sqlViewer.addTextListener((ITextListener)new TextListener());
        this.initializeViewerFont((ISourceViewer)this.sqlViewer);
        this.sqlConfiguration = new SQLCodeConfiguration(this.colorManager);
        this.sqlViewer.configure((SourceViewerConfiguration)this.sqlConfiguration);
        this.sqlViewer.setDocument((IDocument)new SQLDocument());
        SourceViewer extension = this.sqlViewer;
        MatchingCharacterPainter painter = new MatchingCharacterPainter((ISourceViewer)this.sqlViewer, (ICharacterPairMatcher)new SQLCharacterPairMatcher());
        painter.setColor(this.colorManager.getColor("SQLEditorPreferencePage.ColorMatching"));
        extension.addPainter((IPainter)painter);
        StyledTextUtil.changeColor(this.colorManager, this.sqlViewer.getTextWidget());
        this.setControl((Control)container);
    }

    protected void initializeViewerFont(ISourceViewer viewer) {
        StyledText styledText = viewer.getTextWidget();
        styledText.setFont(DbPlugin.getDefaultFont());
    }

    protected void update() {
        if ("".equals(this.txtConstraintName.getText())) {
            this.updateStatus(MSG_REQUIRE_NAME);
        } else if ("".equals(this.sqlViewer.getDocument().get().trim())) {
            this.updateStatus(MSG_REQUIRE_CHECK);
        } else {
            this.updateStatus(null);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setDescription(MSG_DSC);
            this.update();
        }
    }

    private class TextListener
    implements ITextListener {
        private TextListener() {
        }

        public void textChanged(TextEvent event) {
            CheckWizardPage.this.update();
        }
    }
}

