/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.internal;

import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.OracleColumn;

public class ColumnFilterInfo {
    private Column column;
    private TableColumn fTableColumn;
    private boolean checked = true;
    private int sortNo = 0;
    private boolean isDesc = false;

    public ColumnFilterInfo(Column col) {
        this.column = col;
        this.fTableColumn = col.getColumn();
    }

    public ColumnFilterInfo() {
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public String getColumnName() {
        return this.fTableColumn.getColumnName();
    }

    public String getTypeName() {
        return this.fTableColumn.getTypeName().toLowerCase();
    }

    public String getSize() {
        return this.column.getSize();
    }

    public boolean isNotNull() {
        return this.fTableColumn.isNotNull();
    }

    public boolean isPrimaryKey() {
        return this.column.getPkColumn() != null;
    }

    public String getDefaultValue() {
        return this.fTableColumn.getDefaultValue();
    }

    public String getCommentName() {
        if (this.column instanceof OracleColumn) {
            return ((OracleColumn)this.column).getColumn().getRemarks();
        }
        return this.column.getRemarks();
    }

    public int getSortNo() {
        return this.sortNo;
    }

    public void setSortNo(int sortNo) {
        this.sortNo = sortNo;
    }

    public boolean isDesc() {
        return this.isDesc;
    }

    public void setDesc(boolean isDesc) {
        this.isDesc = isDesc;
    }

    public Column getColumn() {
        return this.column;
    }

    public void setColumn(Column col) {
        this.column = col;
        this.fTableColumn = col.getColumn();
    }
}

