/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.event;

import java.math.BigDecimal;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.ui.editors.ITableViewEditor;

public class TableSortListener
extends SelectionAdapter {
    protected ImageCacher ic = ImageCacher.getInstance();
    protected ITableViewEditor editor = null;
    protected boolean desc = true;
    protected int columnIndex;
    protected TableColumn col;

    public TableSortListener(ITableViewEditor editor, int columnIndex) {
        this.editor = editor;
        this.columnIndex = columnIndex;
        this.col = editor.getViewer().getTable().getColumn(columnIndex);
    }

    public void widgetSelected(SelectionEvent e) {
        TableColumn col = (TableColumn)e.widget;
        Table table = col.getParent();
        if (!this.desc) {
            this.editor.getViewer().setSorter((ViewerSorter)new TableColumnSorter(this.columnIndex, this.desc));
            this.desc = true;
            try {
                table.setSortColumn(col);
                table.setSortDirection(128);
            }
            catch (Throwable throwable) {}
        } else {
            this.editor.getViewer().setSorter((ViewerSorter)new TableColumnSorter(this.columnIndex, this.desc));
            this.desc = false;
            try {
                table.setSortColumn(col);
                table.setSortDirection(1024);
            }
            catch (Throwable throwable) {}
        }
        this.editor.changeColumnColor();
    }

    protected class TableColumnSorter
    extends ViewerSorter {
        boolean isDesc = false;
        int index;

        public TableColumnSorter(int index, boolean isDesc) {
            this.index = index;
            this.isDesc = isDesc;
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            TableElement first = (TableElement)o1;
            TableElement second = (TableElement)o2;
            if (first.isNew() && second.isNew()) {
                return 0;
            }
            if (first.isNew()) {
                return 1;
            }
            if (second.isNew()) {
                return -1;
            }
            if (this.index == 0) {
                int no2;
                int no1 = first.getRecordNo();
                if (no1 < (no2 = second.getRecordNo())) {
                    if (this.isDesc) {
                        return 1;
                    }
                    return -1;
                }
                if (no1 > no2) {
                    if (this.isDesc) {
                        return -1;
                    }
                    return 1;
                }
                return 0;
            }
            String v1 = (String)first.getItems()[this.index - 1];
            String v2 = (String)second.getItems()[this.index - 1];
            try {
                BigDecimal d1 = new BigDecimal(v1);
                BigDecimal d2 = new BigDecimal(v2);
                if (this.isDesc) {
                    return d2.compareTo(d1);
                }
                return d1.compareTo(d2);
            }
            catch (NumberFormatException numberFormatException) {
                if (this.isDesc) {
                    return v2.compareTo(v1);
                }
                return v1.compareTo(v2);
            }
        }
    }
}

