/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.rule.AbstractMappingFactory;
import zigen.plugin.db.core.rule.IMappingFactory;
import zigen.plugin.db.ui.editors.ITableViewEditor;
import zigen.plugin.db.ui.editors.LobViewDialog;
import zigen.plugin.db.ui.editors.event.TableKeyEventHandler;
import zigen.plugin.db.ui.editors.internal.CellEditorType;
import zigen.plugin.db.ui.editors.internal.ColumnFilterInfo;
import zigen.plugin.db.ui.editors.internal.FileCellEditor;
import zigen.plugin.db.ui.internal.ITable;

public class CellModifier
implements ICellModifier {
    protected ITableViewEditor editor;
    protected ITable table;
    protected TableViewer viewer;
    protected Object oldValue = null;
    protected Object newValue = null;
    protected IMappingFactory factory;
    protected ColumnFilterInfo[] filterInfos;
    TableKeyEventHandler handler = null;

    public CellModifier(ITableViewEditor editor, ColumnFilterInfo[] filterInfos, TableKeyEventHandler handler) {
        if (handler == null) {
            System.err.println("TableKeyEventHandler is null !!");
        }
        this.editor = editor;
        this.table = editor.getTableNode();
        this.viewer = editor.getViewer();
        this.factory = AbstractMappingFactory.getFactory(this.table.getDbConfig());
        this.filterInfos = filterInfos;
        this.handler = handler;
    }

    public boolean canModify(Object element, String property) {
        TableElement elem;
        int index = Integer.parseInt(property);
        if (index == 0) {
            return false;
        }
        if (element instanceof TableElement && (elem = (TableElement)element).isCanModify()) {
            ColumnFilterInfo info = this.filterInfos[index - 1];
            if (!info.isChecked()) {
                return false;
            }
            TableColumn col = elem.getColumns()[index - 1];
            if (elem.isNew()) {
                switch (col.getDataType()) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: 
                    case 2005: {
                        return false;
                    }
                }
            }
            return this.factory.canModifyDataType(col.getDataType());
        }
        return false;
    }

    public Object getValue(Object element, String property) {
        int index = Integer.parseInt(property);
        if (element instanceof TableElement) {
            TableElement elem = (TableElement)element;
            Object obj = elem.getItems()[index - 1];
            if (obj != null) {
                if (obj instanceof String) {
                    this.oldValue = (String)obj;
                    return this.oldValue;
                }
                return CellEditorType.getDataTypeName(elem.getColumns()[index]);
            }
            this.oldValue = "";
            return "";
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void modify(Object element, String property, Object value) {
        if (value == null) {
            value = "";
        }
        TableElement tableElement = this.getTableElement(element);
        this.newValue = value;
        if (value instanceof FileCellEditor) {
            FileCellEditor fc = (FileCellEditor)((Object)value);
            if (fc.isOpened()) return;
            fc.setOpened(true);
            Shell shell = this.viewer.getControl().getShell();
            int colIndex = Integer.parseInt(property);
            try {
                LobViewDialog v = new LobViewDialog(shell, tableElement, colIndex);
                v.open();
                fc.setOpened(false);
                return;
            }
            catch (Exception e) {
                DbPlugin.log(e);
                return;
            }
        } else {
            if (this.oldValue == null) return;
            int col = Integer.parseInt(property);
            if (tableElement.isNew()) {
                this.handler.updateColumn(tableElement, col, value);
                return;
            } else {
                if (this.oldValue.equals(this.newValue) && !tableElement.isModify()) return;
                if (!tableElement.isUpdatedDataBase()) {
                    this.handler.updateColumn(tableElement, col, value);
                    return;
                } else {
                    tableElement.setUpdatedDataBase(false);
                }
            }
        }
    }

    private TableElement getTableElement(Object obj) {
        Object o;
        if (obj instanceof Item && (o = ((Item)obj).getData()) instanceof TableElement) {
            return (TableElement)o;
        }
        return null;
    }
}

