/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.contentassist.processor;

import java.util.ArrayList;
import java.util.List;
import zigen.plugin.db.DbPluginFormatRule;
import zigen.plugin.db.core.TableInfo;
import zigen.plugin.db.parser.util.ASTUtil2;
import zigen.plugin.db.ui.contentassist.ContentAssistUtil;
import zigen.plugin.db.ui.contentassist.ContentInfo;
import zigen.plugin.db.ui.contentassist.ProcessorInfo;
import zigen.plugin.db.ui.contentassist.SQLProposalCreator2;
import zigen.plugin.db.ui.contentassist.processor.Messages;
import zigen.plugin.db.ui.internal.Column;
import zigen.sql.parser.INode;
import zigen.sql.parser.ast.ASTAlias;
import zigen.sql.parser.ast.ASTColumn;
import zigen.sql.parser.ast.ASTComma;
import zigen.sql.parser.ast.ASTDeleteStatement;
import zigen.sql.parser.ast.ASTFrom;
import zigen.sql.parser.ast.ASTInsertStatement;
import zigen.sql.parser.ast.ASTInto;
import zigen.sql.parser.ast.ASTParentheses;
import zigen.sql.parser.ast.ASTSelect;
import zigen.sql.parser.ast.ASTSelectStatement;
import zigen.sql.parser.ast.ASTTable;
import zigen.sql.parser.ast.ASTUnion;
import zigen.sql.parser.ast.ASTUpdateStatement;

public class DefaultProcessor {
    protected List proposals;
    protected ProcessorInfo pinfo;
    protected String wordGroup;
    protected String word;
    protected int offset;
    protected boolean isAfterPeriod;
    protected int currentScope;
    protected INode currentNode;
    protected DbPluginFormatRule rule;

    public DefaultProcessor(List proposals, ProcessorInfo pinfo) {
        this.proposals = proposals;
        this.pinfo = pinfo;
        this.wordGroup = pinfo.getWordGroup();
        this.word = pinfo.getWord();
        this.offset = pinfo.getOffset();
        this.isAfterPeriod = pinfo.isAfterPeriod();
        this.currentScope = pinfo.getCurrentScope();
        this.currentNode = pinfo.getCurrentNode();
        this.rule = DbPluginFormatRule.getInstance();
    }

    protected ASTSelectStatement findParentASTSelectStatement(INode node) {
        return (ASTSelectStatement)ASTUtil2.findParent(node, "ASTSelectStatement");
    }

    protected ASTInsertStatement findParentASTInsertStatement(INode node) {
        return (ASTInsertStatement)ASTUtil2.findParent(node, "ASTInsertStatement");
    }

    protected ASTUpdateStatement findParentASTUpdateStatement(INode node) {
        return (ASTUpdateStatement)ASTUtil2.findParent(node, "ASTUpdateStatement");
    }

    protected ASTDeleteStatement findParentASTDeleteStatement(INode node) {
        return (ASTDeleteStatement)ASTUtil2.findParent(node, "ASTDeleteStatement");
    }

    protected ASTFrom findASTFrom(ASTSelectStatement node) {
        return (ASTFrom)node.getChild("ASTFrom");
    }

    protected ASTSelect findASTSelect(ASTSelectStatement node) {
        return (ASTSelect)node.getChild("ASTSelect");
    }

    protected ASTFrom findASTFrom(ASTDeleteStatement node) {
        return (ASTFrom)ASTUtil2.findFirstChild((INode)node, "ASTFrom");
    }

    protected ASTSelectStatement findASTSelectStatement(ASTUnion node) {
        return (ASTSelectStatement)ASTUtil2.findFirstChild((INode)node, "ASTSelectStatement");
    }

    protected ASTTable findASTTable(ASTInsertStatement node) {
        ASTInto into = (ASTInto)ASTUtil2.findFirstChild((INode)node, "ASTInto");
        return (ASTTable)ASTUtil2.findFirstChild((INode)into, "ASTTable");
    }

    protected ASTTable findASTTable(ASTUpdateStatement node) {
        INode n;
        if (node.getChildrenSize() > 0 && (n = node.getChild(0)) != null && n instanceof ASTTable) {
            return (ASTTable)n;
        }
        return null;
    }

    protected INode findFromNode(ASTFrom fromlist, String aliasName) {
        if (fromlist != null) {
            int i = 0;
            while (i < fromlist.getChildrenSize()) {
                INode node = fromlist.getChild(i);
                if (node instanceof ASTAlias && aliasName.equalsIgnoreCase(((ASTAlias)node).getAliasName())) {
                    return node;
                }
                ++i;
            }
        }
        return null;
    }

    protected INode[] getFromNodes(ASTFrom fromlist) {
        ArrayList<INode> list = new ArrayList<INode>();
        int i = 0;
        while (i < fromlist.getChildrenSize()) {
            INode node = fromlist.getChild(i);
            if (node instanceof ASTAlias) {
                list.add(node);
            }
            ++i;
        }
        return list.toArray(new INode[0]);
    }

    protected int getSizeRemoveComma(INode target) {
        int cnt = 0;
        int i = 0;
        while (i < target.getChildrenSize()) {
            INode node = target.getChild(i);
            if (!(node instanceof ASTComma)) {
                ++cnt;
            }
            ++i;
        }
        return cnt;
    }

    protected void createTableProposal(TableInfo[] infos, ASTAlias[] target) {
        if (target != null) {
            ArrayList<TableInfo> list = new ArrayList<TableInfo>();
            int i = 0;
            while (i < target.length) {
                ASTAlias alias;
                ASTAlias node = target[i];
                if (node instanceof ASTTable) {
                    ASTTable table = (ASTTable)node;
                    TableInfo info = this.findTableInfo(infos, table.getTableName());
                    if (table.hasAlias()) {
                        String comment = info.getComment();
                        if (comment == null) {
                            comment = info.getName();
                        }
                        list.add(new TableInfo(table.getAliasName(), String.valueOf(comment) + Messages.getString("DefaultProcessor.10")));
                    } else {
                        list.add(new TableInfo(table.getTableName(), info.getComment()));
                    }
                } else if (node instanceof ASTAlias && (alias = node).getAliasName() != null) {
                    list.add(new TableInfo(alias.getAliasName(), Messages.getString("DefaultProcessor.11")));
                }
                ++i;
            }
            SQLProposalCreator2.addProposal(this.proposals, list.toArray(new TableInfo[0]), this.pinfo);
        }
    }

    protected TableInfo findTableInfo(TableInfo[] info, String target) {
        int i = 0;
        while (i < info.length) {
            TableInfo ti = info[i];
            if (ti.getName().equalsIgnoreCase(target)) {
                return ti;
            }
            ++i;
        }
        return null;
    }

    protected void createColumnProposal(INode target) {
        if (target != null) {
            if (target instanceof ASTTable) {
                this.createColumn((ASTTable)target);
            } else if (target instanceof ASTSelectStatement) {
                this.createColumn((ASTSelectStatement)target);
            } else if (target instanceof ASTParentheses) {
                ASTSelectStatement select = (ASTSelectStatement)ASTUtil2.findFirstChild(target, "ASTSelectStatement");
                if (select != null) {
                    this.createColumnProposal((INode)select);
                } else {
                    throw new IllegalStateException(Messages.getString("DefaultProcessor.13"));
                }
            }
        }
    }

    void createColumn(ASTTable target) {
        ContentInfo ci;
        if (target != null && (ci = new ContentInfo(ContentAssistUtil.getIDBConfig())).isConnected()) {
            String tableName = target.getTableName();
            Column[] cols = ci.getColumns(tableName);
            SQLProposalCreator2.addProposal(this.proposals, cols, this.pinfo);
        }
    }

    void createColumn(ASTSelectStatement target) {
        if (target != null) {
            String alias = target.getAliasName();
            ASTSelect selectList = this.findASTSelect(target);
            int count = this.getSizeRemoveComma((INode)selectList);
            String[][] colInfo = new String[count][2];
            int index = 0;
            int i = 0;
            while (i < selectList.getChildrenSize()) {
                INode node = selectList.getChild(i);
                StringBuffer sb = new StringBuffer();
                if (node instanceof ASTColumn) {
                    ASTColumn column = (ASTColumn)node;
                    String columnName = column.getAliasName();
                    sb.append(columnName);
                    if (alias != null) {
                        sb.append(Messages.getString("DefaultProcessor.14"));
                        sb.append(alias);
                        sb.append(Messages.getString("DefaultProcessor.15"));
                        sb.append(columnName);
                    }
                    colInfo[index][0] = columnName;
                    colInfo[index][1] = sb.toString();
                    ++index;
                }
                ++i;
            }
            SQLProposalCreator2.addProposal(this.proposals, colInfo, this.pinfo);
        }
    }
}

