/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.contentassist;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.preference.IPreferenceStore;
import zigen.plugin.db.DbPlugin;

public class ObjectCacher {
    private static final Map map = new HashMap();
    private int timeout = 60000;
    private String key = null;
    private Object obj = null;
    private IPreferenceStore preferenceStore = DbPlugin.getDefault().getPreferenceStore();

    public static synchronized ObjectCacher getInstance(String key) {
        ObjectCacher instance = (ObjectCacher)map.get(key);
        if (instance == null) {
            instance = new ObjectCacher();
            instance.key = key;
            map.put(key, instance);
        }
        return instance;
    }

    private ObjectCacher() {
    }

    public void put(Object obj) {
        this.obj = obj;
        int _time = this.preferenceStore.getInt("CodeAssistPreferencePage.SqlCodeAssitCacheTime");
        this.timeout = _time * 1000;
        this.starttimer();
    }

    public Object get() {
        return this.obj;
    }

    private void starttimer() {
        new Timer(true).schedule(new TimerTask(){

            public void run() {
                map.remove(ObjectCacher.this.key);
                ObjectCacher.this.key = null;
                ObjectCacher.this.obj = null;
            }
        }, this.timeout);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

