/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.contentassist;

import java.sql.Connection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SchemaSearcher;
import zigen.plugin.db.core.TableInfo;
import zigen.plugin.db.core.TableSearcher;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ui.actions.ConfirmConnectDBAction;
import zigen.plugin.db.ui.contentassist.ContentAssistUtil;
import zigen.plugin.db.ui.contentassist.ObjectCacher;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ContentAssistTable;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.internal.TreeNode;
import zigen.plugin.db.ui.views.TreeView;

public class ContentInfo {
    IDBConfig config;
    Transaction trans;
    boolean isConnected = false;
    String currentSchema = null;

    public ContentInfo(IDBConfig config) {
        this.config = config;
        if (config != null) {
            this.configure();
        } else {
            DbPlugin.log("ContentInfo\u306e\u751f\u6210\u51e6\u7406\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u63a5\u7d9a\u5b9a\u7fa9\u60c5\u5831\u304c\u3042\u308a\u307e\u305b\u3093");
        }
    }

    private void configure() {
        try {
            this.trans = Transaction.getInstance(this.config);
            if (this.trans.isConneting()) {
                this.isConnected = true;
                DbPlugin.fireStatusChangeListener(this.config, 106);
                this.currentSchema = this.getSchemaName(this.trans.getConnection(), this.config);
            } else {
                Display.getDefault().syncExec((Runnable)new ConfirmConnectDBAction(this.trans));
                if (this.trans.isConneting()) {
                    this.configure();
                } else {
                    this.isConnected = false;
                }
            }
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
    }

    private String getSchemaName(Connection con, IDBConfig config) {
        DbPlugin.getDefault();
        TreeView tw = (TreeView)DbPlugin.findView("zigen.plugin.db.ui.views.TreeView");
        if (tw != null) {
            DataBase db = tw.getContentProvider().findDataBase(config);
            if (SchemaSearcher.isSupport(con)) {
                List list = db.getChildren();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    TreeNode node = (TreeNode)iterator.next();
                    if (node instanceof Schema) {
                        Schema schema = (Schema)node;
                        if (!schema.getName().equalsIgnoreCase(config.getSchema())) continue;
                        return schema.getName();
                    }
                    return null;
                }
            }
        } else {
            return this.matchSchemaName(this.getSchemas(con, config), config);
        }
        return null;
    }

    private String matchSchemaName(String[] schemas, IDBConfig config) {
        int i = 0;
        while (i < schemas.length) {
            String schema = schemas[i];
            if (schema.equalsIgnoreCase(config.getSchema())) {
                return schema;
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getSchemas(Connection con, IDBConfig config) {
        ObjectCacher holder;
        String[] result = null;
        ObjectCacher objectCacher = holder = ObjectCacher.getInstance(String.valueOf(config.getDbName()) + "@Schema");
        synchronized (objectCacher) {
            result = (String[])holder.get();
            if (result == null) {
                try {
                    result = SchemaSearcher.execute(con);
                }
                catch (Exception e) {
                    DbPlugin.log(e);
                }
                holder.put(result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableInfo[] getTableInfo() {
        if (this.config == null) {
            return null;
        }
        String[] tableTypes = null;
        switch (this.config.getDbType()) {
            case 1: {
                tableTypes = new String[]{"TABLE", "VIEW", "SYNONYM"};
                break;
            }
            default: {
                tableTypes = new String[]{"TABLE", "VIEW"};
            }
        }
        TableInfo[] result = null;
        try {
            ObjectCacher holder;
            Connection con = this.trans.getConnection();
            String keySchemaName = this.config.getSchema() != null ? this.config.getSchema() : this.config.getDbName();
            ObjectCacher objectCacher = holder = ObjectCacher.getInstance(keySchemaName);
            synchronized (objectCacher) {
                result = (TableInfo[])holder.get();
                if (result == null) {
                    try {
                        result = this.currentSchema != null ? TableSearcher.execute(con, this.currentSchema, tableTypes) : TableSearcher.execute(con, null, tableTypes);
                    }
                    catch (Exception e) {
                        DbPlugin.log(e);
                    }
                    holder.put(result);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Column[] getColumns(String tableName) {
        ObjectCacher holder;
        Column[] result = null;
        ObjectCacher objectCacher = holder = ObjectCacher.getInstance(tableName);
        synchronized (objectCacher) {
            result = (Column[])holder.get();
            if (result == null) {
                ContentAssistTable table = ContentAssistUtil.createContentAssistTable(this.currentSchema, tableName);
                result = table.getColumns();
                holder.put(result);
            }
        }
        return result;
    }

    public String getCurrentSchema() {
        return this.currentSchema;
    }

    public IDBConfig getConfig() {
        return this.config;
    }

    public boolean isConnected() {
        return this.isConnected;
    }
}

