/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.views.SQLExecuteView;

public class OpenViewAction
extends Action {
    private final IWorkbenchWindow window;
    private int instanceNum;
    private final String viewId = "zigen.plugin.db.ui.views.SQLExecuteView";
    private IDBConfig config;
    private SQLExecuteView view;

    public OpenViewAction(SQLExecuteView view, IWorkbenchWindow window) {
        this.view = view;
        this.setText(Messages.getString("OpenViewAction.0"));
        this.setToolTipText(Messages.getString("OpenViewAction.1"));
        this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("open.gif"));
        this.window = window;
    }

    public void run() {
        try {
            this.checkSecondaryId();
            IViewPart part = this.window.getActivePage().showView("zigen.plugin.db.ui.views.SQLExecuteView", Integer.toString(this.instanceNum), 1);
            ++this.instanceNum;
            if (part instanceof SQLExecuteView) {
                SQLExecuteView sv = (SQLExecuteView)part;
                sv.setLockedDataBase(this.view.isLockedDataBase());
                sv.setCommitMode(this.config, this.config.isAutoCommit());
            }
        }
        catch (PartInitException e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    private void checkSecondaryId() {
        IWorkbenchPage page = this.window.getActivePage();
        IViewReference vr = page.findViewReference("zigen.plugin.db.ui.views.SQLExecuteView", Integer.toString(this.instanceNum));
        if (vr != null) {
            ++this.instanceNum;
        } else {
            return;
        }
        this.checkSecondaryId();
    }

    public void setDbConfig(IDBConfig config) {
        this.config = config;
    }
}

