/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBConfigManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SameDbNameException;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.views.TreeContentProvider;

public class CopyDBAction
extends Action
implements Runnable {
    TreeViewer viewer = null;

    public CopyDBAction(TreeViewer viewer) {
        this.viewer = viewer;
        this.setText(Messages.getString("CopyDBAction.5"));
        this.setToolTipText(Messages.getString("CopyDBAction.6"));
        this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("db_copy.gif"));
    }

    public void run() {
        Object element = ((StructuredSelection)this.viewer.getSelection()).getFirstElement();
        if (element instanceof DataBase) {
            DataBase db = (DataBase)element;
            IDBConfig config = db.getDbConfig();
            IDBConfig copyConfig = (IDBConfig)config.clone();
            Shell shell = DbPlugin.getDefault().getShell();
            String name = String.valueOf(config.getDbName()) + Messages.getString("CopyDBAction.7");
            InputDialog dialog = new InputDialog(shell, Messages.getString("CopyDBAction.8"), Messages.getString("CopyDBAction.9"), name, (IInputValidator)new DBNameValidator());
            int rc = dialog.open();
            if (rc == 1) {
                return;
            }
            copyConfig.setDbName(dialog.getValue());
            IContentProvider obj = this.viewer.getContentProvider();
            if (obj instanceof TreeContentProvider) {
                TreeContentProvider provider = (TreeContentProvider)obj;
                DataBase registDb = provider.addDataBase(copyConfig);
                this.viewer.refresh();
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)registDb), true);
                this.viewer.getControl().notifyListeners(13, null);
            }
            try {
                DBConfigManager.save(copyConfig);
            }
            catch (SameDbNameException e) {
                DbPlugin.getDefault().showErrorDialog(e);
            }
            DbPlugin.fireStatusChangeListener(this.viewer, 107);
        }
    }

    public class DBNameValidator
    implements IInputValidator {
        final String name = Messages.getString("CopyDBAction.0");

        public String isValid(String str) {
            if (str == null || str.trim().equals("")) {
                return String.valueOf(this.name) + Messages.getString("CopyDBAction.2");
            }
            if (DBConfigManager.hasSection(str)) {
                return String.valueOf(Messages.getString("CopyDBAction.3")) + this.name + Messages.getString("CopyDBAction.4");
            }
            return null;
        }
    }
}

