/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class StringUtil {
    private static Pattern commentPattern = Pattern.compile("/\\*.*?(\\*/|$)", 32);
    private static Pattern lineCommentPattern = Pattern.compile("--.*?(\r|\n|$)");
    private static Pattern leftTrimPattern = Pattern.compile("^(\u3000| )+");
    private static Pattern rightTrimPattern = Pattern.compile("(\u3000| )+$");

    public static int endWordPosition(String text) {
        boolean flg = false;
        int i = text.length() - 1;
        while (i >= 0) {
            char chr = text.charAt(i);
            switch (chr) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': {
                    if (!flg) break;
                    return i + 1;
                }
                default: {
                    if (flg) break;
                    flg = true;
                }
            }
            --i;
        }
        return 0;
    }

    public static int firstWordPosition(String text) {
        int i = 0;
        while (i < text.length()) {
            char chr = text.charAt(i);
            switch (chr) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return i;
                }
            }
            ++i;
        }
        return 0;
    }

    public static Object[] remove(Object[] src, Object[] target) {
        LinkedList<Object> srcList = new LinkedList<Object>(Arrays.asList(src));
        int i = 0;
        while (i < target.length) {
            srcList.remove(target[i]);
            ++i;
        }
        return srcList.toArray(new Object[srcList.size()]);
    }

    public static Object[] add(Object[] array1, Object[] array2) {
        if (array1 != null && array2 == null) {
            return array1;
        }
        if (array1 == null && array2 != null) {
            return array2;
        }
        TreeSet<Object> tree = new TreeSet<Object>();
        int i = 0;
        while (i < array1.length) {
            if (array1[i] != null) {
                tree.add(array1[i]);
            }
            ++i;
        }
        i = 0;
        while (i < array2.length) {
            if (!tree.contains(array2[i]) && array2[i] != null) {
                tree.add(array2[i]);
            }
            ++i;
        }
        return tree.toArray();
    }

    public static boolean isNumeric(String text) {
        int i = 0;
        while (i < text.length()) {
            char chr = text.charAt(i);
            if (chr < '0' || chr > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String padding(String value, int digit) {
        StringBuffer sb = new StringBuffer(value);
        int len = digit - value.getBytes().length;
        int i = 0;
        while (i < len) {
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    public static String indent(String value, int digit) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < digit) {
            sb.append(" ");
            ++i;
        }
        sb.append(value);
        return sb.toString();
    }

    public static String rTrim(String str, char trimChar) {
        int cnt = 0;
        int i = str.length() - 1;
        while (i >= 0) {
            char c = str.charAt(i);
            if (c != trimChar) {
                cnt = i + 1;
                break;
            }
            --i;
        }
        return str.substring(0, cnt);
    }

    public static String rTrimFullSpace(String str) {
        return StringUtil.rTrim(str, '\u3000');
    }

    public static String lTrimFullSpace(String str) {
        return StringUtil.lTrim(str, '\u3000');
    }

    public static String lTrim(String str, char trimChar) {
        int cnt = str.length();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c != trimChar) {
                cnt = i;
                break;
            }
            ++i;
        }
        return str.substring(cnt);
    }

    public static final String encodeDoubleQuotation(String str) {
        return str.replaceAll("\"", "\\\\\"");
    }

    public static String removeComment(String s) {
        return commentPattern.matcher(s).replaceAll("");
    }

    public static String removeLineComment(String s) {
        return lineCommentPattern.matcher(s).replaceAll("");
    }

    public static String removeLeftFullSpace(String s) {
        return leftTrimPattern.matcher(s).replaceAll("");
    }

    public static String removerightFullSpace(String s) {
        return rightTrimPattern.matcher(s).replaceAll("");
    }

    public static String convertLineSep(String text) {
        return text.replaceAll("\\r\\n|\\r|\\n", "\n");
    }

    public static String convertLineSep(String text, String demiliter) {
        return text.replaceAll("\\r\\n|\\r|\\n", demiliter);
    }
}

