package daruma.storage_manager.type_definition.types;

import daruma.storage_manager.type_definition.AbstractSingleTypeDefinition;
import daruma.storage_manager.type_definition.TypeException;
import daruma.sql.SQLDataType;

import daruma.xml.util.WhitespaceProceccer;


public class IntegerTypeDefinition extends AbstractSingleTypeDefinition
{
	public	IntegerTypeDefinition()
	{
		super();
	}

	@Override
	public	SQLDataType	getSingleSQLDataType()
	{
		/*
		return( new SQLDataType( "int" , Integer.class ) );
		*/
		return( new SQLDataType( "bigint" , Long.class ) );
	}

	@Override
	public	String	parseValue( String  value ) throws TypeException
	{
		String	v = WhitespaceProceccer.cutoffEdgeWhitespaces( value );

		try
		{
			Long.parseLong( v );
		}
		catch( NumberFormatException  e )
		{
			throw new TypeException
			  ( "\"" + value + "\" is not a valid integer value" );
		}

		return( v );
	}
}
