/*
 * Decompiled with CFR 0.152.
 */
package daruma.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class ISO8601DateFormat
extends DateFormat {
    private static final long serialVersionUID = 0L;
    private static ISO8601DateFormat instance = new ISO8601DateFormat();

    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        if (date == null || toAppendTo == null || fieldPosition == null) {
            return toAppendTo;
        }
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        TimeZone tz = TimeZone.getDefault();
        String id = tz.getID();
        int offset = tz.getRawOffset();
        f.setTimeZone(new SimpleTimeZone(offset, id));
        String s = ((DateFormat)f).format(date, toAppendTo, fieldPosition).toString();
        if (s.length() >= 5) {
            char sign = s.charAt(s.length() - 5);
            char hour1 = s.charAt(s.length() - 4);
            char hour2 = s.charAt(s.length() - 3);
            char minute1 = s.charAt(s.length() - 2);
            char minute2 = s.charAt(s.length() - 1);
            if ((sign == '+' || sign == '-') && Character.isDigit(hour1) && Character.isDigit(hour2) && Character.isDigit(minute1) && Character.isDigit(minute2)) {
                return new StringBuffer(s.substring(0, s.length() - 2) + ':' + minute1 + minute2);
            }
        }
        return new StringBuffer(s);
    }

    public Date parse(String source, ParsePosition pos) {
        SimpleDateFormat baseFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        baseFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        Date d = ((DateFormat)baseFormat).parse(source, pos);
        String s = source;
        int p = pos.getIndex();
        if (p < s.length()) {
            if (s.charAt(p) == '.') {
                char ch;
                ++p;
                long milliSec = 0L;
                int factor = 100;
                while (p < s.length() && Character.isDigit(ch = s.charAt(p))) {
                    int n = Character.digit(ch, 10);
                    milliSec += (long)(n * factor);
                    factor /= 10;
                    ++p;
                }
                d = new Date(d.getTime() + milliSec);
            }
        } else {
            return null;
        }
        if (p >= s.length()) {
            return null;
        }
        char ch = s.charAt(p);
        ++p;
        if (ch != 'Z') {
            long sign;
            if (s.length() - p < 5 || s.charAt(p + 2) != ':') {
                return null;
            }
            if (ch == '+') {
                sign = 1L;
            } else if (ch == '-') {
                sign = -1L;
            } else {
                return null;
            }
            char hour1 = s.charAt(p);
            char hour2 = s.charAt(p + 1);
            char minute1 = s.charAt(p + 3);
            char minute2 = s.charAt(p + 4);
            if (!(Character.isDigit(hour1) && Character.isDigit(hour2) && Character.isDigit(minute1) && Character.isDigit(minute2))) {
                return null;
            }
            long hours = Character.digit(hour1, 10) * 10 + Character.digit(hour2, 10);
            long minutes = Character.digit(minute1, 10) * 10 + Character.digit(minute2, 10);
            d = new Date(d.getTime() - sign * 1000L * 60L * minutes - sign * 1000L * 60L * 60L * hours);
            p += 5;
        }
        pos.setIndex(p);
        return d;
    }

    public static ISO8601DateFormat getISO8601Instance() {
        return instance;
    }
}

