/*
 * Decompiled with CFR 0.152.
 */
package daruma.storage_manager.type_definition;

import daruma.storage_manager.StorageException;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.ElementName;
import daruma.xml.SimpleXPath;
import daruma.xml.UniversalName;

public class ColumnNameFactory {
    public static final String ColNameSep = "$";
    public static final String ColNameAttributePrefix = "_at_";
    public static final String ColNameSuffixSep = "_";
    public static final String ColNameForValue = "_value_";

    private ColumnNameFactory() {
    }

    public static String createColumnName(SimpleXPath path, StorageManager storage) throws StorageException {
        String columnName;
        if (path == null || path.getList().size() == 0) {
            columnName = ColumnNameFactory.getTopLevelElementColumnName();
            if (path != null && path.isAttribute()) {
                columnName = columnName + ColNameSep;
                columnName = columnName + ColNameAttributePrefix;
                columnName = columnName + storage.getUniversalNameID(path.getAttributeName());
            }
        } else {
            SimpleXPath newPath = new SimpleXPath(path);
            columnName = storage.getShortXPathStringForDB(newPath);
        }
        return columnName;
    }

    public static String createAttributeColumnName(SimpleXPath path, UniversalName attributeName, StorageManager storage) throws StorageException {
        String baseColumnName;
        if (path == null) {
            baseColumnName = ColumnNameFactory.getTopLevelElementColumnName();
        } else {
            SimpleXPath newPath = new SimpleXPath(path);
            baseColumnName = storage.getShortXPathStringForDB(newPath);
        }
        String columnName = baseColumnName + ColNameSep + ColNameAttributePrefix + storage.getUniversalNameID(attributeName);
        return columnName;
    }

    public static String createAttributeColumnName(SimpleXPath path, ElementName elementName, UniversalName attributeName, StorageManager storage) throws StorageException {
        String baseColumnName;
        if (path == null) {
            baseColumnName = ColumnNameFactory.getTopLevelElementColumnName();
        } else {
            SimpleXPath newPath = new SimpleXPath(path, elementName);
            baseColumnName = storage.getShortXPathStringForDB(newPath);
        }
        String columnName = baseColumnName + ColNameSep + ColNameAttributePrefix + storage.getUniversalNameID(attributeName);
        return columnName;
    }

    public static final String getTopLevelElementColumnName() {
        return ColNameForValue;
    }

    public static final String getTopLevelElementColumnName(String suffix) {
        return "_value_$" + suffix;
    }

    public static final String getColumnName(String shortName, String suffix) {
        return shortName + ColNameSep + suffix;
    }

    public static final String getCoiceElementIndexColumnName(String base) {
        return base + ColNameSep + "choice_element_index";
    }
}

