#@GO[vig[vj̃NX`

module DarkHall
	class Troop < StorableObject
		attr_accessor :groups
	
		def initialize
			@groups = []
		end
		
		def all_enemies
			@groups.flatten
		end
		
		
		def add_enemies(enemy_ids, option_hash = {})
			opt = RArg.parse(option_hash) do
				default_arg :number_rank_bonus, 0
				default_arg :front, false
			end
			
			enemy_ids = [enemy_ids] unless enemy_ids.kind_of?(Array)
			enemy_ids.each_with_index do |enemy_id, i|
				enemy_id = enemy_id.to_s
				new_group = []
				
				# GN
				rank = ENEMY_DATA[enemy_id].number_rank
				unless rank == NUM_ONE then
					rank += opt[:number_rank_bonus]
					rank -= i # 2O[vڈȍ~͐ȂȂ

					rank = NUM_E if rank < NUM_E # ŏ:E
					rank = NUM_A if rank > NUM_A # ő:A
				end
				
				list = NUMBER_LIST_TABLE[rank]
				number = Util.random_pick(list)
				
				# prefix
				if rand(100) < 5 then
					list = [EP::Hungry, EP::Systematic, EP::Sleepy]
					prefix = random_pick(list)
				else
					prefix = EP::Standard
				end
				
				number.times do
					new_group << Enemy.new(enemy_id, prefix)
				end
				
				if opt[:front] then
					@groups.unshift(new_group)
				else
					@groups << new_group
				end
			end
		end
		
		def add_fixed_enemies(enemy_id, number)
			@groups << []
			number.times do
				@groups.last << Enemy.new(enemy_id.to_s, EP::Standard)
			end
			
			return self
		end
		
		def front_groups
			@groups.slice(0, FRONT_GROUP_MAX) || []
		end
		
		def back_groups
			@groups.slice(FRONT_GROUP_MAX, BACK_GROUP_MAX) || []
		end
		
		def level
			total = 0
			enemies = @groups.flatten
			enemies.each{|x| total += x.level}
			
			return (total / enemies.size).to_i
		end
		
		def agl
			@groups.flatten.map{|x| x.agl}.min
		end

		def update
			@groups.each do |group|
				group.delete_if{|x| x.dead?}
			end
		end
		
		def update_formation
			update
			@groups.delete_if{|x| x.empty?}
			@groups.each_with_index do |enemies, i|
				if i < FRONT_GROUP_MAX then
					enemies.each{|x| x.position = POS_FORWARD}
				else
					enemies.each{|x| x.position = POS_BACK}
				end
			end
		end
		
		def dump
			hash = super
			hash['groups'] = @groups
			return hash
		end
		
		def self.create_from_mpac_model(hash)
			obj = self.new
			obj.groups = hash['groups']
			return obj
		end

	end
	
	class RoomTroop < Troop
		def sometime_escape?
			true
		end
	end
	
	class WanderingTroop < Troop
		def sometime_escape?
			true
		end
	end
	
	class BossTroop < Troop
		def sometime_escape?
			false
		end
	end
	
end
