#　設定を読み込むモジュール

require 'ini'
require 'pathname'
require 'rubyplus'
require 'gettext'

module DarkHall
	class Setting
		attr_reader :ini
	
		def initialize(ini_hash = {})
			@ini = ini_hash
			@ini['General'] ||= {
				'ScreenMode' => 'window',
				'Language' => 'ja',
				'MixerFrequency' => '44100',
				'MixerChunkSize' => '1024',
			}
			@ini['ErrorReport'] ||= {'Reboot' => 'true'}
		end
		
		def self.load(path)
			if File.exist?(path) then
				self.new(Ini.parse_file(path))
			else
				self.new
			end
		end

		
		public
		
		def language
			@ini['General']['Language']
		end
		
		def screen_mode
			@ini['General']['ScreenMode']
		end
		
		def full_screen?
			screen_mode == 'full_screen'
		end
		
		def mixer_frequency
			@ini['General']['MixerFrequency'].to_i
		end
		
		def mixer_chunk_size
			@ini['General']['MixerChunkSize'].to_i
		end
		
		def multiple_boot_guard
			@ini['General']['MultipleBootGuard'] || 'yes'
		end

		
		def error_report_mail_address
			get_optional('ErrorReport', 'MailAddress')
		end
		
		def error_report_reboot?
			get_switch('ErrorReport', 'Reboot')
		end
		
		
		# 今のところ設定変更は不可
		def use_logger?
			true
		end
		
		def save_path
			Pathname.new('./save/')
		end
		
		def use_hardware_draw?
			true
		end


		def use_alpha_bg?
			true
		end

		def use_alpha_effect?
			true
		end
		
		def use_ttf_blended_draw?
			true
		end

		
		
		def get_lower_string(section, key)
			v = @ini[section][key]
			return (v ? v.downcase : '')
		end

		def get_switch(section, key)
			case @ini[section][key].downcase
			when 'true', '1', 'yes', 'on'
				true
			else
				false
			end
		end
		
		def get_value(section, key, range, default)
			value = @ini[section][key].to_i
			value = default unless value.in?(range)
			return value
		end
		
		def get_optional(section, key)
			if (v = @ini[section][key]) and not v.empty? then
				v
			else
				nil
			end
		end
	end
	
	SETTING = Setting.load('setting.ini')

	if ($option_info and (loc = $option_info.locale)) or (loc = SETTING.language) then
		GetText.locale = loc
	end
	GetText.output_charset = 'UTF-8'
	
	#GetText.set_locale_all(locale)
	#puts "GetText-Locale: #{GetText.locale.to_posix} (charset=#{GetText.locale.charset})"

end



