# Copyright 2004-2006 by Kevin Smith
# released under the MIT-style wxruby2 license

# This wrapper serves three functions:
# 1. It loads the binary library 'wxruby2.so' or 'wxruby.dll', while
#    still allowing applications to just require 'wx'.
# 2. It sets up the version information
# 3. It loads in ruby extensions to the core Wx classes.

# original file is wx.rb, arranged by Team D.H. <team.darkhall@gmail.com>


# load the binary library
require 'wxruby2'

# alias the module
Wx = Wxruby2

# Load the version information (should be bundled with all released versions)
begin
  require 'wx/version'
rescue LoadError
  Wx::WXRUBY_VERSION = '0.0.0'
end
# Convenience string for WxWidgets version info
Wx::WXWIDGETS_VERSION = '%i.%i.%i' % [ Wx::WXWIDGETS_MAJOR_VERSION,
                                       Wx::WXWIDGETS_MINOR_VERSION,
                                       Wx::WXWIDGETS_RELEASE_NUMBER ]

# Helper functions
require 'wx/helpers'

# Load in all the class extension methods written in ruby
# evthandler must be required first b/c it sets up methods modified elsewhere
require 'wx/classes/evthandler.rb'

# Change for exerb -- start
require 'wx/classes/acceleratortable.rb'
require 'wx/classes/animation.rb'
require 'wx/classes/app.rb'
require 'wx/classes/artprovider.rb'
require 'wx/classes/auinotebook.rb'
require 'wx/classes/bitmap.rb'
require 'wx/classes/busycursor.rb'
require 'wx/classes/checklistbox.rb'
require 'wx/classes/choice.rb'
require 'wx/classes/clientdc.rb'
require 'wx/classes/clipboard.rb'
require 'wx/classes/colour.rb'
require 'wx/classes/combobox.rb'
require 'wx/classes/commandevent.rb'
require 'wx/classes/controlwithitems.rb'
require 'wx/classes/dataformat.rb'
require 'wx/classes/data_object.rb'
require 'wx/classes/data_object_simple.rb'
require 'wx/classes/dc.rb'
require 'wx/classes/event.rb'
require 'wx/classes/evthandler.rb'
require 'wx/classes/font.rb'
require 'wx/classes/functions.rb'
require 'wx/classes/gauge.rb'
require 'wx/classes/genericdirctrl.rb'
require 'wx/classes/grid.rb'
require 'wx/classes/hboxsizer.rb'
require 'wx/classes/helpcontroller.rb'
require 'wx/classes/helpcontrollerhelpprovider.rb'
require 'wx/classes/helpprovider.rb'
require 'wx/classes/htmlhelpcontroller.rb'
require 'wx/classes/htmlwindow.rb'
require 'wx/classes/icon.rb'
require 'wx/classes/iconbundle.rb'
require 'wx/classes/image.rb'
require 'wx/classes/imagelist.rb'
require 'wx/classes/listbox.rb'
require 'wx/classes/listctrl.rb'
require 'wx/classes/locale.rb'
require 'wx/classes/mediactrl.rb'
require 'wx/classes/menu.rb'
require 'wx/classes/menuitem.rb'
require 'wx/classes/notebook.rb'
require 'wx/classes/object.rb'
require 'wx/classes/paintdc.rb'
require 'wx/classes/point.rb'
require 'wx/classes/previewframe.rb'
require 'wx/classes/rect.rb'
require 'wx/classes/richtextctrl.rb'
require 'wx/classes/simplehelpprovider.rb'
require 'wx/classes/size.rb'
require 'wx/classes/sizer.rb'
require 'wx/classes/sound.rb'
require 'wx/classes/splitterwindow.rb'
require 'wx/classes/standardpaths.rb'
require 'wx/classes/styledtextctrl.rb'
require 'wx/classes/textctrl.rb'
require 'wx/classes/texturlevent.rb'
require 'wx/classes/timer.rb'
require 'wx/classes/toolbar.rb'
require 'wx/classes/toolbartool.rb'
require 'wx/classes/treectrl.rb'
require 'wx/classes/validator.rb'
require 'wx/classes/vboxsizer.rb'
require 'wx/classes/window.rb'
require 'wx/classes/xmlresource.rb'
# Change for exerb -- end

# Load in syntax sweeteners
require 'wx/accessors'
require 'wx/keyword_ctors'
require 'wx/keyword_defs'

# If a program is ended by ruby's exit, it can bypass doing the proper
# Wx clean-up routines called by Wx::App#on_exit. This can under some
# circumstances cause crashes as the application ends.
Kernel::at_exit do
  # These are set at App startup and wxRuby shut down respectively - see App.i
  if Wx::const_defined?(:THE_APP) and not $__wx_app_ended__ 
    Wx::THE_APP.on_exit
  end
end

