# 遺跡・第ニ階層

@name = _("第ニ階層")
@bgm = :Dungeon1
@width = 60
@height = 40



in_region(:SouthRoute){
	treasure_level 3
	appearing_enemy 40, :RoofBird
	appearing_enemy 40, :KoboltWorker
	appearing_enemy 10, :KoboltWorker, :Pixie
	appearing_enemy 10, :RoofBird, :Pixie

	set_stair(24, 24, DIR_N, '1', 23, 27, DIR_N)
}

in_region(:FeatherHome){
}

in_region(:EastSpace){
	treasure_level 3
	appearing_enemy 2, :RoofBird
	appearing_enemy 3, :KoboltWorker
	appearing_enemy 2, :KoboltWorker, :KoboltLeader
	appearing_enemy 1, :KoboltWorker, :KoboltWorker, :KoboltLeader 
	appearing_enemy 1, :KoboltWorker, :Pixie
	
	set_one_way_door(21, 23, DIR_W)
	set_locked_door(11, 12, DIR_N, 'to_bridge', :KeyOfWizard)

	set_one_way_door(26, 19, DIR_N)
	
}


in_region(:SquareRooms){
		treasure_level 4
	appearing_enemy 50, :KoboltWorker
	appearing_enemy 35, :KoboltWorker, :KoboltWorker
	appearing_enemy 15, :KoboltWorker, :KoboltLeader, :KoboltWorker


	set_one_way_door(42, 10, DIR_N)
}


in_region(:NorthRoute){
	treasure_level 4
	appearing_enemy 30, :RoofBird
	appearing_enemy 20, :KoboltWorker
	appearing_enemy 10, :KoboltWorker, :KoboltLeader, :KoboltWorker
	appearing_enemy 10, :KoboltWorker, :KoboltWorker, :KoboltLeader
	appearing_enemy 10, :KoboltWorker, :Pixie
	appearing_enemy 10, :RoofBird, :Pixie

	set_locked_door(11, 4, DIR_S, 'feather_n', :KeyOfWizard)

	set_stair(24, 1, DIR_N, '3', 4, 2, DIR_S)
}

in_region(:JinRoom){
	
}





def on_move(party)
	if party.is_position?(3, 14, DIR_N) and not GS.switch[:RuinFeatherEscape] and not GS.switch[:BusterRuinFeather] then
		message(_("どこかからか、翼のはためくような音が聴こえてくる……\n\n上空を見上げた冒険者たちは\nなにかの影が高速で横切ったのを見た"))
		holder = GS.party.find_item_holder('VoiceOfHarpy')
		if holder then
			if Game.ask(_("ハーピーの金切り笛を鳴らしてみますか？")) then
				message(_("%{holder}が笛を吹くと、かん高い音があたりに鳴り響き\n翼の音は小さくなっていった").evaluate(:holder => holder.name))
				GS.switch[:RuinFeatherEscape] = true
			end
		end
	elsif (party.is_position?(3, 7, DIR_N) or party.is_position?(3, 7, DIR_S)) and not GS.switch[:RuinFeatherEscape] and not GS.switch[:BusterRuinFeather] then
		BGM.fade_out
		BGM.load(:BossBattle)
		message(_("……翼の音が近づいてくる！"))
				
		troop = BossTroop.new
		troop.add_fixed_enemies('RuinFeather', 1)
		win = Game.battle(troop, nil, 4)
		GS.switch[:BusterRuinFeather] = true if win

		
	elsif party.is_position?(3, 22, DIR_N) then
		dungeon_message(_("扉に文字が彫りこんである\n\n- 翼あるものの道 -\n* 力無き者、智無き者は死を覚悟せよ *"))
	elsif party.is_position?(3, 21, DIR_N) then
		dungeon_message(_("幅の広い通路だ\n\n上を見上げてみると、天井が見えない……\nこの空間には相当な高さがあるようだ"))
	elsif party.region == :JinRoom then
		show_special_action(:special_detect, _("[A] 棚の祭具を調べる"), 'A')
	end
end

def on_door(party)
	if party.on?(11, 12, DIR_N) then
		SE.equip
		message(_("扉はびくともしない\nよく見ると扉の中央に、真新しい文字が刻まれている……\n\n- 未開通 -"))
		return false
	else
		return true
	end
end



def on_enter_region(party, old_region)
	case party.region
	when :JinRoom
		dungeon_message(_("小部屋の中に、ひときわ大きな木棚があり\nその棚の中にはいくつかの祭具らしきものが置かれている"))
		
	when :MerchantRoom
		$phase.hide_sub_windows
		BGM.fade_out
		message(_("部屋の中には一人の男がいた\n\nいや、その姿は「男」と呼べるのだろうか？\nしゃれた服を着て帽子をかぶり、ふるまいは人間のようだが\nその頭はどう見てもワニのように見える"))
		
		BGM.play(:NPC2)
		message(_("ワニ頭の男は、にこやかに声をかけてきた\n\n「ようこそ友よ！　何か欲しいものはないかい？」"))
		
		last_selected = nil
		loop do
			selects = []
			selects << SelectItem.new(:who_are_you, _("あなたは何者？"))
			selects << SelectItem.new(:buy, _("品物を見せて！"))
			unless GS.party.find_item_holder('VoiceOfHarpy') then
				selects << SelectItem.new(:feather_home, _("「翼あるものの道」を突破したい"))
			end
			selects << SelectItem.new(:cancel, _("話をやめる"))
			
			id = Game.select(selects, :default_id => last_selected)
			last_selected = id
			
			case id
			when :who_are_you
				message _("「私はデミトリ。この迷宮で物を売って生活してる、陽気で誠実な行商人さ！」")
			when :buy
				index = Game.member_select("だれが？")
				if index then
					$member_index = index
					Phase.change(MerchantBuyPhase.new)
					Game.operation_loop('Buying')
					Phase.change(DungeonPhase.new)
				end
			when :feather_home
				message _("「おっと、あの道を通りたいのか？\n\nあそこには巨鳥が棲みついてて\n通ろうとしたやつらは、たいていパックリやられちまうんだ」")
				message _("「そこでこの笛！\nこれさえあれば一吹きで鳥を追い払える、魔法の笛さ！」\n\nワニ頭の男は、銀色の笛を取り出してみせた")
				price = 700
				message _("「どうだい、この笛は欲しくないか？\n私たちは友達だ、金貨%{price}枚でいいよ！」").evaluate(:price => price)
				if GS.party.gold >= price then
					if Game.ask(_("笛を金貨%{price}枚で購入しますか？").evaluate(:price => price)) then
						item = Item.new('VoiceOfHarpy')
						getter = party.get_item(item)
						if getter then
							GS.party.lose_gold(price)
							SE.coin
							message _("%{getter}は$c[item]%{item}$cを手に入れた").evaluate(:getter => getter.name, :item => item.name)	
							Game.save(FQ_BIG_CHANGE, "ハーピーの金切り笛入手")
						else
							message(_("「おっと待ってくれ、誰も手が空いてないみたいだぜ？\n持ち物を整理してから来てくれよ」"))
						end
					else
						message _("「そうかい、そいつは残念だな\nついでに他の品物も見ていってはどうだい？」")
					end
				else
					message _("「なに、お金が足りないって？　そいつは残念だな\nついでに他の品物も見ていってはどうだい？」")
				end
			when :cancel
				message _("「またいつでも来てくれ、友よ！」")
				break
			end
		end
		BGM.play(:Dungeon1)
		$phase.show_sub_windows
		DUNGEON_WINDOW.update.show
	when :GlimRoom
		if (holder = GS.party.find_item_holder('GlimWand')) then
			message(_("%{holder}の持っている灯の杖が、急に赤く輝きはじめた……") % {:holder => holder.name})
		end
	when :Fountain
		fountain
	end
end


def on_detect(party)
	if party.on?(35, 14) then
		msg = _("%{detector}は辺りを調べた\n\n隠し階段を発見！\n次の階層に移動しますか？").evaluate(:detector => GS.party.members.first.name)
		if Game.ask(msg) then
			jump_to('1', 13, 20, nil, '隠し階段')
		end
		
		return true
	end
end

def on_special_action(party, action_id)
	case action_id
	when :special_detect
		items = []
		items << SelectItem.new(:wand, _('古びた錫杖を調べる')) unless GS.switch[:GetOldWand]
		items << SelectItem.new(:lamp, _('古びたランプを調べる'))
		items << SelectItem.new(:cancel, _('キャンセル'))
		
		case Game.select(items)
		when :wand
			message(_("錫杖はかなり古いもののようで、そこかしこに埃を被っている\n儀式のための道具のようだが、術具として使うこともできそうだ"))
			
			Game.ask_about_item_recieving(Weapon.new('OldWand'), _("錫杖を持って行きますか？")) do
				GS.switch[:GetOldWand] = true
			end

		when :lamp
			BGM.fade_out
			message(_("ランプに触れると、中から煙がモクモクと立ちこめ\n煙の中から一人の太った魔神が現れた！"))
			message(_("魔神はにかっと笑い、陽気にしゃべり始めた\n\n「はっはー、私を呼び出してくれてありがとう！」"))
			message(_("「お礼に君たちを屍にしてあげよう！」"))
			
			troop = BossTroop.new
			troop.add_fixed_enemies('MalorJin', 1)
			win = Game.battle(troop, nil)
			if win then
				Game.save
				message(_("魔神は力を失い、悔しそうにランプの中へ戻っていった……"))
			end
		end
	end
end
