/*
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * History
 * 2010/06/30 avanza Co.,Ltd.
 * -スケジュール登録時における参加メンバー選択方式にMyGroupを追加
 * -施設予約承認機能追加
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;

/**
 * MyGroupのResultDataです。 <br />
 * 公開先MyGroup情報の表示用
 */
public class ScheduleMyGroupResultData implements ALData, Cloneable {

  /** ID */
  private ALStringField group_id;

  /** 名前 */
  private ALStringField name;

  /**
   * 
   * @see com.aimluck.eip.common.ALData#initField()
   */
  public void initField() {
    group_id = new ALStringField();
    name = new ALStringField();
  }

  /**
   * 
   * @param string
   */
  public void setName(String string) {
    name.setValue(string);
  }

  /**
   * 
   * @return
   */
  public String getName() {
    return name.getValue();
  }

  /**
   * @return
   */
  public String getGroupId() {
    return group_id.getValue();
  }

  /**
   * @param field
   */
  public void setGroupId(String string) {
    group_id.setValue(string);
  }
}
