/*
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.enquete.EnqueteListSelectData;
import com.aimluck.eip.util.ALEipUtils;

/**
 * Enqueteの一覧を処理するクラスです。 <br />
 * 
 */
public class EnqueteListScreen extends EnqueteScreen {
  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(EnqueteListScreen.class.getName());

  /**
   * @see org.apache.turbine.modules.screens.RawScreen#doOutput(org.apache.turbine.util.RunData)
   */
  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {

    VelocityPortlet portlet = ALEipUtils.getPortlet(rundata, context);

    try {
      EnqueteListSelectData listData = new EnqueteListSelectData();
      listData.initField();
      //ページング
      listData.setRowsNum(Integer.parseInt(portlet.getPortletConfig()
          .getInitParameter("p1b-rows")));
      listData.setStrLength(Integer.parseInt(portlet.getPortletConfig()
          .getInitParameter("p4b-strlen")));
      listData.doViewList(this, rundata, context);      
      String layout_template = "portlets/html/ja/ajax-enquete-list.vm";
      setTemplate(rundata, context, layout_template);
    
    } catch (Exception ex) {
      logger.error("[EnqueteListScreen] Exception.", ex);
      ALEipUtils.redirectDBError(rundata);
    }
  }
}
