package com.aimluck.eip.enquete;

import java.util.ArrayList;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.util.ALCommonUtils;

public class EnqueteSummaryDetailResultData implements ALData {

  /** Enquete ID */
  private ALNumberField enquete_id;
  
  /** アンケート名 */
  private ALStringField name;

  /** 公開方法（記名・無記名） */
  private String method;
  
  /** 項目名 */
  private ALStringField itemName;
  
  /** 状態(複数選択可不可) */
  private String status;
  
  /** 詳細リスト */
  private ArrayList<EnqueteChoiceItemRecordData> detailList;

  /**
   * 
   * @see com.aimluck.eip.common.ALData#initField()
   */
  public void initField() {
    enquete_id = new ALNumberField();
    name = new ALStringField();
    method = new String();
    itemName = new ALStringField();
    status = new String();
  }

  /**
   * @return
   */
  
  public ALNumberField getEnqueteId() {
    return enquete_id;
  }
  
  /**
   * @param i
   */
  public void setEnqueteId(long i) {
    enquete_id.setValue(i);
  }
  
  /**
   * @return
   */
  public String getName() {
    return ALCommonUtils.replaceToAutoCR(name.toString());
  }

  /**
   * @param string
   */
  public void setName(String string) {
    name.setValue(string);
  }

  public String getMethod() {
    return method;
  }

  public void setMethod(String method) {
    this.method = method;
  }
  
  public ALStringField getItemName() {
    return itemName;
  }

  public void setItemName(ALStringField itemName) {
    this.itemName = itemName;
  }
  
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public ArrayList<EnqueteChoiceItemRecordData> getDetailList() {
    return detailList;
  }

  public void setDetailList(ArrayList<EnqueteChoiceItemRecordData> detailList) {
    this.detailList = detailList;
  }
}
