/*****************************************************************************
 *
 *   Portable uPD7810/11, 7810H/11H, 78C10/C11/C14 disassembler
 *   Copyright Juergen Buchmueller, all rights reserved.
 *
 *   NS20030112: added 7807.
 *
 *****************************************************************************/

//#include "emu.h"
//#include "debugger.h"
#include "upd7810.h"

struct dasm_s {
	UINT8 token;
	const void *args;
};

enum
{
	_illegal=1,
	_ACI,
	_ADC,
	_ADCW,
	_ADCX,
	_ADD,
	_ADDNC,
	_ADDNCW,
	_ADDNCX,
	_ADDW,
	_ADDX,
	_ADI,
	_ADINC,
	_ANA,
	_ANAW,
	_ANAX,
	_AND,
	_ANI,
	_ANIW,
	_BIT,
	_BLOCK,
	_CALB,
	_CALF,
	_CALL,
	_CALT,
	_CLC,
	_CLR,    /* 7807 */
	_CMC,    /* 7807 */
	_DAA,
	_DADC,
	_DADD,
	_DADDNC,
	_DAN,
	_DCR,
	_DCRW,
	_DCX,
	_DEQ,
	_DGT,
	_DI,
	_DIV,
	_DLT,
	_DMOV,
	_DNE,
	_DOFF,
	_DON,
	_DOR,
	_DRLL,
	_DRLR,
	_DSBB,
	_DSLL,
	_DSLR,
	_DSUB,
	_DSUBNB,
	_DXR,
	_EADD,
	_EI,
	_EQA,
	_EQAW,
	_EQAX,
	_EQI,
	_EQIW,
	_ESUB,
	_EX,     /* 7801 */
	_EXA,
	_EXH,
	_EXX,
	_EXR,    /* 7807 */
	_GTA,
	_GTAW,
	_GTAX,
	_GTI,
	_GTIW,
	_HALT,
	_IN,     /* 7801 */
	_INR,
	_INRW,
	_INX,
	_JB,
	_JEA,
	_JMP,
	_JR,
	_JRE,
	_LBCD,
	_LDAW,
	_LDAX,
	_LDEAX,
	_LDED,
	_LHLD,
	_LSPD,
	_LTA,
	_LTAW,
	_LTAX,
	_LTI,
	_LTIW,
	_LXI,
	_MOV,
	_MUL,
	_MVI,
	_MVIW,
	_MVIX,
	_NEA,
	_NEAW,
	_NEAX,
	_NEGA,
	_NEI,
	_NEIW,
	_NOP,
	_NOT,    /* 7807 */
	_OFFA,
	_OFFAW,
	_OFFAX,
	_OFFI,
	_OFFIW,
	_ONA,
	_ONAW,
	_ONAX,
	_ONI,
	_ONIW,
	_OR, /* 7807 */
	_ORA,
	_ORAW,
	_ORAX,
	_ORI,
	_ORIW,
	_OUT,    /* 7801 */
	_PER,    /* 7801 */
	_PEX,    /* 7801 */
	_POP,
	_PUSH,
	_RET,
	_RETI,
	_RETS,
	_RLD,
	_RLL,
	_RLR,
	_RRD,
	_SBB,
	_SBBW,
	_SBBX,
	_SBCD,
	_SBI,
	_SDED,
	_SETB,   /* 7807 */
	_SHLD,
	_SIO,    /* 7801 */
	_SK,
	_SKIT,
	_SKN,
	_SKNIT,
	_SLL,
	_SLLC,
	_SLR,
	_SLRC,
	_SOFTI,
	_SSPD,
	_STAW,
	_STAX,
	_STC,
	_STEAX,
	_STM,    /* 7801 */
	_STOP,
	_SUB,
	_SUBNB,
	_SUBNBW,
	_SUBNBX,
	_SUBW,
	_SUBX,
	_SUI,
	_SUINB,
	_TABLE,
	_XOR,    /* 7807 */
	_XRA,
	_XRAW,
	_XRAX,
	_XRI
};

static const char *const token[] =
{
	"",
	"illegal",
	"ACI",
	"ADC",
	"ADCW",
	"ADCX",
	"ADD",
	"ADDNC",
	"ADDNCW",
	"ADDNCX",
	"ADDW",
	"ADDX",
	"ADI",
	"ADINC",
	"ANA",
	"ANAW",
	"ANAX",
	"AND",
	"ANI",
	"ANIW",
	"BIT",
	"BLOCK",
	"CALB",
	"CALF",
	"CALL",
	"CALT",
	"CLC",
	"CLR",  /* 7807 */
	"CMC",  /* 7807 */
	"DAA",
	"DADC",
	"DADD",
	"DADDNC",
	"DAN",
	"DCR",
	"DCRW",
	"DCX",
	"DEQ",
	"DGT",
	"DI",
	"DIV",
	"DLT",
	"DMOV",
	"DNE",
	"DOFF",
	"DON",
	"DOR",
	"DRLL",
	"DRLR",
	"DSBB",
	"DSLL",
	"DSLR",
	"DSUB",
	"DSUBNB",
	"DXR",
	"EADD",
	"EI",
	"EQA",
	"EQAW",
	"EQAX",
	"EQI",
	"EQIW",
	"ESUB",
	"EX",   /* 7801 */
	"EXA",
	"EXH",
	"EXX",
	"EXR",  /* 7807 */
	"GTA",
	"GTAW",
	"GTAX",
	"GTI",
	"GTIW",
	"HALT",
	"IN",   /* 7801 */
	"INR",
	"INRW",
	"INX",
	"JB",
	"JEA",
	"JMP",
	"JR",
	"JRE",
	"LBCD",
	"LDAW",
	"LDAX",
	"LDEAX",
	"LDED",
	"LHLD",
	"LSPD",
	"LTA",
	"LTAW",
	"LTAX",
	"LTI",
	"LTIW",
	"LXI",
	"MOV",
	"MUL",
	"MVI",
	"MVIW",
	"MVIX",
	"NEA",
	"NEAW",
	"NEAX",
	"NEGA",
	"NEI",
	"NEIW",
	"NOP",
	"NOT",  /* 7807 */
	"OFFA",
	"OFFAW",
	"OFFAX",
	"OFFI",
	"OFFIW",
	"ONA",
	"ONAW",
	"ONAX",
	"ONI",
	"ONIW",
	"OR",   /* 7807 */
	"ORA",
	"ORAW",
	"ORAX",
	"ORI",
	"ORIW",
	"OUT",  /* 7801 */
	"PER",  /* 7801 */
	"PEX",  /* 7801 */
	"POP",
	"PUSH",
	"RET",
	"RETI",
	"RETS",
	"RLD",
	"RLL",
	"RLR",
	"RRD",
	"SBB",
	"SBBW",
	"SBBX",
	"SBCD",
	"SBI",
	"SDED",
	"SETB", /* 7807 */
	"SHLD",
	"SIO",  /* 7801 */
	"SK",
	"SKIT",
	"SKN",
	"SKNIT",
	"SLL",
	"SLLC",
	"SLR",
	"SLRC",
	"SOFTI",
	"SSPD",
	"STAW",
	"STAX",
	"STC",
	"STEAX",
	"STM",  /*7801 */
	"STOP",
	"SUB",
	"SUBNB",
	"SUBNBW",
	"SUBNBX",
	"SUBW",
	"SUBX",
	"SUI",
	"SUINB",
	"TABLE",
	"XOR",  /* 7807 */
	"XRA",
	"XRAW",
	"XRAX",
	"XRI"
};


/* prefix 48 */
static const struct dasm_s dasm48_7810[256] =
{
	{_illegal,0   }, /* 00: 0100 1000 0000 0000                      */
	{_SLRC,"A"       }, /* 01: 0100 1000 0000 0001                      */
	{_SLRC,"B"       }, /* 02: 0100 1000 0000 0010                      */
	{_SLRC,"C"       }, /* 03: 0100 1000 0000 0011                      */
	{_illegal,0   }, /* 04: 0100 1000 0000 0100                      */
	{_SLLC,"A"       }, /* 05: 0100 1000 0000 0101                      */
	{_SLLC,"B"       }, /* 06: 0100 1000 0000 0110                      */
	{_SLLC,"C"       }, /* 07: 0100 1000 0000 0111                      */
	{_SK,"NV"        }, /* 08: 0100 1000 0000 1000                      */
	{_illegal,0   }, /* 09: 0100 1000 0000 1001                      */
	{_SK,"CY"        }, /* 0a: 0100 1000 0000 1010                      */
	{_SK,"HC"        }, /* 0b: 0100 1000 0000 1011                      */
	{_SK,"Z"         }, /* 0c: 0100 1000 0000 1100                      */
	{_illegal,0   }, /* 0d: 0100 1000 0000 1101                      */
	{_illegal,0   }, /* 0e: 0100 1000 0000 1110                      */
	{_illegal,0   }, /* 0f: 0100 1000 0000 1111                      */

	{_illegal,0   }, /* 10: 0100 1000 0001 0000                      */
	{_illegal,0   }, /* 11: 0100 1000 0001 0001                      */
	{_illegal,0   }, /* 12: 0100 1000 0001 0010                      */
	{_illegal,0   }, /* 13: 0100 1000 0001 0011                      */
	{_illegal,0   }, /* 14: 0100 1000 0001 0100                      */
	{_illegal,0   }, /* 15: 0100 1000 0001 0101                      */
	{_illegal,0   }, /* 16: 0100 1000 0001 0110                      */
	{_illegal,0   }, /* 17: 0100 1000 0001 0111                      */
	{_SKN,"NV"       }, /* 18: 0100 1000 0001 1000                      */
	{_illegal,0   }, /* 19: 0100 1000 0001 1001                      */
	{_SKN,"CY"       }, /* 1a: 0100 1000 0001 1010                      */
	{_SKN,"HC"       }, /* 1b: 0100 1000 0001 1011                      */
	{_SKN,"Z"        }, /* 1c: 0100 1000 0001 1100                      */
	{_illegal,0   }, /* 1d: 0100 1000 0001 1101                      */
	{_illegal,0   }, /* 1e: 0100 1000 0001 1110                      */
	{_illegal,0   }, /* 1f: 0100 1000 0001 1111                      */

	{_illegal,0   }, /* 20: 0100 1000 0010 0000                      */
	{_SLR,"A"        }, /* 21: 0100 1000 0010 0001                      */
	{_SLR,"B"        }, /* 22: 0100 1000 0010 0010                      */
	{_SLR,"C"        }, /* 23: 0100 1000 0010 0011                      */
	{_illegal,0   }, /* 24: 0100 1000 0010 0100                      */
	{_SLL,"A"        }, /* 25: 0100 1000 0010 0101                      */
	{_SLL,"B"        }, /* 26: 0100 1000 0010 0110                      */
	{_SLL,"C"        }, /* 27: 0100 1000 0010 0111                      */
	{_JEA,0       }, /* 28: 0100 1000 0010 1000                      */
	{_CALB,0      }, /* 29: 0100 1000 0010 1001                      */
	{_CLC,0       }, /* 2a: 0100 1000 0010 1010                      */
	{_STC,0       }, /* 2b: 0100 1000 0010 1011                      */
	{_illegal,0   }, /* 2c: 0100 1000 0010 1100                      */
	{_MUL,"A"        }, /* 2d: 0100 1000 0010 1101                      */
	{_MUL,"B"        }, /* 2e: 0100 1000 0010 1110                      */
	{_MUL,"C"        }, /* 2f: 0100 1000 0010 1111                      */

	{_illegal,0   }, /* 30: 0100 1000 0011 0000                      */
	{_RLR,"A"        }, /* 31: 0100 1000 0011 0001                      */
	{_RLR,"B"        }, /* 32: 0100 1000 0011 0010                      */
	{_RLR,"C"        }, /* 33: 0100 1000 0011 0011                      */
	{_illegal,0   }, /* 34: 0100 1000 0011 0100                      */
	{_RLL,"A"        }, /* 35: 0100 1000 0011 0101                      */
	{_RLL,"B"        }, /* 36: 0100 1000 0011 0110                      */
	{_RLL,"C"        }, /* 37: 0100 1000 0011 0111                      */
	{_RLD,0       }, /* 38: 0100 1000 0011 1000                      */
	{_RRD,0       }, /* 39: 0100 1000 0011 1001                      */
	{_NEGA,0      }, /* 3a: 0100 1000 0011 1010                      */
	{_HALT,0      }, /* 3b: 0100 1000 0011 1011                      */
	{_illegal,0   }, /* 3c: 0100 1000 0011 1100                      */
	{_DIV,"A"        }, /* 3d: 0100 1000 0011 1101                      */
	{_DIV,"B"        }, /* 3e: 0100 1000 0011 1110                      */
	{_DIV,"C"        }, /* 3f: 0100 1000 0011 1111                      */

	{_SKIT,"NMI"     }, /* 40: 0100 1000 0100 0000                      */
	{_SKIT,"FT0"     }, /* 41: 0100 1000 0100 0001                      */
	{_SKIT,"FT1"     }, /* 42: 0100 1000 0100 0010                      */
	{_SKIT,"F1"      }, /* 43: 0100 1000 0100 0011                      */
	{_SKIT,"F2"      }, /* 44: 0100 1000 0100 0100                      */
	{_SKIT,"FE0"     }, /* 45: 0100 1000 0100 0101                      */
	{_SKIT,"FE1"     }, /* 46: 0100 1000 0100 0110                      */
	{_SKIT,"FEIN"    }, /* 47: 0100 1000 0100 0111                      */
	{_SKIT,"FAD"     }, /* 48: 0100 1000 0100 1000                      */
	{_SKIT,"FSR"     }, /* 49: 0100 1000 0100 1001                      */
	{_SKIT,"FST"     }, /* 4a: 0100 1000 0100 1010                      */
	{_SKIT,"ER"      }, /* 4b: 0100 1000 0100 1011                      */
	{_SKIT,"OV"      }, /* 4c: 0100 1000 0100 1100                      */
	{_illegal,0   }, /* 4d: 0100 1000 0100 1101                      */
	{_illegal,0   }, /* 4e: 0100 1000 0100 1110                      */
	{_illegal,0   }, /* 4f: 0100 1000 0100 1111                      */

	{_SKIT,"AN4"     }, /* 50: 0100 1000 0101 0000                      */
	{_SKIT,"AN5"     }, /* 51: 0100 1000 0101 0001                      */
	{_SKIT,"AN6"     }, /* 52: 0100 1000 0101 0010                      */
	{_SKIT,"AN7"     }, /* 53: 0100 1000 0101 0011                      */
	{_SKIT,"SB"      }, /* 54: 0100 1000 0101 0100                      */
	{_illegal,0   }, /* 55: 0100 1000 0101 0101                      */
	{_illegal,0   }, /* 56: 0100 1000 0101 0110                      */
	{_illegal,0   }, /* 57: 0100 1000 0101 0111                      */
	{_illegal,0   }, /* 58: 0100 1000 0101 1000                      */
	{_illegal,0   }, /* 59: 0100 1000 0101 1001                      */
	{_illegal,0   }, /* 5a: 0100 1000 0101 1010                      */
	{_illegal,0   }, /* 5b: 0100 1000 0101 1011                      */
	{_illegal,0   }, /* 5c: 0100 1000 0101 1100                      */
	{_illegal,0   }, /* 5d: 0100 1000 0101 1101                      */
	{_illegal,0   }, /* 5e: 0100 1000 0101 1110                      */
	{_illegal,0   }, /* 5f: 0100 1000 0101 1111                      */

	{_SKNIT,"NMI"    }, /* 60: 0100 1000 0110 0000                      */
	{_SKNIT,"FT0"    }, /* 61: 0100 1000 0110 0001                      */
	{_SKNIT,"FT1"    }, /* 62: 0100 1000 0110 0010                      */
	{_SKNIT,"F1"     }, /* 63: 0100 1000 0110 0011                      */
	{_SKNIT,"F2"     }, /* 64: 0100 1000 0110 0100                      */
	{_SKNIT,"FE0"    }, /* 65: 0100 1000 0110 0101                      */
	{_SKNIT,"FE1"    }, /* 66: 0100 1000 0110 0110                      */
	{_SKNIT,"FEIN"   }, /* 67: 0100 1000 0110 0111                      */
	{_SKNIT,"FAD"    }, /* 68: 0100 1000 0110 1000                      */
	{_SKNIT,"FSR"    }, /* 69: 0100 1000 0110 1001                      */
	{_SKNIT,"FST"    }, /* 6a: 0100 1000 0110 1010                      */
	{_SKNIT,"ER"     }, /* 6b: 0100 1000 0110 1011                      */
	{_SKNIT,"OV"     }, /* 6c: 0100 1000 0110 1100                      */
	{_illegal,0   }, /* 6d: 0100 1000 0110 1101                      */
	{_illegal,0   }, /* 6e: 0100 1000 0110 1110                      */
	{_illegal,0   }, /* 6f: 0100 1000 0110 1111                      */

	{_SKNIT,"AN4"    }, /* 70: 0100 1000 0111 0000                      */
	{_SKNIT,"AN5"    }, /* 71: 0100 1000 0111 0001                      */
	{_SKNIT,"AN6"    }, /* 72: 0100 1000 0111 0010                      */
	{_SKNIT,"AN7"    }, /* 73: 0100 1000 0111 0011                      */
	{_SKNIT,"SB"     }, /* 74: 0100 1000 0111 0100                      */
	{_illegal,0   }, /* 75: 0100 1000 0111 0101                      */
	{_illegal,0   }, /* 76: 0100 1000 0111 0110                      */
	{_illegal,0   }, /* 77: 0100 1000 0111 0111                      */
	{_illegal,0   }, /* 78: 0100 1000 0111 1000                      */
	{_illegal,0   }, /* 79: 0100 1000 0111 1001                      */
	{_illegal,0   }, /* 7a: 0100 1000 0111 1010                      */
	{_illegal,0   }, /* 7b: 0100 1000 0111 1011                      */
	{_illegal,0   }, /* 7c: 0100 1000 0111 1100                      */
	{_illegal,0   }, /* 7d: 0100 1000 0111 1101                      */
	{_illegal,0   }, /* 7e: 0100 1000 0111 1110                      */
	{_illegal,0   }, /* 7f: 0100 1000 0111 1111                      */

	{_illegal,0   }, /* 80: 0100 1000 1000 0000                      */
	{_illegal,0   }, /* 81: 0100 1000 1000 0001                      */
	{_LDEAX,"(DE)"   }, /* 82: 0100 1000 1000 0010                      */
	{_LDEAX,"(HL)"   }, /* 83: 0100 1000 1000 0011                      */
	{_LDEAX,"(DE++)" }, /* 84: 0100 1000 1000 0100                      */
	{_LDEAX,"(HL++)" }, /* 85: 0100 1000 1000 0101                      */
	{_illegal,0   }, /* 86: 0100 1000 1000 0110                      */
	{_illegal,0   }, /* 87: 0100 1000 1000 0111                      */
	{_illegal,0   }, /* 88: 0100 1000 1000 1000                      */
	{_illegal,0   }, /* 89: 0100 1000 1000 1001                      */
	{_illegal,0   }, /* 8a: 0100 1000 1000 1010                      */
	{_LDEAX,"(DE+%b)"}, /* 8b: 0100 1000 1000 1011 xxxx xxxx            */
	{_LDEAX,"(HL+A)" }, /* 8c: 0100 1000 1000 1100                      */
	{_LDEAX,"(HL+B)" }, /* 8d: 0100 1000 1000 1101                      */
	{_LDEAX,"(HL+EA)"}, /* 8e: 0100 1000 1000 1110                      */
	{_LDEAX,"(HL+%b)"}, /* 8f: 0100 1000 1000 1111 xxxx xxxx            */

	{_illegal,0   }, /* 90: 0100 1000 1000 0000                      */
	{_illegal,0   }, /* 91: 0100 1000 1000 0001                      */
	{_STEAX,"(DE)"   }, /* 92: 0100 1000 1000 0010                      */
	{_STEAX,"(HL)"   }, /* 93: 0100 1000 1000 0011                      */
	{_STEAX,"(DE++)" }, /* 94: 0100 1000 1000 0100                      */
	{_STEAX,"(HL++)" }, /* 95: 0100 1000 1000 0101                      */
	{_illegal,0   }, /* 96: 0100 1000 1000 0110                      */
	{_illegal,0   }, /* 97: 0100 1000 1000 0111                      */
	{_illegal,0   }, /* 98: 0100 1000 1000 1000                      */
	{_illegal,0   }, /* 99: 0100 1000 1000 1001                      */
	{_illegal,0   }, /* 9a: 0100 1000 1000 1010                      */
	{_STEAX,"(DE+%b)"}, /* 9b: 0100 1000 1000 1011 xxxx xxxx            */
	{_STEAX,"(HL+A)" }, /* 9c: 0100 1000 1000 1100                      */
	{_STEAX,"(HL+B)" }, /* 9d: 0100 1000 1000 1101                      */
	{_STEAX,"(HL+EA)"}, /* 9e: 0100 1000 1000 1110                      */
	{_STEAX,"(HL+%b)"}, /* 9f: 0100 1000 1000 1111 xxxx xxxx            */

	{_DSLR,"EA"      }, /* a0: 0100 1000 1010 0000                      */
	{_illegal,0   }, /* a1: 0100 1000 1010 0001                      */
	{_illegal,0   }, /* a2: 0100 1000 1010 0010                      */
	{_illegal,0   }, /* a3: 0100 1000 1010 0011                      */
	{_DSLL,"EA"      }, /* a4: 0100 1000 1010 0100                      */
	{_illegal,0   }, /* a5: 0100 1000 1010 0101                      */
	{_illegal,0   }, /* a6: 0100 1000 1010 0110                      */
	{_illegal,0   }, /* a7: 0100 1000 1010 0111                      */
	{_TABLE,0         }, /* a8: 0100 1000 1010 1000                      */
	{_illegal,0   }, /* a9: 0100 1000 1010 1001                      */
	{_illegal,0   }, /* aa: 0100 1000 1010 1010                      */
	{_illegal,0   }, /* ab: 0100 1000 1010 1011                      */
	{_illegal,0   }, /* ac: 0100 1000 1010 1100                      */
	{_illegal,0   }, /* ad: 0100 1000 1010 1101                      */
	{_illegal,0   }, /* ae: 0100 1000 1010 1110                      */
	{_illegal,0   }, /* af: 0100 1000 1010 1111                      */

	{_DRLR,"EA"      }, /* b0: 0100 1000 1011 0000                      */
	{_illegal,0   }, /* b1: 0100 1000 1011 0001                      */
	{_illegal,0   }, /* b2: 0100 1000 1011 0010                      */
	{_illegal,0   }, /* b3: 0100 1000 1011 0011                      */
	{_DRLL,"EA"      }, /* b4: 0100 1000 1011 0100                      */
	{_illegal,0   }, /* b5: 0100 1000 1011 0101                      */
	{_illegal,0   }, /* b6: 0100 1000 1011 0110                      */
	{_illegal,0   }, /* b7: 0100 1000 1011 0111                      */
	{_illegal,0   }, /* b8: 0100 1000 1011 1000                      */
	{_illegal,0   }, /* b9: 0100 1000 1011 1001                      */
	{_illegal,0   }, /* ba: 0100 1000 1011 1010                      */
	{_STOP,0      }, /* bb: 0100 1000 1011 1011                      */  /* 7810 */
	{_illegal,0   }, /* bc: 0100 1000 1011 1100                      */
	{_illegal,0   }, /* bd: 0100 1000 1011 1101                      */
	{_illegal,0   }, /* be: 0100 1000 1011 1110                      */
	{_illegal,0   }, /* bf: 0100 1000 1011 1111                      */

	{_DMOV,"EA,ECNT" }, /* c0: 0100 1000 1100 0000                      */
	{_DMOV,"EA,ECPT" }, /* c1: 0100 1000 1100 0001                      */   /* 7810 */
	{_illegal,0   }, /* c2: 0100 1000 1100 0010                      */
	{_illegal,0   }, /* c3: 0100 1000 1100 0011                      */
	{_illegal,0   }, /* c4: 0100 1000 1100 0100                      */
	{_illegal,0   }, /* c5: 0100 1000 1100 0101                      */
	{_illegal,0   }, /* c6: 0100 1000 1100 0110                      */
	{_illegal,0   }, /* c7: 0100 1000 1100 0111                      */
	{_illegal,0   }, /* c8: 0100 1000 1100 1000                      */
	{_illegal,0   }, /* c9: 0100 1000 1100 1001                      */
	{_illegal,0   }, /* ca: 0100 1000 1100 1010                      */
	{_illegal,0   }, /* cb: 0100 1000 1100 1011                      */
	{_illegal,0   }, /* cc: 0100 1000 1100 1100                      */
	{_illegal,0   }, /* cd: 0100 1000 1100 1101                      */
	{_illegal,0   }, /* ce: 0100 1000 1100 1110                      */
	{_illegal,0   }, /* cf: 0100 1000 1100 1111                      */

	{_illegal,0   }, /* d0: 0100 1000 1101 0000                      */
	{_illegal,0   }, /* d1: 0100 1000 1101 0001                      */
	{_DMOV,"ETM0,EA" }, /* d2: 0100 1000 1101 0010                      */
	{_DMOV,"ETM1,EA" }, /* d3: 0100 1000 1101 0011                      */
	{_illegal,0   }, /* d4: 0100 1000 1101 0100                      */
	{_illegal,0   }, /* d5: 0100 1000 1101 0101                      */
	{_illegal,0   }, /* d6: 0100 1000 1101 0110                      */
	{_illegal,0   }, /* d7: 0100 1000 1101 0111                      */
	{_illegal,0   }, /* d8: 0100 1000 1101 1000                      */
	{_illegal,0   }, /* d9: 0100 1000 1101 1001                      */
	{_illegal,0   }, /* da: 0100 1000 1101 1010                      */
	{_illegal,0   }, /* db: 0100 1000 1101 1011                      */
	{_illegal,0   }, /* dc: 0100 1000 1101 1100                      */
	{_illegal,0   }, /* dd: 0100 1000 1101 1101                      */
	{_illegal,0   }, /* de: 0100 1000 1101 1110                      */
	{_illegal,0   }, /* df: 0100 1000 1101 1111                      */

	{_illegal,0   }, /* e0: 0100 1000 1110 0000                      */
	{_illegal,0   }, /* e1: 0100 1000 1110 0001                      */
	{_illegal,0   }, /* e2: 0100 1000 1110 0010                      */
	{_illegal,0   }, /* e3: 0100 1000 1110 0011                      */
	{_illegal,0   }, /* e4: 0100 1000 1110 0100                      */
	{_illegal,0   }, /* e5: 0100 1000 1110 0101                      */
	{_illegal,0   }, /* e6: 0100 1000 1110 0110                      */
	{_illegal,0   }, /* e7: 0100 1000 1110 0111                      */
	{_illegal,0   }, /* e8: 0100 1000 1110 1000                      */
	{_illegal,0   }, /* e9: 0100 1000 1110 1001                      */
	{_illegal,0   }, /* ea: 0100 1000 1110 1010                      */
	{_illegal,0   }, /* eb: 0100 1000 1110 1011                      */
	{_illegal,0   }, /* ec: 0100 1000 1110 1100                      */
	{_illegal,0   }, /* ed: 0100 1000 1110 1101                      */
	{_illegal,0   }, /* ee: 0100 1000 1110 1110                      */
	{_illegal,0   }, /* ef: 0100 1000 1110 1111                      */

	{_illegal,0   }, /* f0: 0100 1000 1111 0000                      */
	{_illegal,0   }, /* f1: 0100 1000 1111 0001                      */
	{_illegal,0   }, /* f2: 0100 1000 1111 0010                      */
	{_illegal,0   }, /* f3: 0100 1000 1111 0011                      */
	{_illegal,0   }, /* f4: 0100 1000 1111 0100                      */
	{_illegal,0   }, /* f5: 0100 1000 1111 0101                      */
	{_illegal,0   }, /* f6: 0100 1000 1111 0110                      */
	{_illegal,0   }, /* f7: 0100 1000 1111 0111                      */
	{_illegal,0   }, /* f8: 0100 1000 1111 1000                      */
	{_illegal,0   }, /* f9: 0100 1000 1111 1001                      */
	{_illegal,0   }, /* fa: 0100 1000 1111 1010                      */
	{_illegal,0   }, /* fb: 0100 1000 1111 1011                      */
	{_illegal,0   }, /* fc: 0100 1000 1111 1100                      */
	{_illegal,0   }, /* fd: 0100 1000 1111 1101                      */
	{_illegal,0   }, /* fe: 0100 1000 1111 1110                      */
	{_illegal,0   }  /* ff: 0100 1000 1111 1111                      */
};

static const struct dasm_s dasm48_7807[256] =
{
	{_illegal,0   }, /* 00: 0100 1000 0000 0000                      */
	{_SLRC,"A"       }, /* 01: 0100 1000 0000 0001                      */
	{_SLRC,"B"       }, /* 02: 0100 1000 0000 0010                      */
	{_SLRC,"C"       }, /* 03: 0100 1000 0000 0011                      */
	{_illegal,0   }, /* 04: 0100 1000 0000 0100                      */
	{_SLLC,"A"       }, /* 05: 0100 1000 0000 0101                      */
	{_SLLC,"B"       }, /* 06: 0100 1000 0000 0110                      */
	{_SLLC,"C"       }, /* 07: 0100 1000 0000 0111                      */
	{_SK,"NV"        }, /* 08: 0100 1000 0000 1000                      */
	{_illegal,0   }, /* 09: 0100 1000 0000 1001                      */
	{_SK,"CY"        }, /* 0a: 0100 1000 0000 1010                      */
	{_SK,"HC"        }, /* 0b: 0100 1000 0000 1011                      */
	{_SK,"Z"         }, /* 0c: 0100 1000 0000 1100                      */
	{_illegal,0   }, /* 0d: 0100 1000 0000 1101                      */
	{_illegal,0   }, /* 0e: 0100 1000 0000 1110                      */
	{_illegal,0   }, /* 0f: 0100 1000 0000 1111                      */

	{_illegal,0   }, /* 10: 0100 1000 0001 0000                      */
	{_illegal,0   }, /* 11: 0100 1000 0001 0001                      */
	{_illegal,0   }, /* 12: 0100 1000 0001 0010                      */
	{_illegal,0   }, /* 13: 0100 1000 0001 0011                      */
	{_illegal,0   }, /* 14: 0100 1000 0001 0100                      */
	{_illegal,0   }, /* 15: 0100 1000 0001 0101                      */
	{_illegal,0   }, /* 16: 0100 1000 0001 0110                      */
	{_illegal,0   }, /* 17: 0100 1000 0001 0111                      */
	{_SKN,"NV"       }, /* 18: 0100 1000 0001 1000                      */
	{_illegal,0   }, /* 19: 0100 1000 0001 1001                      */
	{_SKN,"CY"       }, /* 1a: 0100 1000 0001 1010                      */
	{_SKN,"HC"       }, /* 1b: 0100 1000 0001 1011                      */
	{_SKN,"Z"        }, /* 1c: 0100 1000 0001 1100                      */
	{_illegal,0   }, /* 1d: 0100 1000 0001 1101                      */
	{_illegal,0   }, /* 1e: 0100 1000 0001 1110                      */
	{_illegal,0   }, /* 1f: 0100 1000 0001 1111                      */

	{_illegal,0   }, /* 20: 0100 1000 0010 0000                      */
	{_SLR,"A"        }, /* 21: 0100 1000 0010 0001                      */
	{_SLR,"B"        }, /* 22: 0100 1000 0010 0010                      */
	{_SLR,"C"        }, /* 23: 0100 1000 0010 0011                      */
	{_illegal,0   }, /* 24: 0100 1000 0010 0100                      */
	{_SLL,"A"        }, /* 25: 0100 1000 0010 0101                      */
	{_SLL,"B"        }, /* 26: 0100 1000 0010 0110                      */
	{_SLL,"C"        }, /* 27: 0100 1000 0010 0111                      */
	{_JEA,0       }, /* 28: 0100 1000 0010 1000                      */
	{_CALB,0      }, /* 29: 0100 1000 0010 1001                      */
	{_CLC,0       }, /* 2a: 0100 1000 0010 1010                      */
	{_STC,0       }, /* 2b: 0100 1000 0010 1011                      */
	{_illegal,0   }, /* 2c: 0100 1000 0010 1100                      */
	{_MUL,"A"        }, /* 2d: 0100 1000 0010 1101                      */
	{_MUL,"B"        }, /* 2e: 0100 1000 0010 1110                      */
	{_MUL,"C"        }, /* 2f: 0100 1000 0010 1111                      */

	{_illegal,0   }, /* 30: 0100 1000 0011 0000                      */
	{_RLR,"A"        }, /* 31: 0100 1000 0011 0001                      */
	{_RLR,"B"        }, /* 32: 0100 1000 0011 0010                      */
	{_RLR,"C"        }, /* 33: 0100 1000 0011 0011                      */
	{_illegal,0   }, /* 34: 0100 1000 0011 0100                      */
	{_RLL,"A"        }, /* 35: 0100 1000 0011 0101                      */
	{_RLL,"B"        }, /* 36: 0100 1000 0011 0110                      */
	{_RLL,"C"        }, /* 37: 0100 1000 0011 0111                      */
	{_RLD,0       }, /* 38: 0100 1000 0011 1000                      */
	{_RRD,0       }, /* 39: 0100 1000 0011 1001                      */
	{_NEGA,0      }, /* 3a: 0100 1000 0011 1010                      */
	{_HALT,0      }, /* 3b: 0100 1000 0011 1011                      */
	{_illegal,0   }, /* 3c: 0100 1000 0011 1100                      */
	{_DIV,"A"        }, /* 3d: 0100 1000 0011 1101                      */
	{_DIV,"B"        }, /* 3e: 0100 1000 0011 1110                      */
	{_DIV,"C"        }, /* 3f: 0100 1000 0011 1111                      */

	{_SKIT,"NMI"     }, /* 40: 0100 1000 0100 0000                      */
	{_SKIT,"FT0"     }, /* 41: 0100 1000 0100 0001                      */
	{_SKIT,"FT1"     }, /* 42: 0100 1000 0100 0010                      */
	{_SKIT,"F1"      }, /* 43: 0100 1000 0100 0011                      */
	{_SKIT,"F2"      }, /* 44: 0100 1000 0100 0100                      */
	{_SKIT,"FE0"     }, /* 45: 0100 1000 0100 0101                      */
	{_SKIT,"FE1"     }, /* 46: 0100 1000 0100 0110                      */
	{_SKIT,"FEIN"    }, /* 47: 0100 1000 0100 0111                      */
	{_SKIT,"FAD"     }, /* 48: 0100 1000 0100 1000                      */
	{_SKIT,"FSR"     }, /* 49: 0100 1000 0100 1001                      */
	{_SKIT,"FST"     }, /* 4a: 0100 1000 0100 1010                      */
	{_SKIT,"ER"      }, /* 4b: 0100 1000 0100 1011                      */
	{_SKIT,"OV"      }, /* 4c: 0100 1000 0100 1100                      */
	{_illegal,0   }, /* 4d: 0100 1000 0100 1101                      */
	{_illegal,0   }, /* 4e: 0100 1000 0100 1110                      */
	{_illegal,0   }, /* 4f: 0100 1000 0100 1111                      */

	{_SKIT,"AN4"     }, /* 50: 0100 1000 0101 0000                      */
	{_SKIT,"AN5"     }, /* 51: 0100 1000 0101 0001                      */
	{_SKIT,"AN6"     }, /* 52: 0100 1000 0101 0010                      */
	{_SKIT,"AN7"     }, /* 53: 0100 1000 0101 0011                      */
	{_SKIT,"SB"      }, /* 54: 0100 1000 0101 0100                      */
	{_illegal,0   }, /* 55: 0100 1000 0101 0101                      */
	{_illegal,0   }, /* 56: 0100 1000 0101 0110                      */
	{_illegal,0   }, /* 57: 0100 1000 0101 0111                      */
	{_illegal,0   }, /* 58: 0100 1000 0101 1000                      */
	{_illegal,0   }, /* 59: 0100 1000 0101 1001                      */
	{_illegal,0   }, /* 5a: 0100 1000 0101 1010                      */
	{_illegal,0   }, /* 5b: 0100 1000 0101 1011                      */
	{_illegal,0   }, /* 5c: 0100 1000 0101 1100                      */
	{_illegal,0   }, /* 5d: 0100 1000 0101 1101                      */
	{_illegal,0   }, /* 5e: 0100 1000 0101 1110                      */
	{_illegal,0   }, /* 5f: 0100 1000 0101 1111                      */

	{_SKNIT,"NMI"    }, /* 60: 0100 1000 0110 0000                      */
	{_SKNIT,"FT0"    }, /* 61: 0100 1000 0110 0001                      */
	{_SKNIT,"FT1"    }, /* 62: 0100 1000 0110 0010                      */
	{_SKNIT,"F1"     }, /* 63: 0100 1000 0110 0011                      */
	{_SKNIT,"F2"     }, /* 64: 0100 1000 0110 0100                      */
	{_SKNIT,"FE0"    }, /* 65: 0100 1000 0110 0101                      */
	{_SKNIT,"FE1"    }, /* 66: 0100 1000 0110 0110                      */
	{_SKNIT,"FEIN"   }, /* 67: 0100 1000 0110 0111                      */
	{_SKNIT,"FAD"    }, /* 68: 0100 1000 0110 1000                      */
	{_SKNIT,"FSR"    }, /* 69: 0100 1000 0110 1001                      */
	{_SKNIT,"FST"    }, /* 6a: 0100 1000 0110 1010                      */
	{_SKNIT,"ER"     }, /* 6b: 0100 1000 0110 1011                      */
	{_SKNIT,"OV"     }, /* 6c: 0100 1000 0110 1100                      */
	{_illegal,0   }, /* 6d: 0100 1000 0110 1101                      */
	{_illegal,0   }, /* 6e: 0100 1000 0110 1110                      */
	{_illegal,0   }, /* 6f: 0100 1000 0110 1111                      */

	{_SKNIT,"AN4"    }, /* 70: 0100 1000 0111 0000                      */
	{_SKNIT,"AN5"    }, /* 71: 0100 1000 0111 0001                      */
	{_SKNIT,"AN6"    }, /* 72: 0100 1000 0111 0010                      */
	{_SKNIT,"AN7"    }, /* 73: 0100 1000 0111 0011                      */
	{_SKNIT,"SB"     }, /* 74: 0100 1000 0111 0100                      */
	{_illegal,0   }, /* 75: 0100 1000 0111 0101                      */
	{_illegal,0   }, /* 76: 0100 1000 0111 0110                      */
	{_illegal,0   }, /* 77: 0100 1000 0111 0111                      */
	{_illegal,0   }, /* 78: 0100 1000 0111 1000                      */
	{_illegal,0   }, /* 79: 0100 1000 0111 1001                      */
	{_illegal,0   }, /* 7a: 0100 1000 0111 1010                      */
	{_illegal,0   }, /* 7b: 0100 1000 0111 1011                      */
	{_illegal,0   }, /* 7c: 0100 1000 0111 1100                      */
	{_illegal,0   }, /* 7d: 0100 1000 0111 1101                      */
	{_illegal,0   }, /* 7e: 0100 1000 0111 1110                      */
	{_illegal,0   }, /* 7f: 0100 1000 0111 1111                      */

	{_illegal,0   }, /* 80: 0100 1000 1000 0000                      */
	{_illegal,0   }, /* 81: 0100 1000 1000 0001                      */
	{_LDEAX,"(DE)"   }, /* 82: 0100 1000 1000 0010                      */
	{_LDEAX,"(HL)"   }, /* 83: 0100 1000 1000 0011                      */
	{_LDEAX,"(DE++)" }, /* 84: 0100 1000 1000 0100                      */
	{_LDEAX,"(HL++)" }, /* 85: 0100 1000 1000 0101                      */
	{_illegal,0   }, /* 86: 0100 1000 1000 0110                      */
	{_illegal,0   }, /* 87: 0100 1000 1000 0111                      */
	{_illegal,0   }, /* 88: 0100 1000 1000 1000                      */
	{_illegal,0   }, /* 89: 0100 1000 1000 1001                      */
	{_illegal,0   }, /* 8a: 0100 1000 1000 1010                      */
	{_LDEAX,"(DE+%b)"}, /* 8b: 0100 1000 1000 1011 xxxx xxxx            */
	{_LDEAX,"(HL+A)" }, /* 8c: 0100 1000 1000 1100                      */
	{_LDEAX,"(HL+B)" }, /* 8d: 0100 1000 1000 1101                      */
	{_LDEAX,"(HL+EA)"}, /* 8e: 0100 1000 1000 1110                      */
	{_LDEAX,"(HL+%b)"}, /* 8f: 0100 1000 1000 1111 xxxx xxxx            */

	{_illegal,0   }, /* 90: 0100 1000 1000 0000                      */
	{_illegal,0   }, /* 91: 0100 1000 1000 0001                      */
	{_STEAX,"(DE)"   }, /* 92: 0100 1000 1000 0010                      */
	{_STEAX,"(HL)"   }, /* 93: 0100 1000 1000 0011                      */
	{_STEAX,"(DE++)" }, /* 94: 0100 1000 1000 0100                      */
	{_STEAX,"(HL++)" }, /* 95: 0100 1000 1000 0101                      */
	{_illegal,0   }, /* 96: 0100 1000 1000 0110                      */
	{_illegal,0   }, /* 97: 0100 1000 1000 0111                      */
	{_illegal,0   }, /* 98: 0100 1000 1000 1000                      */
	{_illegal,0   }, /* 99: 0100 1000 1000 1001                      */
	{_illegal,0   }, /* 9a: 0100 1000 1000 1010                      */
	{_STEAX,"(DE+%b)"}, /* 9b: 0100 1000 1000 1011 xxxx xxxx            */
	{_STEAX,"(HL+A)" }, /* 9c: 0100 1000 1000 1100                      */
	{_STEAX,"(HL+B)" }, /* 9d: 0100 1000 1000 1101                      */
	{_STEAX,"(HL+EA)"}, /* 9e: 0100 1000 1000 1110                      */
	{_STEAX,"(HL+%b)"}, /* 9f: 0100 1000 1000 1111 xxxx xxxx            */

	{_DSLR,"EA"      }, /* a0: 0100 1000 1010 0000                      */
	{_illegal,0   }, /* a1: 0100 1000 1010 0001                      */
	{_illegal,0   }, /* a2: 0100 1000 1010 0010                      */
	{_illegal,0   }, /* a3: 0100 1000 1010 0011                      */
	{_DSLL,"EA"      }, /* a4: 0100 1000 1010 0100                      */
	{_illegal,0   }, /* a5: 0100 1000 1010 0101                      */
	{_illegal,0   }, /* a6: 0100 1000 1010 0110                      */
	{_illegal,0   }, /* a7: 0100 1000 1010 0111                      */
	{_TABLE,0         }, /* a8: 0100 1000 1010 1000                      */
	{_illegal,0   }, /* a9: 0100 1000 1010 1001                      */
	{_CMC,0       }, /* aa: 0100 1000 1010 1010                      */  /* 7807 */
	{_illegal,0   }, /* ab: 0100 1000 1010 1011                      */
	{_EXA,0       }, /* ac: 0100 1000 1010 1100                      */  /* 7807 */
	{_EXR,0       }, /* ad: 0100 1000 1010 1101                      */  /* 7807 */
	{_EXH,0       }, /* ae: 0100 1000 1010 1110                      */  /* 7807 */
	{_EXX,0       }, /* af: 0100 1000 1010 1111                      */  /* 7807 */

	{_DRLR,"EA"      }, /* b0: 0100 1000 1011 0000                      */
	{_illegal,0   }, /* b1: 0100 1000 1011 0001                      */
	{_illegal,0   }, /* b2: 0100 1000 1011 0010                      */
	{_illegal,0   }, /* b3: 0100 1000 1011 0011                      */
	{_DRLL,"EA"      }, /* b4: 0100 1000 1011 0100                      */
	{_illegal,0   }, /* b5: 0100 1000 1011 0101                      */
	{_illegal,0   }, /* b6: 0100 1000 1011 0110                      */
	{_illegal,0   }, /* b7: 0100 1000 1011 0111                      */
	{_illegal,0   }, /* b8: 0100 1000 1011 1000                      */
	{_illegal,0   }, /* b9: 0100 1000 1011 1001                      */
	{_illegal,0   }, /* ba: 0100 1000 1011 1010                      */
	{_illegal,0       }, /* bb: 0100 1000 1011 1011                      */
	{_illegal,0   }, /* bc: 0100 1000 1011 1100                      */
	{_illegal,0   }, /* bd: 0100 1000 1011 1101                      */
	{_illegal,0   }, /* be: 0100 1000 1011 1110                      */
	{_illegal,0   }, /* bf: 0100 1000 1011 1111                      */

	{_DMOV,"EA,ECNT" }, /* c0: 0100 1000 1100 0000                      */
	{_DMOV,"EA,ECPT0"}, /* c1: 0100 1000 1100 0001                      */   /* 7807 */
	{_DMOV,"EA,ECPT1"}, /* c2: 0100 1000 1100 0010                      */   /* 7807 */
	{_illegal,0   }, /* c3: 0100 1000 1100 0011                      */
	{_illegal,0   }, /* c4: 0100 1000 1100 0100                      */
	{_illegal,0   }, /* c5: 0100 1000 1100 0101                      */
	{_illegal,0   }, /* c6: 0100 1000 1100 0110                      */
	{_illegal,0   }, /* c7: 0100 1000 1100 0111                      */
	{_illegal,0   }, /* c8: 0100 1000 1100 1000                      */
	{_illegal,0   }, /* c9: 0100 1000 1100 1001                      */
	{_illegal,0   }, /* ca: 0100 1000 1100 1010                      */
	{_illegal,0   }, /* cb: 0100 1000 1100 1011                      */
	{_illegal,0   }, /* cc: 0100 1000 1100 1100                      */
	{_illegal,0   }, /* cd: 0100 1000 1100 1101                      */
	{_illegal,0   }, /* ce: 0100 1000 1100 1110                      */
	{_illegal,0   }, /* cf: 0100 1000 1100 1111                      */

	{_illegal,0   }, /* d0: 0100 1000 1101 0000                      */
	{_illegal,0   }, /* d1: 0100 1000 1101 0001                      */
	{_DMOV,"ETM0,EA" }, /* d2: 0100 1000 1101 0010                      */
	{_DMOV,"ETM1,EA" }, /* d3: 0100 1000 1101 0011                      */
	{_illegal,0   }, /* d4: 0100 1000 1101 0100                      */
	{_illegal,0   }, /* d5: 0100 1000 1101 0101                      */
	{_illegal,0   }, /* d6: 0100 1000 1101 0110                      */
	{_illegal,0   }, /* d7: 0100 1000 1101 0111                      */
	{_illegal,0   }, /* d8: 0100 1000 1101 1000                      */
	{_illegal,0   }, /* d9: 0100 1000 1101 1001                      */
	{_illegal,0   }, /* da: 0100 1000 1101 1010                      */
	{_illegal,0   }, /* db: 0100 1000 1101 1011                      */
	{_illegal,0   }, /* dc: 0100 1000 1101 1100                      */
	{_illegal,0   }, /* dd: 0100 1000 1101 1101                      */
	{_illegal,0   }, /* de: 0100 1000 1101 1110                      */
	{_illegal,0   }, /* df: 0100 1000 1101 1111                      */

	{_illegal,0   }, /* e0: 0100 1000 1110 0000                      */
	{_illegal,0   }, /* e1: 0100 1000 1110 0001                      */
	{_illegal,0   }, /* e2: 0100 1000 1110 0010                      */
	{_illegal,0   }, /* e3: 0100 1000 1110 0011                      */
	{_illegal,0   }, /* e4: 0100 1000 1110 0100                      */
	{_illegal,0   }, /* e5: 0100 1000 1110 0101                      */
	{_illegal,0   }, /* e6: 0100 1000 1110 0110                      */
	{_illegal,0   }, /* e7: 0100 1000 1110 0111                      */
	{_illegal,0   }, /* e8: 0100 1000 1110 1000                      */
	{_illegal,0   }, /* e9: 0100 1000 1110 1001                      */
	{_illegal,0   }, /* ea: 0100 1000 1110 1010                      */
	{_illegal,0   }, /* eb: 0100 1000 1110 1011                      */
	{_illegal,0   }, /* ec: 0100 1000 1110 1100                      */
	{_illegal,0   }, /* ed: 0100 1000 1110 1101                      */
	{_illegal,0   }, /* ee: 0100 1000 1110 1110                      */
	{_illegal,0   }, /* ef: 0100 1000 1110 1111                      */

	{_illegal,0   }, /* f0: 0100 1000 1111 0000                      */
	{_illegal,0   }, /* f1: 0100 1000 1111 0001                      */
	{_illegal,0   }, /* f2: 0100 1000 1111 0010                      */
	{_illegal,0   }, /* f3: 0100 1000 1111 0011                      */
	{_illegal,0   }, /* f4: 0100 1000 1111 0100                      */
	{_illegal,0   }, /* f5: 0100 1000 1111 0101                      */
	{_illegal,0   }, /* f6: 0100 1000 1111 0110                      */
	{_illegal,0   }, /* f7: 0100 1000 1111 0111                      */
	{_illegal,0   }, /* f8: 0100 1000 1111 1000                      */
	{_illegal,0   }, /* f9: 0100 1000 1111 1001                      */
	{_illegal,0   }, /* fa: 0100 1000 1111 1010                      */
	{_illegal,0   }, /* fb: 0100 1000 1111 1011                      */
	{_illegal,0   }, /* fc: 0100 1000 1111 1100                      */
	{_illegal,0   }, /* fd: 0100 1000 1111 1101                      */
	{_illegal,0   }, /* fe: 0100 1000 1111 1110                      */
	{_illegal,0   }  /* ff: 0100 1000 1111 1111                      */
};

/* prefix 4C */
static const struct dasm_s  dasm4C_7810[256] =
{
	{_illegal,0   }, /* 00: 0100 1100 0000 0000                      */
	{_illegal,0   }, /* 01: 0100 1100 0000 0001                      */
	{_illegal,0   }, /* 02: 0100 1100 0000 0010                      */
	{_illegal,0   }, /* 03: 0100 1100 0000 0011                      */
	{_illegal,0   }, /* 04: 0100 1100 0000 0100                      */
	{_illegal,0   }, /* 05: 0100 1100 0000 0101                      */
	{_illegal,0   }, /* 06: 0100 1100 0000 0110                      */
	{_illegal,0   }, /* 07: 0100 1100 0000 0111                      */
	{_illegal,0   }, /* 08: 0100 1100 0000 1000                      */
	{_illegal,0   }, /* 09: 0100 1100 0000 1001                      */
	{_illegal,0   }, /* 0a: 0100 1100 0000 1010                      */
	{_illegal,0   }, /* 0b: 0100 1100 0000 1011                      */
	{_illegal,0   }, /* 0c: 0100 1100 0000 1100                      */
	{_illegal,0   }, /* 0d: 0100 1100 0000 1101                      */
	{_illegal,0   }, /* 0e: 0100 1100 0000 1110                      */
	{_illegal,0   }, /* 0f: 0100 1100 0000 1111                      */

	{_illegal,0   }, /* 10: 0100 1100 0001 0000                      */
	{_illegal,0   }, /* 11: 0100 1100 0001 0001                      */
	{_illegal,0   }, /* 12: 0100 1100 0001 0010                      */
	{_illegal,0   }, /* 13: 0100 1100 0001 0011                      */
	{_illegal,0   }, /* 14: 0100 1100 0001 0100                      */
	{_illegal,0   }, /* 15: 0100 1100 0001 0101                      */
	{_illegal,0   }, /* 16: 0100 1100 0001 0110                      */
	{_illegal,0   }, /* 17: 0100 1100 0001 0111                      */
	{_illegal,0   }, /* 18: 0100 1100 0001 1000                      */
	{_illegal,0   }, /* 19: 0100 1100 0001 1001                      */
	{_illegal,0   }, /* 1a: 0100 1100 0001 1010                      */
	{_illegal,0   }, /* 1b: 0100 1100 0001 1011                      */
	{_illegal,0   }, /* 1c: 0100 1100 0001 1100                      */
	{_illegal,0   }, /* 1d: 0100 1100 0001 1101                      */
	{_illegal,0   }, /* 1e: 0100 1100 0001 1110                      */
	{_illegal,0   }, /* 1f: 0100 1100 0001 1111                      */

	{_illegal,0   }, /* 20: 0100 1100 0010 0000                      */
	{_illegal,0   }, /* 21: 0100 1100 0010 0001                      */
	{_illegal,0   }, /* 22: 0100 1100 0010 0010                      */
	{_illegal,0   }, /* 23: 0100 1100 0010 0011                      */
	{_illegal,0   }, /* 24: 0100 1100 0010 0100                      */
	{_illegal,0   }, /* 25: 0100 1100 0010 0101                      */
	{_illegal,0   }, /* 26: 0100 1100 0010 0110                      */
	{_illegal,0   }, /* 27: 0100 1100 0010 0111                      */
	{_illegal,0   }, /* 28: 0100 1100 0010 1000                      */
	{_illegal,0   }, /* 29: 0100 1100 0010 1001                      */
	{_illegal,0   }, /* 2a: 0100 1100 0010 1010                      */
	{_illegal,0   }, /* 2b: 0100 1100 0010 1011                      */
	{_illegal,0   }, /* 2c: 0100 1100 0010 1100                      */
	{_illegal,0   }, /* 2d: 0100 1100 0010 1101                      */
	{_illegal,0   }, /* 2e: 0100 1100 0010 1110                      */
	{_illegal,0   }, /* 2f: 0100 1100 0010 1111                      */

	{_illegal,0   }, /* 30: 0100 1100 0011 0000                      */
	{_illegal,0   }, /* 31: 0100 1100 0011 0001                      */
	{_illegal,0   }, /* 32: 0100 1100 0011 0010                      */
	{_illegal,0   }, /* 33: 0100 1100 0011 0011                      */
	{_illegal,0   }, /* 34: 0100 1100 0011 0100                      */
	{_illegal,0   }, /* 35: 0100 1100 0011 0101                      */
	{_illegal,0   }, /* 36: 0100 1100 0011 0110                      */
	{_illegal,0   }, /* 37: 0100 1100 0011 0111                      */
	{_illegal,0   }, /* 38: 0100 1100 0011 1000                      */
	{_illegal,0   }, /* 39: 0100 1100 0011 1001                      */
	{_illegal,0   }, /* 3a: 0100 1100 0011 1010                      */
	{_illegal,0   }, /* 3b: 0100 1100 0011 1011                      */
	{_illegal,0   }, /* 3c: 0100 1100 0011 1100                      */
	{_illegal,0   }, /* 3d: 0100 1100 0011 1101                      */
	{_illegal,0   }, /* 3e: 0100 1100 0011 1110                      */
	{_illegal,0   }, /* 3f: 0100 1100 0011 1111                      */

	{_illegal,0   }, /* 40: 0100 1100 0100 0000                      */
	{_illegal,0   }, /* 41: 0100 1100 0100 0001                      */
	{_illegal,0   }, /* 42: 0100 1100 0100 0010                      */
	{_illegal,0   }, /* 43: 0100 1100 0100 0011                      */
	{_illegal,0   }, /* 44: 0100 1100 0100 0100                      */
	{_illegal,0   }, /* 45: 0100 1100 0100 0101                      */
	{_illegal,0   }, /* 46: 0100 1100 0100 0110                      */
	{_illegal,0   }, /* 47: 0100 1100 0100 0111                      */
	{_illegal,0   }, /* 48: 0100 1100 0100 1000                      */
	{_illegal,0   }, /* 49: 0100 1100 0100 1001                      */
	{_illegal,0   }, /* 4a: 0100 1100 0100 1010                      */
	{_illegal,0   }, /* 4b: 0100 1100 0100 1011                      */
	{_illegal,0   }, /* 4c: 0100 1100 0100 1100                      */
	{_illegal,0   }, /* 4d: 0100 1100 0100 1101                      */
	{_illegal,0   }, /* 4e: 0100 1100 0100 1110                      */
	{_illegal,0   }, /* 4f: 0100 1100 0100 1111                      */

	{_illegal,0   }, /* 50: 0100 1100 0101 0000                      */
	{_illegal,0   }, /* 51: 0100 1100 0101 0001                      */
	{_illegal,0   }, /* 52: 0100 1100 0101 0010                      */
	{_illegal,0   }, /* 53: 0100 1100 0101 0011                      */
	{_illegal,0   }, /* 54: 0100 1100 0101 0100                      */
	{_illegal,0   }, /* 55: 0100 1100 0101 0101                      */
	{_illegal,0   }, /* 56: 0100 1100 0101 0110                      */
	{_illegal,0   }, /* 57: 0100 1100 0101 0111                      */
	{_illegal,0   }, /* 58: 0100 1100 0101 1000                      */
	{_illegal,0   }, /* 59: 0100 1100 0101 1001                      */
	{_illegal,0   }, /* 5a: 0100 1100 0101 1010                      */
	{_illegal,0   }, /* 5b: 0100 1100 0101 1011                      */
	{_illegal,0   }, /* 5c: 0100 1100 0101 1100                      */
	{_illegal,0   }, /* 5d: 0100 1100 0101 1101                      */
	{_illegal,0   }, /* 5e: 0100 1100 0101 1110                      */
	{_illegal,0   }, /* 5f: 0100 1100 0101 1111                      */

	{_illegal,0   }, /* 60: 0100 1100 0110 0000                      */
	{_illegal,0   }, /* 61: 0100 1100 0110 0001                      */
	{_illegal,0   }, /* 62: 0100 1100 0110 0010                      */
	{_illegal,0   }, /* 63: 0100 1100 0110 0011                      */
	{_illegal,0   }, /* 64: 0100 1100 0110 0100                      */
	{_illegal,0   }, /* 65: 0100 1100 0110 0101                      */
	{_illegal,0   }, /* 66: 0100 1100 0110 0110                      */
	{_illegal,0   }, /* 67: 0100 1100 0110 0111                      */
	{_illegal,0   }, /* 68: 0100 1100 0110 1000                      */
	{_illegal,0   }, /* 69: 0100 1100 0110 1001                      */
	{_illegal,0   }, /* 6a: 0100 1100 0110 1010                      */
	{_illegal,0   }, /* 6b: 0100 1100 0110 1011                      */
	{_illegal,0   }, /* 6c: 0100 1100 0110 1100                      */
	{_illegal,0   }, /* 6d: 0100 1100 0110 1101                      */
	{_illegal,0   }, /* 6e: 0100 1100 0110 1110                      */
	{_illegal,0   }, /* 6f: 0100 1100 0110 1111                      */

	{_illegal,0   }, /* 70: 0100 1100 0111 0000                      */
	{_illegal,0   }, /* 71: 0100 1100 0111 0001                      */
	{_illegal,0   }, /* 72: 0100 1100 0111 0010                      */
	{_illegal,0   }, /* 73: 0100 1100 0111 0011                      */
	{_illegal,0   }, /* 74: 0100 1100 0111 0100                      */
	{_illegal,0   }, /* 75: 0100 1100 0111 0101                      */
	{_illegal,0   }, /* 76: 0100 1100 0111 0110                      */
	{_illegal,0   }, /* 77: 0100 1100 0111 0111                      */
	{_illegal,0   }, /* 78: 0100 1100 0111 1000                      */
	{_illegal,0   }, /* 79: 0100 1100 0111 1001                      */
	{_illegal,0   }, /* 7a: 0100 1100 0111 1010                      */
	{_illegal,0   }, /* 7b: 0100 1100 0111 1011                      */
	{_illegal,0   }, /* 7c: 0100 1100 0111 1100                      */
	{_illegal,0   }, /* 7d: 0100 1100 0111 1101                      */
	{_illegal,0   }, /* 7e: 0100 1100 0111 1110                      */
	{_illegal,0   }, /* 7f: 0100 1100 0111 1111                      */

	{_illegal,0   }, /* 80: 0100 1100 1000 0000                      */
	{_illegal,0   }, /* 81: 0100 1100 1000 0001                      */
	{_illegal,0   }, /* 82: 0100 1100 1000 0010                      */
	{_illegal,0   }, /* 83: 0100 1100 1000 0011                      */
	{_illegal,0   }, /* 84: 0100 1100 1000 0100                      */
	{_illegal,0   }, /* 85: 0100 1100 1000 0101                      */
	{_illegal,0   }, /* 86: 0100 1100 1000 0110                      */
	{_illegal,0   }, /* 87: 0100 1100 1000 0111                      */
	{_illegal,0   }, /* 88: 0100 1100 1000 1000                      */
	{_illegal,0   }, /* 89: 0100 1100 1000 1001                      */
	{_illegal,0   }, /* 8a: 0100 1100 1000 1010                      */
	{_illegal,0   }, /* 8b: 0100 1100 1000 1011                      */
	{_illegal,0   }, /* 8c: 0100 1100 1000 1100                      */
	{_illegal,0   }, /* 8d: 0100 1100 1000 1101                      */
	{_illegal,0   }, /* 8e: 0100 1100 1000 1110                      */
	{_illegal,0   }, /* 8f: 0100 1100 1000 1111                      */

	{_illegal,0   }, /* 90: 0100 1100 1001 0000                      */
	{_illegal,0   }, /* 91: 0100 1100 1001 0001                      */
	{_illegal,0   }, /* 92: 0100 1100 1001 0010                      */
	{_illegal,0   }, /* 93: 0100 1100 1001 0011                      */
	{_illegal,0   }, /* 94: 0100 1100 1001 0100                      */
	{_illegal,0   }, /* 95: 0100 1100 1001 0101                      */
	{_illegal,0   }, /* 96: 0100 1100 1001 0110                      */
	{_illegal,0   }, /* 97: 0100 1100 1001 0111                      */
	{_illegal,0   }, /* 98: 0100 1100 1001 1000                      */
	{_illegal,0   }, /* 99: 0100 1100 1001 1001                      */
	{_illegal,0   }, /* 9a: 0100 1100 1001 1010                      */
	{_illegal,0   }, /* 9b: 0100 1100 1001 1011                      */
	{_illegal,0   }, /* 9c: 0100 1100 1001 1100                      */
	{_illegal,0   }, /* 9d: 0100 1100 1001 1101                      */
	{_illegal,0   }, /* 9e: 0100 1100 1001 1110                      */
	{_illegal,0   }, /* 9f: 0100 1100 1001 1111                      */

	{_illegal,0   }, /* a0: 0100 1100 1010 0000                      */
	{_illegal,0   }, /* a1: 0100 1100 1010 0001                      */
	{_illegal,0   }, /* a2: 0100 1100 1010 0010                      */
	{_illegal,0   }, /* a3: 0100 1100 1010 0011                      */
	{_illegal,0   }, /* a4: 0100 1100 1010 0100                      */
	{_illegal,0   }, /* a5: 0100 1100 1010 0101                      */
	{_illegal,0   }, /* a6: 0100 1100 1010 0110                      */
	{_illegal,0   }, /* a7: 0100 1100 1010 0111                      */
	{_illegal,0   }, /* a8: 0100 1100 1010 1000                      */
	{_illegal,0   }, /* a9: 0100 1100 1010 1001                      */
	{_illegal,0   }, /* aa: 0100 1100 1010 1010                      */
	{_illegal,0   }, /* ab: 0100 1100 1010 1011                      */
	{_illegal,0   }, /* ac: 0100 1100 1010 1100                      */
	{_illegal,0   }, /* ad: 0100 1100 1010 1101                      */
	{_illegal,0   }, /* ae: 0100 1100 1010 1110                      */
	{_illegal,0   }, /* af: 0100 1100 1010 1111                      */

	{_illegal,0   }, /* b0: 0100 1100 1011 0000                      */
	{_illegal,0   }, /* b1: 0100 1100 1011 0001                      */
	{_illegal,0   }, /* b2: 0100 1100 1011 0010                      */
	{_illegal,0   }, /* b3: 0100 1100 1011 0011                      */
	{_illegal,0   }, /* b4: 0100 1100 1011 0100                      */
	{_illegal,0   }, /* b5: 0100 1100 1011 0101                      */
	{_illegal,0   }, /* b6: 0100 1100 1011 0110                      */
	{_illegal,0   }, /* b7: 0100 1100 1011 0111                      */
	{_illegal,0   }, /* b8: 0100 1100 1011 1000                      */
	{_illegal,0   }, /* b9: 0100 1100 1011 1001                      */
	{_illegal,0   }, /* ba: 0100 1100 1011 1010                      */
	{_illegal,0   }, /* bb: 0100 1100 1011 1011                      */
	{_illegal,0   }, /* bc: 0100 1100 1011 1100                      */
	{_illegal,0   }, /* bd: 0100 1100 1011 1101                      */
	{_illegal,0   }, /* be: 0100 1100 1011 1110                      */
	{_illegal,0   }, /* bf: 0100 1100 1011 1111                      */

	{_MOV,"A,PA"     }, /* c0: 0100 1100 1100 0000                      */
	{_MOV,"A,PB"     }, /* c1: 0100 1100 1100 0001                      */
	{_MOV,"A,PC"     }, /* c2: 0100 1100 1100 0010                      */
	{_MOV,"A,PD"     }, /* c3: 0100 1100 1100 0011                      */
	{_illegal,0   }, /* c4: 0100 1100 1100 0100                      */
	{_MOV,"A,PF"     }, /* c5: 0100 1100 1100 0101                      */
	{_MOV,"A,MKH"    }, /* c6: 0100 1100 1100 0110                      */
	{_MOV,"A,MKL"    }, /* c7: 0100 1100 1100 0111                      */
	{_MOV,"A,ANM"    }, /* c8: 0100 1100 1100 1000                      */   /* 7810 */
	{_MOV,"A,SMH"    }, /* c9: 0100 1100 1100 1001                      */
	{_illegal,0   }, /* ca: 0100 1100 1100 1010                      */
	{_MOV,"A,EOM"    }, /* cb: 0100 1100 1100 1011                      */
	{_illegal,0   }, /* cc: 0100 1100 1100 1100                      */
	{_MOV,"A,TMM"    }, /* cd: 0100 1100 1100 1101                      */
	{_illegal,0   }, /* ce: 0100 1100 1100 1110                      */
	{_illegal,0   }, /* cf: 0100 1100 1100 1111                      */

	{_illegal,0   }, /* d0: 0100 1100 1101 0000                      */
	{_illegal,0   }, /* d1: 0100 1100 1101 0001                      */
	{_illegal,0   }, /* d2: 0100 1100 1101 0010                      */
	{_illegal,0   }, /* d3: 0100 1100 1101 0011                      */
	{_illegal,0   }, /* d4: 0100 1100 1101 0100                      */
	{_illegal,0   }, /* d5: 0100 1100 1101 0101                      */
	{_illegal,0   }, /* d6: 0100 1100 1101 0110                      */
	{_illegal,0   }, /* d7: 0100 1100 1101 0111                      */
	{_illegal,0   }, /* d8: 0100 1100 1101 1000                      */
	{_MOV,"A,RXB"    }, /* d9: 0100 1100 1101 1001                      */
	{_illegal,0   }, /* da: 0100 1100 1101 1010                      */
	{_illegal,0   }, /* db: 0100 1100 1101 1011                      */
	{_illegal,0   }, /* dc: 0100 1100 1101 1100                      */
	{_illegal,0   }, /* dd: 0100 1100 1101 1101                      */
	{_illegal,0   }, /* de: 0100 1100 1101 1110                      */
	{_illegal,0   }, /* df: 0100 1100 1101 1111                      */

	{_MOV,"A,CR0"    }, /* e0: 0100 1100 1110 0000                      */   /* 7810 */
	{_MOV,"A,CR1"    }, /* e1: 0100 1100 1110 0001                      */   /* 7810 */
	{_MOV,"A,CR2"    }, /* e2: 0100 1100 1110 0010                      */   /* 7810 */
	{_MOV,"A,CR3"    }, /* e3: 0100 1100 1110 0011                      */   /* 7810 */
	{_illegal,0   }, /* e4: 0100 1100 1110 0100                      */
	{_illegal,0   }, /* e5: 0100 1100 1110 0101                      */
	{_illegal,0   }, /* e6: 0100 1100 1110 0110                      */
	{_illegal,0   }, /* e7: 0100 1100 1110 0111                      */
	{_illegal,0   }, /* e8: 0100 1100 1110 1000                      */
	{_illegal,0   }, /* e9: 0100 1100 1110 1001                      */
	{_illegal,0   }, /* ea: 0100 1100 1110 1010                      */
	{_illegal,0   }, /* eb: 0100 1100 1110 1011                      */
	{_illegal,0   }, /* ec: 0100 1100 1110 1100                      */
	{_illegal,0   }, /* ed: 0100 1100 1110 1101                      */
	{_illegal,0   }, /* ee: 0100 1100 1110 1110                      */
	{_illegal,0   }, /* ef: 0100 1100 1110 1111                      */

	{_illegal,0   }, /* f0: 0100 1100 1111 0000                      */
	{_illegal,0   }, /* f1: 0100 1100 1111 0001                      */
	{_illegal,0   }, /* f2: 0100 1100 1111 0010                      */
	{_illegal,0   }, /* f3: 0100 1100 1111 0011                      */
	{_illegal,0   }, /* f4: 0100 1100 1111 0100                      */
	{_illegal,0   }, /* f5: 0100 1100 1111 0101                      */
	{_illegal,0   }, /* f6: 0100 1100 1111 0110                      */
	{_illegal,0   }, /* f7: 0100 1100 1111 0111                      */
	{_illegal,0   }, /* f8: 0100 1100 1111 1000                      */
	{_illegal,0   }, /* f9: 0100 1100 1111 1001                      */
	{_illegal,0   }, /* fa: 0100 1100 1111 1010                      */
	{_illegal,0   }, /* fb: 0100 1100 1111 1011                      */
	{_illegal,0   }, /* fc: 0100 1100 1111 1100                      */
	{_illegal,0   }, /* fd: 0100 1100 1111 1101                      */
	{_illegal,0   }, /* fe: 0100 1100 1111 1110                      */
	{_illegal,0   }  /* ff: 0100 1100 1111 1111                      */
};

static const struct dasm_s  dasm4C_7807[256] =
{
	{_illegal,0   }, /* 00: 0100 1100 0000 0000                      */
	{_illegal,0   }, /* 01: 0100 1100 0000 0001                      */
	{_illegal,0   }, /* 02: 0100 1100 0000 0010                      */
	{_illegal,0   }, /* 03: 0100 1100 0000 0011                      */
	{_illegal,0   }, /* 04: 0100 1100 0000 0100                      */
	{_illegal,0   }, /* 05: 0100 1100 0000 0101                      */
	{_illegal,0   }, /* 06: 0100 1100 0000 0110                      */
	{_illegal,0   }, /* 07: 0100 1100 0000 0111                      */
	{_illegal,0   }, /* 08: 0100 1100 0000 1000                      */
	{_illegal,0   }, /* 09: 0100 1100 0000 1001                      */
	{_illegal,0   }, /* 0a: 0100 1100 0000 1010                      */
	{_illegal,0   }, /* 0b: 0100 1100 0000 1011                      */
	{_illegal,0   }, /* 0c: 0100 1100 0000 1100                      */
	{_illegal,0   }, /* 0d: 0100 1100 0000 1101                      */
	{_illegal,0   }, /* 0e: 0100 1100 0000 1110                      */
	{_illegal,0   }, /* 0f: 0100 1100 0000 1111                      */

	{_illegal,0   }, /* 10: 0100 1100 0001 0000                      */
	{_illegal,0   }, /* 11: 0100 1100 0001 0001                      */
	{_illegal,0   }, /* 12: 0100 1100 0001 0010                      */
	{_illegal,0   }, /* 13: 0100 1100 0001 0011                      */
	{_illegal,0   }, /* 14: 0100 1100 0001 0100                      */
	{_illegal,0   }, /* 15: 0100 1100 0001 0101                      */
	{_illegal,0   }, /* 16: 0100 1100 0001 0110                      */
	{_illegal,0   }, /* 17: 0100 1100 0001 0111                      */
	{_illegal,0   }, /* 18: 0100 1100 0001 1000                      */
	{_illegal,0   }, /* 19: 0100 1100 0001 1001                      */
	{_illegal,0   }, /* 1a: 0100 1100 0001 1010                      */
	{_illegal,0   }, /* 1b: 0100 1100 0001 1011                      */
	{_illegal,0   }, /* 1c: 0100 1100 0001 1100                      */
	{_illegal,0   }, /* 1d: 0100 1100 0001 1101                      */
	{_illegal,0   }, /* 1e: 0100 1100 0001 1110                      */
	{_illegal,0   }, /* 1f: 0100 1100 0001 1111                      */

	{_illegal,0   }, /* 20: 0100 1100 0010 0000                      */
	{_illegal,0   }, /* 21: 0100 1100 0010 0001                      */
	{_illegal,0   }, /* 22: 0100 1100 0010 0010                      */
	{_illegal,0   }, /* 23: 0100 1100 0010 0011                      */
	{_illegal,0   }, /* 24: 0100 1100 0010 0100                      */
	{_illegal,0   }, /* 25: 0100 1100 0010 0101                      */
	{_illegal,0   }, /* 26: 0100 1100 0010 0110                      */
	{_illegal,0   }, /* 27: 0100 1100 0010 0111                      */
	{_illegal,0   }, /* 28: 0100 1100 0010 1000                      */
	{_illegal,0   }, /* 29: 0100 1100 0010 1001                      */
	{_illegal,0   }, /* 2a: 0100 1100 0010 1010                      */
	{_illegal,0   }, /* 2b: 0100 1100 0010 1011                      */
	{_illegal,0   }, /* 2c: 0100 1100 0010 1100                      */
	{_illegal,0   }, /* 2d: 0100 1100 0010 1101                      */
	{_illegal,0   }, /* 2e: 0100 1100 0010 1110                      */
	{_illegal,0   }, /* 2f: 0100 1100 0010 1111                      */

	{_illegal,0   }, /* 30: 0100 1100 0011 0000                      */
	{_illegal,0   }, /* 31: 0100 1100 0011 0001                      */
	{_illegal,0   }, /* 32: 0100 1100 0011 0010                      */
	{_illegal,0   }, /* 33: 0100 1100 0011 0011                      */
	{_illegal,0   }, /* 34: 0100 1100 0011 0100                      */
	{_illegal,0   }, /* 35: 0100 1100 0011 0101                      */
	{_illegal,0   }, /* 36: 0100 1100 0011 0110                      */
	{_illegal,0   }, /* 37: 0100 1100 0011 0111                      */
	{_illegal,0   }, /* 38: 0100 1100 0011 1000                      */
	{_illegal,0   }, /* 39: 0100 1100 0011 1001                      */
	{_illegal,0   }, /* 3a: 0100 1100 0011 1010                      */
	{_illegal,0   }, /* 3b: 0100 1100 0011 1011                      */
	{_illegal,0   }, /* 3c: 0100 1100 0011 1100                      */
	{_illegal,0   }, /* 3d: 0100 1100 0011 1101                      */
	{_illegal,0   }, /* 3e: 0100 1100 0011 1110                      */
	{_illegal,0   }, /* 3f: 0100 1100 0011 1111                      */

	{_illegal,0   }, /* 40: 0100 1100 0100 0000                      */
	{_illegal,0   }, /* 41: 0100 1100 0100 0001                      */
	{_illegal,0   }, /* 42: 0100 1100 0100 0010                      */
	{_illegal,0   }, /* 43: 0100 1100 0100 0011                      */
	{_illegal,0   }, /* 44: 0100 1100 0100 0100                      */
	{_illegal,0   }, /* 45: 0100 1100 0100 0101                      */
	{_illegal,0   }, /* 46: 0100 1100 0100 0110                      */
	{_illegal,0   }, /* 47: 0100 1100 0100 0111                      */
	{_illegal,0   }, /* 48: 0100 1100 0100 1000                      */
	{_illegal,0   }, /* 49: 0100 1100 0100 1001                      */
	{_illegal,0   }, /* 4a: 0100 1100 0100 1010                      */
	{_illegal,0   }, /* 4b: 0100 1100 0100 1011                      */
	{_illegal,0   }, /* 4c: 0100 1100 0100 1100                      */
	{_illegal,0   }, /* 4d: 0100 1100 0100 1101                      */
	{_illegal,0   }, /* 4e: 0100 1100 0100 1110                      */
	{_illegal,0   }, /* 4f: 0100 1100 0100 1111                      */

	{_illegal,0   }, /* 50: 0100 1100 0101 0000                      */
	{_illegal,0   }, /* 51: 0100 1100 0101 0001                      */
	{_illegal,0   }, /* 52: 0100 1100 0101 0010                      */
	{_illegal,0   }, /* 53: 0100 1100 0101 0011                      */
	{_illegal,0   }, /* 54: 0100 1100 0101 0100                      */
	{_illegal,0   }, /* 55: 0100 1100 0101 0101                      */
	{_illegal,0   }, /* 56: 0100 1100 0101 0110                      */
	{_illegal,0   }, /* 57: 0100 1100 0101 0111                      */
	{_illegal,0   }, /* 58: 0100 1100 0101 1000                      */
	{_illegal,0   }, /* 59: 0100 1100 0101 1001                      */
	{_illegal,0   }, /* 5a: 0100 1100 0101 1010                      */
	{_illegal,0   }, /* 5b: 0100 1100 0101 1011                      */
	{_illegal,0   }, /* 5c: 0100 1100 0101 1100                      */
	{_illegal,0   }, /* 5d: 0100 1100 0101 1101                      */
	{_illegal,0   }, /* 5e: 0100 1100 0101 1110                      */
	{_illegal,0   }, /* 5f: 0100 1100 0101 1111                      */

	{_illegal,0   }, /* 60: 0100 1100 0110 0000                      */
	{_illegal,0   }, /* 61: 0100 1100 0110 0001                      */
	{_illegal,0   }, /* 62: 0100 1100 0110 0010                      */
	{_illegal,0   }, /* 63: 0100 1100 0110 0011                      */
	{_illegal,0   }, /* 64: 0100 1100 0110 0100                      */
	{_illegal,0   }, /* 65: 0100 1100 0110 0101                      */
	{_illegal,0   }, /* 66: 0100 1100 0110 0110                      */
	{_illegal,0   }, /* 67: 0100 1100 0110 0111                      */
	{_illegal,0   }, /* 68: 0100 1100 0110 1000                      */
	{_illegal,0   }, /* 69: 0100 1100 0110 1001                      */
	{_illegal,0   }, /* 6a: 0100 1100 0110 1010                      */
	{_illegal,0   }, /* 6b: 0100 1100 0110 1011                      */
	{_illegal,0   }, /* 6c: 0100 1100 0110 1100                      */
	{_illegal,0   }, /* 6d: 0100 1100 0110 1101                      */
	{_illegal,0   }, /* 6e: 0100 1100 0110 1110                      */
	{_illegal,0   }, /* 6f: 0100 1100 0110 1111                      */

	{_illegal,0   }, /* 70: 0100 1100 0111 0000                      */
	{_illegal,0   }, /* 71: 0100 1100 0111 0001                      */
	{_illegal,0   }, /* 72: 0100 1100 0111 0010                      */
	{_illegal,0   }, /* 73: 0100 1100 0111 0011                      */
	{_illegal,0   }, /* 74: 0100 1100 0111 0100                      */
	{_illegal,0   }, /* 75: 0100 1100 0111 0101                      */
	{_illegal,0   }, /* 76: 0100 1100 0111 0110                      */
	{_illegal,0   }, /* 77: 0100 1100 0111 0111                      */
	{_illegal,0   }, /* 78: 0100 1100 0111 1000                      */
	{_illegal,0   }, /* 79: 0100 1100 0111 1001                      */
	{_illegal,0   }, /* 7a: 0100 1100 0111 1010                      */
	{_illegal,0   }, /* 7b: 0100 1100 0111 1011                      */
	{_illegal,0   }, /* 7c: 0100 1100 0111 1100                      */
	{_illegal,0   }, /* 7d: 0100 1100 0111 1101                      */
	{_illegal,0   }, /* 7e: 0100 1100 0111 1110                      */
	{_illegal,0   }, /* 7f: 0100 1100 0111 1111                      */

	{_illegal,0   }, /* 80: 0100 1100 1000 0000                      */
	{_illegal,0   }, /* 81: 0100 1100 1000 0001                      */
	{_illegal,0   }, /* 82: 0100 1100 1000 0010                      */
	{_illegal,0   }, /* 83: 0100 1100 1000 0011                      */
	{_illegal,0   }, /* 84: 0100 1100 1000 0100                      */
	{_illegal,0   }, /* 85: 0100 1100 1000 0101                      */
	{_illegal,0   }, /* 86: 0100 1100 1000 0110                      */
	{_illegal,0   }, /* 87: 0100 1100 1000 0111                      */
	{_illegal,0   }, /* 88: 0100 1100 1000 1000                      */
	{_illegal,0   }, /* 89: 0100 1100 1000 1001                      */
	{_illegal,0   }, /* 8a: 0100 1100 1000 1010                      */
	{_illegal,0   }, /* 8b: 0100 1100 1000 1011                      */
	{_illegal,0   }, /* 8c: 0100 1100 1000 1100                      */
	{_illegal,0   }, /* 8d: 0100 1100 1000 1101                      */
	{_illegal,0   }, /* 8e: 0100 1100 1000 1110                      */
	{_illegal,0   }, /* 8f: 0100 1100 1000 1111                      */

	{_illegal,0   }, /* 90: 0100 1100 1001 0000                      */
	{_illegal,0   }, /* 91: 0100 1100 1001 0001                      */
	{_illegal,0   }, /* 92: 0100 1100 1001 0010                      */
	{_illegal,0   }, /* 93: 0100 1100 1001 0011                      */
	{_illegal,0   }, /* 94: 0100 1100 1001 0100                      */
	{_illegal,0   }, /* 95: 0100 1100 1001 0101                      */
	{_illegal,0   }, /* 96: 0100 1100 1001 0110                      */
	{_illegal,0   }, /* 97: 0100 1100 1001 0111                      */
	{_illegal,0   }, /* 98: 0100 1100 1001 1000                      */
	{_illegal,0   }, /* 99: 0100 1100 1001 1001                      */
	{_illegal,0   }, /* 9a: 0100 1100 1001 1010                      */
	{_illegal,0   }, /* 9b: 0100 1100 1001 1011                      */
	{_illegal,0   }, /* 9c: 0100 1100 1001 1100                      */
	{_illegal,0   }, /* 9d: 0100 1100 1001 1101                      */
	{_illegal,0   }, /* 9e: 0100 1100 1001 1110                      */
	{_illegal,0   }, /* 9f: 0100 1100 1001 1111                      */

	{_illegal,0   }, /* a0: 0100 1100 1010 0000                      */
	{_illegal,0   }, /* a1: 0100 1100 1010 0001                      */
	{_illegal,0   }, /* a2: 0100 1100 1010 0010                      */
	{_illegal,0   }, /* a3: 0100 1100 1010 0011                      */
	{_illegal,0   }, /* a4: 0100 1100 1010 0100                      */
	{_illegal,0   }, /* a5: 0100 1100 1010 0101                      */
	{_illegal,0   }, /* a6: 0100 1100 1010 0110                      */
	{_illegal,0   }, /* a7: 0100 1100 1010 0111                      */
	{_illegal,0   }, /* a8: 0100 1100 1010 1000                      */
	{_illegal,0   }, /* a9: 0100 1100 1010 1001                      */
	{_illegal,0   }, /* aa: 0100 1100 1010 1010                      */
	{_illegal,0   }, /* ab: 0100 1100 1010 1011                      */
	{_illegal,0   }, /* ac: 0100 1100 1010 1100                      */
	{_illegal,0   }, /* ad: 0100 1100 1010 1101                      */
	{_illegal,0   }, /* ae: 0100 1100 1010 1110                      */
	{_illegal,0   }, /* af: 0100 1100 1010 1111                      */

	{_illegal,0   }, /* b0: 0100 1100 1011 0000                      */
	{_illegal,0   }, /* b1: 0100 1100 1011 0001                      */
	{_illegal,0   }, /* b2: 0100 1100 1011 0010                      */
	{_illegal,0   }, /* b3: 0100 1100 1011 0011                      */
	{_illegal,0   }, /* b4: 0100 1100 1011 0100                      */
	{_illegal,0   }, /* b5: 0100 1100 1011 0101                      */
	{_illegal,0   }, /* b6: 0100 1100 1011 0110                      */
	{_illegal,0   }, /* b7: 0100 1100 1011 0111                      */
	{_illegal,0   }, /* b8: 0100 1100 1011 1000                      */
	{_illegal,0   }, /* b9: 0100 1100 1011 1001                      */
	{_illegal,0   }, /* ba: 0100 1100 1011 1010                      */
	{_illegal,0   }, /* bb: 0100 1100 1011 1011                      */
	{_illegal,0   }, /* bc: 0100 1100 1011 1100                      */
	{_illegal,0   }, /* bd: 0100 1100 1011 1101                      */
	{_illegal,0   }, /* be: 0100 1100 1011 1110                      */
	{_illegal,0   }, /* bf: 0100 1100 1011 1111                      */

	{_MOV,"A,PA"     }, /* c0: 0100 1100 1100 0000                      */
	{_MOV,"A,PB"     }, /* c1: 0100 1100 1100 0001                      */
	{_MOV,"A,PC"     }, /* c2: 0100 1100 1100 0010                      */
	{_MOV,"A,PD"     }, /* c3: 0100 1100 1100 0011                      */
	{_illegal,0   }, /* c4: 0100 1100 1100 0100                      */
	{_MOV,"A,PF"     }, /* c5: 0100 1100 1100 0101                      */
	{_MOV,"A,MKH"    }, /* c6: 0100 1100 1100 0110                      */
	{_MOV,"A,MKL"    }, /* c7: 0100 1100 1100 0111                      */
	{_illegal,0      }, /* c8: 0100 1100 1100 1000                      */
	{_MOV,"A,SMH"    }, /* c9: 0100 1100 1100 1001                      */
	{_illegal,0   }, /* ca: 0100 1100 1100 1010                      */
	{_MOV,"A,EOM"    }, /* cb: 0100 1100 1100 1011                      */
	{_illegal,0   }, /* cc: 0100 1100 1100 1100                      */
	{_MOV,"A,TMM"    }, /* cd: 0100 1100 1100 1101                      */
	{_MOV,"A,PT"      }, /* ce: 0100 1100 1100 1110                      */  /* 7807 */
	{_illegal,0   }, /* cf: 0100 1100 1100 1111                      */

	{_illegal,0   }, /* d0: 0100 1100 1101 0000                      */
	{_illegal,0   }, /* d1: 0100 1100 1101 0001                      */
	{_illegal,0   }, /* d2: 0100 1100 1101 0010                      */
	{_illegal,0   }, /* d3: 0100 1100 1101 0011                      */
	{_illegal,0   }, /* d4: 0100 1100 1101 0100                      */
	{_illegal,0   }, /* d5: 0100 1100 1101 0101                      */
	{_illegal,0   }, /* d6: 0100 1100 1101 0110                      */
	{_illegal,0   }, /* d7: 0100 1100 1101 0111                      */
	{_illegal,0   }, /* d8: 0100 1100 1101 1000                      */
	{_MOV,"A,RXB"    }, /* d9: 0100 1100 1101 1001                      */
	{_illegal,0   }, /* da: 0100 1100 1101 1010                      */
	{_illegal,0   }, /* db: 0100 1100 1101 1011                      */
	{_illegal,0   }, /* dc: 0100 1100 1101 1100                      */
	{_illegal,0   }, /* dd: 0100 1100 1101 1101                      */
	{_illegal,0   }, /* de: 0100 1100 1101 1110                      */
	{_illegal,0   }, /* df: 0100 1100 1101 1111                      */

	{_illegal,0   }, /* e0: 0100 1100 1110 0000                      */
	{_illegal,0   }, /* e1: 0100 1100 1110 0001                      */
	{_illegal,0   }, /* e2: 0100 1100 1110 0010                      */
	{_illegal,0   }, /* e3: 0100 1100 1110 0011                      */
	{_illegal,0   }, /* e4: 0100 1100 1110 0100                      */
	{_illegal,0   }, /* e5: 0100 1100 1110 0101                      */
	{_illegal,0   }, /* e6: 0100 1100 1110 0110                      */
	{_illegal,0   }, /* e7: 0100 1100 1110 0111                      */
	{_illegal,0   }, /* e8: 0100 1100 1110 1000                      */
	{_illegal,0   }, /* e9: 0100 1100 1110 1001                      */
	{_illegal,0   }, /* ea: 0100 1100 1110 1010                      */
	{_illegal,0   }, /* eb: 0100 1100 1110 1011                      */
	{_illegal,0   }, /* ec: 0100 1100 1110 1100                      */
	{_illegal,0   }, /* ed: 0100 1100 1110 1101                      */
	{_illegal,0   }, /* ee: 0100 1100 1110 1110                      */
	{_illegal,0   }, /* ef: 0100 1100 1110 1111                      */

	{_illegal,0   }, /* f0: 0100 1100 1111 0000                      */
	{_illegal,0   }, /* f1: 0100 1100 1111 0001                      */
	{_illegal,0   }, /* f2: 0100 1100 1111 0010                      */
	{_illegal,0   }, /* f3: 0100 1100 1111 0011                      */
	{_illegal,0   }, /* f4: 0100 1100 1111 0100                      */
	{_illegal,0   }, /* f5: 0100 1100 1111 0101                      */
	{_illegal,0   }, /* f6: 0100 1100 1111 0110                      */
	{_illegal,0   }, /* f7: 0100 1100 1111 0111                      */
	{_illegal,0   }, /* f8: 0100 1100 1111 1000                      */
	{_illegal,0   }, /* f9: 0100 1100 1111 1001                      */
	{_illegal,0   }, /* fa: 0100 1100 1111 1010                      */
	{_illegal,0   }, /* fb: 0100 1100 1111 1011                      */
	{_illegal,0   }, /* fc: 0100 1100 1111 1100                      */
	{_illegal,0   }, /* fd: 0100 1100 1111 1101                      */
	{_illegal,0   }, /* fe: 0100 1100 1111 1110                      */
	{_illegal,0   }  /* ff: 0100 1100 1111 1111                      */
};

/* prefix 4D */
static const struct dasm_s  dasm4D_7810[256] =
{
	{_illegal,0   }, /* 00: 0100 1101 0000 0000                      */
	{_illegal,0   }, /* 01: 0100 1101 0000 0001                      */
	{_illegal,0   }, /* 02: 0100 1101 0000 0010                      */
	{_illegal,0   }, /* 03: 0100 1101 0000 0011                      */
	{_illegal,0   }, /* 04: 0100 1101 0000 0100                      */
	{_illegal,0   }, /* 05: 0100 1101 0000 0101                      */
	{_illegal,0   }, /* 06: 0100 1101 0000 0110                      */
	{_illegal,0   }, /* 07: 0100 1101 0000 0111                      */
	{_illegal,0   }, /* 08: 0100 1101 0000 1000                      */
	{_illegal,0   }, /* 09: 0100 1101 0000 1001                      */
	{_illegal,0   }, /* 0a: 0100 1101 0000 1010                      */
	{_illegal,0   }, /* 0b: 0100 1101 0000 1011                      */
	{_illegal,0   }, /* 0c: 0100 1101 0000 1100                      */
	{_illegal,0   }, /* 0d: 0100 1101 0000 1101                      */
	{_illegal,0   }, /* 0e: 0100 1101 0000 1110                      */
	{_illegal,0   }, /* 0f: 0100 1101 0000 1111                      */

	{_illegal,0   }, /* 10: 0100 1101 0001 0000                      */
	{_illegal,0   }, /* 11: 0100 1101 0001 0001                      */
	{_illegal,0   }, /* 12: 0100 1101 0001 0010                      */
	{_illegal,0   }, /* 13: 0100 1101 0001 0011                      */
	{_illegal,0   }, /* 14: 0100 1101 0001 0100                      */
	{_illegal,0   }, /* 15: 0100 1101 0001 0101                      */
	{_illegal,0   }, /* 16: 0100 1101 0001 0110                      */
	{_illegal,0   }, /* 17: 0100 1101 0001 0111                      */
	{_illegal,0   }, /* 18: 0100 1101 0001 1000                      */
	{_illegal,0   }, /* 19: 0100 1101 0001 1001                      */
	{_illegal,0   }, /* 1a: 0100 1101 0001 1010                      */
	{_illegal,0   }, /* 1b: 0100 1101 0001 1011                      */
	{_illegal,0   }, /* 1c: 0100 1101 0001 1100                      */
	{_illegal,0   }, /* 1d: 0100 1101 0001 1101                      */
	{_illegal,0   }, /* 1e: 0100 1101 0001 1110                      */
	{_illegal,0   }, /* 1f: 0100 1101 0001 1111                      */

	{_illegal,0   }, /* 20: 0100 1101 0010 0000                      */
	{_illegal,0   }, /* 21: 0100 1101 0010 0001                      */
	{_illegal,0   }, /* 22: 0100 1101 0010 0010                      */
	{_illegal,0   }, /* 23: 0100 1101 0010 0011                      */
	{_illegal,0   }, /* 24: 0100 1101 0010 0100                      */
	{_illegal,0   }, /* 25: 0100 1101 0010 0101                      */
	{_illegal,0   }, /* 26: 0100 1101 0010 0110                      */
	{_illegal,0   }, /* 27: 0100 1101 0010 0111                      */
	{_illegal,0   }, /* 28: 0100 1101 0010 1000                      */
	{_illegal,0   }, /* 29: 0100 1101 0010 1001                      */
	{_illegal,0   }, /* 2a: 0100 1101 0010 1010                      */
	{_illegal,0   }, /* 2b: 0100 1101 0010 1011                      */
	{_illegal,0   }, /* 2c: 0100 1101 0010 1100                      */
	{_illegal,0   }, /* 2d: 0100 1101 0010 1101                      */
	{_illegal,0   }, /* 2e: 0100 1101 0010 1110                      */
	{_illegal,0   }, /* 2f: 0100 1101 0010 1111                      */

	{_illegal,0   }, /* 30: 0100 1101 0011 0000                      */
	{_illegal,0   }, /* 31: 0100 1101 0011 0001                      */
	{_illegal,0   }, /* 32: 0100 1101 0011 0010                      */
	{_illegal,0   }, /* 33: 0100 1101 0011 0011                      */
	{_illegal,0   }, /* 34: 0100 1101 0011 0100                      */
	{_illegal,0   }, /* 35: 0100 1101 0011 0101                      */
	{_illegal,0   }, /* 36: 0100 1101 0011 0110                      */
	{_illegal,0   }, /* 37: 0100 1101 0011 0111                      */
	{_illegal,0   }, /* 38: 0100 1101 0011 1000                      */
	{_illegal,0   }, /* 39: 0100 1101 0011 1001                      */
	{_illegal,0   }, /* 3a: 0100 1101 0011 1010                      */
	{_illegal,0   }, /* 3b: 0100 1101 0011 1011                      */
	{_illegal,0   }, /* 3c: 0100 1101 0011 1100                      */
	{_illegal,0   }, /* 3d: 0100 1101 0011 1101                      */
	{_illegal,0   }, /* 3e: 0100 1101 0011 1110                      */
	{_illegal,0   }, /* 3f: 0100 1101 0011 1111                      */

	{_illegal,0   }, /* 40: 0100 1101 0100 0000                      */
	{_illegal,0   }, /* 41: 0100 1101 0100 0001                      */
	{_illegal,0   }, /* 42: 0100 1101 0100 0010                      */
	{_illegal,0   }, /* 43: 0100 1101 0100 0011                      */
	{_illegal,0   }, /* 44: 0100 1101 0100 0100                      */
	{_illegal,0   }, /* 45: 0100 1101 0100 0101                      */
	{_illegal,0   }, /* 46: 0100 1101 0100 0110                      */
	{_illegal,0   }, /* 47: 0100 1101 0100 0111                      */
	{_illegal,0   }, /* 48: 0100 1101 0100 1000                      */
	{_illegal,0   }, /* 49: 0100 1101 0100 1001                      */
	{_illegal,0   }, /* 4a: 0100 1101 0100 1010                      */
	{_illegal,0   }, /* 4b: 0100 1101 0100 1011                      */
	{_illegal,0   }, /* 4c: 0100 1101 0100 1100                      */
	{_illegal,0   }, /* 4d: 0100 1101 0100 1101                      */
	{_illegal,0   }, /* 4e: 0100 1101 0100 1110                      */
	{_illegal,0   }, /* 4f: 0100 1101 0100 1111                      */

	{_illegal,0   }, /* 50: 0100 1101 0101 0000                      */
	{_illegal,0   }, /* 51: 0100 1101 0101 0001                      */
	{_illegal,0   }, /* 52: 0100 1101 0101 0010                      */
	{_illegal,0   }, /* 53: 0100 1101 0101 0011                      */
	{_illegal,0   }, /* 54: 0100 1101 0101 0100                      */
	{_illegal,0   }, /* 55: 0100 1101 0101 0101                      */
	{_illegal,0   }, /* 56: 0100 1101 0101 0110                      */
	{_illegal,0   }, /* 57: 0100 1101 0101 0111                      */
	{_illegal,0   }, /* 58: 0100 1101 0101 1000                      */
	{_illegal,0   }, /* 59: 0100 1101 0101 1001                      */
	{_illegal,0   }, /* 5a: 0100 1101 0101 1010                      */
	{_illegal,0   }, /* 5b: 0100 1101 0101 1011                      */
	{_illegal,0   }, /* 5c: 0100 1101 0101 1100                      */
	{_illegal,0   }, /* 5d: 0100 1101 0101 1101                      */
	{_illegal,0   }, /* 5e: 0100 1101 0101 1110                      */
	{_illegal,0   }, /* 5f: 0100 1101 0101 1111                      */

	{_illegal,0   }, /* 60: 0100 1101 0110 0000                      */
	{_illegal,0   }, /* 61: 0100 1101 0110 0001                      */
	{_illegal,0   }, /* 62: 0100 1101 0110 0010                      */
	{_illegal,0   }, /* 63: 0100 1101 0110 0011                      */
	{_illegal,0   }, /* 64: 0100 1101 0110 0100                      */
	{_illegal,0   }, /* 65: 0100 1101 0110 0101                      */
	{_illegal,0   }, /* 66: 0100 1101 0110 0110                      */
	{_illegal,0   }, /* 67: 0100 1101 0110 0111                      */
	{_illegal,0   }, /* 68: 0100 1101 0110 1000                      */
	{_illegal,0   }, /* 69: 0100 1101 0110 1001                      */
	{_illegal,0   }, /* 6a: 0100 1101 0110 1010                      */
	{_illegal,0   }, /* 6b: 0100 1101 0110 1011                      */
	{_illegal,0   }, /* 6c: 0100 1101 0110 1100                      */
	{_illegal,0   }, /* 6d: 0100 1101 0110 1101                      */
	{_illegal,0   }, /* 6e: 0100 1101 0110 1110                      */
	{_illegal,0   }, /* 6f: 0100 1101 0110 1111                      */

	{_illegal,0   }, /* 70: 0100 1101 0111 0000                      */
	{_illegal,0   }, /* 71: 0100 1101 0111 0001                      */
	{_illegal,0   }, /* 72: 0100 1101 0111 0010                      */
	{_illegal,0   }, /* 73: 0100 1101 0111 0011                      */
	{_illegal,0   }, /* 74: 0100 1101 0111 0100                      */
	{_illegal,0   }, /* 75: 0100 1101 0111 0101                      */
	{_illegal,0   }, /* 76: 0100 1101 0111 0110                      */
	{_illegal,0   }, /* 77: 0100 1101 0111 0111                      */
	{_illegal,0   }, /* 78: 0100 1101 0111 1000                      */
	{_illegal,0   }, /* 79: 0100 1101 0111 1001                      */
	{_illegal,0   }, /* 7a: 0100 1101 0111 1010                      */
	{_illegal,0   }, /* 7b: 0100 1101 0111 1011                      */
	{_illegal,0   }, /* 7c: 0100 1101 0111 1100                      */
	{_illegal,0   }, /* 7d: 0100 1101 0111 1101                      */
	{_illegal,0   }, /* 7e: 0100 1101 0111 1110                      */
	{_illegal,0   }, /* 7f: 0100 1101 0111 1111                      */

	{_illegal,0   }, /* 80: 0100 1101 1000 0000                      */
	{_illegal,0   }, /* 81: 0100 1101 1000 0001                      */
	{_illegal,0   }, /* 82: 0100 1101 1000 0010                      */
	{_illegal,0   }, /* 83: 0100 1101 1000 0011                      */
	{_illegal,0   }, /* 84: 0100 1101 1000 0100                      */
	{_illegal,0   }, /* 85: 0100 1101 1000 0101                      */
	{_illegal,0   }, /* 86: 0100 1101 1000 0110                      */
	{_illegal,0   }, /* 87: 0100 1101 1000 0111                      */
	{_illegal,0   }, /* 88: 0100 1101 1000 1000                      */
	{_illegal,0   }, /* 89: 0100 1101 1000 1001                      */
	{_illegal,0   }, /* 8a: 0100 1101 1000 1010                      */
	{_illegal,0   }, /* 8b: 0100 1101 1000 1011                      */
	{_illegal,0   }, /* 8c: 0100 1101 1000 1100                      */
	{_illegal,0   }, /* 8d: 0100 1101 1000 1101                      */
	{_illegal,0   }, /* 8e: 0100 1101 1000 1110                      */
	{_illegal,0   }, /* 8f: 0100 1101 1000 1111                      */

	{_illegal,0   }, /* 90: 0100 1101 1001 0000                      */
	{_illegal,0   }, /* 91: 0100 1101 1001 0001                      */
	{_illegal,0   }, /* 92: 0100 1101 1001 0010                      */
	{_illegal,0   }, /* 93: 0100 1101 1001 0011                      */
	{_illegal,0   }, /* 94: 0100 1101 1001 0100                      */
	{_illegal,0   }, /* 95: 0100 1101 1001 0101                      */
	{_illegal,0   }, /* 96: 0100 1101 1001 0110                      */
	{_illegal,0   }, /* 97: 0100 1101 1001 0111                      */
	{_illegal,0   }, /* 98: 0100 1101 1001 1000                      */
	{_illegal,0   }, /* 99: 0100 1101 1001 1001                      */
	{_illegal,0   }, /* 9a: 0100 1101 1001 1010                      */
	{_illegal,0   }, /* 9b: 0100 1101 1001 1011                      */
	{_illegal,0   }, /* 9c: 0100 1101 1001 1100                      */
	{_illegal,0   }, /* 9d: 0100 1101 1001 1101                      */
	{_illegal,0   }, /* 9e: 0100 1101 1001 1110                      */
	{_illegal,0   }, /* 9f: 0100 1101 1001 1111                      */

	{_illegal,0   }, /* a0: 0100 1101 1010 0000                      */
	{_illegal,0   }, /* a1: 0100 1101 1010 0001                      */
	{_illegal,0   }, /* a2: 0100 1101 1010 0010                      */
	{_illegal,0   }, /* a3: 0100 1101 1010 0011                      */
	{_illegal,0   }, /* a4: 0100 1101 1010 0100                      */
	{_illegal,0   }, /* a5: 0100 1101 1010 0101                      */
	{_illegal,0   }, /* a6: 0100 1101 1010 0110                      */
	{_illegal,0   }, /* a7: 0100 1101 1010 0111                      */
	{_illegal,0   }, /* a8: 0100 1101 1010 1000                      */
	{_illegal,0   }, /* a9: 0100 1101 1010 1001                      */
	{_illegal,0   }, /* aa: 0100 1101 1010 1010                      */
	{_illegal,0   }, /* ab: 0100 1101 1010 1011                      */
	{_illegal,0   }, /* ac: 0100 1101 1010 1100                      */
	{_illegal,0   }, /* ad: 0100 1101 1010 1101                      */
	{_illegal,0   }, /* ae: 0100 1101 1010 1110                      */
	{_illegal,0   }, /* af: 0100 1101 1010 1111                      */

	{_illegal,0   }, /* b0: 0100 1101 1011 0000                      */
	{_illegal,0   }, /* b1: 0100 1101 1011 0001                      */
	{_illegal,0   }, /* b2: 0100 1101 1011 0010                      */
	{_illegal,0   }, /* b3: 0100 1101 1011 0011                      */
	{_illegal,0   }, /* b4: 0100 1101 1011 0100                      */
	{_illegal,0   }, /* b5: 0100 1101 1011 0101                      */
	{_illegal,0   }, /* b6: 0100 1101 1011 0110                      */
	{_illegal,0   }, /* b7: 0100 1101 1011 0111                      */
	{_illegal,0   }, /* b8: 0100 1101 1011 1000                      */
	{_illegal,0   }, /* b9: 0100 1101 1011 1001                      */
	{_illegal,0   }, /* ba: 0100 1101 1011 1010                      */
	{_illegal,0   }, /* bb: 0100 1101 1011 1011                      */
	{_illegal,0   }, /* bc: 0100 1101 1011 1100                      */
	{_illegal,0   }, /* bd: 0100 1101 1011 1101                      */
	{_illegal,0   }, /* be: 0100 1101 1011 1110                      */
	{_illegal,0   }, /* bf: 0100 1101 1011 1111                      */

	{_MOV,"PA,A"     }, /* c0: 0100 1101 1100 0000                      */
	{_MOV,"PB,A"     }, /* c1: 0100 1101 1100 0001                      */
	{_MOV,"PC,A"     }, /* c2: 0100 1101 1100 0010                      */
	{_MOV,"PD,A"     }, /* c3: 0100 1101 1100 0011                      */
	{_illegal,0   }, /* c4: 0100 1101 1100 0100                      */
	{_MOV,"PF,A"     }, /* c5: 0100 1101 1100 0101                      */
	{_MOV,"MKH,A"    }, /* c6: 0100 1101 1100 0110                      */
	{_MOV,"MKL,A"    }, /* c7: 0100 1101 1100 0111                      */
	{_MOV,"ANM,A"    }, /* c8: 0100 1101 1100 1000                      */   /* 7810 */
	{_MOV,"SMH,A"    }, /* c9: 0100 1101 1100 1001                      */
	{_MOV,"SML,A"    }, /* ca: 0100 1101 1100 1010                      */
	{_MOV,"EOM,A"    }, /* cb: 0100 1101 1100 1011                      */
	{_MOV,"ETMM,A"   }, /* cc: 0100 1101 1100 1100                      */
	{_MOV,"TMM,A"    }, /* cd: 0100 1101 1100 1101                      */
	{_illegal,0   }, /* ce: 0100 1101 1100 1110                      */
	{_illegal,0   }, /* cf: 0100 1101 1100 1111                      */

	{_MOV,"MM,A"     }, /* d0: 0100 1101 1101 0000                      */
	{_MOV,"MCC,A"    }, /* d1: 0100 1101 1101 0001                      */
	{_MOV,"MA,A"     }, /* d2: 0100 1101 1101 0010                      */
	{_MOV,"MB,A"     }, /* d3: 0100 1101 1101 0011                      */
	{_MOV,"MC,A"     }, /* d4: 0100 1101 1101 0100                      */
	{_illegal,0   }, /* d5: 0100 1101 1101 0101                      */
	{_illegal,0   }, /* d6: 0100 1101 1101 0110                      */
	{_MOV,"MF,A"     }, /* d7: 0100 1101 1101 0111                      */
	{_MOV,"TXB,A"    }, /* d8: 0100 1101 1101 1000                      */
	{_illegal,0   }, /* d9: 0100 1101 1101 1001                      */
	{_MOV,"TM0,A"    }, /* da: 0100 1101 1101 1010                      */
	{_MOV,"TM1,A"    }, /* db: 0100 1101 1101 1011                      */
	{_illegal,0   }, /* dc: 0100 1101 1101 1100                      */
	{_illegal,0   }, /* dd: 0100 1101 1101 1101                      */
	{_illegal,0   }, /* de: 0100 1101 1101 1110                      */
	{_illegal,0   }, /* df: 0100 1101 1101 1111                      */

	{_illegal,0   }, /* e0: 0100 1101 1110 0000                      */
	{_illegal,0   }, /* e1: 0100 1101 1110 0001                      */
	{_illegal,0   }, /* e2: 0100 1101 1110 0010                      */
	{_illegal,0   }, /* e3: 0100 1101 1110 0011                      */
	{_illegal,0   }, /* e4: 0100 1101 1110 0100                      */
	{_illegal,0   }, /* e5: 0100 1101 1110 0101                      */
	{_illegal,0   }, /* e6: 0100 1101 1110 0110                      */
	{_illegal,0   }, /* e7: 0100 1101 1110 0111                      */
	{_MOV,"ZCM,A"    }, /* e8: 0100 1101 1110 1000                      */   /* 7810 */
	{_illegal,0   }, /* e9: 0100 1101 1110 1001                      */
	{_illegal,0   }, /* ea: 0100 1101 1110 1010                      */
	{_illegal,0   }, /* eb: 0100 1101 1110 1011                      */
	{_illegal,0   }, /* ec: 0100 1101 1110 1100                      */
	{_illegal,0   }, /* ed: 0100 1101 1110 1101                      */
	{_illegal,0   }, /* ee: 0100 1101 1110 1110                      */
	{_illegal,0   }, /* ef: 0100 1101 1110 1111                      */

	{_illegal,0   }, /* f0: 0100 1101 1111 0000                      */
	{_illegal,0   }, /* f1: 0100 1101 1111 0001                      */
	{_illegal,0   }, /* f2: 0100 1101 1111 0010                      */
	{_illegal,0   }, /* f3: 0100 1101 1111 0011                      */
	{_illegal,0   }, /* f4: 0100 1101 1111 0100                      */
	{_illegal,0   }, /* f5: 0100 1101 1111 0101                      */
	{_illegal,0   }, /* f6: 0100 1101 1111 0110                      */
	{_illegal,0   }, /* f7: 0100 1101 1111 0111                      */
	{_illegal,0   }, /* f8: 0100 1101 1111 1000                      */
	{_illegal,0   }, /* f9: 0100 1101 1111 1001                      */
	{_illegal,0   }, /* fa: 0100 1101 1111 1010                      */
	{_illegal,0   }, /* fb: 0100 1101 1111 1011                      */
	{_illegal,0   }, /* fc: 0100 1101 1111 1100                      */
	{_illegal,0   }, /* fd: 0100 1101 1111 1101                      */
	{_illegal,0   }, /* fe: 0100 1101 1111 1110                      */
	{_illegal,0   }  /* ff: 0100 1101 1111 1111                      */
};

static const struct dasm_s  dasm4D_7807[256] =
{
	{_illegal,0   }, /* 00: 0100 1101 0000 0000                      */
	{_illegal,0   }, /* 01: 0100 1101 0000 0001                      */
	{_illegal,0   }, /* 02: 0100 1101 0000 0010                      */
	{_illegal,0   }, /* 03: 0100 1101 0000 0011                      */
	{_illegal,0   }, /* 04: 0100 1101 0000 0100                      */
	{_illegal,0   }, /* 05: 0100 1101 0000 0101                      */
	{_illegal,0   }, /* 06: 0100 1101 0000 0110                      */
	{_illegal,0   }, /* 07: 0100 1101 0000 0111                      */
	{_illegal,0   }, /* 08: 0100 1101 0000 1000                      */
	{_illegal,0   }, /* 09: 0100 1101 0000 1001                      */
	{_illegal,0   }, /* 0a: 0100 1101 0000 1010                      */
	{_illegal,0   }, /* 0b: 0100 1101 0000 1011                      */
	{_illegal,0   }, /* 0c: 0100 1101 0000 1100                      */
	{_illegal,0   }, /* 0d: 0100 1101 0000 1101                      */
	{_illegal,0   }, /* 0e: 0100 1101 0000 1110                      */
	{_illegal,0   }, /* 0f: 0100 1101 0000 1111                      */

	{_illegal,0   }, /* 10: 0100 1101 0001 0000                      */
	{_illegal,0   }, /* 11: 0100 1101 0001 0001                      */
	{_illegal,0   }, /* 12: 0100 1101 0001 0010                      */
	{_illegal,0   }, /* 13: 0100 1101 0001 0011                      */
	{_illegal,0   }, /* 14: 0100 1101 0001 0100                      */
	{_illegal,0   }, /* 15: 0100 1101 0001 0101                      */
	{_illegal,0   }, /* 16: 0100 1101 0001 0110                      */
	{_illegal,0   }, /* 17: 0100 1101 0001 0111                      */
	{_illegal,0   }, /* 18: 0100 1101 0001 1000                      */
	{_illegal,0   }, /* 19: 0100 1101 0001 1001                      */
	{_illegal,0   }, /* 1a: 0100 1101 0001 1010                      */
	{_illegal,0   }, /* 1b: 0100 1101 0001 1011                      */
	{_illegal,0   }, /* 1c: 0100 1101 0001 1100                      */
	{_illegal,0   }, /* 1d: 0100 1101 0001 1101                      */
	{_illegal,0   }, /* 1e: 0100 1101 0001 1110                      */
	{_illegal,0   }, /* 1f: 0100 1101 0001 1111                      */

	{_illegal,0   }, /* 20: 0100 1101 0010 0000                      */
	{_illegal,0   }, /* 21: 0100 1101 0010 0001                      */
	{_illegal,0   }, /* 22: 0100 1101 0010 0010                      */
	{_illegal,0   }, /* 23: 0100 1101 0010 0011                      */
	{_illegal,0   }, /* 24: 0100 1101 0010 0100                      */
	{_illegal,0   }, /* 25: 0100 1101 0010 0101                      */
	{_illegal,0   }, /* 26: 0100 1101 0010 0110                      */
	{_illegal,0   }, /* 27: 0100 1101 0010 0111                      */
	{_illegal,0   }, /* 28: 0100 1101 0010 1000                      */
	{_illegal,0   }, /* 29: 0100 1101 0010 1001                      */
	{_illegal,0   }, /* 2a: 0100 1101 0010 1010                      */
	{_illegal,0   }, /* 2b: 0100 1101 0010 1011                      */
	{_illegal,0   }, /* 2c: 0100 1101 0010 1100                      */
	{_illegal,0   }, /* 2d: 0100 1101 0010 1101                      */
	{_illegal,0   }, /* 2e: 0100 1101 0010 1110                      */
	{_illegal,0   }, /* 2f: 0100 1101 0010 1111                      */

	{_illegal,0   }, /* 30: 0100 1101 0011 0000                      */
	{_illegal,0   }, /* 31: 0100 1101 0011 0001                      */
	{_illegal,0   }, /* 32: 0100 1101 0011 0010                      */
	{_illegal,0   }, /* 33: 0100 1101 0011 0011                      */
	{_illegal,0   }, /* 34: 0100 1101 0011 0100                      */
	{_illegal,0   }, /* 35: 0100 1101 0011 0101                      */
	{_illegal,0   }, /* 36: 0100 1101 0011 0110                      */
	{_illegal,0   }, /* 37: 0100 1101 0011 0111                      */
	{_illegal,0   }, /* 38: 0100 1101 0011 1000                      */
	{_illegal,0   }, /* 39: 0100 1101 0011 1001                      */
	{_illegal,0   }, /* 3a: 0100 1101 0011 1010                      */
	{_illegal,0   }, /* 3b: 0100 1101 0011 1011                      */
	{_illegal,0   }, /* 3c: 0100 1101 0011 1100                      */
	{_illegal,0   }, /* 3d: 0100 1101 0011 1101                      */
	{_illegal,0   }, /* 3e: 0100 1101 0011 1110                      */
	{_illegal,0   }, /* 3f: 0100 1101 0011 1111                      */

	{_illegal,0   }, /* 40: 0100 1101 0100 0000                      */
	{_illegal,0   }, /* 41: 0100 1101 0100 0001                      */
	{_illegal,0   }, /* 42: 0100 1101 0100 0010                      */
	{_illegal,0   }, /* 43: 0100 1101 0100 0011                      */
	{_illegal,0   }, /* 44: 0100 1101 0100 0100                      */
	{_illegal,0   }, /* 45: 0100 1101 0100 0101                      */
	{_illegal,0   }, /* 46: 0100 1101 0100 0110                      */
	{_illegal,0   }, /* 47: 0100 1101 0100 0111                      */
	{_illegal,0   }, /* 48: 0100 1101 0100 1000                      */
	{_illegal,0   }, /* 49: 0100 1101 0100 1001                      */
	{_illegal,0   }, /* 4a: 0100 1101 0100 1010                      */
	{_illegal,0   }, /* 4b: 0100 1101 0100 1011                      */
	{_illegal,0   }, /* 4c: 0100 1101 0100 1100                      */
	{_illegal,0   }, /* 4d: 0100 1101 0100 1101                      */
	{_illegal,0   }, /* 4e: 0100 1101 0100 1110                      */
	{_illegal,0   }, /* 4f: 0100 1101 0100 1111                      */

	{_illegal,0   }, /* 50: 0100 1101 0101 0000                      */
	{_illegal,0   }, /* 51: 0100 1101 0101 0001                      */
	{_illegal,0   }, /* 52: 0100 1101 0101 0010                      */
	{_illegal,0   }, /* 53: 0100 1101 0101 0011                      */
	{_illegal,0   }, /* 54: 0100 1101 0101 0100                      */
	{_illegal,0   }, /* 55: 0100 1101 0101 0101                      */
	{_illegal,0   }, /* 56: 0100 1101 0101 0110                      */
	{_illegal,0   }, /* 57: 0100 1101 0101 0111                      */
	{_illegal,0   }, /* 58: 0100 1101 0101 1000                      */
	{_illegal,0   }, /* 59: 0100 1101 0101 1001                      */
	{_illegal,0   }, /* 5a: 0100 1101 0101 1010                      */
	{_illegal,0   }, /* 5b: 0100 1101 0101 1011                      */
	{_illegal,0   }, /* 5c: 0100 1101 0101 1100                      */
	{_illegal,0   }, /* 5d: 0100 1101 0101 1101                      */
	{_illegal,0   }, /* 5e: 0100 1101 0101 1110                      */
	{_illegal,0   }, /* 5f: 0100 1101 0101 1111                      */

	{_illegal,0   }, /* 60: 0100 1101 0110 0000                      */
	{_illegal,0   }, /* 61: 0100 1101 0110 0001                      */
	{_illegal,0   }, /* 62: 0100 1101 0110 0010                      */
	{_illegal,0   }, /* 63: 0100 1101 0110 0011                      */
	{_illegal,0   }, /* 64: 0100 1101 0110 0100                      */
	{_illegal,0   }, /* 65: 0100 1101 0110 0101                      */
	{_illegal,0   }, /* 66: 0100 1101 0110 0110                      */
	{_illegal,0   }, /* 67: 0100 1101 0110 0111                      */
	{_illegal,0   }, /* 68: 0100 1101 0110 1000                      */
	{_illegal,0   }, /* 69: 0100 1101 0110 1001                      */
	{_illegal,0   }, /* 6a: 0100 1101 0110 1010                      */
	{_illegal,0   }, /* 6b: 0100 1101 0110 1011                      */
	{_illegal,0   }, /* 6c: 0100 1101 0110 1100                      */
	{_illegal,0   }, /* 6d: 0100 1101 0110 1101                      */
	{_illegal,0   }, /* 6e: 0100 1101 0110 1110                      */
	{_illegal,0   }, /* 6f: 0100 1101 0110 1111                      */

	{_illegal,0   }, /* 70: 0100 1101 0111 0000                      */
	{_illegal,0   }, /* 71: 0100 1101 0111 0001                      */
	{_illegal,0   }, /* 72: 0100 1101 0111 0010                      */
	{_illegal,0   }, /* 73: 0100 1101 0111 0011                      */
	{_illegal,0   }, /* 74: 0100 1101 0111 0100                      */
	{_illegal,0   }, /* 75: 0100 1101 0111 0101                      */
	{_illegal,0   }, /* 76: 0100 1101 0111 0110                      */
	{_illegal,0   }, /* 77: 0100 1101 0111 0111                      */
	{_illegal,0   }, /* 78: 0100 1101 0111 1000                      */
	{_illegal,0   }, /* 79: 0100 1101 0111 1001                      */
	{_illegal,0   }, /* 7a: 0100 1101 0111 1010                      */
	{_illegal,0   }, /* 7b: 0100 1101 0111 1011                      */
	{_illegal,0   }, /* 7c: 0100 1101 0111 1100                      */
	{_illegal,0   }, /* 7d: 0100 1101 0111 1101                      */
	{_illegal,0   }, /* 7e: 0100 1101 0111 1110                      */
	{_illegal,0   }, /* 7f: 0100 1101 0111 1111                      */

	{_illegal,0   }, /* 80: 0100 1101 1000 0000                      */
	{_illegal,0   }, /* 81: 0100 1101 1000 0001                      */
	{_illegal,0   }, /* 82: 0100 1101 1000 0010                      */
	{_illegal,0   }, /* 83: 0100 1101 1000 0011                      */
	{_illegal,0   }, /* 84: 0100 1101 1000 0100                      */
	{_illegal,0   }, /* 85: 0100 1101 1000 0101                      */
	{_illegal,0   }, /* 86: 0100 1101 1000 0110                      */
	{_illegal,0   }, /* 87: 0100 1101 1000 0111                      */
	{_illegal,0   }, /* 88: 0100 1101 1000 1000                      */
	{_illegal,0   }, /* 89: 0100 1101 1000 1001                      */
	{_illegal,0   }, /* 8a: 0100 1101 1000 1010                      */
	{_illegal,0   }, /* 8b: 0100 1101 1000 1011                      */
	{_illegal,0   }, /* 8c: 0100 1101 1000 1100                      */
	{_illegal,0   }, /* 8d: 0100 1101 1000 1101                      */
	{_illegal,0   }, /* 8e: 0100 1101 1000 1110                      */
	{_illegal,0   }, /* 8f: 0100 1101 1000 1111                      */

	{_illegal,0   }, /* 90: 0100 1101 1001 0000                      */
	{_illegal,0   }, /* 91: 0100 1101 1001 0001                      */
	{_illegal,0   }, /* 92: 0100 1101 1001 0010                      */
	{_illegal,0   }, /* 93: 0100 1101 1001 0011                      */
	{_illegal,0   }, /* 94: 0100 1101 1001 0100                      */
	{_illegal,0   }, /* 95: 0100 1101 1001 0101                      */
	{_illegal,0   }, /* 96: 0100 1101 1001 0110                      */
	{_illegal,0   }, /* 97: 0100 1101 1001 0111                      */
	{_illegal,0   }, /* 98: 0100 1101 1001 1000                      */
	{_illegal,0   }, /* 99: 0100 1101 1001 1001                      */
	{_illegal,0   }, /* 9a: 0100 1101 1001 1010                      */
	{_illegal,0   }, /* 9b: 0100 1101 1001 1011                      */
	{_illegal,0   }, /* 9c: 0100 1101 1001 1100                      */
	{_illegal,0   }, /* 9d: 0100 1101 1001 1101                      */
	{_illegal,0   }, /* 9e: 0100 1101 1001 1110                      */
	{_illegal,0   }, /* 9f: 0100 1101 1001 1111                      */

	{_illegal,0   }, /* a0: 0100 1101 1010 0000                      */
	{_illegal,0   }, /* a1: 0100 1101 1010 0001                      */
	{_illegal,0   }, /* a2: 0100 1101 1010 0010                      */
	{_illegal,0   }, /* a3: 0100 1101 1010 0011                      */
	{_illegal,0   }, /* a4: 0100 1101 1010 0100                      */
	{_illegal,0   }, /* a5: 0100 1101 1010 0101                      */
	{_illegal,0   }, /* a6: 0100 1101 1010 0110                      */
	{_illegal,0   }, /* a7: 0100 1101 1010 0111                      */
	{_illegal,0   }, /* a8: 0100 1101 1010 1000                      */
	{_illegal,0   }, /* a9: 0100 1101 1010 1001                      */
	{_illegal,0   }, /* aa: 0100 1101 1010 1010                      */
	{_illegal,0   }, /* ab: 0100 1101 1010 1011                      */
	{_illegal,0   }, /* ac: 0100 1101 1010 1100                      */
	{_illegal,0   }, /* ad: 0100 1101 1010 1101                      */
	{_illegal,0   }, /* ae: 0100 1101 1010 1110                      */
	{_illegal,0   }, /* af: 0100 1101 1010 1111                      */

	{_illegal,0   }, /* b0: 0100 1101 1011 0000                      */
	{_illegal,0   }, /* b1: 0100 1101 1011 0001                      */
	{_illegal,0   }, /* b2: 0100 1101 1011 0010                      */
	{_illegal,0   }, /* b3: 0100 1101 1011 0011                      */
	{_illegal,0   }, /* b4: 0100 1101 1011 0100                      */
	{_illegal,0   }, /* b5: 0100 1101 1011 0101                      */
	{_illegal,0   }, /* b6: 0100 1101 1011 0110                      */
	{_illegal,0   }, /* b7: 0100 1101 1011 0111                      */
	{_illegal,0   }, /* b8: 0100 1101 1011 1000                      */
	{_illegal,0   }, /* b9: 0100 1101 1011 1001                      */
	{_illegal,0   }, /* ba: 0100 1101 1011 1010                      */
	{_illegal,0   }, /* bb: 0100 1101 1011 1011                      */
	{_illegal,0   }, /* bc: 0100 1101 1011 1100                      */
	{_illegal,0   }, /* bd: 0100 1101 1011 1101                      */
	{_illegal,0   }, /* be: 0100 1101 1011 1110                      */
	{_illegal,0   }, /* bf: 0100 1101 1011 1111                      */

	{_MOV,"PA,A"     }, /* c0: 0100 1101 1100 0000                      */
	{_MOV,"PB,A"     }, /* c1: 0100 1101 1100 0001                      */
	{_MOV,"PC,A"     }, /* c2: 0100 1101 1100 0010                      */
	{_MOV,"PD,A"     }, /* c3: 0100 1101 1100 0011                      */
	{_illegal,0   }, /* c4: 0100 1101 1100 0100                      */
	{_MOV,"PF,A"     }, /* c5: 0100 1101 1100 0101                      */
	{_MOV,"MKH,A"    }, /* c6: 0100 1101 1100 0110                      */
	{_MOV,"MKL,A"    }, /* c7: 0100 1101 1100 0111                      */
	{_illegal,0      }, /* c8: 0100 1101 1100 1000                      */
	{_MOV,"SMH,A"    }, /* c9: 0100 1101 1100 1001                      */
	{_MOV,"SML,A"    }, /* ca: 0100 1101 1100 1010                      */
	{_MOV,"EOM,A"    }, /* cb: 0100 1101 1100 1011                      */
	{_MOV,"ETMM,A"   }, /* cc: 0100 1101 1100 1100                      */
	{_MOV,"TMM,A"    }, /* cd: 0100 1101 1100 1101                      */
	{_illegal,0   }, /* ce: 0100 1101 1100 1110                      */
	{_illegal,0   }, /* cf: 0100 1101 1100 1111                      */

	{_MOV,"MM,A"     }, /* d0: 0100 1101 1101 0000                      */
	{_MOV,"MCC,A"    }, /* d1: 0100 1101 1101 0001                      */
	{_MOV,"MA,A"     }, /* d2: 0100 1101 1101 0010                      */
	{_MOV,"MB,A"     }, /* d3: 0100 1101 1101 0011                      */
	{_MOV,"MC,A"     }, /* d4: 0100 1101 1101 0100                      */
	{_illegal,0   }, /* d5: 0100 1101 1101 0101                      */
	{_illegal,0   }, /* d6: 0100 1101 1101 0110                      */
	{_MOV,"MF,A"     }, /* d7: 0100 1101 1101 0111                      */
	{_MOV,"TXB,A"    }, /* d8: 0100 1101 1101 1000                      */
	{_illegal,0   }, /* d9: 0100 1101 1101 1001                      */
	{_MOV,"TM0,A"    }, /* da: 0100 1101 1101 1010                      */
	{_MOV,"TM1,A"    }, /* db: 0100 1101 1101 1011                      */
	{_illegal,0   }, /* dc: 0100 1101 1101 1100                      */
	{_illegal,0   }, /* dd: 0100 1101 1101 1101                      */
	{_illegal,0   }, /* de: 0100 1101 1101 1110                      */
	{_illegal,0   }, /* df: 0100 1101 1101 1111                      */

	{_illegal,0   }, /* e0: 0100 1101 1110 0000                      */
	{_illegal,0   }, /* e1: 0100 1101 1110 0001                      */
	{_illegal,0   }, /* e2: 0100 1101 1110 0010                      */
	{_illegal,0   }, /* e3: 0100 1101 1110 0011                      */
	{_illegal,0   }, /* e4: 0100 1101 1110 0100                      */
	{_MOV,"MT,A"      }, /* e5: 0100 1101 1110 0101                      */  /* 7807 */
	{_illegal,0   }, /* e6: 0100 1101 1110 0110                      */
	{_illegal,0   }, /* e7: 0100 1101 1110 0111                      */
	{_illegal,0   }, /* e8: 0100 1101 1110 1000                      */
	{_illegal,0   }, /* e9: 0100 1101 1110 1001                      */
	{_illegal,0   }, /* ea: 0100 1101 1110 1010                      */
	{_illegal,0   }, /* eb: 0100 1101 1110 1011                      */
	{_illegal,0   }, /* ec: 0100 1101 1110 1100                      */
	{_illegal,0   }, /* ed: 0100 1101 1110 1101                      */
	{_illegal,0   }, /* ee: 0100 1101 1110 1110                      */
	{_illegal,0   }, /* ef: 0100 1101 1110 1111                      */

	{_illegal,0   }, /* f0: 0100 1101 1111 0000                      */
	{_illegal,0   }, /* f1: 0100 1101 1111 0001                      */
	{_illegal,0   }, /* f2: 0100 1101 1111 0010                      */
	{_illegal,0   }, /* f3: 0100 1101 1111 0011                      */
	{_illegal,0   }, /* f4: 0100 1101 1111 0100                      */
	{_illegal,0   }, /* f5: 0100 1101 1111 0101                      */
	{_illegal,0   }, /* f6: 0100 1101 1111 0110                      */
	{_illegal,0   }, /* f7: 0100 1101 1111 0111                      */
	{_illegal,0   }, /* f8: 0100 1101 1111 1000                      */
	{_illegal,0   }, /* f9: 0100 1101 1111 1001                      */
	{_illegal,0   }, /* fa: 0100 1101 1111 1010                      */
	{_illegal,0   }, /* fb: 0100 1101 1111 1011                      */
	{_illegal,0   }, /* fc: 0100 1101 1111 1100                      */
	{_illegal,0   }, /* fd: 0100 1101 1111 1101                      */
	{_illegal,0   }, /* fe: 0100 1101 1111 1110                      */
	{_illegal,0   }  /* ff: 0100 1101 1111 1111                      */
};

/* prefix 60 */
static const struct dasm_s  dasm60[256] =
{
	{_illegal,0   }, /* 00: 0110 0000 0000 0000                      */
	{_illegal,0   }, /* 01: 0110 0000 0000 0001                      */
	{_illegal,0   }, /* 02: 0110 0000 0000 0010                      */
	{_illegal,0   }, /* 03: 0110 0000 0000 0011                      */
	{_illegal,0   }, /* 04: 0110 0000 0000 0100                      */
	{_illegal,0   }, /* 05: 0110 0000 0000 0101                      */
	{_illegal,0   }, /* 06: 0110 0000 0000 0110                      */
	{_illegal,0   }, /* 07: 0110 0000 0000 0111                      */
	{_ANA,"V,A"      }, /* 08: 0110 0000 0000 1000                      */
	{_ANA,"A,A"      }, /* 09: 0110 0000 0000 1001                      */
	{_ANA,"B,A"      }, /* 0a: 0110 0000 0000 1010                      */
	{_ANA,"C,A"      }, /* 0b: 0110 0000 0000 1011                      */
	{_ANA,"D,A"      }, /* 0c: 0110 0000 0000 1100                      */
	{_ANA,"E,A"      }, /* 0d: 0110 0000 0000 1101                      */
	{_ANA,"H,A"      }, /* 0e: 0110 0000 0000 1110                      */
	{_ANA,"L,A"      }, /* 0f: 0110 0000 0000 1111                      */

	{_XRA,"V,A"      }, /* 10: 0110 0000 0001 0000                      */
	{_XRA,"A,A"      }, /* 11: 0110 0000 0001 0001                      */
	{_XRA,"B,A"      }, /* 12: 0110 0000 0001 0010                      */
	{_XRA,"C,A"      }, /* 13: 0110 0000 0001 0011                      */
	{_XRA,"D,A"      }, /* 14: 0110 0000 0001 0100                      */
	{_XRA,"E,A"      }, /* 15: 0110 0000 0001 0101                      */
	{_XRA,"H,A"      }, /* 16: 0110 0000 0001 0110                      */
	{_XRA,"L,A"      }, /* 17: 0110 0000 0001 0111                      */
	{_ORA,"V,A"      }, /* 18: 0110 0000 0001 1000                      */
	{_ORA,"A,A"      }, /* 19: 0110 0000 0001 1001                      */
	{_ORA,"B,A"      }, /* 1a: 0110 0000 0001 1010                      */
	{_ORA,"C,A"      }, /* 1b: 0110 0000 0001 1011                      */
	{_ORA,"D,A"      }, /* 1c: 0110 0000 0001 1100                      */
	{_ORA,"E,A"      }, /* 1d: 0110 0000 0001 1101                      */
	{_ORA,"H,A"      }, /* 1e: 0110 0000 0001 1110                      */
	{_ORA,"L,A"      }, /* 1f: 0110 0000 0001 1111                      */

	{_ADDNC,"V,A"    }, /* 20: 0110 0000 0010 0000                      */
	{_ADDNC,"A,A"    }, /* 21: 0110 0000 0010 0001                      */
	{_ADDNC,"B,A"    }, /* 22: 0110 0000 0010 0010                      */
	{_ADDNC,"C,A"    }, /* 23: 0110 0000 0010 0011                      */
	{_ADDNC,"D,A"    }, /* 24: 0110 0000 0010 0100                      */
	{_ADDNC,"E,A"    }, /* 25: 0110 0000 0010 0101                      */
	{_ADDNC,"H,A"    }, /* 26: 0110 0000 0010 0110                      */
	{_ADDNC,"L,A"    }, /* 27: 0110 0000 0010 0111                      */
	{_GTA,"V,A"      }, /* 28: 0110 0000 0010 1000                      */
	{_GTA,"A,A"      }, /* 29: 0110 0000 0010 1001                      */
	{_GTA,"B,A"      }, /* 2a: 0110 0000 0010 1010                      */
	{_GTA,"C,A"      }, /* 2b: 0110 0000 0010 1011                      */
	{_GTA,"D,A"      }, /* 2c: 0110 0000 0010 1100                      */
	{_GTA,"E,A"      }, /* 2d: 0110 0000 0010 1101                      */
	{_GTA,"H,A"      }, /* 2e: 0110 0000 0010 1110                      */
	{_GTA,"L,A"      }, /* 2f: 0110 0000 0010 1111                      */

	{_SUBNB,"V,A"    }, /* 30: 0110 0000 0011 0000                      */
	{_SUBNB,"A,A"    }, /* 31: 0110 0000 0011 0001                      */
	{_SUBNB,"B,A"    }, /* 32: 0110 0000 0011 0010                      */
	{_SUBNB,"C,A"    }, /* 33: 0110 0000 0011 0011                      */
	{_SUBNB,"D,A"    }, /* 34: 0110 0000 0011 0100                      */
	{_SUBNB,"E,A"    }, /* 35: 0110 0000 0011 0101                      */
	{_SUBNB,"H,A"    }, /* 36: 0110 0000 0011 0110                      */
	{_SUBNB,"L,A"    }, /* 37: 0110 0000 0011 0111                      */
	{_LTA,"V,A"      }, /* 38: 0110 0000 0011 1000                      */
	{_LTA,"A,A"      }, /* 39: 0110 0000 0011 1001                      */
	{_LTA,"B,A"      }, /* 3a: 0110 0000 0011 1010                      */
	{_LTA,"C,A"      }, /* 3b: 0110 0000 0011 1011                      */
	{_LTA,"D,A"      }, /* 3c: 0110 0000 0011 1100                      */
	{_LTA,"E,A"      }, /* 3d: 0110 0000 0011 1101                      */
	{_LTA,"H,A"      }, /* 3e: 0110 0000 0011 1110                      */
	{_LTA,"L,A"      }, /* 3f: 0110 0000 0011 1111                      */

	{_ADD,"V,A"      }, /* 40: 0110 0000 0100 0000                      */
	{_ADD,"A,A"      }, /* 41: 0110 0000 0100 0001                      */
	{_ADD,"B,A"      }, /* 42: 0110 0000 0100 0010                      */
	{_ADD,"C,A"      }, /* 43: 0110 0000 0100 0011                      */
	{_ADD,"D,A"      }, /* 44: 0110 0000 0100 0100                      */
	{_ADD,"E,A"      }, /* 45: 0110 0000 0100 0101                      */
	{_ADD,"H,A"      }, /* 46: 0110 0000 0100 0110                      */
	{_ADD,"L,A"      }, /* 47: 0110 0000 0100 0111                      */
	{_illegal,0   }, /* 48: 0110 0000 0100 1000                      */
	{_illegal,0   }, /* 49: 0110 0000 0100 1001                      */
	{_illegal,0   }, /* 4a: 0110 0000 0100 1010                      */
	{_illegal,0   }, /* 4b: 0110 0000 0100 1011                      */
	{_illegal,0   }, /* 4c: 0110 0000 0100 1100                      */
	{_illegal,0   }, /* 4d: 0110 0000 0100 1101                      */
	{_illegal,0   }, /* 4e: 0110 0000 0100 1110                      */
	{_illegal,0   }, /* 4f: 0110 0000 0100 1111                      */

	{_ADC,"V,A"      }, /* 50: 0110 0000 0101 0000                      */
	{_ADC,"A,A"      }, /* 51: 0110 0000 0101 0001                      */
	{_ADC,"B,A"      }, /* 52: 0110 0000 0101 0010                      */
	{_ADC,"C,A"      }, /* 53: 0110 0000 0101 0011                      */
	{_ADC,"D,A"      }, /* 54: 0110 0000 0101 0100                      */
	{_ADC,"E,A"      }, /* 55: 0110 0000 0101 0101                      */
	{_ADC,"H,A"      }, /* 56: 0110 0000 0101 0110                      */
	{_ADC,"L,A"      }, /* 57: 0110 0000 0101 0111                      */
	{_illegal,0   }, /* 58: 0110 0000 0101 1000                      */
	{_illegal,0   }, /* 59: 0110 0000 0101 1001                      */
	{_illegal,0   }, /* 5a: 0110 0000 0101 1010                      */
	{_illegal,0   }, /* 5b: 0110 0000 0101 1011                      */
	{_illegal,0   }, /* 5c: 0110 0000 0101 1100                      */
	{_illegal,0   }, /* 5d: 0110 0000 0101 1101                      */
	{_illegal,0   }, /* 5e: 0110 0000 0101 1110                      */
	{_illegal,0   }, /* 5f: 0110 0000 0101 1111                      */

	{_SUB,"V,A"      }, /* 60: 0110 0000 0110 0000                      */
	{_SUB,"A,A"      }, /* 61: 0110 0000 0110 0001                      */
	{_SUB,"B,A"      }, /* 62: 0110 0000 0110 0010                      */
	{_SUB,"C,A"      }, /* 63: 0110 0000 0110 0011                      */
	{_SUB,"D,A"      }, /* 64: 0110 0000 0110 0100                      */
	{_SUB,"E,A"      }, /* 65: 0110 0000 0110 0101                      */
	{_SUB,"H,A"      }, /* 66: 0110 0000 0110 0110                      */
	{_SUB,"L,A"      }, /* 67: 0110 0000 0110 0111                      */
	{_NEA,"V,A"      }, /* 68: 0110 0000 0110 1000                      */
	{_NEA,"A,A"      }, /* 69: 0110 0000 0110 1001                      */
	{_NEA,"B,A"      }, /* 6a: 0110 0000 0110 1010                      */
	{_NEA,"C,A"      }, /* 6b: 0110 0000 0110 1011                      */
	{_NEA,"D,A"      }, /* 6c: 0110 0000 0110 1100                      */
	{_NEA,"E,A"      }, /* 6d: 0110 0000 0110 1101                      */
	{_NEA,"H,A"      }, /* 6e: 0110 0000 0110 1110                      */
	{_NEA,"L,A"      }, /* 6f: 0110 0000 0110 1111                      */

	{_SBB,"V,A"      }, /* 70: 0110 0000 0111 0000                      */
	{_SBB,"A,A"      }, /* 71: 0110 0000 0111 0001                      */
	{_SBB,"B,A"      }, /* 72: 0110 0000 0111 0010                      */
	{_SBB,"C,A"      }, /* 73: 0110 0000 0111 0011                      */
	{_SBB,"D,A"      }, /* 74: 0110 0000 0111 0100                      */
	{_SBB,"E,A"      }, /* 75: 0110 0000 0111 0101                      */
	{_SBB,"H,A"      }, /* 76: 0110 0000 0111 0110                      */
	{_SBB,"L,A"      }, /* 77: 0110 0000 0111 0111                      */
	{_EQA,"V,A"      }, /* 78: 0110 0000 0111 1000                      */
	{_EQA,"A,A"      }, /* 79: 0110 0000 0111 1001                      */
	{_EQA,"B,A"      }, /* 7a: 0110 0000 0111 1010                      */
	{_EQA,"C,A"      }, /* 7b: 0110 0000 0111 1011                      */
	{_EQA,"D,A"      }, /* 7c: 0110 0000 0111 1100                      */
	{_EQA,"E,A"      }, /* 7d: 0110 0000 0111 1101                      */
	{_EQA,"H,A"      }, /* 7e: 0110 0000 0111 1110                      */
	{_EQA,"L,A"      }, /* 7f: 0110 0000 0111 1111                      */

	{_illegal,0   }, /* 80: 0110 0000 1000 0000                      */
	{_illegal,0   }, /* 81: 0110 0000 1000 0001                      */
	{_illegal,0   }, /* 82: 0110 0000 1000 0010                      */
	{_illegal,0   }, /* 83: 0110 0000 1000 0011                      */
	{_illegal,0   }, /* 84: 0110 0000 1000 0100                      */
	{_illegal,0   }, /* 85: 0110 0000 1000 0101                      */
	{_illegal,0   }, /* 86: 0110 0000 1000 0110                      */
	{_illegal,0   }, /* 87: 0110 0000 1000 0111                      */
	{_ANA,"A,V"      }, /* 88: 0110 0000 1000 1000                      */
	{_ANA,"A,A"      }, /* 89: 0110 0000 1000 1001                      */
	{_ANA,"A,B"      }, /* 8a: 0110 0000 1000 1010                      */
	{_ANA,"A,C"      }, /* 8b: 0110 0000 1000 1011                      */
	{_ANA,"A,D"      }, /* 8c: 0110 0000 1000 1100                      */
	{_ANA,"A,E"      }, /* 8d: 0110 0000 1000 1101                      */
	{_ANA,"A,H"      }, /* 8e: 0110 0000 1000 1110                      */
	{_ANA,"A,L"      }, /* 8f: 0110 0000 1000 1111                      */

	{_XRA,"A,V"      }, /* 90: 0110 0000 1001 0000                      */
	{_XRA,"A,A"      }, /* 91: 0110 0000 1001 0001                      */
	{_XRA,"A,B"      }, /* 92: 0110 0000 1001 0010                      */
	{_XRA,"A,C"      }, /* 93: 0110 0000 1001 0011                      */
	{_XRA,"A,D"      }, /* 94: 0110 0000 1001 0100                      */
	{_XRA,"A,E"      }, /* 95: 0110 0000 1001 0101                      */
	{_XRA,"A,H"      }, /* 96: 0110 0000 1001 0110                      */
	{_XRA,"A,L"      }, /* 97: 0110 0000 1001 0111                      */
	{_ORA,"A,V"      }, /* 98: 0110 0000 1001 1000                      */
	{_ORA,"A,A"      }, /* 99: 0110 0000 1001 1001                      */
	{_ORA,"A,B"      }, /* 9a: 0110 0000 1001 1010                      */
	{_ORA,"A,C"      }, /* 9b: 0110 0000 1001 1011                      */
	{_ORA,"A,D"      }, /* 9c: 0110 0000 1001 1100                      */
	{_ORA,"A,E"      }, /* 9d: 0110 0000 1001 1101                      */
	{_ORA,"A,H"      }, /* 9e: 0110 0000 1001 1110                      */
	{_ORA,"A,L"      }, /* 9f: 0110 0000 1001 1111                      */

	{_ADDNC,"A,V"    }, /* a0: 0110 0000 1010 0000                      */
	{_ADDNC,"A,A"    }, /* a1: 0110 0000 1010 0001                      */
	{_ADDNC,"A,B"    }, /* a2: 0110 0000 1010 0010                      */
	{_ADDNC,"A,C"    }, /* a3: 0110 0000 1010 0011                      */
	{_ADDNC,"A,D"    }, /* a4: 0110 0000 1010 0100                      */
	{_ADDNC,"A,E"    }, /* a5: 0110 0000 1010 0101                      */
	{_ADDNC,"A,H"    }, /* a6: 0110 0000 1010 0110                      */
	{_ADDNC,"A,L"    }, /* a7: 0110 0000 1010 0111                      */
	{_GTA,"A,V"      }, /* a8: 0110 0000 1010 1000                      */
	{_GTA,"A,A"      }, /* a9: 0110 0000 1010 1001                      */
	{_GTA,"A,B"      }, /* aa: 0110 0000 1010 1010                      */
	{_GTA,"A,C"      }, /* ab: 0110 0000 1010 1011                      */
	{_GTA,"A,D"      }, /* ac: 0110 0000 1010 1100                      */
	{_GTA,"A,E"      }, /* ad: 0110 0000 1010 1101                      */
	{_GTA,"A,H"      }, /* ae: 0110 0000 1010 1110                      */
	{_GTA,"A,L"      }, /* af: 0110 0000 1010 1111                      */

	{_SUBNB,"A,V"    }, /* b0: 0110 0000 1011 0000                      */
	{_SUBNB,"A,A"    }, /* b1: 0110 0000 1011 0001                      */
	{_SUBNB,"A,B"    }, /* b2: 0110 0000 1011 0010                      */
	{_SUBNB,"A,C"    }, /* b3: 0110 0000 1011 0011                      */
	{_SUBNB,"A,D"    }, /* b4: 0110 0000 1011 0100                      */
	{_SUBNB,"A,E"    }, /* b5: 0110 0000 1011 0101                      */
	{_SUBNB,"A,H"    }, /* b6: 0110 0000 1011 0110                      */
	{_SUBNB,"A,L"    }, /* b7: 0110 0000 1011 0111                      */
	{_LTA,"A,V"      }, /* b8: 0110 0000 1011 1000                      */
	{_LTA,"A,A"      }, /* b9: 0110 0000 1011 1001                      */
	{_LTA,"A,B"      }, /* ba: 0110 0000 1011 1010                      */
	{_LTA,"A,C"      }, /* bb: 0110 0000 1011 1011                      */
	{_LTA,"A,D"      }, /* bc: 0110 0000 1011 1100                      */
	{_LTA,"A,E"      }, /* bd: 0110 0000 1011 1101                      */
	{_LTA,"A,H"      }, /* be: 0110 0000 1011 1110                      */
	{_LTA,"A,L"      }, /* bf: 0110 0000 1011 1111                      */

	{_ADD,"A,V"      }, /* c0: 0110 0000 1100 0000                      */
	{_ADD,"A,A"      }, /* c1: 0110 0000 1100 0001                      */
	{_ADD,"A,B"      }, /* c2: 0110 0000 1100 0010                      */
	{_ADD,"A,C"      }, /* c3: 0110 0000 1100 0011                      */
	{_ADD,"A,D"      }, /* c4: 0110 0000 1100 0100                      */
	{_ADD,"A,E"      }, /* c5: 0110 0000 1100 0101                      */
	{_ADD,"A,H"      }, /* c6: 0110 0000 1100 0110                      */
	{_ADD,"A,L"      }, /* c7: 0110 0000 1100 0111                      */
	{_ONA,"A,V"      }, /* c8: 0110 0000 1100 1000                      */
	{_ONA,"A,A"      }, /* c9: 0110 0000 1100 1001                      */
	{_ONA,"A,B"      }, /* ca: 0110 0000 1100 1010                      */
	{_ONA,"A,C"      }, /* cb: 0110 0000 1100 1011                      */
	{_ONA,"A,D"      }, /* cc: 0110 0000 1100 1100                      */
	{_ONA,"A,E"      }, /* cd: 0110 0000 1100 1101                      */
	{_ONA,"A,H"      }, /* ce: 0110 0000 1100 1110                      */
	{_ONA,"A,L"      }, /* cf: 0110 0000 1100 1111                      */

	{_ADC,"A,V"      }, /* d0: 0110 0000 1101 0000                      */
	{_ADC,"A,A"      }, /* d1: 0110 0000 1101 0001                      */
	{_ADC,"A,B"      }, /* d2: 0110 0000 1101 0010                      */
	{_ADC,"A,C"      }, /* d3: 0110 0000 1101 0011                      */
	{_ADC,"A,D"      }, /* d4: 0110 0000 1101 0100                      */
	{_ADC,"A,E"      }, /* d5: 0110 0000 1101 0101                      */
	{_ADC,"A,H"      }, /* d6: 0110 0000 1101 0110                      */
	{_ADC,"A,L"      }, /* d7: 0110 0000 1101 0111                      */
	{_OFFA,"A,V"     }, /* d8: 0110 0000 1101 1000                      */
	{_OFFA,"A,A"     }, /* d9: 0110 0000 1101 1001                      */
	{_OFFA,"A,B"     }, /* da: 0110 0000 1101 1010                      */
	{_OFFA,"A,C"     }, /* db: 0110 0000 1101 1011                      */
	{_OFFA,"A,D"     }, /* dc: 0110 0000 1101 1100                      */
	{_OFFA,"A,E"     }, /* dd: 0110 0000 1101 1101                      */
	{_OFFA,"A,H"     }, /* de: 0110 0000 1101 1110                      */
	{_OFFA,"A,L"     }, /* df: 0110 0000 1101 1111                      */

	{_SUB,"A,V"      }, /* e0: 0110 0000 1110 0000                      */
	{_SUB,"A,A"      }, /* e1: 0110 0000 1110 0001                      */
	{_SUB,"A,B"      }, /* e2: 0110 0000 1110 0010                      */
	{_SUB,"A,C"      }, /* e3: 0110 0000 1110 0011                      */
	{_SUB,"A,D"      }, /* e4: 0110 0000 1110 0100                      */
	{_SUB,"A,E"      }, /* e5: 0110 0000 1110 0101                      */
	{_SUB,"A,H"      }, /* e6: 0110 0000 1110 0110                      */
	{_SUB,"A,L"      }, /* e7: 0110 0000 1110 0111                      */
	{_NEA,"A,V"      }, /* e8: 0110 0000 1110 1000                      */
	{_NEA,"A,A"      }, /* e9: 0110 0000 1110 1001                      */
	{_NEA,"A,B"      }, /* ea: 0110 0000 1110 1010                      */
	{_NEA,"A,C"      }, /* eb: 0110 0000 1110 1011                      */
	{_NEA,"A,D"      }, /* ec: 0110 0000 1110 1100                      */
	{_NEA,"A,E"      }, /* ed: 0110 0000 1110 1101                      */
	{_NEA,"A,H"      }, /* ee: 0110 0000 1110 1110                      */
	{_NEA,"A,L"      }, /* ef: 0110 0000 1110 1111                      */

	{_SBB,"A,V"      }, /* f0: 0110 0000 1111 0000                      */
	{_SBB,"A,A"      }, /* f1: 0110 0000 1111 0001                      */
	{_SBB,"A,B"      }, /* f2: 0110 0000 1111 0010                      */
	{_SBB,"A,C"      }, /* f3: 0110 0000 1111 0011                      */
	{_SBB,"A,D"      }, /* f4: 0110 0000 1111 0100                      */
	{_SBB,"A,E"      }, /* f5: 0110 0000 1111 0101                      */
	{_SBB,"A,H"      }, /* f6: 0110 0000 1111 0110                      */
	{_SBB,"A,L"      }, /* f7: 0110 0000 1111 0111                      */
	{_EQA,"A,V"      }, /* f8: 0110 0000 1111 1000                      */
	{_EQA,"A,A"      }, /* f9: 0110 0000 1111 1001                      */
	{_EQA,"A,B"      }, /* fa: 0110 0000 1111 1010                      */
	{_EQA,"A,C"      }, /* fb: 0110 0000 1111 1011                      */
	{_EQA,"A,D"      }, /* fc: 0110 0000 1111 1100                      */
	{_EQA,"A,E"      }, /* fd: 0110 0000 1111 1101                      */
	{_EQA,"A,H"      }, /* fe: 0110 0000 1111 1110                      */
	{_EQA,"A,L"      }  /* ff: 0110 0000 1111 1111                      */
};

/* prefix 64 */
static const struct dasm_s  dasm64_7810[256] =
{
	{_MVI,"PA,%b"    }, /* 00: 0110 0100 0000 0000 xxxx xxxx            */
	{_MVI,"PB,%b"    }, /* 01: 0110 0100 0000 0001 xxxx xxxx            */
	{_MVI,"PC,%b"    }, /* 02: 0110 0100 0000 0010 xxxx xxxx            */
	{_MVI,"PD,%b"    }, /* 03: 0110 0100 0000 0011 xxxx xxxx            */
	{_illegal,0   }, /* 04: 0110 0100 0000 0100 xxxx xxxx            */
	{_MVI,"PF,%b"    }, /* 05: 0110 0100 0000 0101 xxxx xxxx            */
	{_MVI,"MKH,%b"   }, /* 06: 0110 0100 0000 0110 xxxx xxxx            */
	{_MVI,"MKL,%b"   }, /* 07: 0110 0100 0000 0111 xxxx xxxx            */
	{_ANI,"PA,%b"    }, /* 08: 0110 0100 0000 1000 xxxx xxxx            */
	{_ANI,"PB,%b"    }, /* 09: 0110 0100 0000 1001 xxxx xxxx            */
	{_ANI,"PC,%b"    }, /* 0a: 0110 0100 0000 1010 xxxx xxxx            */
	{_ANI,"PD,%b"    }, /* 0b: 0110 0100 0000 1011 xxxx xxxx            */
	{_illegal,0   }, /* 0c: 0110 0100 0000 1100 xxxx xxxx            */
	{_ANI,"PF,%b"    }, /* 0d: 0110 0100 0000 1101 xxxx xxxx            */
	{_ANI,"MKH,%b"   }, /* 0e: 0110 0100 0000 1110 xxxx xxxx            */
	{_ANI,"MKL,%b"   }, /* 0f: 0110 0100 0000 1111 xxxx xxxx            */

	{_XRI,"PA,%b"    }, /* 10: 0110 0100 0001 0000 xxxx xxxx            */
	{_XRI,"PB,%b"    }, /* 11: 0110 0100 0001 0001 xxxx xxxx            */
	{_XRI,"PC,%b"    }, /* 12: 0110 0100 0001 0010 xxxx xxxx            */
	{_XRI,"PD,%b"    }, /* 13: 0110 0100 0001 0011 xxxx xxxx            */
	{_illegal,0   }, /* 14: 0110 0100 0001 0100 xxxx xxxx            */
	{_XRI,"PF,%b"    }, /* 15: 0110 0100 0001 0101 xxxx xxxx            */
	{_XRI,"MKH,%b"   }, /* 16: 0110 0100 0001 0110 xxxx xxxx            */
	{_XRI,"MKL,%b"   }, /* 17: 0110 0100 0001 0111 xxxx xxxx            */
	{_ORI,"PA,%b"    }, /* 18: 0110 0100 0001 1000 xxxx xxxx            */
	{_ORI,"PB,%b"    }, /* 19: 0110 0100 0001 1001 xxxx xxxx            */
	{_ORI,"PC,%b"    }, /* 1a: 0110 0100 0001 1010 xxxx xxxx            */
	{_ORI,"PD,%b"    }, /* 1b: 0110 0100 0001 1011 xxxx xxxx            */
	{_illegal,0   }, /* 1c: 0110 0100 0001 1100 xxxx xxxx            */
	{_ORI,"PF,%b"    }, /* 1d: 0110 0100 0001 1101 xxxx xxxx            */
	{_ORI,"MKH,%b"   }, /* 1e: 0110 0100 0001 1110 xxxx xxxx            */
	{_ORI,"MKL,%b"   }, /* 1f: 0110 0100 0001 1111 xxxx xxxx            */

	{_ADINC,"PA,%b"  }, /* 20: 0110 0100 0010 0000 xxxx xxxx            */
	{_ADINC,"PB,%b"  }, /* 21: 0110 0100 0010 0001 xxxx xxxx            */
	{_ADINC,"PC,%b"  }, /* 22: 0110 0100 0010 0010 xxxx xxxx            */
	{_ADINC,"PD,%b"  }, /* 23: 0110 0100 0010 0011 xxxx xxxx            */
	{_illegal,0   }, /* 24: 0110 0100 0010 0100 xxxx xxxx            */
	{_ADINC,"PF,%b"  }, /* 25: 0110 0100 0010 0101 xxxx xxxx            */
	{_ADINC,"MKH,%b" }, /* 26: 0110 0100 0010 0110 xxxx xxxx            */
	{_ADINC,"MKL,%b" }, /* 27: 0110 0100 0010 0111 xxxx xxxx            */
	{_GTI,"PA,%b"    }, /* 28: 0110 0100 0010 1000 xxxx xxxx            */
	{_GTI,"PB,%b"    }, /* 29: 0110 0100 0010 1001 xxxx xxxx            */
	{_GTI,"PC,%b"    }, /* 2a: 0110 0100 0010 1010 xxxx xxxx            */
	{_GTI,"PD,%b"    }, /* 2b: 0110 0100 0010 1011 xxxx xxxx            */
	{_illegal,0   }, /* 2c: 0110 0100 0010 1100 xxxx xxxx            */
	{_GTI,"PF,%b"    }, /* 2d: 0110 0100 0010 1101 xxxx xxxx            */
	{_GTI,"MKH,%b"   }, /* 2e: 0110 0100 0010 1110 xxxx xxxx            */
	{_GTI,"MKL,%b"   }, /* 2f: 0110 0100 0010 1111 xxxx xxxx            */

	{_SUINB,"PA,%b"  }, /* 30: 0110 0100 0011 0000 xxxx xxxx            */
	{_SUINB,"PB,%b"  }, /* 31: 0110 0100 0011 0001 xxxx xxxx            */
	{_SUINB,"PC,%b"  }, /* 32: 0110 0100 0011 0010 xxxx xxxx            */
	{_SUINB,"PD,%b"  }, /* 33: 0110 0100 0011 0011 xxxx xxxx            */
	{_illegal,0   }, /* 34: 0110 0100 0011 0100 xxxx xxxx            */
	{_SUINB,"PF,%b"  }, /* 35: 0110 0100 0011 0101 xxxx xxxx            */
	{_SUINB,"MKH,%b" }, /* 36: 0110 0100 0011 0110 xxxx xxxx            */
	{_SUINB,"MKL,%b" }, /* 37: 0110 0100 0011 0111 xxxx xxxx            */
	{_LTI,"PA,%b"    }, /* 38: 0110 0100 0011 1000 xxxx xxxx            */
	{_LTI,"PB,%b"    }, /* 39: 0110 0100 0011 1001 xxxx xxxx            */
	{_LTI,"PC,%b"    }, /* 3a: 0110 0100 0011 1010 xxxx xxxx            */
	{_LTI,"PD,%b"    }, /* 3b: 0110 0100 0011 1011 xxxx xxxx            */
	{_illegal,0   }, /* 3c: 0110 0100 0011 1100 xxxx xxxx            */
	{_LTI,"PF,%b"    }, /* 3d: 0110 0100 0011 1101 xxxx xxxx            */
	{_LTI,"MKH,%b"   }, /* 3e: 0110 0100 0011 1110 xxxx xxxx            */
	{_LTI,"MKL,%b"   }, /* 3f: 0110 0100 0011 1111 xxxx xxxx            */

	{_ADI,"PA,%b"    }, /* 40: 0110 0100 0100 0000 xxxx xxxx            */
	{_ADI,"PB,%b"    }, /* 41: 0110 0100 0100 0001 xxxx xxxx            */
	{_ADI,"PC,%b"    }, /* 42: 0110 0100 0100 0010 xxxx xxxx            */
	{_ADI,"PD,%b"    }, /* 43: 0110 0100 0100 0011 xxxx xxxx            */
	{_illegal,0   }, /* 44: 0110 0100 0100 0100 xxxx xxxx            */
	{_ADI,"PF,%b"    }, /* 45: 0110 0100 0100 0101 xxxx xxxx            */
	{_ADI,"MKH,%b"   }, /* 46: 0110 0100 0100 0110 xxxx xxxx            */
	{_ADI,"MKL,%b"   }, /* 47: 0110 0100 0100 0111 xxxx xxxx            */
	{_ONI,"PA,%b"    }, /* 48: 0110 0100 0100 1000 xxxx xxxx            */
	{_ONI,"PB,%b"    }, /* 49: 0110 0100 0100 1001 xxxx xxxx            */
	{_ONI,"PC,%b"    }, /* 4a: 0110 0100 0100 1010 xxxx xxxx            */
	{_ONI,"PD,%b"    }, /* 4b: 0110 0100 0100 1011 xxxx xxxx            */
	{_illegal,0   }, /* 4c: 0110 0100 0100 1100 xxxx xxxx            */
	{_ONI,"PF,%b"    }, /* 4d: 0110 0100 0100 1101 xxxx xxxx            */
	{_ONI,"MKH,%b"   }, /* 4e: 0110 0100 0100 1110 xxxx xxxx            */
	{_ONI,"MKL,%b"   }, /* 4f: 0110 0100 0100 1111 xxxx xxxx            */

	{_ACI,"PA,%b"    }, /* 50: 0110 0100 0101 0000 xxxx xxxx            */
	{_ACI,"PB,%b"    }, /* 51: 0110 0100 0101 0001 xxxx xxxx            */
	{_ACI,"PC,%b"    }, /* 52: 0110 0100 0101 0010 xxxx xxxx            */
	{_ACI,"PD,%b"    }, /* 53: 0110 0100 0101 0011 xxxx xxxx            */
	{_illegal,0   }, /* 54: 0110 0100 0101 0100 xxxx xxxx            */
	{_ACI,"PF,%b"    }, /* 55: 0110 0100 0101 0101 xxxx xxxx            */
	{_ACI,"MKH,%b"   }, /* 56: 0110 0100 0101 0110 xxxx xxxx            */
	{_ACI,"MKL,%b"   }, /* 57: 0110 0100 0101 0111 xxxx xxxx            */
	{_OFFI,"PA,%b"   }, /* 58: 0110 0100 0101 1000 xxxx xxxx            */
	{_OFFI,"PB,%b"   }, /* 59: 0110 0100 0101 1001 xxxx xxxx            */
	{_OFFI,"PC,%b"   }, /* 5a: 0110 0100 0101 1010 xxxx xxxx            */
	{_OFFI,"PD,%b"   }, /* 5b: 0110 0100 0101 1011 xxxx xxxx            */
	{_illegal,0   }, /* 5c: 0110 0100 0101 1100 xxxx xxxx            */
	{_OFFI,"PF,%b"   }, /* 5d: 0110 0100 0101 1101 xxxx xxxx            */
	{_OFFI,"MKH,%b"  }, /* 5e: 0110 0100 0101 1110 xxxx xxxx            */
	{_OFFI,"MKL,%b"  }, /* 5f: 0110 0100 0101 1111 xxxx xxxx            */

	{_SUI,"PA,%b"    }, /* 60: 0110 0100 0110 0000 xxxx xxxx            */
	{_SUI,"PB,%b"    }, /* 61: 0110 0100 0110 0001 xxxx xxxx            */
	{_SUI,"PC,%b"    }, /* 62: 0110 0100 0110 0010 xxxx xxxx            */
	{_SUI,"PD,%b"    }, /* 63: 0110 0100 0110 0011 xxxx xxxx            */
	{_illegal,0   }, /* 64: 0110 0100 0110 0100 xxxx xxxx            */
	{_SUI,"PF,%b"    }, /* 65: 0110 0100 0110 0101 xxxx xxxx            */
	{_SUI,"MKH,%b"   }, /* 66: 0110 0100 0110 0110 xxxx xxxx            */
	{_SUI,"MKL,%b"   }, /* 67: 0110 0100 0110 0111 xxxx xxxx            */
	{_NEI,"PA,%b"    }, /* 68: 0110 0100 0110 1000 xxxx xxxx            */
	{_NEI,"PB,%b"    }, /* 69: 0110 0100 0110 1001 xxxx xxxx            */
	{_NEI,"PC,%b"    }, /* 6a: 0110 0100 0110 1010 xxxx xxxx            */
	{_NEI,"PD,%b"    }, /* 6b: 0110 0100 0110 1011 xxxx xxxx            */
	{_illegal,0   }, /* 6c: 0110 0100 0110 1100 xxxx xxxx            */
	{_NEI,"PF,%b"    }, /* 6d: 0110 0100 0110 1101 xxxx xxxx            */
	{_NEI,"MKH,%b"   }, /* 6e: 0110 0100 0110 1110 xxxx xxxx            */
	{_NEI,"MKL,%b"   }, /* 6f: 0110 0100 0110 1111 xxxx xxxx            */

	{_SBI,"PA,%b"    }, /* 70: 0110 0100 0111 0000 xxxx xxxx            */
	{_SBI,"PB,%b"    }, /* 71: 0110 0100 0111 0001 xxxx xxxx            */
	{_SBI,"PC,%b"    }, /* 72: 0110 0100 0111 0010 xxxx xxxx            */
	{_SBI,"PD,%b"    }, /* 73: 0110 0100 0111 0011 xxxx xxxx            */
	{_illegal,0   }, /* 74: 0110 0100 0111 0100 xxxx xxxx            */
	{_SBI,"PF,%b"    }, /* 75: 0110 0100 0111 0101 xxxx xxxx            */
	{_SBI,"MKH,%b"   }, /* 76: 0110 0100 0111 0110 xxxx xxxx            */
	{_SBI,"MKL,%b"   }, /* 77: 0110 0100 0111 0111 xxxx xxxx            */
	{_EQI,"PA,%b"    }, /* 78: 0110 0100 0111 1000 xxxx xxxx            */
	{_EQI,"PB,%b"    }, /* 79: 0110 0100 0111 1001 xxxx xxxx            */
	{_EQI,"PC,%b"    }, /* 7a: 0110 0100 0111 1010 xxxx xxxx            */
	{_EQI,"PD,%b"    }, /* 7b: 0110 0100 0111 1011 xxxx xxxx            */
	{_illegal,0   }, /* 7c: 0110 0100 0111 1100 xxxx xxxx            */
	{_EQI,"PF,%b"    }, /* 7d: 0110 0100 0111 1101 xxxx xxxx            */
	{_EQI,"MKH,%b"   }, /* 7e: 0110 0100 0111 1110 xxxx xxxx            */
	{_EQI,"MKL,%b"   }, /* 7f: 0110 0100 0111 1111 xxxx xxxx            */

	{_MVI,"ANM,%b"   }, /* 80: 0110 0100 1000 0000 xxxx xxxx            */   /* 7810 */
	{_MVI,"SMH,%b"   }, /* 81: 0110 0100 1000 0001 xxxx xxxx            */
	{_illegal,0   }, /* 82: 0110 0100 1000 0010 xxxx xxxx            */
	{_MVI,"EOM,%b"   }, /* 83: 0110 0100 1000 0011 xxxx xxxx            */
	{_illegal,0   }, /* 84: 0110 0100 1000 0100 xxxx xxxx            */
	{_MVI,"TMM,%b"   }, /* 85: 0110 0100 1000 0101 xxxx xxxx            */
	{_illegal,0   }, /* 86: 0110 0100 1000 0110 xxxx xxxx            */
	{_illegal,0   }, /* 87: 0110 0100 1000 0111 xxxx xxxx            */
	{_ANI,"ANM,%b"   }, /* 88: 0110 0100 1000 1000 xxxx xxxx            */   /* 7810 */
	{_ANI,"SMH,%b"   }, /* 89: 0110 0100 1000 1001 xxxx xxxx            */
	{_illegal,0   }, /* 8a: 0110 0100 1000 1010 xxxx xxxx            */
	{_ANI,"EOM,%b"   }, /* 8b: 0110 0100 1000 1011 xxxx xxxx            */
	{_illegal,0   }, /* 8c: 0110 0100 1000 1100 xxxx xxxx            */
	{_ANI,"TMM,%b"   }, /* 8d: 0110 0100 1000 1101 xxxx xxxx            */
	{_illegal,0   }, /* 8e: 0110 0100 1000 1110 xxxx xxxx            */
	{_illegal,0   }, /* 8f: 0110 0100 1000 1111 xxxx xxxx            */

	{_XRI,"ANM,%b"   }, /* 90: 0110 0100 1001 0000 xxxx xxxx            */   /* 7810 */
	{_XRI,"SMH,%b"   }, /* 91: 0110 0100 1001 0001 xxxx xxxx            */
	{_illegal,0   }, /* 92: 0110 0100 1001 0010 xxxx xxxx            */
	{_XRI,"EOM,%b"   }, /* 93: 0110 0100 1001 0011 xxxx xxxx            */
	{_illegal,0   }, /* 94: 0110 0100 1001 0100 xxxx xxxx            */
	{_XRI,"TMM,%b"   }, /* 95: 0110 0100 1001 0101 xxxx xxxx            */
	{_illegal,0   }, /* 96: 0110 0100 1001 0110 xxxx xxxx            */
	{_illegal,0   }, /* 97: 0110 0100 1001 0111 xxxx xxxx            */
	{_ORI,"ANM,%b"   }, /* 98: 0110 0100 1001 1000 xxxx xxxx            */   /* 7810 */
	{_ORI,"SMH,%b"   }, /* 99: 0110 0100 1001 1001 xxxx xxxx            */
	{_illegal,0   }, /* 9a: 0110 0100 1001 1010 xxxx xxxx            */
	{_ORI,"EOM,%b"   }, /* 9b: 0110 0100 1001 1011 xxxx xxxx            */
	{_illegal,0   }, /* 9c: 0110 0100 1001 1100 xxxx xxxx            */
	{_ORI,"TMM,%b"   }, /* 9d: 0110 0100 1001 1101 xxxx xxxx            */
	{_illegal,0   }, /* 9e: 0110 0100 1001 1110 xxxx xxxx            */
	{_illegal,0   }, /* 9f: 0110 0100 1001 1111 xxxx xxxx            */

	{_ADINC,"ANM,%b" }, /* a0: 0110 0100 1010 0000 xxxx xxxx            */   /* 7810 */
	{_ADINC,"SMH,%b" }, /* a1: 0110 0100 1010 0001 xxxx xxxx            */
	{_illegal,0   }, /* a2: 0110 0100 1010 0010 xxxx xxxx            */
	{_ADINC,"EOM,%b" }, /* a3: 0110 0100 1010 0011 xxxx xxxx            */
	{_illegal,0   }, /* a4: 0110 0100 1010 0100 xxxx xxxx            */
	{_ADINC,"TMM,%b" }, /* a5: 0110 0100 1010 0101 xxxx xxxx            */
	{_illegal,0   }, /* a6: 0110 0100 1010 0110 xxxx xxxx            */
	{_illegal,0   }, /* a7: 0110 0100 1010 0111 xxxx xxxx            */
	{_GTI,"ANM,%b"   }, /* a8: 0110 0100 1010 1000 xxxx xxxx            */   /* 7810 */
	{_GTI,"SMH,%b"   }, /* a9: 0110 0100 1010 1001 xxxx xxxx            */
	{_illegal,0   }, /* aa: 0110 0100 1010 1010 xxxx xxxx            */
	{_GTI,"EOM,%b"   }, /* ab: 0110 0100 1010 1011 xxxx xxxx            */
	{_illegal,0   }, /* ac: 0110 0100 1010 1100 xxxx xxxx            */
	{_GTI,"TMM,%b"   }, /* ad: 0110 0100 1010 1101 xxxx xxxx            */
	{_illegal,0   }, /* ae: 0110 0100 1010 1110 xxxx xxxx            */
	{_illegal,0   }, /* af: 0110 0100 1010 1111 xxxx xxxx            */

	{_SUINB,"ANM,%b" }, /* b0: 0110 0100 1011 0000 xxxx xxxx            */   /* 7810 */
	{_SUINB,"SMH,%b" }, /* b1: 0110 0100 1011 0001 xxxx xxxx            */
	{_illegal,0   }, /* b2: 0110 0100 1011 0010 xxxx xxxx            */
	{_SUINB,"EOM,%b" }, /* b3: 0110 0100 1011 0011 xxxx xxxx            */
	{_illegal,0   }, /* b4: 0110 0100 1011 0100 xxxx xxxx            */
	{_SUINB,"TMM,%b" }, /* b5: 0110 0100 1011 0101 xxxx xxxx            */
	{_illegal,0   }, /* b6: 0110 0100 1011 0110 xxxx xxxx            */
	{_illegal,0   }, /* b7: 0110 0100 1011 0111 xxxx xxxx            */
	{_LTI,"ANM,%b"   }, /* b8: 0110 0100 1011 1000 xxxx xxxx            */   /* 7810 */
	{_LTI,"SMH,%b"   }, /* b9: 0110 0100 1011 1001 xxxx xxxx            */
	{_illegal,0   }, /* ba: 0110 0100 1011 1010 xxxx xxxx            */
	{_LTI,"EOM,%b"   }, /* bb: 0110 0100 1011 1011 xxxx xxxx            */
	{_illegal,0   }, /* bc: 0110 0100 1011 1100 xxxx xxxx            */
	{_LTI,"TMM,%b"   }, /* bd: 0110 0100 1011 1101 xxxx xxxx            */
	{_illegal,0   }, /* be: 0110 0100 1011 1110 xxxx xxxx            */
	{_illegal,0   }, /* bf: 0110 0100 1011 1111 xxxx xxxx            */

	{_ADI,"ANM,%b"   }, /* c0: 0110 0100 1100 0000 xxxx xxxx            */   /* 7810 */
	{_ADI,"SMH,%b"   }, /* c1: 0110 0100 1100 0001 xxxx xxxx            */
	{_illegal,0   }, /* c2: 0110 0100 1100 0010 xxxx xxxx            */
	{_ADI,"EOM,%b"   }, /* c3: 0110 0100 1100 0011 xxxx xxxx            */
	{_illegal,0   }, /* c4: 0110 0100 1100 0100 xxxx xxxx            */
	{_ADI,"TMM,%b"   }, /* c5: 0110 0100 1100 0101 xxxx xxxx            */
	{_illegal,0   }, /* c6: 0110 0100 1100 0110 xxxx xxxx            */
	{_illegal,0   }, /* c7: 0110 0100 1100 0111 xxxx xxxx            */
	{_ONI,"ANM,%b"   }, /* c8: 0110 0100 1100 1000 xxxx xxxx            */   /* 7810 */
	{_ONI,"SMH,%b"   }, /* c9: 0110 0100 1100 1001 xxxx xxxx            */
	{_illegal,0   }, /* ca: 0110 0100 1100 1010 xxxx xxxx            */
	{_ONI,"EOM,%b"   }, /* cb: 0110 0100 1100 1011 xxxx xxxx            */
	{_illegal,0   }, /* cc: 0110 0100 1100 1100 xxxx xxxx            */
	{_ONI,"TMM,%b"   }, /* cd: 0110 0100 1100 1101 xxxx xxxx            */
	{_illegal,0   }, /* ce: 0110 0100 1100 1110 xxxx xxxx            */
	{_illegal,0   }, /* cf: 0110 0100 1100 1111 xxxx xxxx            */

	{_ACI,"ANM,%b"   }, /* d0: 0110 0100 1101 0000 xxxx xxxx            */   /* 7810 */
	{_ACI,"SMH,%b"   }, /* d1: 0110 0100 1101 0001 xxxx xxxx            */
	{_illegal,0   }, /* d2: 0110 0100 1101 0010 xxxx xxxx            */
	{_ACI,"EOM,%b"   }, /* d3: 0110 0100 1101 0011 xxxx xxxx            */
	{_illegal,0   }, /* d4: 0110 0100 1101 0100 xxxx xxxx            */
	{_ACI,"TMM,%b"   }, /* d5: 0110 0100 1101 0101 xxxx xxxx            */
	{_illegal,0   }, /* d6: 0110 0100 1101 0110 xxxx xxxx            */
	{_illegal,0   }, /* d7: 0110 0100 1101 0111 xxxx xxxx            */
	{_OFFI,"ANM,%b"  }, /* d8: 0110 0100 1101 1000 xxxx xxxx            */   /* 7810 */
	{_OFFI,"SMH,%b"  }, /* d9: 0110 0100 1101 1001 xxxx xxxx            */
	{_illegal,0   }, /* da: 0110 0100 1101 1010 xxxx xxxx            */
	{_OFFI,"EOM,%b"  }, /* db: 0110 0100 1101 1011 xxxx xxxx            */
	{_illegal,0   }, /* dc: 0110 0100 1101 1100 xxxx xxxx            */
	{_OFFI,"TMM,%b"  }, /* dd: 0110 0100 1101 1101 xxxx xxxx            */
	{_illegal,0   }, /* de: 0110 0100 1101 1110 xxxx xxxx            */
	{_illegal,0   }, /* df: 0110 0100 1101 1111 xxxx xxxx            */

	{_SUI,"ANM,%b"   }, /* e0: 0110 0100 1110 0000 xxxx xxxx            */   /* 7810 */
	{_SUI,"SMH,%b"   }, /* e1: 0110 0100 1110 0001 xxxx xxxx            */
	{_illegal,0   }, /* e2: 0110 0100 1110 0010 xxxx xxxx            */
	{_SUI,"EOM,%b"   }, /* e3: 0110 0100 1110 0011 xxxx xxxx            */
	{_illegal,0   }, /* e4: 0110 0100 1110 0100 xxxx xxxx            */
	{_SUI,"TMM,%b"   }, /* e5: 0110 0100 1110 0101 xxxx xxxx            */
	{_illegal,0   }, /* e6: 0110 0100 1110 0110 xxxx xxxx            */
	{_illegal,0   }, /* e7: 0110 0100 1110 0111 xxxx xxxx            */
	{_NEI,"ANM,%b"   }, /* e8: 0110 0100 1110 1000 xxxx xxxx            */   /* 7810 */
	{_NEI,"SMH,%b"   }, /* e9: 0110 0100 1110 1001 xxxx xxxx            */
	{_illegal,0   }, /* ea: 0110 0100 1110 1010 xxxx xxxx            */
	{_NEI,"EOM,%b"   }, /* eb: 0110 0100 1110 1011 xxxx xxxx            */
	{_illegal,0   }, /* ec: 0110 0100 1110 1100 xxxx xxxx            */
	{_NEI,"TMM,%b"   }, /* ed: 0110 0100 1110 1101 xxxx xxxx            */
	{_illegal,0   }, /* ee: 0110 0100 1110 1110 xxxx xxxx            */
	{_illegal,0   }, /* ef: 0110 0100 1110 1111 xxxx xxxx            */

	{_SBI,"ANM,%b"   }, /* f0: 0110 0100 1111 0000 xxxx xxxx            */   /* 7810 */
	{_SBI,"SMH,%b"   }, /* f1: 0110 0100 1111 0001 xxxx xxxx            */
	{_illegal,0   }, /* f2: 0110 0100 1111 0010 xxxx xxxx            */
	{_SBI,"EOM,%b"   }, /* f3: 0110 0100 1111 0011 xxxx xxxx            */
	{_illegal,0   }, /* f4: 0110 0100 1111 0100 xxxx xxxx            */
	{_SBI,"TMM,%b"   }, /* f5: 0110 0100 1111 0101 xxxx xxxx            */
	{_illegal,0   }, /* f6: 0110 0100 1111 0110 xxxx xxxx            */
	{_illegal,0   }, /* f7: 0110 0100 1111 0111 xxxx xxxx            */
	{_EQI,"ANM,%b"   }, /* f8: 0110 0100 1111 1000 xxxx xxxx            */   /* 7810 */
	{_EQI,"SMH,%b"   }, /* f9: 0110 0100 1111 1001 xxxx xxxx            */
	{_illegal,0   }, /* fa: 0110 0100 1111 1010 xxxx xxxx            */
	{_EQI,"EOM,%b"   }, /* fb: 0110 0100 1111 1011 xxxx xxxx            */
	{_illegal,0   }, /* fc: 0110 0100 1111 1100 xxxx xxxx            */
	{_EQI,"TMM,%b"   }, /* fd: 0110 0100 1111 1101 xxxx xxxx            */
	{_illegal,0   }, /* fe: 0110 0100 1111 1110 xxxx xxxx            */
	{_illegal,0   }  /* ff: 0110 0100 1111 1111 xxxx xxxx            */
};

static const struct dasm_s  dasm64_7807[256] =
{
	{_MVI,"PA,%b"    }, /* 00: 0110 0100 0000 0000 xxxx xxxx            */
	{_MVI,"PB,%b"    }, /* 01: 0110 0100 0000 0001 xxxx xxxx            */
	{_MVI,"PC,%b"    }, /* 02: 0110 0100 0000 0010 xxxx xxxx            */
	{_MVI,"PD,%b"    }, /* 03: 0110 0100 0000 0011 xxxx xxxx            */
	{_illegal,0   }, /* 04: 0110 0100 0000 0100 xxxx xxxx            */
	{_MVI,"PF,%b"    }, /* 05: 0110 0100 0000 0101 xxxx xxxx            */
	{_MVI,"MKH,%b"   }, /* 06: 0110 0100 0000 0110 xxxx xxxx            */
	{_MVI,"MKL,%b"   }, /* 07: 0110 0100 0000 0111 xxxx xxxx            */
	{_ANI,"PA,%b"    }, /* 08: 0110 0100 0000 1000 xxxx xxxx            */
	{_ANI,"PB,%b"    }, /* 09: 0110 0100 0000 1001 xxxx xxxx            */
	{_ANI,"PC,%b"    }, /* 0a: 0110 0100 0000 1010 xxxx xxxx            */
	{_ANI,"PD,%b"    }, /* 0b: 0110 0100 0000 1011 xxxx xxxx            */
	{_illegal,0   }, /* 0c: 0110 0100 0000 1100 xxxx xxxx            */
	{_ANI,"PF,%b"    }, /* 0d: 0110 0100 0000 1101 xxxx xxxx            */
	{_ANI,"MKH,%b"   }, /* 0e: 0110 0100 0000 1110 xxxx xxxx            */
	{_ANI,"MKL,%b"   }, /* 0f: 0110 0100 0000 1111 xxxx xxxx            */

	{_XRI,"PA,%b"    }, /* 10: 0110 0100 0001 0000 xxxx xxxx            */
	{_XRI,"PB,%b"    }, /* 11: 0110 0100 0001 0001 xxxx xxxx            */
	{_XRI,"PC,%b"    }, /* 12: 0110 0100 0001 0010 xxxx xxxx            */
	{_XRI,"PD,%b"    }, /* 13: 0110 0100 0001 0011 xxxx xxxx            */
	{_illegal,0   }, /* 14: 0110 0100 0001 0100 xxxx xxxx            */
	{_XRI,"PF,%b"    }, /* 15: 0110 0100 0001 0101 xxxx xxxx            */
	{_XRI,"MKH,%b"   }, /* 16: 0110 0100 0001 0110 xxxx xxxx            */
	{_XRI,"MKL,%b"   }, /* 17: 0110 0100 0001 0111 xxxx xxxx            */
	{_ORI,"PA,%b"    }, /* 18: 0110 0100 0001 1000 xxxx xxxx            */
	{_ORI,"PB,%b"    }, /* 19: 0110 0100 0001 1001 xxxx xxxx            */
	{_ORI,"PC,%b"    }, /* 1a: 0110 0100 0001 1010 xxxx xxxx            */
	{_ORI,"PD,%b"    }, /* 1b: 0110 0100 0001 1011 xxxx xxxx            */
	{_illegal,0   }, /* 1c: 0110 0100 0001 1100 xxxx xxxx            */
	{_ORI,"PF,%b"    }, /* 1d: 0110 0100 0001 1101 xxxx xxxx            */
	{_ORI,"MKH,%b"   }, /* 1e: 0110 0100 0001 1110 xxxx xxxx            */
	{_ORI,"MKL,%b"   }, /* 1f: 0110 0100 0001 1111 xxxx xxxx            */

	{_ADINC,"PA,%b"  }, /* 20: 0110 0100 0010 0000 xxxx xxxx            */
	{_ADINC,"PB,%b"  }, /* 21: 0110 0100 0010 0001 xxxx xxxx            */
	{_ADINC,"PC,%b"  }, /* 22: 0110 0100 0010 0010 xxxx xxxx            */
	{_ADINC,"PD,%b"  }, /* 23: 0110 0100 0010 0011 xxxx xxxx            */
	{_illegal,0   }, /* 24: 0110 0100 0010 0100 xxxx xxxx            */
	{_ADINC,"PF,%b"  }, /* 25: 0110 0100 0010 0101 xxxx xxxx            */
	{_ADINC,"MKH,%b" }, /* 26: 0110 0100 0010 0110 xxxx xxxx            */
	{_ADINC,"MKL,%b" }, /* 27: 0110 0100 0010 0111 xxxx xxxx            */
	{_GTI,"PA,%b"    }, /* 28: 0110 0100 0010 1000 xxxx xxxx            */
	{_GTI,"PB,%b"    }, /* 29: 0110 0100 0010 1001 xxxx xxxx            */
	{_GTI,"PC,%b"    }, /* 2a: 0110 0100 0010 1010 xxxx xxxx            */
	{_GTI,"PD,%b"    }, /* 2b: 0110 0100 0010 1011 xxxx xxxx            */
	{_illegal,0   }, /* 2c: 0110 0100 0010 1100 xxxx xxxx            */
	{_GTI,"PF,%b"    }, /* 2d: 0110 0100 0010 1101 xxxx xxxx            */
	{_GTI,"MKH,%b"   }, /* 2e: 0110 0100 0010 1110 xxxx xxxx            */
	{_GTI,"MKL,%b"   }, /* 2f: 0110 0100 0010 1111 xxxx xxxx            */

	{_SUINB,"PA,%b"  }, /* 30: 0110 0100 0011 0000 xxxx xxxx            */
	{_SUINB,"PB,%b"  }, /* 31: 0110 0100 0011 0001 xxxx xxxx            */
	{_SUINB,"PC,%b"  }, /* 32: 0110 0100 0011 0010 xxxx xxxx            */
	{_SUINB,"PD,%b"  }, /* 33: 0110 0100 0011 0011 xxxx xxxx            */
	{_illegal,0   }, /* 34: 0110 0100 0011 0100 xxxx xxxx            */
	{_SUINB,"PF,%b"  }, /* 35: 0110 0100 0011 0101 xxxx xxxx            */
	{_SUINB,"MKH,%b" }, /* 36: 0110 0100 0011 0110 xxxx xxxx            */
	{_SUINB,"MKL,%b" }, /* 37: 0110 0100 0011 0111 xxxx xxxx            */
	{_LTI,"PA,%b"    }, /* 38: 0110 0100 0011 1000 xxxx xxxx            */
	{_LTI,"PB,%b"    }, /* 39: 0110 0100 0011 1001 xxxx xxxx            */
	{_LTI,"PC,%b"    }, /* 3a: 0110 0100 0011 1010 xxxx xxxx            */
	{_LTI,"PD,%b"    }, /* 3b: 0110 0100 0011 1011 xxxx xxxx            */
	{_illegal,0   }, /* 3c: 0110 0100 0011 1100 xxxx xxxx            */
	{_LTI,"PF,%b"    }, /* 3d: 0110 0100 0011 1101 xxxx xxxx            */
	{_LTI,"MKH,%b"   }, /* 3e: 0110 0100 0011 1110 xxxx xxxx            */
	{_LTI,"MKL,%b"   }, /* 3f: 0110 0100 0011 1111 xxxx xxxx            */

	{_ADI,"PA,%b"    }, /* 40: 0110 0100 0100 0000 xxxx xxxx            */
	{_ADI,"PB,%b"    }, /* 41: 0110 0100 0100 0001 xxxx xxxx            */
	{_ADI,"PC,%b"    }, /* 42: 0110 0100 0100 0010 xxxx xxxx            */
	{_ADI,"PD,%b"    }, /* 43: 0110 0100 0100 0011 xxxx xxxx            */
	{_illegal,0   }, /* 44: 0110 0100 0100 0100 xxxx xxxx            */
	{_ADI,"PF,%b"    }, /* 45: 0110 0100 0100 0101 xxxx xxxx            */
	{_ADI,"MKH,%b"   }, /* 46: 0110 0100 0100 0110 xxxx xxxx            */
	{_ADI,"MKL,%b"   }, /* 47: 0110 0100 0100 0111 xxxx xxxx            */
	{_ONI,"PA,%b"    }, /* 48: 0110 0100 0100 1000 xxxx xxxx            */
	{_ONI,"PB,%b"    }, /* 49: 0110 0100 0100 1001 xxxx xxxx            */
	{_ONI,"PC,%b"    }, /* 4a: 0110 0100 0100 1010 xxxx xxxx            */
	{_ONI,"PD,%b"    }, /* 4b: 0110 0100 0100 1011 xxxx xxxx            */
	{_illegal,0   }, /* 4c: 0110 0100 0100 1100 xxxx xxxx            */
	{_ONI,"PF,%b"    }, /* 4d: 0110 0100 0100 1101 xxxx xxxx            */
	{_ONI,"MKH,%b"   }, /* 4e: 0110 0100 0100 1110 xxxx xxxx            */
	{_ONI,"MKL,%b"   }, /* 4f: 0110 0100 0100 1111 xxxx xxxx            */

	{_ACI,"PA,%b"    }, /* 50: 0110 0100 0101 0000 xxxx xxxx            */
	{_ACI,"PB,%b"    }, /* 51: 0110 0100 0101 0001 xxxx xxxx            */
	{_ACI,"PC,%b"    }, /* 52: 0110 0100 0101 0010 xxxx xxxx            */
	{_ACI,"PD,%b"    }, /* 53: 0110 0100 0101 0011 xxxx xxxx            */
	{_illegal,0   }, /* 54: 0110 0100 0101 0100 xxxx xxxx            */
	{_ACI,"PF,%b"    }, /* 55: 0110 0100 0101 0101 xxxx xxxx            */
	{_ACI,"MKH,%b"   }, /* 56: 0110 0100 0101 0110 xxxx xxxx            */
	{_ACI,"MKL,%b"   }, /* 57: 0110 0100 0101 0111 xxxx xxxx            */
	{_OFFI,"PA,%b"   }, /* 58: 0110 0100 0101 1000 xxxx xxxx            */
	{_OFFI,"PB,%b"   }, /* 59: 0110 0100 0101 1001 xxxx xxxx            */
	{_OFFI,"PC,%b"   }, /* 5a: 0110 0100 0101 1010 xxxx xxxx            */
	{_OFFI,"PD,%b"   }, /* 5b: 0110 0100 0101 1011 xxxx xxxx            */
	{_illegal,0   }, /* 5c: 0110 0100 0101 1100 xxxx xxxx            */
	{_OFFI,"PF,%b"   }, /* 5d: 0110 0100 0101 1101 xxxx xxxx            */
	{_OFFI,"MKH,%b"  }, /* 5e: 0110 0100 0101 1110 xxxx xxxx            */
	{_OFFI,"MKL,%b"  }, /* 5f: 0110 0100 0101 1111 xxxx xxxx            */

	{_SUI,"PA,%b"    }, /* 60: 0110 0100 0110 0000 xxxx xxxx            */
	{_SUI,"PB,%b"    }, /* 61: 0110 0100 0110 0001 xxxx xxxx            */
	{_SUI,"PC,%b"    }, /* 62: 0110 0100 0110 0010 xxxx xxxx            */
	{_SUI,"PD,%b"    }, /* 63: 0110 0100 0110 0011 xxxx xxxx            */
	{_illegal,0   }, /* 64: 0110 0100 0110 0100 xxxx xxxx            */
	{_SUI,"PF,%b"    }, /* 65: 0110 0100 0110 0101 xxxx xxxx            */
	{_SUI,"MKH,%b"   }, /* 66: 0110 0100 0110 0110 xxxx xxxx            */
	{_SUI,"MKL,%b"   }, /* 67: 0110 0100 0110 0111 xxxx xxxx            */
	{_NEI,"PA,%b"    }, /* 68: 0110 0100 0110 1000 xxxx xxxx            */
	{_NEI,"PB,%b"    }, /* 69: 0110 0100 0110 1001 xxxx xxxx            */
	{_NEI,"PC,%b"    }, /* 6a: 0110 0100 0110 1010 xxxx xxxx            */
	{_NEI,"PD,%b"    }, /* 6b: 0110 0100 0110 1011 xxxx xxxx            */
	{_illegal,0   }, /* 6c: 0110 0100 0110 1100 xxxx xxxx            */
	{_NEI,"PF,%b"    }, /* 6d: 0110 0100 0110 1101 xxxx xxxx            */
	{_NEI,"MKH,%b"   }, /* 6e: 0110 0100 0110 1110 xxxx xxxx            */
	{_NEI,"MKL,%b"   }, /* 6f: 0110 0100 0110 1111 xxxx xxxx            */

	{_SBI,"PA,%b"    }, /* 70: 0110 0100 0111 0000 xxxx xxxx            */
	{_SBI,"PB,%b"    }, /* 71: 0110 0100 0111 0001 xxxx xxxx            */
	{_SBI,"PC,%b"    }, /* 72: 0110 0100 0111 0010 xxxx xxxx            */
	{_SBI,"PD,%b"    }, /* 73: 0110 0100 0111 0011 xxxx xxxx            */
	{_illegal,0   }, /* 74: 0110 0100 0111 0100 xxxx xxxx            */
	{_SBI,"PF,%b"    }, /* 75: 0110 0100 0111 0101 xxxx xxxx            */
	{_SBI,"MKH,%b"   }, /* 76: 0110 0100 0111 0110 xxxx xxxx            */
	{_SBI,"MKL,%b"   }, /* 77: 0110 0100 0111 0111 xxxx xxxx            */
	{_EQI,"PA,%b"    }, /* 78: 0110 0100 0111 1000 xxxx xxxx            */
	{_EQI,"PB,%b"    }, /* 79: 0110 0100 0111 1001 xxxx xxxx            */
	{_EQI,"PC,%b"    }, /* 7a: 0110 0100 0111 1010 xxxx xxxx            */
	{_EQI,"PD,%b"    }, /* 7b: 0110 0100 0111 1011 xxxx xxxx            */
	{_illegal,0   }, /* 7c: 0110 0100 0111 1100 xxxx xxxx            */
	{_EQI,"PF,%b"    }, /* 7d: 0110 0100 0111 1101 xxxx xxxx            */
	{_EQI,"MKH,%b"   }, /* 7e: 0110 0100 0111 1110 xxxx xxxx            */
	{_EQI,"MKL,%b"   }, /* 7f: 0110 0100 0111 1111 xxxx xxxx            */

	{_illegal,0   }, /* 80: 0110 0100 1000 0000 xxxx xxxx            */
	{_MVI,"SMH,%b"   }, /* 81: 0110 0100 1000 0001 xxxx xxxx            */
	{_illegal,0   }, /* 82: 0110 0100 1000 0010 xxxx xxxx            */
	{_MVI,"EOM,%b"   }, /* 83: 0110 0100 1000 0011 xxxx xxxx            */
	{_illegal,0   }, /* 84: 0110 0100 1000 0100 xxxx xxxx            */
	{_MVI,"TMM,%b"   }, /* 85: 0110 0100 1000 0101 xxxx xxxx            */
	{_illegal,0   }, /* 86: 0110 0100 1000 0110 xxxx xxxx            */
	{_illegal,0   }, /* 87: 0110 0100 1000 0111 xxxx xxxx            */
	{_illegal,0   }, /* 88: 0110 0100 1000 1000 xxxx xxxx            */
	{_ANI,"SMH,%b"   }, /* 89: 0110 0100 1000 1001 xxxx xxxx            */
	{_illegal,0   }, /* 8a: 0110 0100 1000 1010 xxxx xxxx            */
	{_ANI,"EOM,%b"   }, /* 8b: 0110 0100 1000 1011 xxxx xxxx            */
	{_illegal,0   }, /* 8c: 0110 0100 1000 1100 xxxx xxxx            */
	{_ANI,"TMM,%b"   }, /* 8d: 0110 0100 1000 1101 xxxx xxxx            */
	{_illegal,0   }, /* 8e: 0110 0100 1000 1110 xxxx xxxx            */
	{_illegal,0   }, /* 8f: 0110 0100 1000 1111 xxxx xxxx            */

	{_illegal,0   }, /* 90: 0110 0100 1001 0000 xxxx xxxx            */
	{_XRI,"SMH,%b"   }, /* 91: 0110 0100 1001 0001 xxxx xxxx            */
	{_illegal,0   }, /* 92: 0110 0100 1001 0010 xxxx xxxx            */
	{_XRI,"EOM,%b"   }, /* 93: 0110 0100 1001 0011 xxxx xxxx            */
	{_illegal,0   }, /* 94: 0110 0100 1001 0100 xxxx xxxx            */
	{_XRI,"TMM,%b"   }, /* 95: 0110 0100 1001 0101 xxxx xxxx            */
	{_illegal,0   }, /* 96: 0110 0100 1001 0110 xxxx xxxx            */
	{_illegal,0   }, /* 97: 0110 0100 1001 0111 xxxx xxxx            */
	{_illegal,0   }, /* 98: 0110 0100 1001 1000 xxxx xxxx            */
	{_ORI,"SMH,%b"   }, /* 99: 0110 0100 1001 1001 xxxx xxxx            */
	{_illegal,0   }, /* 9a: 0110 0100 1001 1010 xxxx xxxx            */
	{_ORI,"EOM,%b"   }, /* 9b: 0110 0100 1001 1011 xxxx xxxx            */
	{_illegal,0   }, /* 9c: 0110 0100 1001 1100 xxxx xxxx            */
	{_ORI,"TMM,%b"   }, /* 9d: 0110 0100 1001 1101 xxxx xxxx            */
	{_illegal,0   }, /* 9e: 0110 0100 1001 1110 xxxx xxxx            */
	{_illegal,0   }, /* 9f: 0110 0100 1001 1111 xxxx xxxx            */

	{_illegal,0   }, /* a0: 0110 0100 1010 0000 xxxx xxxx            */
	{_ADINC,"SMH,%b" }, /* a1: 0110 0100 1010 0001 xxxx xxxx            */
	{_illegal,0   }, /* a2: 0110 0100 1010 0010 xxxx xxxx            */
	{_ADINC,"EOM,%b" }, /* a3: 0110 0100 1010 0011 xxxx xxxx            */
	{_illegal,0   }, /* a4: 0110 0100 1010 0100 xxxx xxxx            */
	{_ADINC,"TMM,%b" }, /* a5: 0110 0100 1010 0101 xxxx xxxx            */
	{_illegal,0   }, /* a6: 0110 0100 1010 0110 xxxx xxxx            */
	{_illegal,0   }, /* a7: 0110 0100 1010 0111 xxxx xxxx            */
	{_illegal,0   }, /* a8: 0110 0100 1010 1000 xxxx xxxx            */
	{_GTI,"SMH,%b"   }, /* a9: 0110 0100 1010 1001 xxxx xxxx            */
	{_illegal,0   }, /* aa: 0110 0100 1010 1010 xxxx xxxx            */
	{_GTI,"EOM,%b"   }, /* ab: 0110 0100 1010 1011 xxxx xxxx            */
	{_illegal,0   }, /* ac: 0110 0100 1010 1100 xxxx xxxx            */
	{_GTI,"TMM,%b"   }, /* ad: 0110 0100 1010 1101 xxxx xxxx            */
	{_GTI,"PT,%b"    }, /* ae: 0110 0100 1010 1110 xxxx xxxx            */
	{_illegal,0   }, /* af: 0110 0100 1010 1111 xxxx xxxx            */

	{_illegal,0   }, /* b0: 0110 0100 1011 0000 xxxx xxxx            */
	{_SUINB,"SMH,%b" }, /* b1: 0110 0100 1011 0001 xxxx xxxx            */
	{_illegal,0   }, /* b2: 0110 0100 1011 0010 xxxx xxxx            */
	{_SUINB,"EOM,%b" }, /* b3: 0110 0100 1011 0011 xxxx xxxx            */
	{_illegal,0   }, /* b4: 0110 0100 1011 0100 xxxx xxxx            */
	{_SUINB,"TMM,%b" }, /* b5: 0110 0100 1011 0101 xxxx xxxx            */
	{_illegal,0   }, /* b6: 0110 0100 1011 0110 xxxx xxxx            */
	{_illegal,0   }, /* b7: 0110 0100 1011 0111 xxxx xxxx            */
	{_illegal,0   }, /* b8: 0110 0100 1011 1000 xxxx xxxx            */
	{_LTI,"SMH,%b"   }, /* b9: 0110 0100 1011 1001 xxxx xxxx            */
	{_illegal,0   }, /* ba: 0110 0100 1011 1010 xxxx xxxx            */
	{_LTI,"EOM,%b"   }, /* bb: 0110 0100 1011 1011 xxxx xxxx            */
	{_illegal,0   }, /* bc: 0110 0100 1011 1100 xxxx xxxx            */
	{_LTI,"TMM,%b"   }, /* bd: 0110 0100 1011 1101 xxxx xxxx            */
	{_LTI,"PT,%b"    }, /* be: 0110 0100 1011 1110 xxxx xxxx            */
	{_illegal,0   }, /* bf: 0110 0100 1011 1111 xxxx xxxx            */

	{_illegal,0   }, /* c0: 0110 0100 1100 0000 xxxx xxxx            */
	{_ADI,"SMH,%b"   }, /* c1: 0110 0100 1100 0001 xxxx xxxx            */
	{_illegal,0   }, /* c2: 0110 0100 1100 0010 xxxx xxxx            */
	{_ADI,"EOM,%b"   }, /* c3: 0110 0100 1100 0011 xxxx xxxx            */
	{_illegal,0   }, /* c4: 0110 0100 1100 0100 xxxx xxxx            */
	{_ADI,"TMM,%b"   }, /* c5: 0110 0100 1100 0101 xxxx xxxx            */
	{_illegal,0   }, /* c6: 0110 0100 1100 0110 xxxx xxxx            */
	{_illegal,0   }, /* c7: 0110 0100 1100 0111 xxxx xxxx            */
	{_illegal,0   }, /* c8: 0110 0100 1100 1000 xxxx xxxx            */
	{_ONI,"SMH,%b"   }, /* c9: 0110 0100 1100 1001 xxxx xxxx            */
	{_illegal,0   }, /* ca: 0110 0100 1100 1010 xxxx xxxx            */
	{_ONI,"EOM,%b"   }, /* cb: 0110 0100 1100 1011 xxxx xxxx            */
	{_illegal,0   }, /* cc: 0110 0100 1100 1100 xxxx xxxx            */
	{_ONI,"TMM,%b"   }, /* cd: 0110 0100 1100 1101 xxxx xxxx            */
	{_ONI,"PT,%b"    }, /* ce: 0110 0100 1100 1110 xxxx xxxx            */
	{_illegal,0   }, /* cf: 0110 0100 1100 1111 xxxx xxxx            */

	{_illegal,0   }, /* d0: 0110 0100 1101 0000 xxxx xxxx            */
	{_ACI,"SMH,%b"   }, /* d1: 0110 0100 1101 0001 xxxx xxxx            */
	{_illegal,0   }, /* d2: 0110 0100 1101 0010 xxxx xxxx            */
	{_ACI,"EOM,%b"   }, /* d3: 0110 0100 1101 0011 xxxx xxxx            */
	{_illegal,0   }, /* d4: 0110 0100 1101 0100 xxxx xxxx            */
	{_ACI,"TMM,%b"   }, /* d5: 0110 0100 1101 0101 xxxx xxxx            */
	{_illegal,0   }, /* d6: 0110 0100 1101 0110 xxxx xxxx            */
	{_illegal,0   }, /* d7: 0110 0100 1101 0111 xxxx xxxx            */
	{_illegal,0   }, /* d8: 0110 0100 1101 1000 xxxx xxxx            */
	{_OFFI,"SMH,%b"  }, /* d9: 0110 0100 1101 1001 xxxx xxxx            */
	{_illegal,0   }, /* da: 0110 0100 1101 1010 xxxx xxxx            */
	{_OFFI,"EOM,%b"  }, /* db: 0110 0100 1101 1011 xxxx xxxx            */
	{_illegal,0   }, /* dc: 0110 0100 1101 1100 xxxx xxxx            */
	{_OFFI,"TMM,%b"  }, /* dd: 0110 0100 1101 1101 xxxx xxxx            */
	{_OFFI,"PT,%b"   }, /* de: 0110 0100 1101 1110 xxxx xxxx            */
	{_illegal,0   }, /* df: 0110 0100 1101 1111 xxxx xxxx            */

	{_illegal,0   }, /* e0: 0110 0100 1110 0000 xxxx xxxx            */
	{_SUI,"SMH,%b"   }, /* e1: 0110 0100 1110 0001 xxxx xxxx            */
	{_illegal,0   }, /* e2: 0110 0100 1110 0010 xxxx xxxx            */
	{_SUI,"EOM,%b"   }, /* e3: 0110 0100 1110 0011 xxxx xxxx            */
	{_illegal,0   }, /* e4: 0110 0100 1110 0100 xxxx xxxx            */
	{_SUI,"TMM,%b"   }, /* e5: 0110 0100 1110 0101 xxxx xxxx            */
	{_illegal,0   }, /* e6: 0110 0100 1110 0110 xxxx xxxx            */
	{_illegal,0   }, /* e7: 0110 0100 1110 0111 xxxx xxxx            */
	{_illegal,0   }, /* e8: 0110 0100 1110 1000 xxxx xxxx            */
	{_NEI,"SMH,%b"   }, /* e9: 0110 0100 1110 1001 xxxx xxxx            */
	{_illegal,0   }, /* ea: 0110 0100 1110 1010 xxxx xxxx            */
	{_NEI,"EOM,%b"   }, /* eb: 0110 0100 1110 1011 xxxx xxxx            */
	{_illegal,0   }, /* ec: 0110 0100 1110 1100 xxxx xxxx            */
	{_NEI,"TMM,%b"   }, /* ed: 0110 0100 1110 1101 xxxx xxxx            */
	{_NEI,"PT,%b"    }, /* ee: 0110 0100 1110 1110 xxxx xxxx            */
	{_illegal,0   }, /* ef: 0110 0100 1110 1111 xxxx xxxx            */

	{_illegal,0   }, /* f0: 0110 0100 1111 0000 xxxx xxxx            */
	{_SBI,"SMH,%b"   }, /* f1: 0110 0100 1111 0001 xxxx xxxx            */
	{_illegal,0   }, /* f2: 0110 0100 1111 0010 xxxx xxxx            */
	{_SBI,"EOM,%b"   }, /* f3: 0110 0100 1111 0011 xxxx xxxx            */
	{_illegal,0   }, /* f4: 0110 0100 1111 0100 xxxx xxxx            */
	{_SBI,"TMM,%b"   }, /* f5: 0110 0100 1111 0101 xxxx xxxx            */
	{_illegal,0   }, /* f6: 0110 0100 1111 0110 xxxx xxxx            */
	{_illegal,0   }, /* f7: 0110 0100 1111 0111 xxxx xxxx            */
	{_illegal,0   }, /* f8: 0110 0100 1111 1000 xxxx xxxx            */
	{_EQI,"SMH,%b"   }, /* f9: 0110 0100 1111 1001 xxxx xxxx            */
	{_illegal,0   }, /* fa: 0110 0100 1111 1010 xxxx xxxx            */
	{_EQI,"EOM,%b"   }, /* fb: 0110 0100 1111 1011 xxxx xxxx            */
	{_illegal,0   }, /* fc: 0110 0100 1111 1100 xxxx xxxx            */
	{_EQI,"TMM,%b"   }, /* fd: 0110 0100 1111 1101 xxxx xxxx            */
	{_EQI,"PT,%b"    }, /* fe: 0110 0100 1111 1110 xxxx xxxx            */
	{_illegal,0   }  /* ff: 0110 0100 1111 1111 xxxx xxxx            */
};

/* prefix 70 */
static const struct dasm_s  dasm70[256] =
{
	{_illegal,0   }, /* 00: 0111 0000 0000 0000                      */
	{_illegal,0   }, /* 01: 0111 0000 0000 0001                      */
	{_illegal,0   }, /* 02: 0111 0000 0000 0010                      */
	{_illegal,0   }, /* 03: 0111 0000 0000 0011                      */
	{_illegal,0   }, /* 04: 0111 0000 0000 0100                      */
	{_illegal,0   }, /* 05: 0111 0000 0000 0101                      */
	{_illegal,0   }, /* 06: 0111 0000 0000 0110                      */
	{_illegal,0   }, /* 07: 0111 0000 0000 0111                      */
	{_illegal,0   }, /* 08: 0111 0000 0000 1000                      */
	{_illegal,0   }, /* 09: 0111 0000 0000 1001                      */
	{_illegal,0   }, /* 0a: 0111 0000 0000 1010                      */
	{_illegal,0   }, /* 0b: 0111 0000 0000 1011                      */
	{_illegal,0   }, /* 0c: 0111 0000 0000 1100                      */
	{_illegal,0   }, /* 0d: 0111 0000 0000 1101                      */
	{_SSPD,"%w"      }, /* 0e: 0111 0000 0000 1110 llll llll hhhh hhhh  */
	{_LSPD,"%w"      }, /* 0f: 0111 0000 0000 1111 llll llll hhhh hhhh  */

	{_illegal,0   }, /* 10: 0111 0000 0001 0000                      */
	{_illegal,0   }, /* 11: 0111 0000 0001 0001                      */
	{_illegal,0   }, /* 12: 0111 0000 0001 0010                      */
	{_illegal,0   }, /* 13: 0111 0000 0001 0011                      */
	{_illegal,0   }, /* 14: 0111 0000 0001 0100                      */
	{_illegal,0   }, /* 15: 0111 0000 0001 0101                      */
	{_illegal,0   }, /* 16: 0111 0000 0001 0110                      */
	{_illegal,0   }, /* 17: 0111 0000 0001 0111                      */
	{_illegal,0   }, /* 18: 0111 0000 0001 1000                      */
	{_illegal,0   }, /* 19: 0111 0000 0001 1001                      */
	{_illegal,0   }, /* 1a: 0111 0000 0001 1010                      */
	{_illegal,0   }, /* 1b: 0111 0000 0001 1011                      */
	{_illegal,0   }, /* 1c: 0111 0000 0001 1100                      */
	{_illegal,0   }, /* 1d: 0111 0000 0001 1101                      */
	{_SBCD,"%w"      }, /* 1e: 0111 0000 0001 1110 llll llll hhhh hhhh  */
	{_LBCD,"%w"      }, /* 1f: 0111 0000 0001 1111 llll llll hhhh hhhh  */

	{_illegal,0   }, /* 20: 0111 0000 0010 0000                      */
	{_illegal,0   }, /* 21: 0111 0000 0010 0001                      */
	{_illegal,0   }, /* 22: 0111 0000 0010 0010                      */
	{_illegal,0   }, /* 23: 0111 0000 0010 0011                      */
	{_illegal,0   }, /* 24: 0111 0000 0010 0100                      */
	{_illegal,0   }, /* 25: 0111 0000 0010 0101                      */
	{_illegal,0   }, /* 26: 0111 0000 0010 0110                      */
	{_illegal,0   }, /* 27: 0111 0000 0010 0111                      */
	{_illegal,0   }, /* 28: 0111 0000 0010 1000                      */
	{_illegal,0   }, /* 29: 0111 0000 0010 1001                      */
	{_illegal,0   }, /* 2a: 0111 0000 0010 1010                      */
	{_illegal,0   }, /* 2b: 0111 0000 0010 1011                      */
	{_illegal,0   }, /* 2c: 0111 0000 0010 1100                      */
	{_illegal,0   }, /* 2d: 0111 0000 0010 1101                      */
	{_SDED,"%w"      }, /* 2e: 0111 0000 0010 1110 llll llll hhhh hhhh  */
	{_LDED,"%w"      }, /* 2f: 0111 0000 0010 1111 llll llll hhhh hhhh  */

	{_illegal,0   }, /* 30: 0111 0000 0011 0000                      */
	{_illegal,0   }, /* 31: 0111 0000 0011 0001                      */
	{_illegal,0   }, /* 32: 0111 0000 0011 0010                      */
	{_illegal,0   }, /* 33: 0111 0000 0011 0011                      */
	{_illegal,0   }, /* 34: 0111 0000 0011 0100                      */
	{_illegal,0   }, /* 35: 0111 0000 0011 0101                      */
	{_illegal,0   }, /* 36: 0111 0000 0011 0110                      */
	{_illegal,0   }, /* 37: 0111 0000 0011 0111                      */
	{_illegal,0   }, /* 38: 0111 0000 0011 1000                      */
	{_illegal,0   }, /* 39: 0111 0000 0011 1001                      */
	{_illegal,0   }, /* 3a: 0111 0000 0011 1010                      */
	{_illegal,0   }, /* 3b: 0111 0000 0011 1011                      */
	{_illegal,0   }, /* 3c: 0111 0000 0011 1100                      */
	{_illegal,0   }, /* 3d: 0111 0000 0011 1101                      */
	{_SHLD,"%w"      }, /* 3e: 0111 0000 0011 1110 llll llll hhhh hhhh  */
	{_LHLD,"%w"      }, /* 3f: 0111 0000 0011 1111 llll llll hhhh hhhh  */

	{_EADD,"EA,V"    }, /* 40: 0111 0000 0100 0000                      */
	{_EADD,"EA,A"    }, /* 41: 0111 0000 0100 0001                      */
	{_EADD,"EA,B"    }, /* 42: 0111 0000 0100 0010                      */
	{_EADD,"EA,C"    }, /* 43: 0111 0000 0100 0011                      */
	{_illegal,0   }, /* 44: 0111 0000 0100 0100                      */
	{_illegal,0   }, /* 45: 0111 0000 0100 0101                      */
	{_illegal,0   }, /* 46: 0111 0000 0100 0110                      */
	{_illegal,0   }, /* 47: 0111 0000 0100 0111                      */
	{_illegal,0   }, /* 48: 0111 0000 0100 1000                      */
	{_illegal,0   }, /* 49: 0111 0000 0100 1001                      */
	{_illegal,0   }, /* 4a: 0111 0000 0100 1010                      */
	{_illegal,0   }, /* 4b: 0111 0000 0100 1011                      */
	{_illegal,0   }, /* 4c: 0111 0000 0100 1100                      */
	{_illegal,0   }, /* 4d: 0111 0000 0100 1101                      */
	{_illegal,0   }, /* 4e: 0111 0000 0100 1110                      */
	{_illegal,0   }, /* 4f: 0111 0000 0100 1111                      */

	{_illegal,0   }, /* 50: 0111 0000 0101 0000                      */
	{_illegal,0   }, /* 51: 0111 0000 0101 0001                      */
	{_illegal,0   }, /* 52: 0111 0000 0101 0010                      */
	{_illegal,0   }, /* 53: 0111 0000 0101 0011                      */
	{_illegal,0   }, /* 54: 0111 0000 0101 0100                      */
	{_illegal,0   }, /* 55: 0111 0000 0101 0101                      */
	{_illegal,0   }, /* 56: 0111 0000 0101 0110                      */
	{_illegal,0   }, /* 57: 0111 0000 0101 0111                      */
	{_illegal,0   }, /* 58: 0111 0000 0101 1000                      */
	{_illegal,0   }, /* 59: 0111 0000 0101 1001                      */
	{_illegal,0   }, /* 5a: 0111 0000 0101 1010                      */
	{_illegal,0   }, /* 5b: 0111 0000 0101 1011                      */
	{_illegal,0   }, /* 5c: 0111 0000 0101 1100                      */
	{_illegal,0   }, /* 5d: 0111 0000 0101 1101                      */
	{_illegal,0   }, /* 5e: 0111 0000 0101 1110                      */
	{_illegal,0   }, /* 5f: 0111 0000 0101 1111                      */

	{_ESUB,"EA,V"    }, /* 60: 0111 0000 0110 0000                      */
	{_ESUB,"EA,A"    }, /* 61: 0111 0000 0110 0001                      */
	{_ESUB,"EA,B"    }, /* 62: 0111 0000 0110 0010                      */
	{_ESUB,"EA,C"    }, /* 63: 0111 0000 0110 0011                      */
	{_illegal,0   }, /* 64: 0111 0000 0110 0100                      */
	{_illegal,0   }, /* 65: 0111 0000 0110 0101                      */
	{_illegal,0   }, /* 66: 0111 0000 0110 0110                      */
	{_illegal,0   }, /* 67: 0111 0000 0110 0111                      */
	{_MOV,"V,(%w)"   }, /* 68: 0111 0000 0110 1000 llll llll hhhh hhhh  */
	{_MOV,"A,(%w)"   }, /* 69: 0111 0000 0110 1001 llll llll hhhh hhhh  */
	{_MOV,"B,(%w)"   }, /* 6a: 0111 0000 0110 1010 llll llll hhhh hhhh  */
	{_MOV,"C,(%w)"   }, /* 6b: 0111 0000 0110 1011 llll llll hhhh hhhh  */
	{_MOV,"D,(%w)"   }, /* 6c: 0111 0000 0110 1100 llll llll hhhh hhhh  */
	{_MOV,"E,(%w)"   }, /* 6d: 0111 0000 0110 1101 llll llll hhhh hhhh  */
	{_MOV,"H,(%w)"   }, /* 6e: 0111 0000 0110 1110 llll llll hhhh hhhh  */
	{_MOV,"L,(%w)"   }, /* 6f: 0111 0000 0110 1111 llll llll hhhh hhhh  */

	{_illegal,0   }, /* 70: 0111 0000 0111 0000                      */
	{_illegal,0   }, /* 71: 0111 0000 0111 0001                      */
	{_illegal,0   }, /* 72: 0111 0000 0111 0010                      */
	{_illegal,0   }, /* 73: 0111 0000 0111 0011                      */
	{_illegal,0   }, /* 74: 0111 0000 0111 0100                      */
	{_illegal,0   }, /* 75: 0111 0000 0111 0101                      */
	{_illegal,0   }, /* 76: 0111 0000 0111 0110                      */
	{_illegal,0   }, /* 77: 0111 0000 0111 0111                      */
	{_MOV,"(%w),V"   }, /* 78: 0111 0000 0111 1000 llll llll hhhh hhhh  */
	{_MOV,"(%w),A"   }, /* 79: 0111 0000 0111 1001 llll llll hhhh hhhh  */
	{_MOV,"(%w),B"   }, /* 7a: 0111 0000 0111 1010 llll llll hhhh hhhh  */
	{_MOV,"(%w),C"   }, /* 7b: 0111 0000 0111 1011 llll llll hhhh hhhh  */
	{_MOV,"(%w),D"   }, /* 7c: 0111 0000 0111 1100 llll llll hhhh hhhh  */
	{_MOV,"(%w),E"   }, /* 7d: 0111 0000 0111 1101 llll llll hhhh hhhh  */
	{_MOV,"(%w),H"   }, /* 7e: 0111 0000 0111 1110 llll llll hhhh hhhh  */
	{_MOV,"(%w),L"   }, /* 7f: 0111 0000 0111 1111 llll llll hhhh hhhh  */

	{_illegal,0   }, /* 80: 0111 0000 1000 0000                      */
	{_illegal,0   }, /* 81: 0111 0000 1000 0001                      */
	{_illegal,0   }, /* 82: 0111 0000 1000 0010                      */
	{_illegal,0   }, /* 83: 0111 0000 1000 0011                      */
	{_illegal,0   }, /* 84: 0111 0000 1000 0100                      */
	{_illegal,0   }, /* 85: 0111 0000 1000 0101                      */
	{_illegal,0   }, /* 86: 0111 0000 1000 0110                      */
	{_illegal,0   }, /* 87: 0111 0000 1000 0111                      */
	{_illegal,0   }, /* 88: 0111 0000 1000 1000                      */
	{_ANAX,"(BC)"    }, /* 89: 0111 0000 1000 1001                      */
	{_ANAX,"(DE)"    }, /* 8a: 0111 0000 1000 1010                      */
	{_ANAX,"(HL)"    }, /* 8b: 0111 0000 1000 1011                      */
	{_ANAX,"(DE+)"   }, /* 8c: 0111 0000 1000 1100                      */
	{_ANAX,"(HL+)"   }, /* 8d: 0111 0000 1000 1101                      */
	{_ANAX,"(DE-)"   }, /* 8e: 0111 0000 1000 1110                      */
	{_ANAX,"(HL-)"   }, /* 8f: 0111 0000 1000 1111                      */

	{_illegal,0   }, /* 90: 0111 0000 1001 0000                      */
	{_XRAX,"(BC)"    }, /* 91: 0111 0000 1001 0001                      */
	{_XRAX,"(DE)"    }, /* 92: 0111 0000 1001 0010                      */
	{_XRAX,"(HL)"    }, /* 93: 0111 0000 1001 0011                      */
	{_XRAX,"(DE+)"   }, /* 94: 0111 0000 1001 0100                      */
	{_XRAX,"(HL+)"   }, /* 95: 0111 0000 1001 0101                      */
	{_XRAX,"(DE-)"   }, /* 96: 0111 0000 1001 0110                      */
	{_XRAX,"(HL-)"   }, /* 97: 0111 0000 1001 0111                      */
	{_illegal,0   }, /* 98: 0111 0000 1001 1000                      */
	{_ORAX,"(BC)"     }, /* 99: 0111 0000 1001 1001                      */
	{_ORAX,"(DE)"     }, /* 9a: 0111 0000 1001 1010                      */
	{_ORAX,"(HL)"     }, /* 9b: 0111 0000 1001 1011                      */
	{_ORAX,"(DE+)"    }, /* 9c: 0111 0000 1001 1100                      */
	{_ORAX,"(HL+)"    }, /* 9d: 0111 0000 1001 1101                      */
	{_ORAX,"(DE-)"    }, /* 9e: 0111 0000 1001 1110                      */
	{_ORAX,"(HL-)"    }, /* 9f: 0111 0000 1001 1111                      */

	{_illegal,0   }, /* a0: 0111 0000 1010 0000                      */
	{_ADDNCX,"(BC)"  }, /* a1: 0111 0000 1010 0001                      */
	{_ADDNCX,"(DE)"  }, /* a2: 0111 0000 1010 0010                      */
	{_ADDNCX,"(HL)"  }, /* a3: 0111 0000 1010 0011                      */
	{_ADDNCX,"(DE+)" }, /* a4: 0111 0000 1010 0100                      */
	{_ADDNCX,"(HL+)" }, /* a5: 0111 0000 1010 0101                      */
	{_ADDNCX,"(DE-)" }, /* a6: 0111 0000 1010 0110                      */
	{_ADDNCX,"(HL-)" }, /* a7: 0111 0000 1010 0111                      */
	{_illegal,0   }, /* a8: 0111 0000 1010 1000                      */
	{_GTAX,"(BC)"    }, /* a9: 0111 0000 1010 1001                      */
	{_GTAX,"(DE)"    }, /* aa: 0111 0000 1010 1010                      */
	{_GTAX,"(HL)"    }, /* ab: 0111 0000 1010 1011                      */
	{_GTAX,"(DE+)"   }, /* ac: 0111 0000 1010 1100                      */
	{_GTAX,"(HL+)"   }, /* ad: 0111 0000 1010 1101                      */
	{_GTAX,"(DE-)"   }, /* ae: 0111 0000 1010 1110                      */
	{_GTAX,"(HL-)"   }, /* af: 0111 0000 1010 1111                      */

	{_illegal,0   }, /* b0: 0111 0000 1011 0000                      */
	{_SUBNBX,"(BC)"  }, /* b1: 0111 0000 1011 0001                      */
	{_SUBNBX,"(DE)"  }, /* b2: 0111 0000 1011 0010                      */
	{_SUBNBX,"(HL)"  }, /* b3: 0111 0000 1011 0011                      */
	{_SUBNBX,"(DE+)" }, /* b4: 0111 0000 1011 0100                      */
	{_SUBNBX,"(HL+)" }, /* b5: 0111 0000 1011 0101                      */
	{_SUBNBX,"(DE-)" }, /* b6: 0111 0000 1011 0110                      */
	{_SUBNBX,"(HL-)" }, /* b7: 0111 0000 1011 0111                      */
	{_illegal,0   }, /* b8: 0111 0000 1011 1000                      */
	{_LTAX,"(BC)"    }, /* b9: 0111 0000 1011 1001                      */
	{_LTAX,"(DE)"    }, /* ba: 0111 0000 1011 1010                      */
	{_LTAX,"(HL)"    }, /* bb: 0111 0000 1011 1011                      */
	{_LTAX,"(DE+)"   }, /* bc: 0111 0000 1011 1100                      */
	{_LTAX,"(HL+)"   }, /* bd: 0111 0000 1011 1101                      */
	{_LTAX,"(DE-)"   }, /* be: 0111 0000 1011 1110                      */
	{_LTAX,"(HL-)"   }, /* bf: 0111 0000 1011 1111                      */

	{_illegal,0   }, /* c0: 0111 0000 1100 0000                      */
	{_ADDX,"(BC)"    }, /* c1: 0111 0000 1100 0001                      */
	{_ADDX,"(DE)"    }, /* c2: 0111 0000 1100 0010                      */
	{_ADDX,"(HL)"    }, /* c3: 0111 0000 1100 0011                      */
	{_ADDX,"(DE+)"   }, /* c4: 0111 0000 1100 0100                      */
	{_ADDX,"(HL+)"   }, /* c5: 0111 0000 1100 0101                      */
	{_ADDX,"(DE-)"   }, /* c6: 0111 0000 1100 0110                      */
	{_ADDX,"(HL-)"   }, /* c7: 0111 0000 1100 0111                      */
	{_illegal,0   }, /* c8: 0111 0000 1100 1000                      */
	{_ONAX,"(BC)"    }, /* c9: 0111 0000 1100 1001                      */
	{_ONAX,"(DE)"    }, /* ca: 0111 0000 1100 1010                      */
	{_ONAX,"(HL)"    }, /* cb: 0111 0000 1100 1011                      */
	{_ONAX,"(DE+)"   }, /* cc: 0111 0000 1100 1100                      */
	{_ONAX,"(HL+)"   }, /* cd: 0111 0000 1100 1101                      */
	{_ONAX,"(DE-)"   }, /* ce: 0111 0000 1100 1110                      */
	{_ONAX,"(HL-)"   }, /* cf: 0111 0000 1100 1111                      */

	{_illegal,0   }, /* d0: 0111 0000 1101 0000                      */
	{_ADCX,"(BC)"    }, /* d1: 0111 0000 1101 0001                      */
	{_ADCX,"(DE)"    }, /* d2: 0111 0000 1101 0010                      */
	{_ADCX,"(HL)"    }, /* d3: 0111 0000 1101 0011                      */
	{_ADCX,"(DE+)"   }, /* d4: 0111 0000 1101 0100                      */
	{_ADCX,"(HL+)"   }, /* d5: 0111 0000 1101 0101                      */
	{_ADCX,"(DE-)"   }, /* d6: 0111 0000 1101 0110                      */
	{_ADCX,"(HL-)"   }, /* d7: 0111 0000 1101 0111                      */
	{_illegal,0   }, /* d8: 0111 0000 1101 1000                      */
	{_OFFAX,"(BC)"   }, /* d9: 0111 0000 1101 1001                      */
	{_OFFAX,"(DE)"   }, /* da: 0111 0000 1101 1010                      */
	{_OFFAX,"(HL)"   }, /* db: 0111 0000 1101 1011                      */
	{_OFFAX,"(DE+)"  }, /* dc: 0111 0000 1101 1100                      */
	{_OFFAX,"(HL+)"  }, /* dd: 0111 0000 1101 1101                      */
	{_OFFAX,"(DE-)"  }, /* de: 0111 0000 1101 1110                      */
	{_OFFAX,"(HL-)"  }, /* df: 0111 0000 1101 1111                      */

	{_illegal,0   }, /* e0: 0111 0000 1110 0000                      */
	{_SUBX,"(BC)"    }, /* e1: 0111 0000 1110 0001                      */
	{_SUBX,"(DE)"    }, /* e2: 0111 0000 1110 0010                      */
	{_SUBX,"(HL)"    }, /* e3: 0111 0000 1110 0011                      */
	{_SUBX,"(DE+)"   }, /* e4: 0111 0000 1110 0100                      */
	{_SUBX,"(HL+)"   }, /* e5: 0111 0000 1110 0101                      */
	{_SUBX,"(DE-)"   }, /* e6: 0111 0000 1110 0110                      */
	{_SUBX,"(HL-)"   }, /* e7: 0111 0000 1110 0111                      */
	{_illegal,0   }, /* e8: 0111 0000 1110 1000                      */
	{_NEAX,"(BC)"    }, /* e9: 0111 0000 1110 1001                      */
	{_NEAX,"(DE)"    }, /* ea: 0111 0000 1110 1010                      */
	{_NEAX,"(HL)"    }, /* eb: 0111 0000 1110 1011                      */
	{_NEAX,"(DE+)"   }, /* ec: 0111 0000 1110 1100                      */
	{_NEAX,"(HL+)"   }, /* ed: 0111 0000 1110 1101                      */
	{_NEAX,"(DE-)"   }, /* ee: 0111 0000 1110 1110                      */
	{_NEAX,"(HL-)"   }, /* ef: 0111 0000 1110 1111                      */

	{_illegal,0   }, /* f0: 0111 0000 1111 0000                      */
	{_SBBX,"(BC)"    }, /* f1: 0111 0000 1111 0001                      */
	{_SBBX,"(DE)"    }, /* f2: 0111 0000 1111 0010                      */
	{_SBBX,"(HL)"    }, /* f3: 0111 0000 1111 0011                      */
	{_SBBX,"(DE+)"   }, /* f4: 0111 0000 1111 0100                      */
	{_SBBX,"(HL+)"   }, /* f5: 0111 0000 1111 0101                      */
	{_SBBX,"(DE-)"   }, /* f6: 0111 0000 1111 0110                      */
	{_SBBX,"(HL-)"   }, /* f7: 0111 0000 1111 0111                      */
	{_illegal,0   }, /* f8: 0111 0000 1111 1000                      */
	{_EQAX,"(BC)"    }, /* f9: 0111 0000 1111 1001                      */
	{_EQAX,"(DE)"    }, /* fa: 0111 0000 1111 1010                      */
	{_EQAX,"(HL)"    }, /* fb: 0111 0000 1111 1011                      */
	{_EQAX,"(DE+)"   }, /* fc: 0111 0000 1111 1100                      */
	{_EQAX,"(HL+)"   }, /* fd: 0111 0000 1111 1101                      */
	{_EQAX,"(DE-)"   }, /* fe: 0111 0000 1111 1110                      */
	{_EQAX,"(HL-)"   }  /* ff: 0111 0000 1111 1111                      */
};

/* prefix 74 */
static const struct dasm_s  dasm74[256] =
{
	{_illegal,0   }, /* 00: 0111 0100 0000 0000                      */
	{_illegal,0   }, /* 01: 0111 0100 0000 0001                      */
	{_illegal,0   }, /* 02: 0111 0100 0000 0010                      */
	{_illegal,0   }, /* 03: 0111 0100 0000 0011                      */
	{_illegal,0   }, /* 04: 0111 0100 0000 0100                      */
	{_illegal,0   }, /* 05: 0111 0100 0000 0101                      */
	{_illegal,0   }, /* 06: 0111 0100 0000 0110                      */
	{_illegal,0   }, /* 07: 0111 0100 0000 0111                      */
	{_ANI,"V,%b"     }, /* 08: 0111 0100 0000 1000 xxxx xxxx            */
	{_ANI,"A,%b"     }, /* 09: 0111 0100 0000 1001 xxxx xxxx            */
	{_ANI,"B,%b"     }, /* 0a: 0111 0100 0000 1010 xxxx xxxx            */
	{_ANI,"C,%b"     }, /* 0b: 0111 0100 0000 1011 xxxx xxxx            */
	{_ANI,"D,%b"     }, /* 0c: 0111 0100 0000 1100 xxxx xxxx            */
	{_ANI,"E,%b"     }, /* 0d: 0111 0100 0000 1101 xxxx xxxx            */
	{_ANI,"H,%b"     }, /* 0e: 0111 0100 0000 1110 xxxx xxxx            */
	{_ANI,"L,%b"     }, /* 0f: 0111 0100 0000 1111 xxxx xxxx            */

	{_XRI,"V,%b"     }, /* 10: 0111 0100 0001 0000 xxxx xxxx            */
	{_XRI,"A,%b"     }, /* 11: 0111 0100 0001 0001 xxxx xxxx            */
	{_XRI,"B,%b"     }, /* 12: 0111 0100 0001 0010 xxxx xxxx            */
	{_XRI,"C,%b"     }, /* 13: 0111 0100 0001 0011 xxxx xxxx            */
	{_XRI,"D,%b"     }, /* 14: 0111 0100 0001 0100 xxxx xxxx            */
	{_XRI,"E,%b"     }, /* 15: 0111 0100 0001 0101 xxxx xxxx            */
	{_XRI,"H,%b"     }, /* 16: 0111 0100 0001 0110 xxxx xxxx            */
	{_XRI,"L,%b"     }, /* 17: 0111 0100 0001 0111 xxxx xxxx            */
	{_ORI,"V,%b"     }, /* 18: 0111 0100 0001 1000 xxxx xxxx            */
	{_ORI,"A,%b"     }, /* 19: 0111 0100 0001 1001 xxxx xxxx            */
	{_ORI,"B,%b"     }, /* 1a: 0111 0100 0001 1010 xxxx xxxx            */
	{_ORI,"C,%b"     }, /* 1b: 0111 0100 0001 1011 xxxx xxxx            */
	{_ORI,"D,%b"     }, /* 1c: 0111 0100 0001 1100 xxxx xxxx            */
	{_ORI,"E,%b"     }, /* 1d: 0111 0100 0001 1101 xxxx xxxx            */
	{_ORI,"H,%b"     }, /* 1e: 0111 0100 0001 1110 xxxx xxxx            */
	{_ORI,"L,%b"     }, /* 1f: 0111 0100 0001 1111 xxxx xxxx            */

	{_ADINC,"V,%b"   }, /* 20: 0111 0100 0010 0000 xxxx xxxx            */
	{_ADINC,"A,%b"   }, /* 21: 0111 0100 0010 0001 xxxx xxxx            */
	{_ADINC,"B,%b"   }, /* 22: 0111 0100 0010 0010 xxxx xxxx            */
	{_ADINC,"C,%b"   }, /* 23: 0111 0100 0010 0011 xxxx xxxx            */
	{_ADINC,"D,%b"   }, /* 24: 0111 0100 0010 0100 xxxx xxxx            */
	{_ADINC,"E,%b"   }, /* 25: 0111 0100 0010 0101 xxxx xxxx            */
	{_ADINC,"H,%b"   }, /* 26: 0111 0100 0010 0110 xxxx xxxx            */
	{_ADINC,"L,%b"   }, /* 27: 0111 0100 0010 0111 xxxx xxxx            */
	{_GTI,"V,%b"     }, /* 28: 0111 0100 0010 1000 xxxx xxxx            */
	{_GTI,"A,%b"     }, /* 29: 0111 0100 0010 1001 xxxx xxxx            */
	{_GTI,"B,%b"     }, /* 2a: 0111 0100 0010 1010 xxxx xxxx            */
	{_GTI,"C,%b"     }, /* 2b: 0111 0100 0010 1011 xxxx xxxx            */
	{_GTI,"D,%b"     }, /* 2c: 0111 0100 0010 1100 xxxx xxxx            */
	{_GTI,"E,%b"     }, /* 2d: 0111 0100 0010 1101 xxxx xxxx            */
	{_GTI,"H,%b"     }, /* 2e: 0111 0100 0010 1110 xxxx xxxx            */
	{_GTI,"L,%b"     }, /* 2f: 0111 0100 0010 1111 xxxx xxxx            */

	{_SUINB,"V,%b"   }, /* 30: 0111 0100 0011 0000 xxxx xxxx            */
	{_SUINB,"A,%b"   }, /* 31: 0111 0100 0011 0001 xxxx xxxx            */
	{_SUINB,"B,%b"   }, /* 32: 0111 0100 0011 0010 xxxx xxxx            */
	{_SUINB,"C,%b"   }, /* 33: 0111 0100 0011 0011 xxxx xxxx            */
	{_SUINB,"D,%b"   }, /* 34: 0111 0100 0011 0100 xxxx xxxx            */
	{_SUINB,"E,%b"   }, /* 35: 0111 0100 0011 0101 xxxx xxxx            */
	{_SUINB,"H,%b"   }, /* 36: 0111 0100 0011 0110 xxxx xxxx            */
	{_SUINB,"L,%b"   }, /* 37: 0111 0100 0011 0111 xxxx xxxx            */
	{_LTI,"V,%b"     }, /* 38: 0111 0100 0011 1000 xxxx xxxx            */
	{_LTI,"A,%b"     }, /* 39: 0111 0100 0011 1001 xxxx xxxx            */
	{_LTI,"B,%b"     }, /* 3a: 0111 0100 0011 1010 xxxx xxxx            */
	{_LTI,"C,%b"     }, /* 3b: 0111 0100 0011 1011 xxxx xxxx            */
	{_LTI,"D,%b"     }, /* 3c: 0111 0100 0011 1100 xxxx xxxx            */
	{_LTI,"E,%b"     }, /* 3d: 0111 0100 0011 1101 xxxx xxxx            */
	{_LTI,"H,%b"     }, /* 3e: 0111 0100 0011 1110 xxxx xxxx            */
	{_LTI,"L,%b"     }, /* 3f: 0111 0100 0011 1111 xxxx xxxx            */

	{_ADI,"V,%b"     }, /* 40: 0111 0100 0100 0000 xxxx xxxx            */
	{_ADI,"A,%b"     }, /* 41: 0111 0100 0100 0001 xxxx xxxx            */
	{_ADI,"B,%b"     }, /* 42: 0111 0100 0100 0010 xxxx xxxx            */
	{_ADI,"C,%b"     }, /* 43: 0111 0100 0100 0011 xxxx xxxx            */
	{_ADI,"D,%b"     }, /* 44: 0111 0100 0100 0100 xxxx xxxx            */
	{_ADI,"E,%b"     }, /* 45: 0111 0100 0100 0101 xxxx xxxx            */
	{_ADI,"H,%b"     }, /* 46: 0111 0100 0100 0110 xxxx xxxx            */
	{_ADI,"L,%b"     }, /* 47: 0111 0100 0100 0111 xxxx xxxx            */
	{_ONI,"V,%b"     }, /* 48: 0111 0100 0100 1000 xxxx xxxx            */
	{_ONI,"A,%b"     }, /* 49: 0111 0100 0100 1001 xxxx xxxx            */
	{_ONI,"B,%b"     }, /* 4a: 0111 0100 0100 1010 xxxx xxxx            */
	{_ONI,"C,%b"     }, /* 4b: 0111 0100 0100 1011 xxxx xxxx            */
	{_ONI,"D,%b"     }, /* 4c: 0111 0100 0100 1100 xxxx xxxx            */
	{_ONI,"E,%b"     }, /* 4d: 0111 0100 0100 1101 xxxx xxxx            */
	{_ONI,"H,%b"     }, /* 4e: 0111 0100 0100 1110 xxxx xxxx            */
	{_ONI,"L,%b"     }, /* 4f: 0111 0100 0100 1111 xxxx xxxx            */

	{_ACI,"V,%b"     }, /* 50: 0111 0100 0101 0000 xxxx xxxx            */
	{_ACI,"A,%b"     }, /* 51: 0111 0100 0101 0001 xxxx xxxx            */
	{_ACI,"B,%b"     }, /* 52: 0111 0100 0101 0010 xxxx xxxx            */
	{_ACI,"C,%b"     }, /* 53: 0111 0100 0101 0011 xxxx xxxx            */
	{_ACI,"D,%b"     }, /* 54: 0111 0100 0101 0100 xxxx xxxx            */
	{_ACI,"E,%b"     }, /* 55: 0111 0100 0101 0101 xxxx xxxx            */
	{_ACI,"H,%b"     }, /* 56: 0111 0100 0101 0110 xxxx xxxx            */
	{_ACI,"L,%b"     }, /* 57: 0111 0100 0101 0111 xxxx xxxx            */
	{_OFFI,"V,%b"    }, /* 58: 0111 0100 0101 1000 xxxx xxxx            */
	{_OFFI,"A,%b"    }, /* 59: 0111 0100 0101 1001 xxxx xxxx            */
	{_OFFI,"B,%b"    }, /* 5a: 0111 0100 0101 1010 xxxx xxxx            */
	{_OFFI,"C,%b"    }, /* 5b: 0111 0100 0101 1011 xxxx xxxx            */
	{_OFFI,"D,%b"    }, /* 5c: 0111 0100 0101 1100 xxxx xxxx            */
	{_OFFI,"E,%b"    }, /* 5d: 0111 0100 0101 1101 xxxx xxxx            */
	{_OFFI,"H,%b"    }, /* 5e: 0111 0100 0101 1110 xxxx xxxx            */
	{_OFFI,"L,%b"    }, /* 5f: 0111 0100 0101 1111 xxxx xxxx            */

	{_SUI,"V,%b"     }, /* 60: 0111 0100 0110 0000 xxxx xxxx            */
	{_SUI,"A,%b"     }, /* 61: 0111 0100 0110 0001 xxxx xxxx            */
	{_SUI,"B,%b"     }, /* 62: 0111 0100 0110 0010 xxxx xxxx            */
	{_SUI,"C,%b"     }, /* 63: 0111 0100 0110 0011 xxxx xxxx            */
	{_SUI,"D,%b"     }, /* 64: 0111 0100 0110 0100 xxxx xxxx            */
	{_SUI,"E,%b"     }, /* 65: 0111 0100 0110 0101 xxxx xxxx            */
	{_SUI,"H,%b"     }, /* 66: 0111 0100 0110 0110 xxxx xxxx            */
	{_SUI,"L,%b"     }, /* 67: 0111 0100 0110 0111 xxxx xxxx            */
	{_NEI,"V,%b"     }, /* 68: 0111 0100 0110 1000 xxxx xxxx            */
	{_NEI,"A,%b"     }, /* 69: 0111 0100 0110 1001 xxxx xxxx            */
	{_NEI,"B,%b"     }, /* 6a: 0111 0100 0110 1010 xxxx xxxx            */
	{_NEI,"C,%b"     }, /* 6b: 0111 0100 0110 1011 xxxx xxxx            */
	{_NEI,"D,%b"     }, /* 6c: 0111 0100 0110 1100 xxxx xxxx            */
	{_NEI,"E,%b"     }, /* 6d: 0111 0100 0110 1101 xxxx xxxx            */
	{_NEI,"H,%b"     }, /* 6e: 0111 0100 0110 1110 xxxx xxxx            */
	{_NEI,"L,%b"     }, /* 6f: 0111 0100 0110 1111 xxxx xxxx            */

	{_SBI,"V,%b"     }, /* 70: 0111 0100 0111 0000 xxxx xxxx            */
	{_SBI,"A,%b"     }, /* 71: 0111 0100 0111 0001 xxxx xxxx            */
	{_SBI,"B,%b"     }, /* 72: 0111 0100 0111 0010 xxxx xxxx            */
	{_SBI,"C,%b"     }, /* 73: 0111 0100 0111 0011 xxxx xxxx            */
	{_SBI,"D,%b"     }, /* 74: 0111 0100 0111 0100 xxxx xxxx            */
	{_SBI,"E,%b"     }, /* 75: 0111 0100 0111 0101 xxxx xxxx            */
	{_SBI,"H,%b"     }, /* 76: 0111 0100 0111 0110 xxxx xxxx            */
	{_SBI,"L,%b"     }, /* 77: 0111 0100 0111 0111 xxxx xxxx            */
	{_EQI,"V,%b"     }, /* 78: 0111 0100 0111 1000 xxxx xxxx            */
	{_EQI,"A,%b"     }, /* 79: 0111 0100 0111 1001 xxxx xxxx            */
	{_EQI,"B,%b"     }, /* 7a: 0111 0100 0111 1010 xxxx xxxx            */
	{_EQI,"C,%b"     }, /* 7b: 0111 0100 0111 1011 xxxx xxxx            */
	{_EQI,"D,%b"     }, /* 7c: 0111 0100 0111 1100 xxxx xxxx            */
	{_EQI,"E,%b"     }, /* 7d: 0111 0100 0111 1101 xxxx xxxx            */
	{_EQI,"H,%b"     }, /* 7e: 0111 0100 0111 1110 xxxx xxxx            */
	{_EQI,"L,%b"     }, /* 7f: 0111 0100 0111 1111 xxxx xxxx            */

	{_illegal,0   }, /* 80: 0111 0100 1000 0000                      */
	{_illegal,0   }, /* 81: 0111 0100 1000 0001                      */
	{_illegal,0   }, /* 82: 0111 0100 1000 0010                      */
	{_illegal,0   }, /* 83: 0111 0100 1000 0011                      */
	{_illegal,0   }, /* 84: 0111 0100 1000 0100                      */
	{_illegal,0   }, /* 85: 0111 0100 1000 0101                      */
	{_illegal,0   }, /* 86: 0111 0100 1000 0110                      */
	{_illegal,0   }, /* 87: 0111 0100 1000 0111                      */
	{_ANAW,"%a"      }, /* 88: 0111 0100 1000 1000 oooo oooo            */
	{_illegal,0   }, /* 89: 0111 0100 1000 1001                      */
	{_illegal,0   }, /* 8a: 0111 0100 1000 1010                      */
	{_illegal,0   }, /* 8b: 0111 0100 1000 1011                      */
	{_illegal,0   }, /* 8c: 0111 0100 1000 1100                      */
	{_DAN,"EA,BC"    }, /* 8d: 0111 0100 1000 1101                      */
	{_DAN,"EA,DE"    }, /* 8e: 0111 0100 1000 1110                      */
	{_DAN,"EA,HL"    }, /* 8f: 0111 0100 1000 1111                      */

	{_XRAW,"%a"      }, /* 90: 0111 0100 1001 0000 oooo oooo            */
	{_illegal,0   }, /* 91: 0111 0100 1001 0001                      */
	{_illegal,0   }, /* 92: 0111 0100 1001 0010                      */
	{_illegal,0   }, /* 93: 0111 0100 1001 0011                      */
	{_illegal,0   }, /* 94: 0111 0100 1001 0100                      */
	{_DXR,"EA,BC"    }, /* 95: 0111 0100 1001 0101                      */
	{_DXR,"EA,DE"    }, /* 96: 0111 0100 1001 0110                      */
	{_DXR,"EA,HL"    }, /* 97: 0111 0100 1001 0111                      */
	{_ORAW,"%a"      }, /* 98: 0111 0100 1001 1000 oooo oooo            */
	{_illegal,0   }, /* 99: 0111 0100 1001 1001                      */
	{_illegal,0   }, /* 9a: 0111 0100 1001 1010                      */
	{_illegal,0   }, /* 9b: 0111 0100 1001 1011                      */
	{_illegal,0   }, /* 9c: 0111 0100 1001 1100                      */
	{_DOR,"EA,BC"    }, /* 9d: 0111 0100 1001 1101                      */
	{_DOR,"EA,DE"    }, /* 9e: 0111 0100 1001 1110                      */
	{_DOR,"EA,HL"    }, /* 9f: 0111 0100 1001 1111                      */

	{_ADDNCW,"%a"    }, /* a0: 0111 0100 1010 0000 oooo oooo            */
	{_illegal,0   }, /* a1: 0111 0100 1010 0001                      */
	{_illegal,0   }, /* a2: 0111 0100 1010 0010                      */
	{_illegal,0   }, /* a3: 0111 0100 1010 0011                      */
	{_illegal,0   }, /* a4: 0111 0100 1010 0100                      */
	{_DADDNC,"EA,BC" }, /* a5: 0111 0100 1010 0101                      */
	{_DADDNC,"EA,DE" }, /* a6: 0111 0100 1010 0110                      */
	{_DADDNC,"EA,HL" }, /* a7: 0111 0100 1010 0111                      */
	{_GTAW,"%a"      }, /* a8: 0111 0100 1010 1000 oooo oooo            */
	{_illegal,0   }, /* a9: 0111 0100 1010 1001                      */
	{_illegal,0   }, /* aa: 0111 0100 1010 1010                      */
	{_illegal,0   }, /* ab: 0111 0100 1010 1011                      */
	{_illegal,0   }, /* ac: 0111 0100 1010 1100                      */
	{_DGT,"EA,BC"    }, /* ad: 0111 0100 1010 1101                      */
	{_DGT,"EA,DE"    }, /* ae: 0111 0100 1010 1110                      */
	{_DGT,"EA,HL"    }, /* af: 0111 0100 1010 1111                      */

	{_SUBNBW,"%a"    }, /* b0: 0111 0100 1011 0000 oooo oooo            */
	{_illegal,0   }, /* b1: 0111 0100 1011 0001                      */
	{_illegal,0   }, /* b2: 0111 0100 1011 0010                      */
	{_illegal,0   }, /* b3: 0111 0100 1011 0011                      */
	{_illegal,0   }, /* b4: 0111 0100 1011 0100                      */
	{_DSUBNB,"EA,BC" }, /* b5: 0111 0100 1011 0101                      */
	{_DSUBNB,"EA,DE" }, /* b6: 0111 0100 1011 0110                      */
	{_DSUBNB,"EA,HL" }, /* b7: 0111 0100 1011 0111                      */
	{_LTAW,"%a"      }, /* b8: 0111 0100 1011 1000 oooo oooo            */
	{_illegal,0   }, /* b9: 0111 0100 1011 1001                      */
	{_illegal,0   }, /* ba: 0111 0100 1011 1010                      */
	{_illegal,0   }, /* bb: 0111 0100 1011 1011                      */
	{_illegal,0   }, /* bc: 0111 0100 1011 1100                      */
	{_DLT,"EA,BC"    }, /* bd: 0111 0100 1011 1101                      */
	{_DLT,"EA,DE"    }, /* be: 0111 0100 1011 1110                      */
	{_DLT,"EA,HL"    }, /* bf: 0111 0100 1011 1111                      */

	{_ADDW,"%a"      }, /* c0: 0111 0100 1100 0000 oooo oooo            */
	{_illegal,0   }, /* c1: 0111 0100 1100 0001                      */
	{_illegal,0   }, /* c2: 0111 0100 1100 0010                      */
	{_illegal,0   }, /* c3: 0111 0100 1100 0011                      */
	{_illegal,0   }, /* c4: 0111 0100 1100 0100                      */
	{_DADD,"EA,BC"   }, /* c5: 0111 0100 1100 0101                      */
	{_DADD,"EA,DE"   }, /* c6: 0111 0100 1100 0110                      */
	{_DADD,"EA,HL"   }, /* c7: 0111 0100 1100 0111                      */
	{_ONAW,"%a"      }, /* c8: 0111 0100 1100 1000 oooo oooo            */
	{_illegal,0   }, /* c9: 0111 0100 1100 1001                      */
	{_illegal,0   }, /* ca: 0111 0100 1100 1010                      */
	{_illegal,0   }, /* cb: 0111 0100 1100 1011                      */
	{_illegal,0   }, /* cc: 0111 0100 1100 1100                      */
	{_DON,"EA,BC"    }, /* cd: 0111 0100 1100 1101                      */
	{_DON,"EA,DE"    }, /* ce: 0111 0100 1100 1110                      */
	{_DON,"EA,HL"    }, /* cf: 0111 0100 1100 1111                      */

	{_ADCW,"%a"      }, /* d0: 0111 0100 1101 0000 oooo oooo            */
	{_illegal,0   }, /* d1: 0111 0100 1101 0001                      */
	{_illegal,0   }, /* d2: 0111 0100 1101 0010                      */
	{_illegal,0   }, /* d3: 0111 0100 1101 0011                      */
	{_illegal,0   }, /* d4: 0111 0100 1101 0100                      */
	{_DADC,"EA,BC"   }, /* d5: 0111 0100 1101 0101                      */
	{_DADC,"EA,DE"   }, /* d6: 0111 0100 1101 0110                      */
	{_DADC,"EA,HL"   }, /* d7: 0111 0100 1101 0111                      */
	{_OFFAW,"%a"     }, /* d8: 0111 0100 1101 1000 oooo oooo            */
	{_illegal,0   }, /* d9: 0111 0100 1101 1001                      */
	{_illegal,0   }, /* da: 0111 0100 1101 1010                      */
	{_illegal,0   }, /* db: 0111 0100 1101 1011                      */
	{_illegal,0   }, /* dc: 0111 0100 1101 1100                      */
	{_DOFF,"EA,BC"   }, /* dd: 0111 0100 1101 1101                      */
	{_DOFF,"EA,DE"   }, /* de: 0111 0100 1101 1110                      */
	{_DOFF,"EA,HL"   }, /* df: 0111 0100 1101 1111                      */

	{_SUBW,"%a"      }, /* e0: 0111 0100 1110 0000 oooo oooo            */
	{_illegal,0   }, /* e1: 0111 0100 1110 0001                      */
	{_illegal,0   }, /* e2: 0111 0100 1110 0010                      */
	{_illegal,0   }, /* e3: 0111 0100 1110 0011                      */
	{_illegal,0   }, /* e4: 0111 0100 1110 0100                      */
	{_DSUB,"EA,BC"   }, /* e5: 0111 0100 1110 0101                      */
	{_DSUB,"EA,DE"   }, /* e6: 0111 0100 1110 0110                      */
	{_DSUB,"EA,HL"   }, /* e7: 0111 0100 1110 0111                      */
	{_NEAW,"%a"      }, /* e8: 0111 0100 1110 1000 oooo oooo            */
	{_illegal,0   }, /* e9: 0111 0100 1110 1001                      */
	{_illegal,0   }, /* ea: 0111 0100 1110 1010                      */
	{_illegal,0   }, /* eb: 0111 0100 1110 1011                      */
	{_illegal,0   }, /* ec: 0111 0100 1110 1100                      */
	{_DNE,"EA,BC"    }, /* ed: 0111 0100 1110 1101                      */
	{_DNE,"EA,DE"    }, /* ee: 0111 0100 1110 1110                      */
	{_DNE,"EA,HL"    }, /* ef: 0111 0100 1110 1111                      */

	{_SBBW,"%a"      }, /* f0: 0111 0100 1111 0000 oooo oooo            */
	{_illegal,0   }, /* f1: 0111 0100 1111 0001                      */
	{_illegal,0   }, /* f2: 0111 0100 1111 0010                      */
	{_illegal,0   }, /* f3: 0111 0100 1111 0011                      */
	{_illegal,0   }, /* f4: 0111 0100 1111 0100                      */
	{_DSBB,"EA,BC"   }, /* f5: 0111 0100 1111 0101                      */
	{_DSBB,"EA,DE"   }, /* f6: 0111 0100 1111 0110                      */
	{_DSBB,"EA,HL"   }, /* f7: 0111 0100 1111 0111                      */
	{_EQAW,"%a"      }, /* f8: 0111 0100 1111 1000 oooo oooo            */
	{_illegal,0   }, /* f9: 0111 0100 1111 1001                      */
	{_illegal,0   }, /* fa: 0111 0100 1111 1010                      */
	{_illegal,0   }, /* fb: 0111 0100 1111 1011                      */
	{_illegal,0   }, /* fc: 0111 0100 1111 1100                      */
	{_DEQ,"EA,BC"    }, /* fd: 0111 0100 1111 1101                      */
	{_DEQ,"EA,DE"    }, /* fe: 0111 0100 1111 1110                      */
	{_DEQ,"EA,HL"    }  /* ff: 0111 0100 1111 1111                      */
};

/* main opcodes */
static const struct dasm_s  dasmXX_7810[256] =
{
	{_NOP,0       }, /* 00: 0000 0000                                */
	{_LDAW,"%a"      }, /* 01: 0000 0001 oooo oooo                      */
	{_INX,"SP"       }, /* 02: 0000 0010                                */
	{_DCX,"SP"       }, /* 03: 0000 0011                                */
	{_LXI,"SP,%w"    }, /* 04: 0000 0100 llll llll hhhh hhhh            */
	{_ANIW,"%a,%b"   }, /* 05: 0000 0101 oooo oooo xxxx xxxx            */
	{_illegal,0   }, /* 06:                                          */
	{_ANI,"A,%b"     }, /* 07: 0000 0111 xxxx xxxx                      */
	{_MOV,"A,EAH"    }, /* 08: 0000 1000                                */
	{_MOV,"A,EAL"    }, /* 09: 0000 1001                                */
	{_MOV,"A,B"      }, /* 0a: 0000 1010                                */
	{_MOV,"A,C"      }, /* 0b: 0000 1011                                */
	{_MOV,"A,D"      }, /* 0c: 0000 1100                                */
	{_MOV,"A,E"      }, /* 0d: 0000 1101                                */
	{_MOV,"A,H"      }, /* 0e: 0000 1110                                */
	{_MOV,"A,L"      }, /* 0f: 0000 1111                                */

	{_EXA,0       }, /* 10: 0001 0000                                */  /* 7810 */
	{_EXX,0       }, /* 11: 0001 0001                                */  /* 7810 */
	{_INX,"BC"       }, /* 12: 0001 0010                                */
	{_DCX,"BC"       }, /* 13: 0001 0011                                */
	{_LXI,"BC,%w"    }, /* 14: 0001 0100 llll llll hhhh hhhh            */
	{_ORIW,"%a,%b"   }, /* 15: 0001 0101 oooo oooo xxxx xxxx            */
	{_XRI,"A,%b"     }, /* 16: 0001 0110 xxxx xxxx                      */
	{_ORI,"A,%b"     }, /* 17: 0001 0111 xxxx xxxx                      */
	{_MOV,"EAH,A"    }, /* 18: 0001 1000                                */
	{_MOV,"EAL,A"    }, /* 19: 0001 1001                                */
	{_MOV,"B,A"      }, /* 1a: 0001 1010                                */
	{_MOV,"C,A"      }, /* 1b: 0001 1011                                */
	{_MOV,"D,A"      }, /* 1c: 0001 1100                                */
	{_MOV,"E,A"      }, /* 1d: 0001 1101                                */
	{_MOV,"H,A"      }, /* 1e: 0001 1110                                */
	{_MOV,"L,A"      }, /* 1f: 0001 1111                                */

	{_INRW,"%a"      }, /* 20: 0010 0000 oooo oooo                      */
	{_JB,0            }, /* 21: 0010 0001                                */
	{_INX,"DE"       }, /* 22: 0010 0010                                */
	{_DCX,"DE"       }, /* 23: 0010 0011                                */
	{_LXI,"DE,%w"    }, /* 24: 0010 0100 llll llll hhhh hhhh            */
	{_GTIW,"%a,%b"   }, /* 25: 0010 0101 oooo oooo xxxx xxxx            */
	{_ADINC,"A,%b"   }, /* 26: 0010 0110 xxxx xxxx                      */
	{_GTI,"A,%b"     }, /* 27: 0010 0111 xxxx xxxx                      */
	{_illegal,0   }, /* 28: 0010 1000                                */
	{_LDAX,"(BC)"    }, /* 29: 0010 1001                                */
	{_LDAX,"(DE)"    }, /* 2a: 0010 1010                                */
	{_LDAX,"(HL)"    }, /* 2b: 0010 1011                                */
	{_LDAX,"(DE+)"   }, /* 2c: 0010 1100                                */
	{_LDAX,"(HL+)"   }, /* 2d: 0010 1101                                */
	{_LDAX,"(DE-)"   }, /* 2e: 0010 1110                                */
	{_LDAX,"(HL-)"   }, /* 2f: 0010 1111                                */

	{_DCRW,"%a"      }, /* 30: 0011 0000 oooo oooo                      */
	{_BLOCK,0         }, /* 31: 0011 0001                                */  /* 7810 */
	{_INX,"HL",       }, /* 32: 0011 0010                                */
	{_DCX,"HL",       }, /* 33: 0011 0011                                */
	{_LXI,"HL,%w"    }, /* 34: 0011 0100 llll llll hhhh hhhh            */
	{_LTIW,"%a,%b"   }, /* 35: 0011 0101 oooo oooo xxxx xxxx            */
	{_SUINB,"A,%b"   }, /* 36: 0011 0110 xxxx xxxx                      */
	{_LTI,"A,%b"     }, /* 37: 0011 0111 xxxx xxxx                      */
	{_illegal,0   }, /* 38:                                          */
	{_STAX,"(BC)"    }, /* 39: 0011 1001                                */
	{_STAX,"(DE)"    }, /* 3a: 0011 1010                                */
	{_STAX,"(HL)"    }, /* 3b: 0011 1011                                */
	{_STAX,"(DE+)"   }, /* 3c: 0011 1100                                */
	{_STAX,"(HL+)"   }, /* 3d: 0011 1101                                */
	{_STAX,"(DE-)"   }, /* 3e: 0011 1110                                */
	{_STAX,"(HL-)"   }, /* 3f: 0011 1111                                */

	{_CALL,"%w"      }, /* 40: 0100 0000 llll llll hhhh hhhh            */
	{_INR,"A"        }, /* 41: 0100 0001                                */
	{_INR,"B"        }, /* 42: 0100 0010                                */
	{_INR,"C"        }, /* 43: 0100 0011                                */
	{_LXI,"EA,%w"    }, /* 44: 0100 0100 llll llll hhhh hhhh            */
	{_ONIW,"%a,%b"   }, /* 45: 0100 0101 oooo oooo xxxx xxxx            */
	{_ADI,"A,%b"     }, /* 46: 0100 0110 xxxx xxxx                      */
	{_ONI,"A,%b"     }, /* 47: 0100 0111 xxxx xxxx                      */
	{0,dasm48_7810  }, /* 48: prefix                                   */
	{_MVIX,"BC,%b"   }, /* 49: 0100 1001 xxxx xxxx                      */
	{_MVIX,"DE,%b"   }, /* 4a: 0100 1010 xxxx xxxx                      */
	{_MVIX,"HL,%b"   }, /* 4b: 0100 1011 xxxx xxxx                      */
	{0,dasm4C_7810  }, /* 4c: prefix                                   */
	{0,dasm4D_7810  }, /* 4d: prefix                                   */
	{_JRE,"%d"       }, /* 4e: 0100 111d dddd dddd                      */
	{_JRE,"%d"       }, /* 4f: 0100 111d dddd dddd                      */

	{_EXH,0       }, /* 50: 0101 0000                                */  /* 7810 */
	{_DCR,"A"        }, /* 51: 0101 0001                                */
	{_DCR,"B"        }, /* 52: 0101 0010                                */
	{_DCR,"C"        }, /* 53: 0101 0011                                */
	{_JMP,"%w"       }, /* 54: 0101 0100 llll llll hhhh hhhh            */
	{_OFFIW,"%a,%b"  }, /* 55: 0101 0101 oooo oooo xxxx xxxx            */
	{_ACI,"A,%b"     }, /* 56: 0101 0110 xxxx xxxx                      */
	{_OFFI,"A,%b"    }, /* 57: 0101 0111 xxxx xxxx                      */
	{_BIT,"0,%a",     }, /* 58: 0101 1000 oooo oooo                      */  /* 7810 */
	{_BIT,"1,%a",     }, /* 59: 0101 1001 oooo oooo                      */  /* 7810 */
	{_BIT,"2,%a",     }, /* 5a: 0101 1010 oooo oooo                      */  /* 7810 */
	{_BIT,"3,%a",     }, /* 5b: 0101 1011 oooo oooo                      */  /* 7810 */
	{_BIT,"4,%a",     }, /* 5c: 0101 1100 oooo oooo                      */  /* 7810 */
	{_BIT,"5,%a",     }, /* 5d: 0101 1101 oooo oooo                      */  /* 7810 */
	{_BIT,"6,%a",     }, /* 5e: 0101 1110 oooo oooo                      */  /* 7810 */
	{_BIT,"7,%a",     }, /* 5f: 0101 1111 oooo oooo                      */  /* 7810 */

	{0,dasm60        }, /* 60: prefix                                   */
	{_DAA,0       }, /* 61: 0110 0001                                */
	{_RETI,0      }, /* 62: 0110 0010                                */
	{_STAW,"%a"      }, /* 63: 0110 0011 oooo oooo                      */
	{0,dasm64_7810   }, /* 64: prefix                                   */
	{_NEIW,"%a,%b"   }, /* 65: 0110 0101 oooo oooo xxxx xxxx            */
	{_SUI,"A,%b"     }, /* 66: 0110 0110 xxxx xxxx                      */
	{_NEI,"A,%b"     }, /* 67: 0110 0111 xxxx xxxx                      */
	{_MVI,"V,%b"     }, /* 68: 0110 1000 xxxx xxxx                      */
	{_MVI,"A,%b"     }, /* 69: 0110 1001 xxxx xxxx                      */
	{_MVI,"B,%b"     }, /* 6a: 0110 1010 xxxx xxxx                      */
	{_MVI,"C,%b"     }, /* 6b: 0110 1011 xxxx xxxx                      */
	{_MVI,"D,%b"     }, /* 6c: 0110 1100 xxxx xxxx                      */
	{_MVI,"E,%b"     }, /* 6d: 0110 1101 xxxx xxxx                      */
	{_MVI,"H,%b"     }, /* 6e: 0110 1110 xxxx xxxx                      */
	{_MVI,"L,%b"     }, /* 6f: 0110 1111 xxxx xxxx                      */

	{0,dasm70        }, /* 70: prefix                                   */
	{_MVIW,"%a,%b"   }, /* 71: 0111 0001 oooo oooo xxxx xxxx            */
	{_SOFTI,0         }, /* 72: 0111 0010                                */
	{_illegal,0   }, /* 73:                                          */
	{0,dasm74        }, /* 74: prefix                                   */
	{_EQIW,"%a,%b"   }, /* 75: 0111 0101 oooo oooo xxxx xxxx            */
	{_SBI,"A,%b"     }, /* 76: 0111 0110 xxxx xxxx                      */
	{_EQI,"A,%b"     }, /* 77: 0111 0111 xxxx xxxx                      */
	{_CALF,"%f"      }, /* 78: 0111 1ddd dddd dddd                      */
	{_CALF,"%f"      }, /* 79: 0111 1ddd dddd dddd                      */
	{_CALF,"%f"      }, /* 7a: 0111 1ddd dddd dddd                      */
	{_CALF,"%f"      }, /* 7b: 0111 1ddd dddd dddd                      */
	{_CALF,"%f"      }, /* 7c: 0111 1ddd dddd dddd                      */
	{_CALF,"%f"      }, /* 7d: 0111 1ddd dddd dddd                      */
	{_CALF,"%f"      }, /* 7e: 0111 1ddd dddd dddd                      */
	{_CALF,"%f"      }, /* 7f: 0111 1ddd dddd dddd                      */

	{_CALT,"%t"      }, /* 80: 100t tttt                                */
	{_CALT,"%t"      }, /* 81: 100t tttt                                */
	{_CALT,"%t"      }, /* 82: 100t tttt                                */
	{_CALT,"%t"      }, /* 83: 100t tttt                                */
	{_CALT,"%t"      }, /* 84: 100t tttt                                */
	{_CALT,"%t"      }, /* 85: 100t tttt                                */
	{_CALT,"%t"      }, /* 86: 100t tttt                                */
	{_CALT,"%t"      }, /* 87: 100t tttt                                */
	{_CALT,"%t"      }, /* 88: 100t tttt                                */
	{_CALT,"%t"      }, /* 89: 100t tttt                                */
	{_CALT,"%t"      }, /* 8a: 100t tttt                                */
	{_CALT,"%t"      }, /* 8b: 100t tttt                                */
	{_CALT,"%t"      }, /* 8c: 100t tttt                                */
	{_CALT,"%t"      }, /* 8d: 100t tttt                                */
	{_CALT,"%t"      }, /* 8e: 100t tttt                                */
	{_CALT,"%t"      }, /* 8f: 100t tttt                                */

	{_CALT,"%t"      }, /* 90: 100t tttt                                */
	{_CALT,"%t"      }, /* 91: 100t tttt                                */
	{_CALT,"%t"      }, /* 92: 100t tttt                                */
	{_CALT,"%t"      }, /* 93: 100t tttt                                */
	{_CALT,"%t"      }, /* 94: 100t tttt                                */
	{_CALT,"%t"      }, /* 95: 100t tttt                                */
	{_CALT,"%t"      }, /* 96: 100t tttt                                */
	{_CALT,"%t"      }, /* 97: 100t tttt                                */
	{_CALT,"%t"      }, /* 98: 100t tttt                                */
	{_CALT,"%t"      }, /* 99: 100t tttt                                */
	{_CALT,"%t"      }, /* 9a: 100t tttt                                */
	{_CALT,"%t"      }, /* 9b: 100t tttt                                */
	{_CALT,"%t"      }, /* 9c: 100t tttt                                */
	{_CALT,"%t"      }, /* 9d: 100t tttt                                */
	{_CALT,"%t"      }, /* 9e: 100t tttt                                */
	{_CALT,"%t"      }, /* 9f: 100t tttt                                */

	{_POP,"VA"       }, /* a0: 1010 0000                                */
	{_POP,"BC"       }, /* a1: 1010 0001                                */
	{_POP,"DE"       }, /* a2: 1010 0010                                */
	{_POP,"HL",       }, /* a3: 1010 0011                                */
	{_POP,"EA"       }, /* a4: 1010 0100                                */
	{_DMOV,"EA,BC"   }, /* a5: 1010 0101                                */
	{_DMOV,"EA,DE"   }, /* a6: 1010 0110                                */
	{_DMOV,"EA,HL"   }, /* a7: 1010 0111                                */
	{_INX,"EA"       }, /* a8: 1010 1000                                */
	{_DCX,"EA"       }, /* a9: 1010 1001                                */
	{_EI,0            }, /* aa: 1010 1010                                */
	{_LDAX,"(DE+%b)" }, /* ab: 1010 1011 dddd dddd                      */
	{_LDAX,"(HL+A)"  }, /* ac: 1010 1100                                */
	{_LDAX,"(HL+B)"  }, /* ad: 1010 1101                                */
	{_LDAX,"(HL+EA)" }, /* ae: 1010 1110                                */
	{_LDAX,"(HL+%b)" }, /* af: 1010 1111 dddd dddd                      */

	{_PUSH,"VA"      }, /* b0: 1011 0000                                */
	{_PUSH,"BC"      }, /* b1: 1011 0001                                */
	{_PUSH,"DE"      }, /* b2: 1011 0010                                */
	{_PUSH,"HL",      }, /* b3: 1011 0011                                */
	{_PUSH,"EA"      }, /* b4: 1011 0100                                */
	{_DMOV,"BC,EA"   }, /* b5: 1011 0101                                */
	{_DMOV,"DE,EA"   }, /* b6: 1011 0110                                */
	{_DMOV,"HL,EA"   }, /* b7: 1011 0111                                */
	{_RET,0       }, /* b8: 1011 1000                                */
	{_RETS,0      }, /* b9: 1011 1001                                */
	{_DI,0            }, /* ba: 1011 1010                                */
	{_STAX,"(DE+%b)" }, /* bb: 1011 1011 dddd dddd                      */
	{_STAX,"(HL+A)"  }, /* bc: 1011 1100                                */
	{_STAX,"(HL+B)"  }, /* bd: 1011 1101                                */
	{_STAX,"(HL+EA)" }, /* be: 1011 1110                                */
	{_STAX,"(HL+%b)" }, /* bf: 1011 1111 dddd dddd                      */

	{_JR,"%o"        }, /* c0: 11oo oooo                                */
	{_JR,"%o"        }, /* c1: 11oo oooo                                */
	{_JR,"%o"        }, /* c2: 11oo oooo                                */
	{_JR,"%o"        }, /* c3: 11oo oooo                                */
	{_JR,"%o"        }, /* c4: 11oo oooo                                */
	{_JR,"%o"        }, /* c5: 11oo oooo                                */
	{_JR,"%o"        }, /* c6: 11oo oooo                                */
	{_JR,"%o"        }, /* c7: 11oo oooo                                */
	{_JR,"%o"        }, /* c8: 11oo oooo                                */
	{_JR,"%o"        }, /* c9: 11oo oooo                                */
	{_JR,"%o"        }, /* ca: 11oo oooo                                */
	{_JR,"%o"        }, /* cb: 11oo oooo                                */
	{_JR,"%o"        }, /* cc: 11oo oooo                                */
	{_JR,"%o"        }, /* cd: 11oo oooo                                */
	{_JR,"%o"        }, /* ce: 11oo oooo                                */
	{_JR,"%o"        }, /* cf: 11oo oooo                                */

	{_JR,"%o"        }, /* d0: 11oo oooo                                */
	{_JR,"%o"        }, /* d1: 11oo oooo                                */
	{_JR,"%o"        }, /* d2: 11oo oooo                                */
	{_JR,"%o"        }, /* d3: 11oo oooo                                */
	{_JR,"%o"        }, /* d4: 11oo oooo                                */
	{_JR,"%o"        }, /* d5: 11oo oooo                                */
	{_JR,"%o"        }, /* d6: 11oo oooo                                */
	{_JR,"%o"        }, /* d7: 11oo oooo                                */
	{_JR,"%o"        }, /* d8: 11oo oooo                                */
	{_JR,"%o"        }, /* d9: 11oo oooo                                */
	{_JR,"%o"        }, /* da: 11oo oooo                                */
	{_JR,"%o"        }, /* db: 11oo oooo                                */
	{_JR,"%o"        }, /* dc: 11oo oooo                                */
	{_JR,"%o"        }, /* dd: 11oo oooo                                */
	{_JR,"%o"        }, /* de: 11oo oooo                                */
	{_JR,"%o"        }, /* df: 11oo oooo                                */

	{_JR,"%o"        }, /* e0: 11oo oooo                                */
	{_JR,"%o"        }, /* e1: 11oo oooo                                */
	{_JR,"%o"        }, /* e2: 11oo oooo                                */
	{_JR,"%o"        }, /* e3: 11oo oooo                                */
	{_JR,"%o"        }, /* e4: 11oo oooo                                */
	{_JR,"%o"        }, /* e5: 11oo oooo                                */
	{_JR,"%o"        }, /* e6: 11oo oooo                                */
	{_JR,"%o"        }, /* e7: 11oo oooo                                */
	{_JR,"%o"        }, /* e8: 11oo oooo                                */
	{_JR,"%o"        }, /* e9: 11oo oooo                                */
	{_JR,"%o"        }, /* ea: 11oo oooo                                */
	{_JR,"%o"        }, /* eb: 11oo oooo                                */
	{_JR,"%o"        }, /* ec: 11oo oooo                                */
	{_JR,"%o"        }, /* ed: 11oo oooo                                */
	{_JR,"%o"        }, /* ee: 11oo oooo                                */
	{_JR,"%o"        }, /* ef: 11oo oooo                                */

	{_JR,"%o"        }, /* f0: 11oo oooo                                */
	{_JR,"%o"        }, /* f1: 11oo oooo                                */
	{_JR,"%o"        }, /* f2: 11oo oooo                                */
	{_JR,"%o"        }, /* f3: 11oo oooo                                */
	{_JR,"%o"        }, /* f4: 11oo oooo                                */
	{_JR,"%o"        }, /* f5: 11oo oooo                                */
	{_JR,"%o"        }, /* f6: 11oo oooo                                */
	{_JR,"%o"        }, /* f7: 11oo oooo                                */
	{_JR,"%o"        }, /* f8: 11oo oooo                                */
	{_JR,"%o"        }, /* f9: 11oo oooo                                */
	{_JR,"%o"        }, /* fa: 11oo oooo                                */
	{_JR,"%o"        }, /* fb: 11oo oooo                                */
	{_JR,"%o"        }, /* fc: 11oo oooo                                */
	{_JR,"%o"        }, /* fd: 11oo oooo                                */
	{_JR,"%o"        }, /* fe: 11oo oooo                                */
	{_JR,"%o"        }  /* ff: 11oo oooo                                */
};

static const struct dasm_s  dasmXX_7807[256] =
{
	{_NOP,0       }, /* 00: 0000 0000                                */
	{_LDAW,"%a"      }, /* 01: 0000 0001 oooo oooo                      */
	{_INX,"SP"       }, /* 02: 0000 0010                                */
	{_DCX,"SP"       }, /* 03: 0000 0011                                */
	{_LXI,"SP,%w"    }, /* 04: 0000 0100 llll llll hhhh hhhh            */
	{_ANIW,"%a,%b"   }, /* 05: 0000 0101 oooo oooo xxxx xxxx            */
	{_illegal,0   }, /* 06:                                          */
	{_ANI,"A,%b"     }, /* 07: 0000 0111 xxxx xxxx                      */
	{_MOV,"A,EAH"    }, /* 08: 0000 1000                                */
	{_MOV,"A,EAL"    }, /* 09: 0000 1001                                */
	{_MOV,"A,B"      }, /* 0a: 0000 1010                                */
	{_MOV,"A,C"      }, /* 0b: 0000 1011                                */
	{_MOV,"A,D"      }, /* 0c: 0000 1100                                */
	{_MOV,"A,E"      }, /* 0d: 0000 1101                                */
	{_MOV,"A,H"      }, /* 0e: 0000 1110                                */
	{_MOV,"A,L"      }, /* 0f: 0000 1111                                */

	{_BLOCK,"D+"  }, /* 10: 0001 0000                                */  /* 7807 */
	{_BLOCK,"D-"  }, /* 11: 0001 0001                                */  /* 7807 */
	{_INX,"BC"       }, /* 12: 0001 0010                                */
	{_DCX,"BC"       }, /* 13: 0001 0011                                */
	{_LXI,"BC,%w"    }, /* 14: 0001 0100 llll llll hhhh hhhh            */
	{_ORIW,"%a,%b"   }, /* 15: 0001 0101 oooo oooo xxxx xxxx            */
	{_XRI,"A,%b"     }, /* 16: 0001 0110 xxxx xxxx                      */
	{_ORI,"A,%b"     }, /* 17: 0001 0111 xxxx xxxx                      */
	{_MOV,"EAH,A"    }, /* 18: 0001 1000                                */
	{_MOV,"EAL,A"    }, /* 19: 0001 1001                                */
	{_MOV,"B,A"      }, /* 1a: 0001 1010                                */
	{_MOV,"C,A"      }, /* 1b: 0001 1011                                */
	{_MOV,"D,A"      }, /* 1c: 0001 1100                                */
	{_MOV,"E,A"      }, /* 1d: 0001 1101                                */
	{_MOV,"H,A"      }, /* 1e: 0001 1110                                */
	{_MOV,"L,A"      }, /* 1f: 0001 1111                                */

	{_INRW,"%a"      }, /* 20: 0010 0000 oooo oooo                      */
	{_JB,0            }, /* 21: 0010 0001                                */
	{_INX,"DE"       }, /* 22: 0010 0010                                */
	{_DCX,"DE"       }, /* 23: 0010 0011                                */
	{_LXI,"DE,%w"    }, /* 24: 0010 0100 llll llll hhhh hhhh            */
	{_GTIW,"%a,%b"   }, /* 25: 0010 0101 oooo oooo xxxx xxxx            */
	{_ADINC,"A,%b"   }, /* 26: 0010 0110 xxxx xxxx                      */
	{_GTI,"A,%b"     }, /* 27: 0010 0111 xxxx xxxx                      */
	{_illegal,0   }, /* 28: 0010 1000                                */
	{_LDAX,"(BC)"    }, /* 29: 0010 1001                                */
	{_LDAX,"(DE)"    }, /* 2a: 0010 1010                                */
	{_LDAX,"(HL)"    }, /* 2b: 0010 1011                                */
	{_LDAX,"(DE+)"   }, /* 2c: 0010 1100                                */
	{_LDAX,"(HL+)"   }, /* 2d: 0010 1101                                */
	{_LDAX,"(DE-)"   }, /* 2e: 0010 1110                                */
	{_LDAX,"(HL-)"   }, /* 2f: 0010 1111                                */

	{_DCRW,"%a"      }, /* 30: 0011 0000 oooo oooo                      */
	{_AND,"CY,%i"     }, /* 31: 0011 0001 bbbb bbbb                      */  /* 7807 */
	{_INX,"HL",       }, /* 32: 0011 0010                                */
	{_DCX,"HL",       }, /* 33: 0011 0011                                */
	{_LXI,"HL,%w"    }, /* 34: 0011 0100 llll llll hhhh hhhh            */
	{_LTIW,"%a,%b"   }, /* 35: 0011 0101 oooo oooo xxxx xxxx            */
	{_SUINB,"A,%b"   }, /* 36: 0011 0110 xxxx xxxx                      */
	{_LTI,"A,%b"     }, /* 37: 0011 0111 xxxx xxxx                      */
	{_illegal,0   }, /* 38:                                          */
	{_STAX,"(BC)"    }, /* 39: 0011 1001                                */
	{_STAX,"(DE)"    }, /* 3a: 0011 1010                                */
	{_STAX,"(HL)"    }, /* 3b: 0011 1011                                */
	{_STAX,"(DE+)"   }, /* 3c: 0011 1100                                */
	{_STAX,"(HL+)"   }, /* 3d: 0011 1101                                */
	{_STAX,"(DE-)"   }, /* 3e: 0011 1110                                */
	{_STAX,"(HL-)"   }, /* 3f: 0011 1111                                */

	{_CALL,"%w"      }, /* 40: 0100 0000 llll llll hhhh hhhh            */
	{_INR,"A"        }, /* 41: 0100 0001                                */
	{_INR,"B"        }, /* 42: 0100 0010                                */
	{_INR,"C"        }, /* 43: 0100 0011                                */
	{_LXI,"EA,%w"    }, /* 44: 0100 0100 llll llll hhhh hhhh            */
	{_ONIW,"%a,%b"   }, /* 45: 0100 0101 oooo oooo xxxx xxxx            */
	{_ADI,"A,%b"     }, /* 46: 0100 0110 xxxx xxxx                      */
	{_ONI,"A,%b"     }, /* 47: 0100 0111 xxxx xxxx                      */
	{0,dasm48_7807   }, /* 48: prefix                                   */
	{_MVIX,"BC,%b"   }, /* 49: 0100 1001 xxxx xxxx                      */
	{_MVIX,"DE,%b"   }, /* 4a: 0100 1010 xxxx xxxx                      */
	{_MVIX,"HL,%b"   }, /* 4b: 0100 1011 xxxx xxxx                      */
	{0,dasm4C_7807   }, /* 4c: prefix                                   */
	{0,dasm4D_7807   }, /* 4d: prefix                                   */
	{_JRE,"%d"       }, /* 4e: 0100 111d dddd dddd                      */
	{_JRE,"%d"       }, /* 4f: 0100 111d dddd dddd                      */
	{_SKN,"%i"        }, /* 50: 0101 0000 bbbb bbbb                      */  /* 7807 */
	{_DCR,"A"        }, /* 51: 0101 0001                                */
	{_DCR,"B"        }, /* 52: 0101 0010                                */
	{_DCR,"C"        }, /* 53: 0101 0011                                */
	{_JMP,"%w"       }, /* 54: 0101 0100 llll llll hhhh hhhh            */
	{_OFFIW,"%a,%b"  }, /* 55: 0101 0101 oooo oooo xxxx xxxx            */
	{_ACI,"A,%b"     }, /* 56: 0101 0110 xxxx xxxx                      */
	{_OFFI,"A,%b"    }, /* 57: 0101 0111 xxxx xxxx                      */
	{_SETB,"%i"      }, /* 58: 0101 1000 bbbb bbbb                      */   /* 7807 */
	{_NOT,"%i"       }, /* 59: 0101 1001 bbbb bbbb                      */   /* 7807 */
	{_MOV,"%i,CY"    }, /* 5a: 0101 1010 bbbb bbbb                      */   /* 7807 */
	{_CLR,"%i"       }, /* 5b: 0101 1011 bbbb bbbb                      */   /* 7807 */
	{_OR,"CY,%i"     }, /* 5c: 0101 1100 bbbb bbbb                      */   /* 7807 */
	{_SK,"%i"        }, /* 5d: 0101 1101 bbbb bbbb                      */   /* 7807 */
	{_XOR,"CY,%i"    }, /* 5e: 0101 1110 bbbb bbbb                      */   /* 7807 */
	{_MOV,"CY,%i"    }, /* 5f: 0101 1111 bbbb bbbb                      */   /* 7807 */

	{0,dasm60        }, /* 60: prefix                                   */
	{_DAA,0       }, /* 61: 0110 0001                                */
	{_RETI,0      }, /* 62: 0110 0010                                */
	{_STAW,"%a"      }, /* 63: 0110 0011 oooo oooo                      */
	{0,dasm64_7807   }, /* 64: prefix                                   */
	{_NEIW,"%a,%b"   }, /* 65: 0110 0101 oooo oooo xxxx xxxx            */
	{_SUI,"A,%b"     }, /* 66: 0110 0110 xxxx xxxx                      */
	{_NEI,"A,%b"     }, /* 67: 0110 0111 xxxx xxxx                      */
	{_MVI,"V,%b"     }, /* 68: 0110 1000 xxxx xxxx                      */
	{_MVI,"A,%b"     }, /* 69: 0110 1001 xxxx xxxx                      */
	{_MVI,"B,%b"     }, /* 6a: 0110 1010 xxxx xxxx                      */
	{_MVI,"C,%b"     }, /* 6b: 0110 1011 xxxx xxxx                      */
	{_MVI,"D,%b"     }, /* 6c: 0110 1100 xxxx xxxx                      */
	{_MVI,"E,%b"     }, /* 6d: 0110 1101 xxxx xxxx                      */
	{_MVI,"H,%b"     }, /* 6e: 0110 1110 xxxx xxxx                      */
	{_MVI,"L,%b"     }, /* 6f: 0110 1111 xxxx xxxx                      */

	{0,dasm70        }, /* 70: prefix                                   */
	{_MVIW,"%a,%b"   }, /* 71: 0111 0001 oooo oooo xxxx xxxx            */
	{_SOFTI,0         }, /* 72: 0111 0010                                */
	{_illegal,0   }, /* 73:                                          */
	{0,dasm74        }, /* 74: prefix                                   */
	{_EQIW,"%a,%b"   }, /* 75: 0111 0101 oooo oooo xxxx xxxx            */
	{_SBI,"A,%b"     }, /* 76: 0111 0110 xxxx xxxx                      */
	{_EQI,"A,%b"     }, /* 77: 0111 0111 xxxx xxxx                      */
	{_CALF,"%f"      }, /* 78: 0111 1ddd dddd dddd                      */
	{_CALF,"%f"      }, /* 79: 0111 1ddd dddd dddd                      */
	{_CALF,"%f"      }, /* 7a: 0111 1ddd dddd dddd                      */
	{_CALF,"%f"      }, /* 7b: 0111 1ddd dddd dddd                      */
	{_CALF,"%f"      }, /* 7c: 0111 1ddd dddd dddd                      */
	{_CALF,"%f"      }, /* 7d: 0111 1ddd dddd dddd                      */
	{_CALF,"%f"      }, /* 7e: 0111 1ddd dddd dddd                      */
	{_CALF,"%f"      }, /* 7f: 0111 1ddd dddd dddd                      */

	{_CALT,"%t"      }, /* 80: 100t tttt                                */
	{_CALT,"%t"      }, /* 81: 100t tttt                                */
	{_CALT,"%t"      }, /* 82: 100t tttt                                */
	{_CALT,"%t"      }, /* 83: 100t tttt                                */
	{_CALT,"%t"      }, /* 84: 100t tttt                                */
	{_CALT,"%t"      }, /* 85: 100t tttt                                */
	{_CALT,"%t"      }, /* 86: 100t tttt                                */
	{_CALT,"%t"      }, /* 87: 100t tttt                                */
	{_CALT,"%t"      }, /* 88: 100t tttt                                */
	{_CALT,"%t"      }, /* 89: 100t tttt                                */
	{_CALT,"%t"      }, /* 8a: 100t tttt                                */
	{_CALT,"%t"      }, /* 8b: 100t tttt                                */
	{_CALT,"%t"      }, /* 8c: 100t tttt                                */
	{_CALT,"%t"      }, /* 8d: 100t tttt                                */
	{_CALT,"%t"      }, /* 8e: 100t tttt                                */
	{_CALT,"%t"      }, /* 8f: 100t tttt                                */

	{_CALT,"%t"      }, /* 90: 100t tttt                                */
	{_CALT,"%t"      }, /* 91: 100t tttt                                */
	{_CALT,"%t"      }, /* 92: 100t tttt                                */
	{_CALT,"%t"      }, /* 93: 100t tttt                                */
	{_CALT,"%t"      }, /* 94: 100t tttt                                */
	{_CALT,"%t"      }, /* 95: 100t tttt                                */
	{_CALT,"%t"      }, /* 96: 100t tttt                                */
	{_CALT,"%t"      }, /* 97: 100t tttt                                */
	{_CALT,"%t"      }, /* 98: 100t tttt                                */
	{_CALT,"%t"      }, /* 99: 100t tttt                                */
	{_CALT,"%t"      }, /* 9a: 100t tttt                                */
	{_CALT,"%t"      }, /* 9b: 100t tttt                                */
	{_CALT,"%t"      }, /* 9c: 100t tttt                                */
	{_CALT,"%t"      }, /* 9d: 100t tttt                                */
	{_CALT,"%t"      }, /* 9e: 100t tttt                                */
	{_CALT,"%t"      }, /* 9f: 100t tttt                                */

	{_POP,"VA"       }, /* a0: 1010 0000                                */
	{_POP,"BC"       }, /* a1: 1010 0001                                */
	{_POP,"DE"       }, /* a2: 1010 0010                                */
	{_POP,"HL",       }, /* a3: 1010 0011                                */
	{_POP,"EA"       }, /* a4: 1010 0100                                */
	{_DMOV,"EA,BC"   }, /* a5: 1010 0101                                */
	{_DMOV,"EA,DE"   }, /* a6: 1010 0110                                */
	{_DMOV,"EA,HL"   }, /* a7: 1010 0111                                */
	{_INX,"EA"       }, /* a8: 1010 1000                                */
	{_DCX,"EA"       }, /* a9: 1010 1001                                */
	{_EI,0            }, /* aa: 1010 1010                                */
	{_LDAX,"(DE+%b)" }, /* ab: 1010 1011 dddd dddd                      */
	{_LDAX,"(HL+A)"  }, /* ac: 1010 1100                                */
	{_LDAX,"(HL+B)"  }, /* ad: 1010 1101                                */
	{_LDAX,"(HL+EA)" }, /* ae: 1010 1110                                */
	{_LDAX,"(HL+%b)" }, /* af: 1010 1111 dddd dddd                      */

	{_PUSH,"VA"      }, /* b0: 1011 0000                                */
	{_PUSH,"BC"      }, /* b1: 1011 0001                                */
	{_PUSH,"DE"      }, /* b2: 1011 0010                                */
	{_PUSH,"HL",      }, /* b3: 1011 0011                                */
	{_PUSH,"EA"      }, /* b4: 1011 0100                                */
	{_DMOV,"BC,EA"   }, /* b5: 1011 0101                                */
	{_DMOV,"DE,EA"   }, /* b6: 1011 0110                                */
	{_DMOV,"HL,EA"   }, /* b7: 1011 0111                                */
	{_RET,0       }, /* b8: 1011 1000                                */
	{_RETS,0      }, /* b9: 1011 1001                                */
	{_DI,0            }, /* ba: 1011 1010                                */
	{_STAX,"(DE+%b)" }, /* bb: 1011 1011 dddd dddd                      */
	{_STAX,"(HL+A)"  }, /* bc: 1011 1100                                */
	{_STAX,"(HL+B)"  }, /* bd: 1011 1101                                */
	{_STAX,"(HL+EA)" }, /* be: 1011 1110                                */
	{_STAX,"(HL+%b)" }, /* bf: 1011 1111 dddd dddd                      */

	{_JR,"%o"        }, /* c0: 11oo oooo                                */
	{_JR,"%o"        }, /* c1: 11oo oooo                                */
	{_JR,"%o"        }, /* c2: 11oo oooo                                */
	{_JR,"%o"        }, /* c3: 11oo oooo                                */
	{_JR,"%o"        }, /* c4: 11oo oooo                                */
	{_JR,"%o"        }, /* c5: 11oo oooo                                */
	{_JR,"%o"        }, /* c6: 11oo oooo                                */
	{_JR,"%o"        }, /* c7: 11oo oooo                                */
	{_JR,"%o"        }, /* c8: 11oo oooo                                */
	{_JR,"%o"        }, /* c9: 11oo oooo                                */
	{_JR,"%o"        }, /* ca: 11oo oooo                                */
	{_JR,"%o"        }, /* cb: 11oo oooo                                */
	{_JR,"%o"        }, /* cc: 11oo oooo                                */
	{_JR,"%o"        }, /* cd: 11oo oooo                                */
	{_JR,"%o"        }, /* ce: 11oo oooo                                */
	{_JR,"%o"        }, /* cf: 11oo oooo                                */

	{_JR,"%o"        }, /* d0: 11oo oooo                                */
	{_JR,"%o"        }, /* d1: 11oo oooo                                */
	{_JR,"%o"        }, /* d2: 11oo oooo                                */
	{_JR,"%o"        }, /* d3: 11oo oooo                                */
	{_JR,"%o"        }, /* d4: 11oo oooo                                */
	{_JR,"%o"        }, /* d5: 11oo oooo                                */
	{_JR,"%o"        }, /* d6: 11oo oooo                                */
	{_JR,"%o"        }, /* d7: 11oo oooo                                */
	{_JR,"%o"        }, /* d8: 11oo oooo                                */
	{_JR,"%o"        }, /* d9: 11oo oooo                                */
	{_JR,"%o"        }, /* da: 11oo oooo                                */
	{_JR,"%o"        }, /* db: 11oo oooo                                */
	{_JR,"%o"        }, /* dc: 11oo oooo                                */
	{_JR,"%o"        }, /* dd: 11oo oooo                                */
	{_JR,"%o"        }, /* de: 11oo oooo                                */
	{_JR,"%o"        }, /* df: 11oo oooo                                */

	{_JR,"%o"        }, /* e0: 11oo oooo                                */
	{_JR,"%o"        }, /* e1: 11oo oooo                                */
	{_JR,"%o"        }, /* e2: 11oo oooo                                */
	{_JR,"%o"        }, /* e3: 11oo oooo                                */
	{_JR,"%o"        }, /* e4: 11oo oooo                                */
	{_JR,"%o"        }, /* e5: 11oo oooo                                */
	{_JR,"%o"        }, /* e6: 11oo oooo                                */
	{_JR,"%o"        }, /* e7: 11oo oooo                                */
	{_JR,"%o"        }, /* e8: 11oo oooo                                */
	{_JR,"%o"        }, /* e9: 11oo oooo                                */
	{_JR,"%o"        }, /* ea: 11oo oooo                                */
	{_JR,"%o"        }, /* eb: 11oo oooo                                */
	{_JR,"%o"        }, /* ec: 11oo oooo                                */
	{_JR,"%o"        }, /* ed: 11oo oooo                                */
	{_JR,"%o"        }, /* ee: 11oo oooo                                */
	{_JR,"%o"        }, /* ef: 11oo oooo                                */

	{_JR,"%o"        }, /* f0: 11oo oooo                                */
	{_JR,"%o"        }, /* f1: 11oo oooo                                */
	{_JR,"%o"        }, /* f2: 11oo oooo                                */
	{_JR,"%o"        }, /* f3: 11oo oooo                                */
	{_JR,"%o"        }, /* f4: 11oo oooo                                */
	{_JR,"%o"        }, /* f5: 11oo oooo                                */
	{_JR,"%o"        }, /* f6: 11oo oooo                                */
	{_JR,"%o"        }, /* f7: 11oo oooo                                */
	{_JR,"%o"        }, /* f8: 11oo oooo                                */
	{_JR,"%o"        }, /* f9: 11oo oooo                                */
	{_JR,"%o"        }, /* fa: 11oo oooo                                */
	{_JR,"%o"        }, /* fb: 11oo oooo                                */
	{_JR,"%o"        }, /* fc: 11oo oooo                                */
	{_JR,"%o"        }, /* fd: 11oo oooo                                */
	{_JR,"%o"        }, /* fe: 11oo oooo                                */
	{_JR,"%o"        }  /* ff: 11oo oooo                                */
};

/*********************************************************
 *
 * uPD7801
 *
 *********************************************************/

static const struct dasm_s dasm48_7801[256] = {
	/* 0x00 - 0x3F */
	{ _SKIT, "F0" },     { _SKIT, "FT" },     { _SKIT, "F1" },     { _SKIT, "F2" },
	{ _SKIT, "FS" },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _SK, "CY" },       { _illegal, 0 },
	{ _SK, "Z" },        { _illegal, 0 },     { _PUSH, "VA" },     { _POP, "VA" },

	{ _SKNIT, "F0" },    { _SKNIT, "FT" },    { _SKNIT, "F1" },    { _SKNIT, "F2" },
	{ _SKNIT, "FS" },    { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _SKN, "CY" },      { _illegal, 0 },
	{ _SKN, "Z" },       { _illegal, 0 },     { _PUSH, "BC" },     { _POP, "BC" },

	{ _EI, 0 },          { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _DI, 0 },          { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _CLC, 0 },         { _STC, 0 },
	{ _PER, 0 },         { _PEX, 0 },         { _PUSH, "DE" },     { _POP, "DE" },

	{ _RLL, "A" },       { _RLR, "A" },       { _RLL, "C" },       { _RLR, "C" },
	{ _SLL, "A" },       { _SLR, "A" },       { _SLL, "C" },       { _SLR, "C" },
	{ _RLD, 0 },         { _RRD, 0 },         { _illegal, 0 },     { _illegal, 0 },
	{ _PER, 0 },         { _illegal, 0 },     { _PUSH, "HL" },     { _POP, "HL" },

	/* 0x40 - 0x7F */
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	/* 0x80 - 0xBF */
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	/* 0xC0 - 0xFF */
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 }
};

static const struct dasm_s dasm4c_7801[256] = {
	/* 0x00 - 0x3F */
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },

	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },

	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },

	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },

	/* 0x40 - 0x7F */
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },

	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },

	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },

	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },

	/* 0x80 - 0xBF */
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },

	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },

	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },

	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },
	{ _IN, 0 },          { _IN, 0 },          { _IN, 0 },          { _IN, 0 },

	/* 0xC0 - 0xFF */
	{ _MOV, "A,PA" },    { _MOV, "A,PB" },    { _MOV, "A,PC" },    { _MOV, "A,MK" },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _MOV, "A,S" },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 }
};

static const struct dasm_s dasm4d_7801[256] = {
	/* 0x00 - 0x3F */
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },

	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },

	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },

	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },

	/* 0x40 - 0x7F */
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },

	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },

	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },

	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },

	/* 0x80 - 0xBF */
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },

	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },

	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },

	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },
	{ _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 }, { _OUT, 0 },

	/* 0xC0 - 0xFF */
	{ _MOV, "PA,A" },    { _MOV, "PB,A" },    { _MOV, "PC,A" },    { _MOV, "MK,A" },
	{ _MOV, "MB,A" },    { _MOV, "MC,A" },    { _MOV, "TM0,A" },   { _MOV, "TM1,A" },
	{ _MOV, "S,A" },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }
};

static const struct dasm_s dasm60_7801[256] = {
	/* 0x00 - 0x3F */
	{ _illegal, 0 },     { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _ANA, "V,A" },     { _ANA, "A,A" }, { _ANA, "B,A" }, { _ANA, "C,A" },
	{ _ANA, "D,A" },     { _ANA, "E,A" }, { _ANA, "H,A" }, { _ANA, "L,A" },

	{ _XRA, "V,A" },     { _XRA, "A,A" }, { _XRA, "B,A" }, { _XRA, "C,A" },
	{ _XRA, "D,A" },     { _XRA, "E,A" }, { _XRA, "H,A" }, { _XRA, "L,A" },
	{ _ORA, "V,A" },     { _ORA, "A,A" }, { _ORA, "B,A" }, { _ORA, "C,A" },
	{ _ORA, "D,A" },     { _ORA, "E,A" }, { _ORA, "H,A" }, { _ORA, "L,A" },

	{ _ADDNC, "V,A" },   { _ADDNC, "A,A" }, { _ADDNC, "B,A" }, { _ADDNC, "C,A" },
	{ _ADDNC, "D,A" },   { _ADDNC, "E,A" }, { _ADDNC, "H,A" }, { _ADDNC, "L,A" },
	{ _GTA, "V,A" },     { _GTA, "A,A" }, { _GTA, "B,A" }, { _GTA, "C,A" },
	{ _GTA, "D,A" },     { _GTA, "E,A" }, { _GTA, "H,A" }, { _GTA, "L,A" },

	{ _SUBNB, "V,A" },   { _SUBNB, "A,A" }, { _SUBNB, "B,A" }, { _SUBNB, "C,A" },
	{ _SUBNB, "D,A" },   { _SUBNB, "E,A" }, { _SUBNB, "H,A" }, { _SUBNB, "L,A" },
	{ _LTA, "V,A" },     { _LTA, "A,A" }, { _LTA, "B,A" }, { _LTA, "C,A" },
	{ _LTA, "D,A" },     { _LTA, "E,A" }, { _LTA, "H,A" }, { _LTA, "L,A" },

	/* 0x40 - 0x7F */
	{ _ADD, "V,A" },     { _ADD, "A,A" }, { _ADD, "B,A" }, { _ADD, "C,A" },
	{ _ADD, "D,A" },     { _ADD, "E,A" }, { _ADD, "H,A" }, { _ADD, "L,A" },
	{ _illegal, 0 },     { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _ADC, "V,A" },     { _ADC, "A,A" }, { _ADC, "B,A" }, { _ADC, "C,A" },
	{ _ADC, "D,A" },     { _ADC, "E,A" }, { _ADC, "H,A" }, { _ADC, "L,A" },
	{ _illegal, 0 },     { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _SUB, "V,A" },     { _SUB, "A,A" }, { _SUB, "B,A" }, { _SUB, "C,A" },
	{ _SUB, "D,A" },     { _SUB, "E,A" }, { _SUB, "H,A" }, { _SUB, "L,A" },
	{ _NEA, "V,A" },     { _NEA, "A,A" }, { _NEA, "B,A" }, { _NEA, "C,A" },
	{ _NEA, "D,A" },     { _NEA, "E,A" }, { _NEA, "H,A" }, { _NEA, "L,A" },

	{ _SBB, "V,A" },     { _SBB, "A,A" }, { _SBB, "B,A" }, { _SBB, "C,A" },
	{ _SBB, "D,A" },     { _SBB, "E,A" }, { _SBB, "H,A" }, { _SBB, "L,A" },
	{ _EQA, "V,A" },     { _EQA, "A,A" }, { _EQA, "B,A" }, { _EQA, "C,A" },
	{ _EQA, "D,A" },     { _EQA, "E,A" }, { _EQA, "H,A" }, { _EQA, "L,A" },

	/* 0x80 - 0xBF */
	{ _illegal, 0 },     { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _ANA, "A,V" },     { _ANA, "A,A" }, { _ANA, "A,B" }, { _ANA, "A,C" },
	{ _ANA, "A,D" },     { _ANA, "A,E" }, { _ANA, "A,H" }, { _ANA, "A,L" },

	{ _XRA, "A,V" },     { _XRA, "A,A" }, { _XRA, "A,B" }, { _XRA, "A,C" },
	{ _XRA, "A,D" },     { _XRA, "A,E" }, { _XRA, "A,H" }, { _XRA, "A,L" },
	{ _ORA, "A,V" },     { _ORA, "A,A" }, { _ORA, "A,B" }, { _ORA, "A,C" },
	{ _ORA, "A,D" },     { _ORA, "A,E" }, { _ORA, "A,H" }, { _ORA, "A,L" },

	{ _ADDNC, "A,V" },   { _ADDNC, "A,A" }, { _ADDNC, "A,B" }, { _ADDNC, "A,C" },
	{ _ADDNC, "A,D" },   { _ADDNC, "A,E" }, { _ADDNC, "A,H" }, { _ADDNC, "A,L" },
	{ _GTA, "A,V" },     { _GTA, "A,A" }, { _GTA, "A,B" }, { _GTA, "A,C" },
	{ _GTA, "A,D" },     { _GTA, "A,E" }, { _GTA, "A,H" }, { _GTA, "A,L" },

	{ _SUBNB, "A,V" },   { _SUBNB, "A,A" }, { _SUBNB, "A,B" }, { _SUBNB, "A,C" },
	{ _SUBNB, "A,D" },   { _SUBNB, "A,E" }, { _SUBNB, "A,H" }, { _SUBNB, "A,L" },
	{ _LTA, "A,V" },     { _LTA, "A,A" }, { _LTA, "A,B" }, { _LTA, "A,C" },
	{ _LTA, "A,D" },     { _LTA, "A,E" }, { _LTA, "A,H" }, { _LTA, "A,L" },

	/* 0xC0 - 0xFF */
	{ _ADD, "A,V" },     { _ADD, "A,A" }, { _ADD, "A,B" }, { _ADD, "A,C" },
	{ _ADD, "A,D" },     { _ADD, "A,E" }, { _ADD, "A,H" }, { _ADD, "A,L" },
	{ _ONA, "A,V" },     { _ONA, "A,A" }, { _ONA, "A,B" }, { _ONA, "A,C" },
	{ _ONA, "A,D" },     { _ONA, "A,E" }, { _ONA, "A,H" }, { _ONA, "A,L" },

	{ _ADC, "A,V" },     { _ADC, "A,A" }, { _ADC, "A,B" }, { _ADC, "A,C" },
	{ _ADC, "A,D" },     { _ADC, "A,E" }, { _ADC, "A,H" }, { _ADC, "A,L" },
	{ _OFFA, "A,V" },    { _OFFA, "A,A" }, { _OFFA, "A,B" }, { _OFFA, "A,C" },
	{ _OFFA, "A,D" },    { _OFFA, "A,E" }, { _OFFA, "A,H" }, { _OFFA, "A,L" },

	{ _SUB, "A,V" },     { _SUB, "A,A" }, { _SUB, "A,B" }, { _SUB, "A,C" },
	{ _SUB, "A,D" },     { _SUB, "A,E" }, { _SUB, "A,H" }, { _SUB, "A,L" },
	{ _NEA, "A,V" },     { _NEA, "A,A" }, { _NEA, "A,B" }, { _NEA, "A,C" },
	{ _NEA, "A,D" },     { _NEA, "A,E" }, { _NEA, "A,H" }, { _NEA, "A,L" },

	{ _SBB, "A,V" },     { _SBB, "A,A" }, { _SBB, "A,B" }, { _SBB, "A,C" },
	{ _SBB, "A,D" },     { _SBB, "A,E" }, { _SBB, "A,H" }, { _SBB, "A,L" },
	{ _EQA, "A,V" },     { _EQA, "A,A" }, { _EQA, "A,B" }, { _EQA, "A,C" },
	{ _EQA, "A,D" },     { _EQA, "A,E" }, { _EQA, "A,H" }, { _EQA, "A,L" }
};

static const struct dasm_s dasm64_7801[256] = {
	/* 0x00 - 0x3F */
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _ANI, "V,%b" }, { _ANI, "A,%b" }, { _ANI, "B,%b" }, { _ANI, "C,%b" },
	{ _ANI, "D,%b" }, { _ANI, "E,%b" }, { _ANI, "H,%b" }, { _ANI, "L,%b" },

	{ _XRI, "V,%b" }, { _XRI, "A,%b" }, { _XRI, "B,%b" }, { _XRI, "C,%b" },
	{ _XRI, "D,%b" }, { _XRI, "E,%b" }, { _XRI, "H,%b" }, { _XRI, "L,%b" },
	{ _ORI, "V,%b" }, { _ORI, "A,%b" }, { _ORI, "B,%b" }, { _ORI, "C,%b" },
	{ _ORI, "D,%b" }, { _ORI, "E,%b" }, { _ORI, "H,%b" }, { _ORI, "L,%b" },

	{ _ADINC, "V,%b" }, { _ADINC, "A,%b" }, { _ADINC, "B,%b" }, { _ADINC, "C,%b" },
	{ _ADINC, "D,%b" }, { _ADINC, "E,%b" }, { _ADINC, "H,%b" }, { _ADINC, "L,%b" },
	{ _GTI, "V,%b" }, { _GTI, "A,%b" }, { _GTI, "B,%b" }, { _GTI, "C,%b" },
	{ _GTI, "D,%b" }, { _GTI, "E,%b" }, { _GTI, "H,%b" }, { _GTI, "L,%b" },

	{ _SUINB, "V,%b" }, { _SUINB, "A,%b" }, { _SUINB, "B,%b" }, { _SUINB, "C,%b" },
	{ _SUINB, "D,%b" }, { _SUINB, "E,%b" }, { _SUINB, "H,%b" }, { _SUINB, "L,%b" },
	{ _LTI, "V,%b" }, { _LTI, "A,%b" }, { _LTI, "B,%b" }, { _LTI, "C,%b" },
	{ _LTI, "D,%b" }, { _LTI, "E,%b" }, { _LTI, "H,%b" }, { _LTI, "L,%b" },

	/* 0x40 - 0x7F */
	{ _ADI, "V,%b" }, { _ADI, "A,%b" }, { _ADI, "B,%b" }, { _ADI, "C,%b" },
	{ _ADI, "D,%b" }, { _ADI, "E,%b" }, { _ADI, "H,%b" }, { _ADI, "L,%b" },
	{ _ONI, "V,%b" }, { _ONI, "A,%b" }, { _ONI, "B,%b" }, { _ONI, "C,%b" },
	{ _ONI, "D,%b" }, { _ONI, "E,%b" }, { _ONI, "H,%b" }, { _ONI, "L,%b" },

	{ _ACI, "V,%b" }, { _ACI, "A,%b" }, { _ACI, "B,%b" }, { _ACI, "C,%b" },
	{ _ACI, "D,%b" }, { _ACI, "E,%b" }, { _ACI, "H,%b" }, { _ACI, "L,%b" },
	{ _OFFI, "V,%b" }, { _OFFI, "A,%b" }, { _OFFI, "B,%b" }, { _OFFI, "C,%b" },
	{ _OFFI, "D,%b" }, { _OFFI, "E,%b" }, { _OFFI, "H,%b" }, { _OFFI, "L,%b" },

	{ _SUI, "V,%b" }, { _SUI, "A,%b" }, { _SUI, "B,%b" }, { _SUI, "C,%b" },
	{ _SUI, "D,%b" }, { _SUI, "E,%b" }, { _SUI, "H,%b" }, { _SUI, "L,%b" },
	{ _NEI, "V,%b" }, { _NEI, "A,%b" }, { _NEI, "B,%b" }, { _NEI, "C,%b" },
	{ _NEI, "D,%b" }, { _NEI, "E,%b" }, { _NEI, "H,%b" }, { _NEI, "L,%b" },

	{ _SBI, "V,%b" }, { _SBI, "A,%b" }, { _SBI, "B,%b" }, { _SBI, "C,%b" },
	{ _SBI, "D,%b" }, { _SBI, "E,%b" }, { _SBI, "H,%b" }, { _SBI, "L,%b" },
	{ _EQI, "V,%b" }, { _EQI, "A,%b" }, { _EQI, "B,%b" }, { _EQI, "C,%b" },
	{ _EQI, "D,%b" }, { _EQI, "E,%b" }, { _EQI, "H,%b" }, { _EQI, "L,%b" },

	/* 0x80 - 0xBF */
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _ANI, "PA,%b" }, { _ANI, "PB,%b" }, { _ANI, "PC,%b" }, { _ANI, "MK,%b" },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _XRI, "PA,%b" }, { _XRI, "PB,%b" }, { _XRI, "PC,%b" }, { _XRI, "MK,%b" },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _ORI, "PA,%b" }, { _ORI, "PB,%b" }, { _ORI, "PC,%b" }, { _ORI, "MK,%b" },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _ADINC, "PA,%b" }, { _ADINC, "PB,%b" }, { _ADINC, "PC,%b" }, { _ADINC, "MK,%b" },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _GTI, "PA,%b" }, { _GTI, "PB,%b" }, { _GTI, "PC,%b" }, { _GTI, "MK,%b" },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _SUINB, "PA,%b" }, { _SUINB, "PB,%b" }, { _SUINB, "PC,%b" }, { _SUINB, "MK,%b" },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _LTI, "PA,%b" }, { _LTI, "PB,%b" }, { _LTI, "PC,%b" }, { _LTI, "MK,%b" },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	/* 0xC0 - 0xFF */
	{ _ADI, "PA,%b" }, { _ADI, "PB,%b" }, { _ADI, "PC,%b" }, { _ADI, "MK,%b" },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _ONI, "PA,%b" }, { _ONI, "PB,%b" }, { _ONI, "PC,%b" }, { _ONI, "MK,%b" },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _ACI, "PA,%b" }, { _ACI, "PB,%b" }, { _ACI, "PC,%b" }, { _ACI, "MK,%b" },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _OFFI, "PA,%b" }, { _OFFI, "PB,%b" }, { _OFFI, "PC,%b" }, { _OFFI, "MK,%b" },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _SUI, "PA,%b" }, { _SUI, "PB,%b" }, { _SUI, "PC,%b" }, { _SUI, "MK,%b" },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _NEI, "PA,%b" }, { _NEI, "PB,%b" }, { _NEI, "PC,%b" }, { _NEI, "MK,%b" },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _SBI, "PA,%b" }, { _SBI, "PB,%b" }, { _SBI, "PC,%b" }, { _SBI, "MK,%b" },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _EQI, "PA,%b" }, { _EQI, "PB,%b" }, { _EQI, "PC,%b" }, { _EQI, "MK,%b" },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }
};

static const struct dasm_s dasm70_7801[256] = {
	/* 0x00 - 0x3F */
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _SSPD, "%w" }, { _LSPD, "%w" },

	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _SBCD, "%w" }, { _LBCD, "%w" },

	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _SDED, "%w" }, { _LDED, "%w" },

	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _SHLD, "%w" }, { _LHLD, "%w" },

	/* 0x40 - 0x7F */
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _MOV, "V,%w" }, { _MOV, "A,%w" }, { _MOV, "B,%w" }, { _MOV, "C,%w" },
	{ _MOV, "D,%w" }, { _MOV, "E,%w" }, { _MOV, "H,%w" }, { _MOV, "L,%w" },

	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _MOV, "%w,V" }, { _MOV, "%w,A" }, { _MOV, "%w,B" }, { _MOV, "%w,C" },
	{ _MOV, "%w,D" }, { _MOV, "%w,E" }, { _MOV, "%w,H" }, { _MOV, "%w,L" },

	/* 0x80 - 0xBF */
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _ANAX, "BC" }, { _ANAX, "DE" }, { _ANAX, "HL" },
	{ _ANAX, "DE+" }, { _ANAX, "HL+" }, { _ANAX, "DE-" }, { _ANAX, "HL-" },

	{ _illegal, 0 }, { _XRAX, "BC" }, { _XRAX, "DE" }, { _XRAX, "HL" },
	{ _XRAX, "DE+" }, { _XRAX, "HL+" }, { _XRAX, "DE-" }, { _XRAX, "HL-" },
	{ _illegal, 0 }, { _ORAX, "BC" }, { _ORAX, "DE" }, { _ORAX, "HL" },
	{ _ORAX, "DE+" }, { _ORAX, "HL+" }, { _ORAX, "DE-" }, { _ORAX, "HL-" },

	{ _illegal, 0 }, { _ADDNCX, "BC" }, { _ADDNCX, "DE" }, { _ADDNCX, "HL" },
	{ _ADDNCX, "DE+" }, { _ADDNCX, "HL+" }, { _ADDNCX, "DE-" }, { _ADDNCX, "HL-" },
	{ _illegal, 0 }, { _GTAX, "BC" }, { _GTAX, "DE" }, { _GTAX, "HL" },
	{ _GTAX, "DE+" }, { _GTAX, "HL+" }, { _GTAX, "DE-" }, { _GTAX, "HL-" },

	{ _illegal, 0 }, { _SUBNBX, "BC" }, { _SUBNBX, "DE" }, { _SUBNBX, "HL" },
	{ _SUBNBX, "DE+" }, { _SUBNBX, "HL+" }, { _SUBNBX,  }, { _SUBNBX, "HL-" },
	{ _illegal, 0 }, { _LTAX, "BC" }, { _LTAX, "DE" }, { _LTAX, "HL" },
	{ _LTAX, "DE+" }, { _LTAX, "HL+" }, { _LTAX, "DE-" }, { _LTAX, "HL-" },

	/* 0xC0 - 0xFF */
	{ _illegal, 0 }, { _ADDX, "BC" }, { _ADDX, "DE" }, { _ADDX, "HL" },
	{ _ADDX, "DE+" }, { _ADDX, "HL+" }, { _ADDX, "DE-" }, { _ADDX, "HL-" },
	{ _illegal, 0 }, { _ONAX, "BC" }, { _ONAX, "DE" }, { _ONAX, "HL" },
	{ _ONAX, "DE+" }, { _ONAX, "HL+" }, { _ONAX, "DE-" }, { _ONAX, "HL-" },

	{ _illegal, 0 }, { _ADCX, "BC" }, { _ADCX, "DE" }, { _ADCX, "HL" },
	{ _ADCX, "DE+" }, { _ADCX, "HL+" }, { _ADCX, "DE-" }, { _ADCX, "HL-" },
	{ _illegal, 0 }, { _OFFAX, "BC" }, { _OFFAX, "DE" }, { _OFFAX, "HL" },
	{ _OFFAX, "DE+" }, { _OFFAX, "HL+" }, { _OFFAX, "DE-" }, { _OFFAX, "HL-" },

	{ _illegal, 0 }, { _SUBX, "BC" }, { _SUBX, "DE" }, { _SUBX, "HL" },
	{ _SUBX, "DE+" }, { _SUBX, "HL+" }, { _SUBX, "DE-" }, { _SUBX, "HL-" },
	{ _illegal, 0 }, { _NEAX, "BC" }, { _NEAX, "DE" }, { _NEAX, "HL" },
	{ _NEAX, "DE+" }, { _NEAX, "HL+" }, { _NEAX, "DE-" }, { _NEAX, "HL-" },

	{ _illegal, 0 }, { _SBBX, "BC" }, { _SBBX, "DE" }, { _SBBX, "HL" },
	{ _SBBX, "DE+" }, { _SBBX, "HL+" }, { _SBBX, "DE-" }, { _SBBX, "HL-" },
	{ _illegal, 0 }, { _EQAX, "BC" }, { _EQAX, "DE" }, { _EQAX, "HL" },
	{ _EQAX, "DE+" }, { _EQAX, "HL+" }, { _EQAX, "DE-" }, { _EQAX, "HL-" },
};

static const struct dasm_s dasm74_7801[256] = {
	/* 0x00 - 0x3F */
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	/* 0x40 - 0x7F */
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	/* 0x80 - 0xBF */
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _ANAW, "%a" }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _XRAW, "%a" }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _ORAW, "%a" }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _ADDNCW, "%a" }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _GTAW, "%a" }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _SUBNBW, "%a" }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _LTAW, "%a" }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	/* 0xC0 - 0xFF */
	{ _ADDW, "%a" }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _ONAW, "%a" }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _ADCW, "%a" }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _OFFAW, "%a" }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _SUBW, "%a" }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _NEAW, "%a" }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },

	{ _SBBW, "%a" }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _EQAW, "%a" }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 },
	{ _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }, { _illegal, 0 }
};

static const struct dasm_s dasmXX_7801[256] = {
	/* 0x00 - 0x3F */
	{ _NOP, 0 },         { _HALT, 0 },        { _INX, "SP" },      { _DCX, "SP" },
	{ _LXI, "SP,%w" },   { _ANIW, "%a,%b" },  { _illegal, 0 },     { _ANI, "A,%b" },
	{ _RET, 0 },         { _SIO, 0 },         { _MOV, "A,B" },     { _MOV, "A,C" },
	{ _MOV, "A,D" },     { _MOV, "A,E" },     { _MOV, "A,H" },     { _MOV, "A,L" },

	{ _EX, 0 },          { _EXX, 0 },         { _INX, "BC" },      { _DCX, "BC" },
	{ _LXI, "BC,%w" },   { _ORIW, "%a,%b" },  { _XRI, "A,%b" },    { _ORI, "A,%b" },
	{ _RETS, 0 },        { _STM, 0 },         { _MOV, "B,A" },     { _MOV, "C,A" },
	{ _MOV, "D,A" },     { _MOV, "E,A" },     { _MOV, "H,A" },     { _MOV, "L,A" },

	{ _INRW, "%a" },     { _TABLE, 0 },       { _INX, "DE" },      { _DCX, "DE" },
	{ _LXI, "DE,%w" },   { _GTIW, "%a,%b" },  { _ADINC, "A,%b" },  { _GTI, "A,%b" },
	{ _LDAW, "%a" },     { _LDAX, "BC" },     { _LDAX, "DE" },     { _LDAX, "HL" },
	{ _LDAX, "DE+" },    { _LDAX, "HL+" },    { _LDAX, "DE-" },    { _LDAX, "HL-" },

	{ _DCRW, "%a" },     { _BLOCK, 0 },       { _INX, "HL" },      { _DCX, "HL" },
	{ _LXI, "HL,%w" },   { _LTIW, "%a,%b" },  { _SUINB, "A,%b" },  { _LTI, "A,%b" },
	{ _STAW, "%a" },     { _STAX, "BC" },     { _STAX, "DE" },     { _STAX, "HL" },
	{ _STAX, "DE+" },    { _STAX, "HL+" },    { _STAX, "DE-" },    { _STAX, "HL-" },

	/* 0x40 - 0x7F */
	{ _illegal, 0 },     { _INR, "A" },       { _INR, "B" },       { _INR, "C" },
	{ _CALL, "%w" },     { _ONIW, "%a,%b" },  { _ADI, "A,%b" },    { _ONI, "A,%b" },
	{ 0, dasm48_7801 }, { _MVIX, "BC,%b" },  { _MVIX, "DE,%b" },  { _MVIX, "HL,%b" },
	{ 0, dasm4c_7801 }, { 0, dasm4d_7801 }, { _JRE, "%d" },      { _JRE, "%d" },

	{ _illegal, 0 },     { _DCR, "A" },       { _DCR, "B" },       { _DCR, "C" },
	{ _JMP, "%w" },      { _OFFIW, "%a,%b" }, { _ACI, "A,%b" },    { _OFFI, "A,%b" },
	{ _BIT, "0,%a" },    { _BIT, "1,%a" },    { _BIT, "2,%a" },    { _BIT, "3,%a" },
	{ _BIT, "4,%a" },    { _BIT, "5,%a" },    { _BIT, "6,%a" },    { _BIT, "7,%a" },

	{ 0, dasm60_7801 }, { _DAA, 0 },         { _RETI, 0 },        { _CALB, 0 },
	{ 0, dasm64_7801 }, { _NEIW, "%a,%b" },  { _SUI, "A,%b" },    { _NEI, "A,%b" },
	{ _MVI, "V,%b" },    { _MVI, "A,%b" },    { _MVI, "B,%b" },    { _MVI, "C,%b" },
	{ _MVI, "D,%b" },    { _MVI, "E,%b" },    { _MVI, "H,%b" },    { _MVI, "L,%b" },

	{ 0, dasm70_7801 }, { _MVIW, "%a,%b" },  { _SOFTI, 0 },       { _JB, 0 },
	{ 0, dasm74_7801 }, { _EQIW, "%a,%b" },  { _SBI, "A,%b" },    { _EQI, "A,%b" },
	{ _CALF, "%f" },     { _CALF, "%f" },     { _CALF, "%f" },     { _CALF, "%f" },
	{ _CALF, "%f" },     { _CALF, "%f" },     { _CALF, "%f" },     { _CALF, "%f" },

	/* 0x80 - 0xBF */
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },

	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },

	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },

	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },

	/* 0xC0 - 0xFF */
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },

	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },

	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },

	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" }
};

/*********************************************************
 *
 * uPD7801
 *
 *********************************************************/

static const struct dasm_s dasm48_78c05[256] = {
	/* 0x00 - 0x3F */
	{ _SKIT, "F0" },     { _SKIT, "FT" },     { _SKIT, "F1" },     { _illegal, 0 }, /* TODO: PDF doesn't mention SKIT and SK */
	{ _SKIT, "FS" },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _SK, "CY" },       { _illegal, 0 },
	{ _SK, "Z" },        { _illegal, 0 },     { _PUSH, "VA" },     { _POP, "VA" },

	{ _SKNIT, "F0" },    { _SKNIT, "FT" },    { _SKNIT, "F1" },    { _illegal, 0 },
	{ _SKNIT, "FS" },    { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _SKN, "CY" },      { _illegal, 0 },
	{ _SKN, "Z" },       { _illegal, 0 },     { _PUSH, "BC" },     { _POP, "BC" },

	{ _EI, 0 },          { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _DI, 0 },          { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _CLC, 0 },         { _STC, 0 },
	{ _illegal, 0 },     { _PEX, 0 },         { _PUSH, "DE" },     { _POP, "DE" },

	{ _RLL, "A" },       { _RLR, "A" },       { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _RLD, 0 },         { _RRD, 0 },         { _illegal, 0 },     { _illegal, 0 },
	{ _PER, 0 },         { _illegal, 0 },     { _PUSH, "HL" },     { _POP, "HL" },

	/* 0x40 - 0x7F */
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	/* 0x80 - 0xBF */
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	/* 0xC0 - 0xFF */
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 }
};

static const struct dasm_s dasm4c_78c05[256] = {
	/* 0x00 - 0x3F */
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	/* 0x40 - 0x7F */
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	/* 0x80 - 0xBF */
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	/* 0xC0 - 0xFF */
	{ _MOV, "A,PA" },    { _MOV, "A,PB" },    { _MOV, "A,PC" },    { _MOV, "A,MK" },
	{ _MOV, "A,MB" },    { _MOV, "A,MC" },    { _MOV, "A,TM0" },   { _MOV, "A,TM1" },
	{ _MOV, "A,S" },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 }, /* TODO: Figure out what regsiter C9 indicates */
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 }
};

static const struct dasm_s dasm4d_78c05[256] = {
	/* 0x00 - 0x3F */
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	/* 0x40 - 0x7F */
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	/* 0x80 - 0xBF */
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	/* 0xC0 - 0xFF */
	{ _MOV, "PA,A" },    { _MOV, "PB,A" },    { _MOV, "PC,A" },    { _MOV, "MK,A" },
	{ _MOV, "MB,A" },    { _MOV, "MC,A" },    { _MOV, "TM0,A" },   { _MOV, "TM1,A" },
	{ _MOV, "S,A" },     { _MOV, "TMM,A" },   { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 }
};

static const struct dasm_s dasm60_78c05[256] = {
	/* 0x00 - 0x3F */
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _ANA, "A,A" },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _XRA, "A,A" },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _ORA, "A,A" },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _ADDNC, "A,A" },   { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _GTA, "A,A" },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _SUBNB, "A,A" },   { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _LTA, "A,A" },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	/* 0x40 - 0x7F */
	{ _illegal, 0 },     { _ADD, "A,A" },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _ADC, "A,A" },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _SUB, "A,A" },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _NEA, "A,A" },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _SBB, "A,A" },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _EQA, "A,A" },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	/* 0x80 - 0xBF */
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _ANA, "A,A" },     { _ANA, "A,B" },     { _ANA, "A,C" },
	{ _ANA, "A,D" },     { _ANA, "A,E" },     { _ANA, "A,H" },     { _ANA, "A,L" },

	{ _illegal, 0 },     { _XRA, "A,A" },     { _XRA, "A,B" },     { _XRA, "A,C" },
	{ _XRA, "A,D" },     { _XRA, "A,E" },     { _XRA, "A,H" },     { _XRA, "A,L" },
	{ _illegal, 0 },     { _ORA, "A,A" },     { _ORA, "A,B" },     { _ORA, "A,C" },
	{ _ORA, "A,D" },     { _ORA, "A,E" },     { _ORA, "A,H" },     { _ORA, "A,L" },

	{ _illegal, 0 },     { _ADDNC, "A,A" },   { _ADDNC, "A,B" },   { _ADDNC, "A,C" },
	{ _ADDNC, "A,D" },   { _ADDNC, "A,E" },   { _ADDNC, "A,H" },   { _ADDNC, "A,L" },
	{ _illegal, 0 },     { _GTA, "A,A" },     { _GTA, "A,B" },     { _GTA, "A,C" },
	{ _GTA, "A,D" },     { _GTA, "A,E" },     { _GTA, "A,H" },     { _GTA, "A,L" },

	{ _illegal, 0 },     { _SUBNB, "A,A" },   { _SUBNB, "A,B" },   { _SUBNB, "A,C" },
	{ _SUBNB, "A,D" },   { _SUBNB, "A,E" },   { _SUBNB, "A,H" },   { _SUBNB, "A,L" },
	{ _illegal, 0 },     { _LTA, "A,A" },     { _LTA, "A,B" },     { _LTA, "A,C" },
	{ _LTA, "A,D" },     { _LTA, "A,E" },     { _LTA, "A,H" },     { _LTA, "A,L" },

	/* 0xC0 - 0xFF */
	{ _illegal, 0 },     { _ADD, "A,A" },     { _ADD, "A,B" },     { _ADD, "A,C" },
	{ _ADD, "A,D" },     { _ADD, "A,E" },     { _ADD, "A,H" },     { _ADD, "A,L" },
	{ _illegal, 0 },     { _ONA, "A,A" },     { _ONA, "A,B" },     { _ONA, "A,C" },
	{ _ONA, "A,D" },     { _ONA, "A,E" },     { _ONA, "A,H" },     { _ONA, "A,L" },

	{ _illegal, 0 },     { _ADC, "A,A" },     { _ADC, "A,B" },     { _ADC, "A,C" },
	{ _ADC, "A,D" },     { _ADC, "A,E" },     { _ADC, "A,H" },     { _ADC, "A,L" },
	{ _illegal, 0 },     { _OFFA, "A,A" },    { _OFFA, "A,B" },    { _OFFA, "A,C" },
	{ _OFFA, "A,D" },    { _OFFA, "A,E" },    { _OFFA, "A,H" },    { _OFFA, "A,L" },

	{ _illegal, 0 },     { _SUB, "A,A" },     { _SUB, "A,B" },     { _SUB, "A,C" },
	{ _SUB, "A,D" },     { _SUB, "A,E" },     { _SUB, "A,H" },     { _SUB, "A,L" },
	{ _illegal, 0 },     { _NEA, "A,A" },     { _NEA, "A,B" },     { _NEA, "A,C" },
	{ _NEA, "A,D" },     { _NEA, "A,E" },     { _NEA, "A,H" },     { _NEA, "A,L" },

	{ _illegal, 0 },     { _SBB, "A,A" },     { _SBB, "A,B" },     { _SBB, "A,C" },
	{ _SBB, "A,D" },     { _SBB, "A,E" },     { _SBB, "A,H" },     { _SBB, "A,L" },
	{ _illegal, 0 },     { _EQA, "A,A" },     { _EQA, "A,B" },     { _EQA, "A,C" },
	{ _EQA, "A,D" },     { _EQA, "A,E" },     { _EQA, "A,H" },     { _EQA, "A,L" }
};

static const struct dasm_s dasm64_78c05[256] = {
	/* 0x00 - 0x3F */
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _ANI, "A,%b" },    { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _XRI, "A,%b" },    { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _ORI, "A,%b" },    { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _ADINC, "A,%b" },  { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _GTI, "A,%b" },    { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _SUINB, "A,%b" },  { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _LTI, "A,%b" },    { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	/* 0x40 - 0x7F */
	{ _illegal, 0 },     { _ADI, "A,%b" },    { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _ONI, "A,%b" },    { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _ACI, "A,%b" },    { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _OFFI, "A,%b" },   { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _SUI, "A,%b" },    { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _NEI, "A,%b" },    { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _SBI, "A,%b" },    { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _EQI, "A,%b" },    { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	/* 0x80 - 0xBF */
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _ANI, "PA,%b" },   { _ANI, "PB,%b" },   { _ANI, "PC,%b" },   { _ANI, "MK,%b" },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _XRI, "PA,%b" },   { _XRI, "PB,%b" },   { _XRI, "PC,%b" },   { _XRI, "MK,%b" },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _ORI, "PA,%b" },   { _ORI, "PB,%b" },   { _ORI, "PC,%b" },   { _ORI, "MK,%b" },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _ADINC, "PA,%b" }, { _ADINC, "PB,%b" }, { _ADINC, "PC,%b" }, { _ADINC, "MK,%b" },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _GTI, "PA,%b" },   { _GTI, "PB,%b" },   { _GTI, "PC,%b" },   { _GTI, "MK,%b" },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _SUINB, "PA,%b" }, { _SUINB, "PB,%b" }, { _SUINB, "PC,%b" }, { _SUINB, "MK,%b" },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _LTI, "PA,%b" },   { _LTI, "PB,%b" },   { _LTI, "PC,%b" },   { _LTI, "MK,%b" },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	/* 0xC0 - 0xFF */
	{ _ADI, "PA,%b" },   { _ADI, "PB,%b" },   { _ADI, "PC,%b" },   { _ADI, "MK,%b" },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _ONI, "PA,%b" },   { _ONI, "PB,%b" },   { _ONI, "PC,%b" },   { _ONI, "MK,%b" },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _ACI, "PA,%b" },   { _ACI, "PB,%b" },   { _ACI, "PC,%b" },   { _ACI, "MK,%b" },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _SUI, "PA,%b" },   { _SUI, "PB,%b" },   { _SUI, "PC,%b" },   { _SUI, "MK,%b" },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _NEI, "PA,%b" },   { _NEI, "PB,%b" },   { _NEI, "PC,%b" },   { _NEI, "MK,%b" },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _SBI, "PA,%b" },   { _SBI, "PB,%b" },   { _SBI, "PC,%b" },   { _SBI, "MK,%b" },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _SBI, "PA,%b" },   { _SBI, "PB,%b" },   { _SBI, "PC,%b" },   { _SBI, "MK,%b" },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _EQI, "PA,%b" },   { _EQI, "PB,%b" },   { _EQI, "PC,%b" },   { _EQI, "MK,%b" },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 }
};

static const struct dasm_s dasm70_78c05[256] = {
	/* 0x00 - 0x3F */
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _SSPD, "%w" },     { _LSPD, "%w" },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _SBCD, "%w" },     { _LBCD, "%w" },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _SDED, "%w" },     { _LDED, "%w" },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _SHLD, "%w" },     { _LHLD, "%w" },

	/* 0x40 - 0x7F */
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _MOV, "A,%w" },    { _MOV, "B,%w" },    { _MOV, "C,%w" },
	{ _MOV, "D,%w" },    { _MOV, "E,%w" },    { _MOV, "H,%w" },    { _MOV, "L,%w" },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _MOV, "%w,A" },    { _MOV, "%w,B" },    { _MOV, "%w,C" },
	{ _MOV, "%w,D" },    { _MOV, "%w,E" },    { _MOV, "%w,H" },    { _MOV, "%w,L" },

	/* 0x80 - 0xBF */
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _ANAX, "BC" },     { _ANAX, "DE" },     { _ANAX, "HL" },
	{ _ANAX, "DE+" },    { _ANAX, "HL+" },    { _ANAX, "DE-" },    { _ANAX, "HL-" },

	{ _illegal, 0 },     { _XRAX, "BC" },     { _XRAX, "DE" },     { _XRAX, "HL" },
	{ _XRAX, "DE+" },    { _XRAX, "HL+" },    { _XRAX, "DE-" },    { _XRAX, "HL-" },
	{ _illegal, 0 },     { _ORAX, "BC" },     { _ORAX, "DE" },     { _ORAX, "HL" },
	{ _ORAX, "DE+" },    { _ORAX, "HL+" },    { _ORAX, "DE-" },    { _ORAX, "HL-" },

	{ _illegal, 0 },     { _ADDNCX, "BC" },   { _ADDNCX, "DE" },   { _ADDNCX, "HL" },
	{ _ADDNCX, "DE+" },  { _ADDNCX, "HL+" },  { _ADDNCX, "DE-" },  { _ADDNCX, "HL-" },
	{ _illegal, 0 },     { _GTAX, "BC" },     { _GTAX, "DE" },     { _GTAX, "HL" },
	{ _GTAX, "DE+" },    { _GTAX, "HL+" },    { _GTAX, "DE-" },    { _GTAX, "HL-" },

	{ _illegal, 0 },     { _SUBNBX, "BC" },   { _SUBNBX, "DE" },   { _SUBNBX, "HL" },
	{ _SUBNBX, "DE+" },  { _SUBNBX, "HL+" },  { _SUBNBX, "DE-" },  { _SUBNBX, "HL-" },
	{ _illegal, 0 },     { _LTAX, "BC" },     { _LTAX, "DE" },     { _LTAX, "HL" },
	{ _LTAX, "DE+" },    { _LTAX, "HL+" },    { _LTAX, "DE-" },    { _LTAX, "HL-" },

	/* 0xC0 - 0xFF */
	{ _illegal, 0 },     { _ADDX, "BC" },     { _ADDX, "DE" },     { _ADDX, "HL" },
	{ _ADDX, "DE+" },    { _ADDX, "HL+" },    { _ADDX, "DE-" },    { _ADDX, "HL-" },
	{ _illegal, 0 },     { _ONAX, "BC" },     { _ONAX, "DE" },     { _ONAX, "HL" },
	{ _ONAX, "DE+" },    { _ONAX, "HL+" },    { _ONAX, "DE-" },    { _ONAX, "HL-" },

	{ _illegal, 0 },     { _ADCX, "BC" },     { _ADCX, "DE" },     { _ADCX, "HL" },
	{ _ADCX, "DE+" },    { _ADCX, "HL+" },    { _ADCX, "DE-" },    { _ADCX, "HL-" },
	{ _illegal, 0 },     { _OFFAX, "BC" },    { _OFFAX, "DE" },    { _OFFAX, "HL" },
	{ _OFFAX, "DE+" },   { _OFFAX, "HL+" },   { _OFFAX, "DE-" },   { _OFFAX, "HL-" },

	{ _illegal, 0 },     { _SUBX, "BC" },     { _SUBX, "DE" },     { _SUBX, "HL" },
	{ _SUBX, "DE+" },    { _SUBX, "HL+" },    { _SUBX, "DE-" },    { _SUBX, "HL-" },
	{ _illegal, 0 },     { _NEAX, "BC" },     { _NEAX, "DE" },     { _NEAX, "HL" },
	{ _NEAX, "DE+" },    { _NEAX, "HL+" },    { _NEAX, "DE-" },    { _NEAX, "HL-" },

	{ _illegal, 0 },     { _SBBX, "BC" },     { _SBBX, "DE" },     { _SBBX, "HL" },
	{ _SBBX, "DE+" },    { _SBBX, "HL+" },    { _SBBX, "DE-" },    { _SBBX, "HL-" },
	{ _illegal, 0 },     { _EQAX, "BC" },     { _EQAX, "DE" },     { _EQAX, "HL" },
	{ _EQAX, "DE+" },    { _EQAX, "HL+" },    { _EQAX, "DE-" },    { _EQAX, "HL-" },
};

static const struct dasm_s dasm74_78c05[256] = {
	/* 0x00 - 0x3F */
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	/* 0x40 - 0x7F */
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	/* 0x80 - 0xBF */
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _ANAW, "%a" },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _XRAW, "%a" },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _ORAW, "%a" },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _ADDNCW, "%a" },   { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _GTAW, "%a" },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _SUBNBW, "%a" },   { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _LTAW, "%a" },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	/* 0xC0 - 0xFF */
	{ _ADDW, "%a" },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _ONAW, "%a" },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _ADCW, "%a" },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _OFFAW, "%a" },    { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _SUBW, "%a" },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _NEAW, "%a" },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ _SBBW, "%a" },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _EQAW, "%a" },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
};

static const struct dasm_s dasmXX_78c05[256] = {
	/* 0x00 - 0x3F */
	{ _NOP, 0 },         { _HALT, 0 },        { _INX, "SP" },      { _DCX, "SP" },
	{ _LXI, "SP,%w" },   { _ANIW, "%a,%b" },  { _illegal, 0 },     { _ANI, "A,%b" },
	{ _RET, 0 },         { _SIO, 0 },         { _MOV, "A,B" },     { _MOV, "A,C" },
	{ _MOV, "A,D" },     { _MOV, "A,E" },     { _MOV, "A,H" },     { _MOV, "A,L" },

	{ _illegal, 0 },     { _illegal, 0 },     { _INX, "BC" },      { _DCX, "BC" },
	{ _LXI, "BC,%w" },   { _ORIW, "%a,%b" },  { _XRI, "A,%b" },    { _ORI, "A,%b" },
	{ _RETS, 0 },        { _STM, 0 },         { _MOV, "B,A" },     { _MOV, "C,A" },
	{ _MOV, "D,A" },     { _MOV, "E,A" },     { _MOV, "H,A" },     { _MOV, "L,A" },

	{ _INRW, "%a" },     { _illegal, 0 },     { _INX, "DE" },      { _DCX, "DE" },
	{ _LXI, "DE,%w" },   { _GTIW, "%a,%b" },  { _ADINC, "A,%b" },  { _GTI, "A,%b" },
	{ _LDAW, "%a" },     { _LDAX, "BC" },     { _LDAX, "DE" },     { _LDAX, "HL" },
	{ _LDAX, "DE+" },    { _LDAX, "HL+" },    { _LDAX, "DE-" },    { _LDAX, "HL-" },

	{ _DCRW, "%a" },     { _illegal, 0 },     { _INX, "HL" },      { _DCX, "HL" },
	{ _LXI, "HL,%w" },   { _LTIW, "%a,%b" },  { _SUINB, "A,%b" },  { _LTI, "A,%b" },
	{ _STAW, "%a" },     { _STAX, "BC" },     { _STAX, "DE" },     { _STAX, "HL" },
	{ _STAX, "DE+" },    { _STAX, "HL+" },    { _STAX, "DE-" },    { _STAX, "HL-" },

	/* 0x40 - 0x7F */
	{ _illegal, 0 },     { _INR, "A" },       { _INR, "B" },       { _INR, "C" },
	{ _CALL, "%w" },     { _ONIW, "%a,%b" },  { _ADI, "A,%b" },    { _ONI, "A,%b" },
	{ 0, dasm48_78c05 },    { _illegal, 0 }, { _illegal, 0 },     { _illegal, 0 },
	{ 0, dasm4c_78c05 },    { 0, dasm4d_78c05 },    { _JRE, "%d" },      { _JRE, "%d" },

	{ _illegal, 0 },     { _DCR, "A" },       { _DCR, "B" },       { _DCR, "C" },
	{ _JMP, "%w" },      { _OFFIW, "%a,%b" }, { _ACI, "A,%b" },    { _OFFI, "A,%b" },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },
	{ _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },     { _illegal, 0 },

	{ 0, dasm60_78c05 },    { _DAA, 0 },         { _RETI, 0 },        { _CALB, 0 },
	{ 0, dasm64_78c05 },    { _NEIW, "%a,%b" },  { _SUI, "A,%b" },    { _NEI, "A,%b" },
	{ _illegal, 0 },     { _MVI, "A,%b" },    { _MVI, "B,%b" },    { _MVI, "C,%b" },
	{ _MVI, "D,%b" },    { _MVI, "E,%b" },    { _MVI, "H,%b" },    { _MVI, "L,%b" },

	{ 0, dasm70_78c05 },    { _MVIW, "%a,%b" },  { _SOFTI, 0 },       { _JB, 0 },
	{ 0, dasm74_78c05 },    { _EQIW, "%a,%b" },  { _SBI, "A,%b" },    { _EQI, "A,%b" },
	{ _CALF, "%f" },     { _CALF, "%f" },     { _CALF, "%f" },     { _CALF, "%f" },
	{ _CALF, "%f" },     { _CALF, "%f" },     { _CALF, "%f" },     { _CALF, "%f" },

	/* 0x80 - 0xBF */
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },

	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },

	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },

	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },
	{ _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },     { _CALT, "%t" },

	/* 0xC0 - 0xFF */
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },

	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },

	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },

	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },
	{ _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" },       { _JR, "%o" }
};

/*********************************************************
 *
 * uPD7907 (from PockEmu)
 *
 *********************************************************/

static const struct dasm_s dasm48_7907[256] = {
	/* 0x00 - 0x3F */
	{ _SKIT, "F0" },	{ _SKIT, "FT" },	{ _SKIT, "F1" },	{ _illegal, 0 },  /* TODO: PDF doesn't mention SKIT and SK */
	{ _SKIT, "FS" },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _SK, "CY" },		{ _illegal, 0 },
	{ _SK, "Z" },		{ _illegal, 0 },	{ _PUSH, "VA" },	{ _POP, "VA" },

	{ _SKNIT, "F0" },	{ _SKNIT, "FT" },	{ _SKNIT, "F1" },	{ _illegal, 0 },
	{ _SKNIT, "FS" },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _SKN, "CY" },		{ _illegal, 0 },
	{ _SKN, "Z" },		{ _illegal, 0 },	{ _PUSH, "BC" },	{ _POP, "BC" },

	{ _EI, 0 },		{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _DI, 0 },		{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _CLC, 0 },		{ _STC, 0 },
	{ _illegal, 0 },	{ _PEX, 0 },		{ _PUSH, "DE" },	{ _POP, "DE" },

	{ _RLL, "A" },		{ _RLR, "A" },		{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _RLD, 0 },		{ _RRD, 0 },		{ _illegal, 0 },	{ _illegal, 0 },
	{ _PER, 0 },		{ _illegal, 0 },	{ _PUSH, "HL" },	{ _POP, "HL" },

	/* 0x40 - 0x7F */
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	/* 0x80 - 0xBF */
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	/* 0xC0 - 0xFF */
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 }
};

static const struct dasm_s dasm4c_7907[256] = {
	/* 0x00 - 0x3F */
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	/* 0x40 - 0x7F */
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	/* 0x80 - 0xBF */
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	/* 0xC0 - 0xFF */
	{ _MOV, "A,PA" },	{ _MOV, "A,PB" },	{ _MOV, "A,PC" },	{ _MOV, "A,MK" },
	{ _MOV, "A,MB" },	{ _MOV, "A,MC" },	{ _MOV, "A,TM0" },	{ _MOV, "A,TM1" },
	{ _MOV, "A,S" },	{ _illegal, 0 },	{ _illegal, 0 },	{ _MOV,"A,EOM"  },  /* TODO: Figure out what regsiter C9 indicates */
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 }
};

static const struct dasm_s dasm4d_7907[256] = {
	/* 0x00 - 0x3F */
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	/* 0x40 - 0x7F */
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	/* 0x80 - 0xBF */
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	/* 0xC0 - 0xFF */
	{ _MOV, "PA,A" },	{ _MOV, "PB,A" },	{ _MOV, "PC,A" },	{ _MOV, "MK,A" },
	{ _MOV, "MB,A" },	{ _MOV, "MC,A" },	{ _MOV, "TM0,A" },	{ _MOV, "TM1,A" },
	{ _MOV, "S,A" },	{ _MOV, "TMM,A" },	{ _MOV, "SML,A" },	{ _MOV,"EOM,A" },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 }
};

static const struct dasm_s dasm60_7907[256] = {
	/* 0x00 - 0x3F */
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _ANA, "A,A" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _XRA, "A,A" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _ORA, "A,A" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _ADDNC, "A,A" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _GTA, "A,A" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _SUBNB, "A,A" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _LTA, "A,A" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	/* 0x40 - 0x7F */
	{ _illegal, 0 },	{ _ADD, "A,A" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _ADC, "A,A" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _SUB, "A,A" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _NEA, "A,A" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _SBB, "A,A" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _EQA, "A,A" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	/* 0x80 - 0xBF */
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _ANA, "A,A" },	{ _ANA, "A,B" },	{ _ANA, "A,C" },
	{ _ANA, "A,D" },	{ _ANA, "A,E" },	{ _ANA, "A,H" },	{ _ANA, "A,L" },

	{ _illegal, 0 },	{ _XRA, "A,A" },	{ _XRA, "A,B" },	{ _XRA, "A,C" },
	{ _XRA, "A,D" },	{ _XRA, "A,E" },	{ _XRA, "A,H" },	{ _XRA, "A,L" },
	{ _illegal, 0 },	{ _ORA, "A,A" },	{ _ORA, "A,B" },	{ _ORA, "A,C" },
	{ _ORA, "A,D" },	{ _ORA, "A,E" },	{ _ORA, "A,H" },	{ _ORA, "A,L" },

	{ _illegal, 0 },	{ _ADDNC, "A,A" },	{ _ADDNC, "A,B" },	{ _ADDNC, "A,C" },
	{ _ADDNC, "A,D" },	{ _ADDNC, "A,E" },	{ _ADDNC, "A,H" },	{ _ADDNC, "A,L" },
	{ _illegal, 0 },	{ _GTA, "A,A" },	{ _GTA, "A,B" },	{ _GTA, "A,C" },
	{ _GTA, "A,D" },	{ _GTA, "A,E" },	{ _GTA, "A,H" },	{ _GTA, "A,L" },

	{ _illegal, 0 },	{ _SUBNB, "A,A" },	{ _SUBNB, "A,B" },	{ _SUBNB, "A,C" },
	{ _SUBNB, "A,D" },	{ _SUBNB, "A,E" },	{ _SUBNB, "A,H" },	{ _SUBNB, "A,L" },
	{ _illegal, 0 },	{ _LTA, "A,A" },	{ _LTA, "A,B" },	{ _LTA, "A,C" },
	{ _LTA, "A,D" },	{ _LTA, "A,E" },	{ _LTA, "A,H" },	{ _LTA, "A,L" },

	/* 0xC0 - 0xFF */
	{ _illegal, 0 },	{ _ADD, "A,A" },	{ _ADD, "A,B" },	{ _ADD, "A,C" },
	{ _ADD, "A,D" },	{ _ADD, "A,E" },	{ _ADD, "A,H" },	{ _ADD, "A,L" },
	{ _illegal, 0 },	{ _ONA, "A,A" },	{ _ONA, "A,B" },	{ _ONA, "A,C" },
	{ _ONA, "A,D" },	{ _ONA, "A,E" },	{ _ONA, "A,H" },	{ _ONA, "A,L" },

	{ _illegal, 0 },	{ _ADC, "A,A" },	{ _ADC, "A,B" },	{ _ADC, "A,C" },
	{ _ADC, "A,D" },	{ _ADC, "A,E" },	{ _ADC, "A,H" },	{ _ADC, "A,L" },
	{ _illegal, 0 },	{ _OFFA, "A,A" },	{ _OFFA, "A,B" },	{ _OFFA, "A,C" },
	{ _OFFA, "A,D" },	{ _OFFA, "A,E" },	{ _OFFA, "A,H" },	{ _OFFA, "A,L" },

	{ _illegal, 0 },	{ _SUB, "A,A" },	{ _SUB, "A,B" },	{ _SUB, "A,C" },
	{ _SUB, "A,D" },	{ _SUB, "A,E" },	{ _SUB, "A,H" },	{ _SUB, "A,L" },
	{ _illegal, 0 },	{ _NEA, "A,A" },	{ _NEA, "A,B" },	{ _NEA, "A,C" },
	{ _NEA, "A,D" },	{ _NEA, "A,E" },	{ _NEA, "A,H" },	{ _NEA, "A,L" },

	{ _illegal, 0 },	{ _SBB, "A,A" },	{ _SBB, "A,B" },	{ _SBB, "A,C" },
	{ _SBB, "A,D" },	{ _SBB, "A,E" },	{ _SBB, "A,H" },	{ _SBB, "A,L" },
	{ _illegal, 0 },	{ _EQA, "A,A" },	{ _EQA, "A,B" },	{ _EQA, "A,C" },
	{ _EQA, "A,D" },	{ _EQA, "A,E" },	{ _EQA, "A,H" },	{ _EQA, "A,L" }
};

static const struct dasm_s dasm64_7907[256] = {
	/* 0x00 - 0x3F */
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _ANI, "A,%b" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _XRI, "A,%b" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _ORI, "A,%b" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _ADINC, "A,%b" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _GTI, "A,%b" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _SUINB, "A,%b" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _LTI, "A,%b" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	/* 0x40 - 0x7F */
	{ _illegal, 0 },	{ _ADI, "A,%b" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _ONI, "A,%b" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _ACI, "A,%b" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _OFFI, "A,%b" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _SUI, "A,%b" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _NEI, "A,%b" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _SBI, "A,%b" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _EQI, "A,%b" },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	/* 0x80 - 0xBF */
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _ANI, "PA,%b" },	{ _ANI, "PB,%b" },	{ _ANI, "PC,%b" },	{ _ANI, "MK,%b" },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _XRI, "PA,%b" },	{ _XRI, "PB,%b" },	{ _XRI, "PC,%b" },	{ _XRI, "MK,%b" },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _ORI, "PA,%b" },	{ _ORI, "PB,%b" },	{ _ORI, "PC,%b" },	{ _ORI, "MK,%b" },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _ADINC, "PA,%b" },	{ _ADINC, "PB,%b" },	{ _ADINC, "PC,%b" },	{ _ADINC, "MK,%b" },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _GTI, "PA,%b" },	{ _GTI, "PB,%b" },	{ _GTI, "PC,%b" },	{ _GTI, "MK,%b" },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _SUINB, "PA,%b" },	{ _SUINB, "PB,%b" },	{ _SUINB, "PC,%b" },	{ _SUINB, "MK,%b" },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _LTI, "PA,%b" },	{ _LTI, "PB,%b" },	{ _LTI, "PC,%b" },	{ _LTI, "MK,%b" },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	/* 0xC0 - 0xFF */
	{ _ADI, "PA,%b" },	{ _ADI, "PB,%b" },	{ _ADI, "PC,%b" },	{ _ADI, "MK,%b" },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _ONI, "PA,%b" },	{ _ONI, "PB,%b" },	{ _ONI, "PC,%b" },	{ _ONI, "MK,%b" },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _ACI, "PA,%b" },	{ _ACI, "PB,%b" },	{ _ACI, "PC,%b" },	{ _ACI, "MK,%b" },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _SUI, "PA,%b" },	{ _SUI, "PB,%b" },	{ _SUI, "PC,%b" },	{ _SUI, "MK,%b" },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _NEI, "PA,%b" },	{ _NEI, "PB,%b" },	{ _NEI, "PC,%b" },	{ _NEI, "MK,%b" },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _SBI, "PA,%b" },	{ _SBI, "PB,%b" },	{ _SBI, "PC,%b" },	{ _SBI, "MK,%b" },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _SBI, "PA,%b" },	{ _SBI, "PB,%b" },	{ _SBI, "PC,%b" },	{ _SBI, "MK,%b" },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _EQI, "PA,%b" },	{ _EQI, "PB,%b" },	{ _EQI, "PC,%b" },	{ _EQI, "MK,%b" },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 }
};

static const struct dasm_s dasm70_7907[256] = {
	/* 0x00 - 0x3F */
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _SSPD, "%w" },	{ _LSPD, "%w" },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _SBCD, "%w" },	{ _LBCD, "%w" },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _SDED, "%w" },	{ _LDED, "%w" },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _SHLD, "%w" },	{ _LHLD, "%w" },

	/* 0x40 - 0x7F */
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _MOV, "A,%w" },	{ _MOV, "B,%w" },	{ _MOV, "C,%w" },
	{ _MOV, "D,%w" },	{ _MOV, "E,%w" },	{ _MOV, "H,%w" },	{ _MOV, "L,%w" },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _MOV, "%w,A" },	{ _MOV, "%w,B" },	{ _MOV, "%w,C" },
	{ _MOV, "%w,D" },	{ _MOV, "%w,E" },	{ _MOV, "%w,H" },	{ _MOV, "%w,L" },

	/* 0x80 - 0xBF */
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _ANAX, "BC" },	{ _ANAX, "DE" },	{ _ANAX, "HL" },
	{ _ANAX, "DE+" },	{ _ANAX, "HL+" },	{ _ANAX, "DE-" },	{ _ANAX, "HL-" },

	{ _illegal, 0 },	{ _XRAX, "BC" },	{ _XRAX, "DE" },	{ _XRAX, "HL" },
	{ _XRAX, "DE+" },	{ _XRAX, "HL+" },	{ _XRAX, "DE-" },	{ _XRAX, "HL-" },
	{ _illegal, 0 },	{ _ORAX, "BC" },	{ _ORAX, "DE" },	{ _ORAX, "HL" },
	{ _ORAX, "DE+" },	{ _ORAX, "HL+" },	{ _ORAX, "DE-" },	{ _ORAX, "HL-" },

	{ _illegal, 0 },	{ _ADDNCX, "BC" },	{ _ADDNCX, "DE" },	{ _ADDNCX, "HL" },
	{ _ADDNCX, "DE+" },	{ _ADDNCX, "HL+" },	{ _ADDNCX, "DE-" },	{ _ADDNCX, "HL-" },
	{ _illegal, 0 },	{ _GTAX, "BC" },	{ _GTAX, "DE" },	{ _GTAX, "HL" },
	{ _GTAX, "DE+" },	{ _GTAX, "HL+" },	{ _GTAX, "DE-" },	{ _GTAX, "HL-" },

	{ _illegal, 0 },	{ _SUBNBX, "BC" },	{ _SUBNBX, "DE" },	{ _SUBNBX, "HL" },
	{ _SUBNBX, "DE+" },	{ _SUBNBX, "HL+" },	{ _SUBNBX, "DE-" },	{ _SUBNBX, "HL-" },
	{ _illegal, 0 },	{ _LTAX, "BC" },	{ _LTAX, "DE" },	{ _LTAX, "HL" },
	{ _LTAX, "DE+" },	{ _LTAX, "HL+" },	{ _LTAX, "DE-" },	{ _LTAX, "HL-" },

	/* 0xC0 - 0xFF */
	{ _illegal, 0 },	{ _ADDX, "BC" },	{ _ADDX, "DE" },	{ _ADDX, "HL" },
	{ _ADDX, "DE+" },	{ _ADDX, "HL+" },	{ _ADDX, "DE-" },	{ _ADDX, "HL-" },
	{ _illegal, 0 },	{ _ONAX, "BC" },	{ _ONAX, "DE" },	{ _ONAX, "HL" },
	{ _ONAX, "DE+" },	{ _ONAX, "HL+" },	{ _ONAX, "DE-" },	{ _ONAX, "HL-" },

	{ _illegal, 0 },	{ _ADCX, "BC" },	{ _ADCX, "DE" },	{ _ADCX, "HL" },
	{ _ADCX, "DE+" },	{ _ADCX, "HL+" },	{ _ADCX, "DE-" },	{ _ADCX, "HL-" },
	{ _illegal, 0 },	{ _OFFAX, "BC" },	{ _OFFAX, "DE" },	{ _OFFAX, "HL" },
	{ _OFFAX, "DE+" },	{ _OFFAX, "HL+" },	{ _OFFAX, "DE-" },	{ _OFFAX, "HL-" },

	{ _illegal, 0 },	{ _SUBX, "BC" },	{ _SUBX, "DE" },	{ _SUBX, "HL" },
	{ _SUBX, "DE+" },	{ _SUBX, "HL+" },	{ _SUBX, "DE-" },	{ _SUBX, "HL-" },
	{ _illegal, 0 },	{ _NEAX, "BC" },	{ _NEAX, "DE" },	{ _NEAX, "HL" },
	{ _NEAX, "DE+" },	{ _NEAX, "HL+" },	{ _NEAX, "DE-" },	{ _NEAX, "HL-" },

	{ _illegal, 0 },	{ _SBBX, "BC" },	{ _SBBX, "DE" },	{ _SBBX, "HL" },
	{ _SBBX, "DE+" },	{ _SBBX, "HL+" },	{ _SBBX, "DE-" },	{ _SBBX, "HL-" },
	{ _illegal, 0 },	{ _EQAX, "BC" },	{ _EQAX, "DE" },	{ _EQAX, "HL" },
	{ _EQAX, "DE+" },	{ _EQAX, "HL+" },	{ _EQAX, "DE-" },	{ _EQAX, "HL-" },
};

static const struct dasm_s dasm74_7907[256] = {
	/* 0x00 - 0x3F */
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	/* 0x40 - 0x7F */
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	/* 0x80 - 0xBF */
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _ANAW, "%a" },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _XRAW, "%a" },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _ORAW, "%a" },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _ADDNCW, "%a" },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _GTAW, "%a" },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _SUBNBW, "%a" },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _LTAW, "%a" },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	/* 0xC0 - 0xFF */
	{ _ADDW, "%a" },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _ONAW, "%a" },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _ADCW, "%a" },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _OFFAW, "%a" },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _SUBW, "%a" },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _NEAW, "%a" },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ _SBBW, "%a" },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _EQAW, "%a" },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
};

static const struct dasm_s dasmXX_7907[256] = {
	/* 0x00 - 0x3F */
	{ _NOP, 0 },		{ _HALT, 0 },		{ _INX, "SP" },		{ _DCX, "SP" },
	{ _LXI, "SP,%w" },	{ _ANIW, "%a,%b" },	{ _illegal, 0 },	{ _ANI, "A,%b" },
	{ _RET, 0 },		{ _SIO, 0 },		{ _MOV, "A,B" },	{ _MOV, "A,C" },
	{ _MOV, "A,D" },	{ _MOV, "A,E" },	{ _MOV, "A,H" },	{ _MOV, "A,L" },

	{ _illegal, 0 },	{ _illegal, 0 },	{ _INX, "BC" },		{ _DCX, "BC" },
	{ _LXI, "BC,%w" },	{ _ORIW, "%a,%b" },	{ _XRI, "A,%b" },	{ _ORI, "A,%b" },
	{ _RETS, 0 },		{ _STM, 0 },		{ _MOV, "B,A" },	{ _MOV, "C,A" },
	{ _MOV, "D,A" },	{ _MOV, "E,A" },	{ _MOV, "H,A" },	{ _MOV, "L,A" },

	{ _INRW, "%a" },	{ _illegal, 0 },	{ _INX, "DE" },		{ _DCX, "DE" },
	{ _LXI, "DE,%w" },	{ _GTIW, "%a,%b" },	{ _ADINC, "A,%b" },	{ _GTI, "A,%b" },
	{ _LDAW, "%a" },	{ _LDAX, "BC" },	{ _LDAX, "DE" },	{ _LDAX, "HL" },
	{ _LDAX, "DE+" },	{ _LDAX, "HL+" },	{ _LDAX, "DE-" },	{ _LDAX, "HL-" },

	{ _DCRW, "%a" },	{ _illegal, 0 },	{ _INX, "HL" },		{ _DCX, "HL" },
	{ _LXI, "HL,%w" },	{ _LTIW, "%a,%b" },	{ _SUINB, "A,%b" },	{ _LTI, "A,%b" },
	{ _STAW, "%a" },	{ _STAX, "BC" },	{ _STAX, "DE" },	{ _STAX, "HL" },
	{ _STAX, "DE+" },	{ _STAX, "HL+" },	{ _STAX, "DE-" },	{ _STAX, "HL-" },

	/* 0x40 - 0x7F */
	{ _illegal, 0 },	{ _INR, "A" },		{ _INR, "B" },		{ _INR, "C" },
	{ _CALL, "%w" },	{ _ONIW, "%a,%b" },	{ _ADI, "A,%b" },	{ _ONI, "A,%b" },
	{ 0, dasm48_7907 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ 0, dasm4c_7907 },	{ 0, dasm4d_7907 },	{ _JRE, "%d" },		{ _JRE, "%d" },

	{ _illegal, 0 },	{ _DCR, "A" },		{ _DCR, "B" },		{ _DCR, "C" },
	{ _JMP, "%w" },		{ _OFFIW, "%a,%b" },	{ _ACI, "A,%b" },	{ _OFFI, "A,%b" },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },
	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },	{ _illegal, 0 },

	{ 0, dasm60_7907 },	{ _DAA, 0 },		{ _RETI, 0 },		{ _CALB, 0 },
	{ 0, dasm64_7907 },	{ _NEIW, "%a,%b" },	{ _SUI, "A,%b" },	{ _NEI, "A,%b" },
	{ _illegal, 0 },	{ _MVI, "A,%b" },	{ _MVI, "B,%b" },	{ _MVI, "C,%b" },
	{ _MVI, "D,%b" },	{ _MVI, "E,%b" },	{ _MVI, "H,%b" },	{ _MVI, "L,%b" },

	{ 0, dasm70_7907 },	{ _MVIW, "%a,%b" },	{ _SOFTI, 0 },		{ _JB, 0 },
	{ 0, dasm74_7907 },	{ _EQIW, "%a,%b" },	{ _SBI, "A,%b" },	{ _EQI, "A,%b" },
	{ _CALF, "%f" },	{ _CALF, "%f" },	{ _CALF, "%f" },	{ _CALF, "%f" },
	{ _CALF, "%f" },	{ _CALF, "%f" },	{ _CALF, "%f" },	{ _CALF, "%f" },

	/* 0x80 - 0xBF */
	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },
	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },
	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },
	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },

	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },
	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },
	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },
	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },

	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },
	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },
	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },
	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },

	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },
	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },
	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },
	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },	{ _CALT, "%t" },

	/* 0xC0 - 0xFF */
	{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },
	{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },
	{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },
	{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },

	{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },
	{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },
	{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },
	{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },

	{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },
	{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },
	{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },
	{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },

	{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },
	{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },
	{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },
	{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" },		{ _JR, "%o" }
};


/* register names for bit manipulation instructions */
static const char *const regname[32] =
{
	"illegal", "illegal", "illegal", "illegal",
	"illegal", "illegal", "illegal", "illegal",
	"illegal", "illegal", "illegal", "illegal",
	"illegal", "illegal", "illegal", "illegal",
	"PA",      "PB",      "PC",      "PD",
	"illegal", "PF",      "MKH",     "MKL",
	"illegal", "SMH",     "illegal", "EOM",
	"illegal", "TMM",     "PT",      "illegal"
};

static offs_t Dasm( _TCHAR *buffer, offs_t pc, const struct dasm_s *dasmXX, const UINT8 *oprom, const UINT8 *opram, int is_7810, symbol_t *first_symbol )
{
	int idx = 0;
	UINT8 op = oprom[idx++], op2, t;
	int offset;
	UINT16 ea;
	const char *a;
	char c2t[2] = {0};
	UINT32 flags = 0;

	t = dasmXX[op].token;
	a = (const char *)dasmXX[op].args;

	/* 0 token means prefix opcode (use table from args) */
	if (0 == t)
	{
		struct dasm_s *p_dasm = (struct dasm_s *)a;

		op2 = oprom[idx++];
		t = p_dasm[op2].token;
		a = (const char *)p_dasm[op2].args;
	}

	buffer += _stprintf(buffer, _T("%-8.8s"), char_to_tchar(token[t]));

	if (t == _CALB || t == _CALF || t == _CALL || t == _CALT)
		flags = DASMFLAG_STEP_OVER;
	else if (t == _RET || t == _RETI)
		flags = DASMFLAG_STEP_OUT;

	while (a && *a)
	{
		if ('%' == *a)
		{
			a++;
			switch (*a)
			{
			case 'a':   /* address V * 256 + offset */
				op2 = opram[idx++];
				buffer += _stprintf(buffer, _T("VV:%02X"), op2);
				break;
			case 'b':   /* immediate byte */
				buffer += _stprintf(buffer, _T("$%02X"), opram[idx++]);
				break;
			case 'w':   /* immediate word */
				ea = opram[idx++];
				ea += opram[idx++] << 8;
				buffer += _stprintf(buffer, _T("%s"), get_value_or_symbol(first_symbol, _T("$%04X"), ea));
				break;
			case 'd':   /* JRE address */
				op2 = oprom[idx++];
				offset = (op & 1) ? -(256 - op2): + op2;
				buffer += _stprintf(buffer, _T("%s"), get_value_or_symbol(first_symbol, _T("$%04X"), ( pc + idx + offset ) & 0xFFFF));
				break;
			case 't':   /* CALT address */
				ea = 0x80 + 2 * (op & (is_7810 ? 0x1f : 0x3f));
				buffer += _stprintf(buffer, _T("(%s)"), get_value_or_symbol(first_symbol, _T("$%04X"), ea));
				break;
			case 'f':   /* CALF address */
				op2 = oprom[idx++];
				ea = 0x800 + 0x100 * (op & 0x07) + op2;
				buffer += _stprintf(buffer, _T("%s"), get_value_or_symbol(first_symbol, _T("$%04X"), ea));
				break;
			case 'o':   /* JR offset */
				offset = ( ( op & 0x20 ) ? -0x20 : 0 ) + ( op & 0x1F );
				buffer += _stprintf(buffer, _T("%s"), get_value_or_symbol(first_symbol, _T("$%04X"), ( pc + idx + offset ) & 0xFFFF));
				break;
			case 'i':   /* bit manipulation */
				op2 = oprom[idx++];
				buffer += _stprintf(buffer, _T("%s,%d"), char_to_tchar(regname[op2 & 0x1f]), op2 >> 5);
				break;
			default:
//				*buffer++ = *a;
				c2t[0] = *a;
				*buffer++ = char_to_tchar(c2t)[0];
			}
		}
		else
		{
//			*buffer++ = *a;
			c2t[0] = *a;
			*buffer++ = char_to_tchar(c2t)[0];
		}
		a++;
	}
	*buffer = _T('\0');

	return idx | flags | DASMFLAG_SUPPORTED;
}

static CPU_DISASSEMBLE( upd7810 )
{
	return Dasm( buffer, pc, dasmXX_7810, oprom, opram, 1, first_symbol );
}

static CPU_DISASSEMBLE( upd7807 )
{
	return Dasm( buffer, pc, dasmXX_7807, oprom, opram, 1, first_symbol );
}

static CPU_DISASSEMBLE( upd7801 )
{
	return Dasm( buffer, pc, dasmXX_7801, oprom, opram, 0, first_symbol );
}

static CPU_DISASSEMBLE( upd78c05 )
{
	return Dasm( buffer, pc, dasmXX_78c05, oprom, opram, 0, first_symbol );
}

static CPU_DISASSEMBLE( upd7907 )
{
	return Dasm( buffer, pc, dasmXX_7907, oprom, opram, 0, first_symbol );
}
