/*
	Skelton for retropc emulator

	Author : Takeda.Toshiya
	Date   : 2010.08.03-

	[ mc6847 ]
*/

#include "vm.h"
//#include "emu.h"
#include "mc6847.h"

#ifndef MC6847_VRAM_OFS
#define MC6847_VRAM_OFS	0
#endif

#define LIGHTGREEN	0
#define YELLOW		1
#define BLUE		2
#define RED		3
#define WHITE		4
#define CYAN		5
#define MAGENTA		6
#define ORANGE		7
#define BLACK		8
// text
#define GREEN		9
#define BEIGE		10
// phc20
#define GRAY		11

// from mess m6847.c
static const uint8_t intfont[64 * 12] = {
	0x00, 0x00, 0x38, 0x44, 0x04, 0x34, 0x4C, 0x4C, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x28, 0x44, 0x44, 0x7C, 0x44, 0x44, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x78, 0x24, 0x24, 0x38, 0x24, 0x24, 0x78, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x44, 0x40, 0x40, 0x40, 0x44, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x78, 0x24, 0x24, 0x24, 0x24, 0x24, 0x78, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7C, 0x40, 0x40, 0x70, 0x40, 0x40, 0x7C, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7C, 0x40, 0x40, 0x70, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x44, 0x40, 0x40, 0x4C, 0x44, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x44, 0x44, 0x44, 0x7C, 0x44, 0x44, 0x44, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x44, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x44, 0x48, 0x50, 0x60, 0x50, 0x48, 0x44, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7C, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x44, 0x6C, 0x54, 0x54, 0x44, 0x44, 0x44, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x44, 0x44, 0x64, 0x54, 0x4C, 0x44, 0x44, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x78, 0x44, 0x44, 0x78, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x54, 0x48, 0x34, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x78, 0x44, 0x44, 0x78, 0x50, 0x48, 0x44, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x44, 0x40, 0x38, 0x04, 0x44, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x44, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x54, 0x6C, 0x44, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x44, 0x44, 0x28, 0x10, 0x28, 0x44, 0x44, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7C, 0x04, 0x08, 0x10, 0x20, 0x40, 0x7C, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x08, 0x08, 0x08, 0x08, 0x08, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x38, 0x54, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x10, 0x20, 0x7C, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x28, 0x28, 0x7C, 0x28, 0x7C, 0x28, 0x28, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x3C, 0x50, 0x38, 0x14, 0x78, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x60, 0x64, 0x08, 0x10, 0x20, 0x4C, 0x0C, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x20, 0x50, 0x50, 0x20, 0x54, 0x48, 0x34, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x10, 0x20, 0x20, 0x20, 0x10, 0x08, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x20, 0x10, 0x08, 0x08, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x10, 0x54, 0x38, 0x38, 0x54, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x10, 0x10, 0x7C, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x40, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x44, 0x4C, 0x54, 0x64, 0x44, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x30, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x44, 0x04, 0x38, 0x40, 0x40, 0x7C, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x44, 0x04, 0x08, 0x04, 0x44, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x18, 0x28, 0x48, 0x7C, 0x08, 0x08, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7C, 0x40, 0x78, 0x04, 0x04, 0x44, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x40, 0x40, 0x78, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7C, 0x04, 0x08, 0x10, 0x20, 0x40, 0x40, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x44, 0x44, 0x38, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x44, 0x44, 0x3C, 0x04, 0x04, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x10, 0x20, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x10, 0x20, 0x40, 0x20, 0x10, 0x08, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x44, 0x04, 0x08, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00
};

void MC6847::initialize()
{
	MC6847_BASE::initialize();
	
	// semigraphics pattern
	for(int i = 0; i < 16; i++) {
		for(int j = 0; j < 6; j++) {
			sg4[i * 12 + j] = ((i & 0x08) ? 0xf0 : 0) | ((i & 0x04) ? 0x0f : 0);
		}
		for(int j = 6; j < 12; j++) {
			sg4[i * 12 + j] = ((i & 0x02) ? 0xf0 : 0) | ((i & 0x01) ? 0x0f : 0);
		}
	}
	for(int i = 0; i < 64; i++) {
		for(int j = 0; j < 4; j++) {
			sg6[i * 12 + j] = ((i & 0x20) ? 0xf0 : 0) | ((i & 0x10) ? 0x0f : 0);
		}
		for(int j = 4; j < 8; j++) {
			sg6[i * 12 + j] = ((i & 0x08) ? 0xf0 : 0) | ((i & 0x04) ? 0x0f : 0);
		}
		for(int j = 8; j < 12; j++) {
			sg6[i * 12 + j] = ((i & 0x02) ? 0xf0 : 0) | ((i & 0x01) ? 0x0f : 0);
		}
	}
	// pc pallete
	palette_pc[LIGHTGREEN] = RGB_COLOR(184,255,181);
	palette_pc[RED       ] = RGB_COLOR(254, 65,105);
	palette_pc[YELLOW    ] = RGB_COLOR(252,253,153);
	palette_pc[BLUE      ] = RGB_COLOR(116, 41,255);
	palette_pc[WHITE     ] = RGB_COLOR(241,229,232);
	palette_pc[CYAN      ] = RGB_COLOR(124,210,213);
	palette_pc[MAGENTA   ] = RGB_COLOR(254,113,255);
	palette_pc[ORANGE    ] = RGB_COLOR(254,112, 35);
	palette_pc[BLACK     ] = RGB_COLOR(  0,  0,  0);
	palette_pc[GREEN     ] = RGB_COLOR( 22,134, 10);
	palette_pc[BEIGE     ] = RGB_COLOR(255,198,170);
	palette_pc[GRAY      ] = RGB_COLOR( 32, 32, 32);
	
	disabled = false;
	
	// register event
	register_vline_event(this);
	update_timing(CPU_CLOCKS, FRAMES_PER_SEC, LINES_PER_FRAME);
}

void MC6847::draw_alpha()
{
	
	int ofs = 0;
	
	for(int y = 0; y < 192; y += 12) {
		for(int x = 0; x < 256; x += 8) {
			uint8_t data = vram_ptr[ofs + MC6847_VRAM_OFS];
#ifdef MC6847_ATTR_OFS
			uint8_t attr = vram_ptr[ofs + MC6847_ATTR_OFS];
#endif
			if(++ofs >= vram_size) {
				ofs = 0;
			}
			// vram data bits may be connected to mode signals
			bool as2 = as;
			bool intext2 = intext;
			bool css2 = css;
			bool inv2 = inv;
#ifdef MC6847_VRAM_AS
			as2 = ((data & MC6847_VRAM_AS) != 0);
#endif
#ifdef MC6847_VRAM_INTEXT
			intext2 = ((data & MC6847_VRAM_INTEXT) != 0);
#endif
#ifdef MC6847_VRAM_CSS
			css2 = ((data & MC6847_VRAM_CSS) != 0);
#endif
#ifdef MC6847_VRAM_INV
			inv2 = ((data & MC6847_VRAM_INV) != 0);
#endif
#ifdef MC6847_ATTR_OFS
#ifdef MC6847_ATTR_AS
			as2 = ((attr & MC6847_ATTR_AS) != 0);
#endif
#ifdef MC6847_ATTR_INTEXT
			intext2 = ((attr & MC6847_ATTR_INTEXT) != 0);
#endif
#ifdef MC6847_ATTR_CSS
			css2 = ((attr & MC6847_ATTR_CSS) != 0);
#endif
#ifdef MC6847_ATTR_INV
			inv2 = ((attr & MC6847_ATTR_INV) != 0);
#endif
#endif
			uint8_t *pattern;
			uint8_t col_fore, col_back;
			if(!as2) {
				if(intext2) {
					// external alphanumerics
					pattern = &extfont[16 * data];
				} else {
					// internal alphanumerics
					pattern = (uint8_t *)(&intfont[12 * (data & 0x3f)]);
				}
				// note: we need to overwrite the color table by each driver
				static const uint8_t color_table[6] = {
#ifdef _PHC20
					WHITE, GRAY, WHITE, GRAY, WHITE, GRAY
#else
					LIGHTGREEN, GREEN, BEIGE, RED, GREEN, BLACK
#endif
				};
				int col = (css2 ? 2 : 0) | (inv2 ? 1 : 0);
				col_fore = color_table[col];
				col_back = color_table[col ^ 1];
			} else {
				if(intext2) {
					// semiggraphics 6
					pattern = &sg6[12 * (data & 0x3f)];
					col_fore = (css2 ? 4 : 0) | ((data >> 6) & 3);
				} else {
					// semiggraphics 4
					pattern = &sg4[12 * (data & 0x0f)];
					col_fore = (data >> 4) & 7;
				}
				col_back = BLACK;
			}
			for(int l = 0; l < 12; l++) {
				uint8_t pat = pattern[l];
				uint8_t* dest = &screen[y + l][x];
				
				dest[0] = (pat & 0x80) ? col_fore : col_back;
				dest[1] = (pat & 0x40) ? col_fore : col_back;
				dest[2] = (pat & 0x20) ? col_fore : col_back;
				dest[3] = (pat & 0x10) ? col_fore : col_back;
				dest[4] = (pat & 0x08) ? col_fore : col_back;
				dest[5] = (pat & 0x04) ? col_fore : col_back;
				dest[6] = (pat & 0x02) ? col_fore : col_back;
				dest[7] = (pat & 0x01) ? col_fore : col_back;
			}
		}
	}
}
