/*
NewsBody.cs : The class of the "body part" in the news article.
 
Copyright (c) 2005 CSamura
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

using System;
using System.Text;
using System.Text.RegularExpressions;

namespace TestWeb
{
	/// <summary>
	/// j[XL̃{fB̃NX
	/// </summary>
	public class NewsBody
	{
		private string body;
		
		/// <summary>
		/// NewsBody ̃ftHgRXgN^
		/// </summary>
		public NewsBody()
		{
			body = "";
		}

		/// <summary>
		/// NewsBody ̃RXgN^
		/// M{fB Content-Type wb_ɂƂ
		/// </summary>
		/// <param name="b">M{fB̕</param>
		/// <param name="ct">Content-Type wb_̕</param>
		public NewsBody(string b, string ct)
		{
			body = b;

			// Content-type wb_̒l charset 𔲂oB
			Regex r = new Regex("charset=[\"]?(?<charset>[-\\w]+)[\"]?[;$]?");
			Match m = r.Match(ct);
			if(m.Success)
			{
				string chs = m.Groups["charset"].Value.ToString();

				// {fBfR[h
				byte[] bs = Encoding.UTF8.GetBytes(body);
				body = Encoding.GetEncoding(chs).GetString(bs);
			}
		}

		/// <summary>
		/// {fB̕Ԃ\bh
		/// </summary>
		/// <returns>{fB̕</returns>
		public string GetBody()
		{
			return body;
		}

		public string EncodeBody(string b)
		{
			byte[] bs = Encoding.GetEncoding("iso-2022-jp").GetBytes(b);
			string res = Encoding.ASCII.GetString(bs);

			return res;
		}
	}
}
