<?php
//
// CSSJ plugin

// Returns PDF page.
require_once ('cssj/cssj_driver.php');

function plugin_cssj_inline()
{
    global $script, $vars;
	include('skin/cssj/global.ini.php');

    $args = func_get_args();
    $count = count($args);
    $href = "$script?plugin=cssj";
    $pages = array();
    if ($count > 2) {
        for ($i = 1; $i < $count - 1; ++$i) {
            $pages[] = $args[$i];
        }
    }
    else {
        $content = $vars['page'];
        $pages[] = $content;
    }
    if (!empty($pages)) {
        $href .= '&pages='.urlencode(implode(',', $pages));
    }
    if ($count > 1) {
        $content = $args[0];
        $href .= '&title='.urlencode($content);
    }
    $content = $args[$count - 1] ? $args[$count - 1] : $content;
    $content = "<a class=\"cssj-pdflink\" href=\"$href\" target=\"pdf\">$content</a>";
	ob_start();
	include('skin/cssj/pdfoptions.php');
    $content = $content.ob_get_contents();
    ob_end_clean();
		
    return $content;
}

function plugin_cssj_action()
{
    global $vars, $_source_messages, $script;
    include('skin/cssj/global.ini.php');

    // ページのベースURL
    $base = $script;
    $dir = substr($base, 0, strrpos($base, '/'));

    // 画像などのリソースへのアクセス範囲
    $resource = "$dir/**";

    if (PKWK_SAFE_MODE) die_message('PKWK_SAFE_MODE prohibits this');

    // 対象ページ
    if (isset($vars['pages'])) {
        $pages = explode(',', $vars['pages']);
    }
    else {
        $pages = array($vars['page']);
    }
    
    // その他パラメータ
    if (isset($vars['style'])) {
    	$style = $vars['style'];
    }
    if (isset($vars['attachments'])) {
    	$style = $vars['attachments'];
    }
    if (isset($vars['source'])) {
    	$source = TRUE;
    }
    else {
    	$source = FALSE;
    }
    
    // 文書のタイトル
    $title = isset($vars['title']) ? $vars['title'] : $pages[0];

    // キャッシュのキーと更新時刻
    $key = '';
    $time = 0;
    foreach($pages as $page) {
        $key .= $page;
        $time = max($time, get_filetime($page));
    }
    $key = encode(md5($key));

    pkwk_common_headers();
    if (!$source) {
    	header("Content-Type: application/pdf");
        header("Content-Disposition: inline; filename=\"".$pages[0].".pdf\"");
    	$driver = cssj_create_driver_for($host, $port);
        $session = cssj_create_session($driver, $user, $password) or die('サーバーに接続できません');
        
	    // プロパティ設定
	    foreach($props as $name => $value) {
	    	cssj_set_property($session, $name, $value);
	    }
	    foreach($vars as $name => $value) {
	    	$name = str_replace(',', '.', $name);
	    	cssj_set_property($session, $name, $value);
	    }
	    
        cssj_include_resource($session, $resource);
        
		// スタイルシート
		$styles = 'skin/cssj/print-skin';
		if (is_dir($styles)) {
			if ($dh = opendir($styles)) {
				while (($file = readdir($dh)) !== false) {
					if (strtolower(substr($file, strlen($file) - 4)) == '.css') {
	                    $path = "$styles/$file";
		            	cssj_ob_start_resource($session, "$dir/$path", 'text/css');
		            	readfile($path);
		            	cssj_ob_end_flush_resource();
		        	}
		        }
		        closedir($dh);
		    }
		}
		
		// 添付ファイル
		if ($attachments != NULL) {
			require_once('plugin/attach.inc.php');
			$serial = 0;
			foreach ($pages as $page) {
			    if (!is_page($page) || !check_readable($page, false, false)) {
			        continue;
			    }
				$at_pages =& new AttachPages($page, 0);
				$at_pages =& $at_pages->pages;
				foreach ($at_pages as $at_page) {
					$files =& $at_page->files;
					foreach ($files as $file) {
						$file =& $file[0];
						$uri = $script.'?plugin=ref'.'&page='.rawurlencode($file->page).'&src='.rawurlencode($file->file);
		            	cssj_ob_start_resource($session, $uri);
		            	readfile($file->filename);
		            	cssj_ob_end_flush_resource();
		            	if ($attachments == 'attach')
		            	{
						    cssj_set_property($session, "output.pdf.attachments.$serial.uri", $uri);
						    cssj_set_property($session, "output.pdf.attachments.$serial.name", $file->file);
							++$serial;
		            	}
					}
				}
			}
		}
        
        cssj_ob_start_main($session, $base, 'text/html', $charset);
    }

    print <<<EOD
<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=$charset">
    <link rel="StyleSheet" type="text/css" href="skin/cssj/print-skin/$style.css">
    <title>$title</title>
  </head>
  <body>
<div class="title-page">
<h1>$title</h1>
</div>
<div class="toc"
     xmlns:cssj="http://www.cssj.jp/ns/cssjml">
  <div class="title">目次</div>
  <span id="toc-page-number"></span>
  <cssj:toc offset="2"/>
  <cssj:make-toc counter="page2"/>
</div>
<div class="body">
EOD;
    foreach ($pages as $page) {
        _cssj_send_page($page);
    }
    print <<<EOD
</div>
  </body>
</html>
EOD;

    if (!$source) {
        cssj_ob_end_flush_main();
        cssj_close($session);
    }

    exit;
}

function _cssj_send_page($page)
{
    if (!is_page($page) || !check_readable($page, false, false)) {
        return;
    }
    global $vars;
    $vars['refer'] = $vars['page'] = $page;
    print "<div class=\"content\"><span id=\"page-number\"></span>";
    print convert_html(get_source($page));
    print "</div>";
}
?>
