<?php
/**
 * CSSJɥ饤ФǤ
 *
 * @package cssj
 * @subpackage driver
 * @example ../examples/client_resource.php ץꥱ¦ΥեѴ
 * @example ../examples/server_resource.php С¦ΥեѴ
 * @example ../examples/ob.php ϥХåեѴ
 * @example ../examples/var.php ѿѿѴ
 * @example ../examples/file.php öե˽Ϥƥ쥯Ȥ
 */

/**
 * ץȥ٥νctip֥ѥåԤޤ
 */
require_once ('cssj_ctip.php');

/**
 * 顼٥:ٹ
 *
 * @access public
 */
define ('CSSJ_WARN', 1);
/**
 * 顼٥:顼
 *
 * @access public
 */
define ('CSSJ_ERROR', 2);
/**
 * 顼٥:̿Ū顼
 *
 * @access public
 */
define ('CSSJ_FATAL', 3);
/**
 * 顼٥:
 *
 * @access public
 */
define ('CSSJ_INFO', 4);

/**
 * ꤵ줿ۥȡݡȤ³뤿Υɥ饤Ф֤ޤ
 * 
 * @access public
 * @param $host string ³ۥ
 * @param $port int ³ݡ
 * @param $encoding string ʸΤȤ˻Ȥ饯󥳡ǥ̾
 * @return mixed ɥ饤
 */
function &cssj_create_driver_for($host, $port, $encoding = 'ISO-8859-1') {
  $driver = array(
    'host' => $host,
    'port' => $port,
    'encoding' => $encoding
  );
  return $driver;
}

/**
 * åޤ
 * 
 * @access public
 * @param $driver mixed ɥ饤
 * @param $user string 桼ID
 * @param $password string ѥ
 * @return mixed å,顼ξfalse
 */
function &cssj_create_session(&$driver, $user, $password) {
  if (($fp = fsockopen($driver['host'], $driver['port'], $errno, $errmsg)) === false) {
    trigger_error (__FUNCTION__.": socket_connect() failed: $errno / $errmsg", E_USER_ERROR);
    return false;
  }
  $session = array(
    'state' => 1,
    'driver' => &$driver,
    'out' => null,
    'fp' => &$fp,
    'errorFunc' => null,
    'progressFunc' => null
  );
  if (cssj_ctip_connect($fp, $driver['encoding']) === false) {
    return false;
  }
  if (cssj_ctip_req_property($fp, 'ctip.auth', 'PLAIN:'.$user.chr(0x0A).$password) === false) {
	  return false;
  }
  if (($response = cssj_ctip_res_next($fp)) === false) {
	  return false;
  }
  if ($response['type'] !== CSSJ_CTIP_RES_ERROR) {
	  return false;
  }
  if ($response['error'] !== 'OK') {
	  trigger_error (__FUNCTION__.": Authentication failed.", E_USER_ERROR);
	  return false;
  }
  return $session;
}

/**
 * Ѵ̤νꤷޤ
 *
 * cssj_format_maincssj_ob_start_main˸ƤӽФƤ
 * δؿƤӽФʤ硢null(ɸ)ˤʤޤ
 * 褬nullξ硢header()ؿˤContent-Lengthإåꤵޤ
 * 
 * @access public
 * @param $session mixed å
 * @param $out mixed 襹ȥ꡼(resource),ѿ(string),ޤɸϤǤnull
 * @param $mimeType Ϸ
 * @return boolean ʤtrue,Ԥʤfalse
 */
function cssj_set_output(&$session, &$out, $mimeType = 'application/pdf') {
  if ($session['state'] >= 2) {
    trigger_error (__FUNCTION__.": Main content is already sent.", E_USER_WARNING);
    return false;
  }
  $session['out'] =& $out;
  return cssj_set_property($session, 'output.type', $mimeType);
}

/**
 * 顼åΤΥХåؿꤷޤ
 *
 * cssj_format_maincssj_ob_start_main˸ƤӽФƤ
 * Хåؿΰϡ顼٥(int)å(string)Ǥ
 * 
 * @access public
 * @param $session mixed å
 * @param $errorFunc function Хåؿ
 * @return void
 */
function cssj_set_error_func(&$session, &$errorFunc) {
  if ($session['state'] >= 2) {
    trigger_error (__FUNCTION__.": Main content is already sent.", E_USER_WARNING);
    return;
  }
  $session['errorFunc'] =& $errorFunc;
}

/**
 * ʹԾΤΥХåؿꤷޤ
 *
 * cssj_format_maincssj_ob_start_main˸ƤӽФƤ
 * Хåؿΰϡɤ߹ߺѤߥХȿ(int)Ǥ
 * 
 * @access public
 * @param $session mixed å
 * @param $progressFunc function Хåؿ
 * @return void
 */
function cssj_set_progress_func(&$session, &$progressFunc) {
  if ($session['state'] >= 2) {
    trigger_error (__FUNCTION__.": Main content is already sent.", E_USER_WARNING);
    return;
  }
  $session['progressFunc'] =& $progressFunc;
}

/**
 * ץѥƥꤷޤ
 *
 * åľ˸ƤӽФƤ
 * Ѳǽʥץѥƥΰϡֳȯԥɡפ򻲾ȤƤ
 * 
 * @access public
 * @param $session mixed å
 * @param $name string ̾
 * @param $value string 
 * @return boolean ʤtrue,Ԥʤfalse
 */
function cssj_set_property(&$session, $name, $value) {
  if ($session['state'] >= 2) {
    trigger_error (__FUNCTION__.": Main content is already sent.", E_USER_WARNING);
    return false;
  }
  return cssj_ctip_req_property($session['fp'], $name, $value);
}

/**
 * ǽʥС¦꥽ꤷޤ
 *
 * cssj_format_maincssj_ob_start_main˸ƤӽФƤ
 * 
 * @access public
 * @param $session mixed å
 * @param $uriPattern string URIѥ
 * @return boolean ʤtrue,Ԥʤfalse
 */
function cssj_include_resource(&$session, $uriPattern) {
  if ($session['state'] >= 2) {
    trigger_error (__FUNCTION__.": Main content is already sent.", E_USER_WARNING);
    return false;
  }
  return cssj_set_property($session, 'ctip.include', $uriPattern);
}

/**
 * 륵С¦꥽ꤷޤ
 *
 * cssj_format_maincssj_ob_start_main˸ƤӽФƤ
 * 
 * @access public
 * @param $session mixed å
 * @param $uriPattern string URIѥ
 * @return boolean ʤtrue,Ԥʤfalse
 */
function cssj_exclude_resource(&$session, $uriPattern) {
  if ($session['state'] >= 2) {
    trigger_error (__FUNCTION__.": Main content is already sent.", E_USER_WARNING);
    return false;
  }
  return cssj_set_property($session, 'ctip.exclude', $uriPattern);
}

/**
 * С¦꥽Ѵޤ
 *
 * δؿ1ĤΥåˤĤ1٤Ƥ֤ȤǤޤ
 * θ塢оݤΥåФcssj_closeʳϤǤޤ
 * 
 * @access public
 * @param $session mixed å
 * @param $uri string URI
 * @return boolean ʤtrue,Ԥʤfalse
 */
function cssj_format_main(&$session, $uri) {
  if ($session['state'] >= 2) {
    trigger_error (__FUNCTION__.": Main content is already sent.", E_USER_WARNING);
    return false;
  }
  if (cssj_include_resource($session, $uri) === false) {
    return false;
  }
  if (cssj_set_property($session, 'ctip.main', $uri) === false) {
    return false;
  }
  $session['state'] = 2;
  if (cssj_ctip_req_end($session['fp']) === false) {
    return false;
  }
  return cssj_ctip_res_build($session['fp'], $session['out'], $session['errorFunc'], $session['progressFunc']);
  }

/**
 * ꥽ΤνϤΥХåե󥰤ͭˤޤ
 *
 * cssj_ob_start_resource,cssj_ob_end_flush_resourceФȤʤޤ
 * δؿcssj_format_maincssj_ob_start_main˸ƤӽФƤ
 * 
 * @access public
 * @param $session mixed å
 * @param $uri string URI
 * @param $mimeType MIME
 * @param $encoding 饯󥳡ǥ
 * @return boolean ʤtrue,Ԥʤfalse
 */
function cssj_ob_start_resource(&$session, $uri, $mimeType = 'text/css', $encoding = '') {
  if ($session['state'] >= 2) {
    trigger_error (__FUNCTION__.": Main content is already sent.", E_USER_WARNING);
    return false;
  }
  $fp =& $session['fp'];
  if (cssj_ctip_req_resource($fp, $uri, $mimeType, $encoding) === false) {
    return false;
  }
  $GLOBALS['cssj_ob_session'] =& $session;
  return ob_start('_cssj_ob_resource_handler', CSSJ_BUFFER_SIZE);
}

/**
 * ХåեƤ꥽ΤΥХåե󥰤λޤ
 *
 * cssj_ob_start_resource,cssj_ob_end_flush_resourceФȤʤޤ
 * δؿcssj_format_maincssj_ob_start_main˸ƤӽФƤ
 * 
 * @access public
 * @return boolean ʤtrue,Ԥʤfalse
 */
function cssj_ob_end_flush_resource() {
  if (!isset($GLOBALS['cssj_ob_session']) || $GLOBALS['cssj_ob_session']['state'] >= 2) {
    trigger_error (__FUNCTION__.": cssj_ob_start_resource() was not called.", E_USER_WARNING);
    return false;
  }
  $err = ob_end_clean();
  if (isset($GLOBALS['cssj_ob_err'])) {
    $err = true;
  }
  unset($GLOBALS['cssj_ob_session']);
  unset($GLOBALS['cssj_ob_err']);
  return $err;
}

/**
 * ꥽ΤΥХåؿǤ
 * 
 * @access private
 * @param $buffer
 * @return string
 */
function _cssj_ob_resource_handler($buffer) {
  if (isset($GLOBALS['cssj_ob_err'])) {
    return '';
  }
  $fp =& $GLOBALS['cssj_ob_session']['fp'];
  for (;;) {
    $buff = substr($buffer, 0, CSSJ_BUFFER_SIZE);
    $len = strlen($buff);
    if ($len <= 0) {
      break;
    }
    $buffer = substr($buffer, $len);
    if (cssj_ctip_req_write($fp, $buff) === false) {
      $GLOBALS['cssj_ob_err'] = true;
      return '';
    }
  }
  return '';
}

/**
 * ΤѴΤνϤΥХåե󥰤ͭˤޤ
 *
 * cssj_ob_start_main,cssj_ob_end_flush_mainФȤʤޤ
 * Τ1ĤΥåˤĤ1٤Ǥ
 * θ塢оݤΥåФcssj_closeʳϤǤޤ
 * 
 * @access public
 * @param $session mixed å
 * @param $uri string URI
 * @param $mimeType MIME
 * @param $encoding 饯󥳡ǥ
 * @return boolean ʤtrue,Ԥʤfalse
 */
function cssj_ob_start_main(&$session, $uri, $mimeType = 'text/html', $encoding = '') {
  if ($session['state'] >= 2) {
    trigger_error (__FUNCTION__.": Main content is already sent.", E_USER_WARNING);
    return false;
  }
  $session['state'] = 2;
  $fp =& $session['fp'];
  if (cssj_ctip_req_main($fp, $uri, $mimeType, $encoding) === false) {
    return false;
  }
  $GLOBALS['cssj_ob_builder'] = cssj_ctip_res_create_builder($fp, $session['out'], $session['errorFunc'], $session['progressFunc']);
  $GLOBALS['cssj_ob_session'] =& $session;
  return ob_start('_cssj_ob_main_handler', CSSJ_BUFFER_SIZE);
}

/**
 * Ѵ̤ΤѴΤΥХåե󥰤λޤ
 *
 * cssj_ob_start_main,cssj_ob_end_flush_mainФȤʤޤ
 * Τ1ĤΥåˤĤ1٤Ǥ
 * θ塢оݤΥåФcssj_closeʳϤǤޤ
 * 
 * @access public
 * @return boolean ʤtrue,Ԥʤfalse
 */
function cssj_ob_end_flush_main() {
  if (!isset($GLOBALS['cssj_ob_session']) || $GLOBALS['cssj_ob_session']['state'] != 2) {
    trigger_error (__FUNCTION__.": cssj_ob_start_main() was not called.", E_USER_WARNING);
    return false;
  }
  $err = ob_end_clean();
  if (isset($GLOBALS['cssj_ob_err'])) {
    $err = false;
  }
  else {
    $fp =& $GLOBALS['cssj_ob_session']['fp'];
    cssj_ctip_req_end($fp);
    while (($err = cssj_ctip_res_build_next($GLOBALS['cssj_ob_builder'])) === true)
      ; 
  }
  unset($GLOBALS['cssj_ob_builder']);
  unset($GLOBALS['cssj_ob_session']);
  unset($GLOBALS['cssj_ob_err']);
  return ($err === false) ? false : true;
}

/**
 * ΤѴΤΥХåؿǤ
 * 
 * @access private
 * @param $buffer
 * @return string
 */
function _cssj_ob_main_handler($buffer) {
  if (isset($GLOBALS['cssj_ob_err'])) {
    return '';
  }
  $fp =& $GLOBALS['cssj_ob_session']['fp'];
  for (;;) {
    $buff = substr($buffer, 0, CSSJ_BUFFER_SIZE);
    $len = strlen($buff);
    if ($len <= 0) {
      break;
    }
    $buffer = substr($buffer, $len);
    $packet = pack('NC', $len + 1, CSSJ_CTIP_REQ_DATA).$buff;
    $len = strlen($packet);
    for (;;) {
      $r = array($fp);
      $w = array($fp);
      $ex = null;
      if (($status = stream_select($r, $w, $ex, 0)) === false) {
        $GLOBALS['cssj_ob_err'] = true;
        return '';
      }
      if ($len > 0 && !empty($w)) {
        stream_set_blocking($fp, 0);
        if (($rlen = fwrite($fp, $packet)) === false) {
          $GLOBALS['cssj_ob_err'] = true;
          stream_set_blocking($fp, 1);
          return '';
        }
        stream_set_blocking($fp, 1);
      	$packet = substr($packet, $rlen);
        $len -= $rlen;
      }
      if (!empty($r)) {
        if (cssj_ctip_res_build_next($GLOBALS['cssj_ob_builder']) === false) {
          $GLOBALS['cssj_ob_err'] = true;
          return '';
        }
      }
	  if ($len <= 0) {
        break;
      }
    }
  }
  return '';
}

/**
 * åĤޤ
 *
 * δؿθƽФ塢оݤȤʤäåФ뤤ʤǤޤ
 * 
 * @access public
 * @param $session
 * @return boolean ʤtrue,Ԥʤfalse
 */
function cssj_close(&$session) {
  if ($session['state'] >= 3) {
    trigger_error (__FUNCTION__.": The session is already closed.", E_USER_WARNING);
    return false;
  }
  $session['state'] = 3;
  return fclose($session['fp']);
}

?>