/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.y_yuuki.cn.mail;

import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.Logger;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Account;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Project;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.mail.Decoder;

public class MailSender {
    public static boolean sendMail(Project project) {
        try {
            Properties props = new Properties();
            props.put("mail.smtp.host", project.getHost());
            props.put("mail.smtp.auth", "true");
            props.put("mail.smtp.port", String.valueOf(project.getPort()));
            if (project.getSsl() == 2) {
                props.put("mail.smtp.starttls.enable", "true");
            } else if (project.getSsl() == 1) {
                props.put("mail.smtp.ssl.enable", "true");
            }
            Decoder dec = new Decoder();
            final Account account = dec.decode(project.getKeyFile(), project.getAccountFile());
            Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(account.getName(), account.getPass());
                }
            });
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(project.getFrom(), "Clone Notifier", "iso-2022-jp"));
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart mbp = new MimeBodyPart();
            FileDataSource fds = new FileDataSource(String.valueOf(project.getGenerateTextDir()) + "//" + project.getGenerateTextFileName());
            mbp.setDataHandler(new DataHandler((DataSource)fds));
            mbp.setFileName(MimeUtility.encodeWord((String)fds.getName()));
            mp.addBodyPart((BodyPart)mbp);
            msg.setSubject("Notification of Changed Clone Information", "iso-2022-jp");
            msg.setContent((Multipart)mp);
            for (String to : project.getToList()) {
                MailSender.sendmail(msg, to);
            }
        }
        catch (Exception e) {
            Logger.writeln("Can't send mail.", 2);
            return false;
        }
        return true;
    }

    private static void sendmail(MimeMessage msg, String to) {
        if (!to.equals("NULL")) {
            try {
                msg.setRecipients(Message.RecipientType.TO, to);
                Transport.send((Message)msg);
                Logger.writeln("<Success> Send mail to " + to, 4);
            }
            catch (MessagingException e) {
                e.printStackTrace();
                Logger.writeln("Can't send mail to " + to, 2);
            }
        }
    }
}

