/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.y_yuuki.cn.generate;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Clone;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.CloneSet;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Project;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.generate.OutputGenerator;

public class TextFileGenerator {
    private static PrintWriter writer = null;
    private static int EXTRA_LINE = 3;

    public static boolean generateTextFile(OutputGenerator generator, Project project) {
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(project.getGenerateTextDir()) + "//" + project.getGenerateTextFileName())));
            writer.println("###################################################################");
            writer.println("\t\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u540d: " + project.getName());
            writer.println("\t\u8a00\u8a9e\uff1a " + project.getLang());
            writer.println("###################################################################");
            writer.println();
            writer.println("\u25a0\u30d5\u30a1\u30a4\u30eb\u60c5\u5831 ");
            writer.printf("\t-\u7dcf\u30d5\u30a1\u30a4\u30eb\u6570\uff1a%d\r\n", generator.getFileNum());
            writer.printf("\t-\u8ffd\u52a0\u30d5\u30a1\u30a4\u30eb\u6570\uff1a%d\r\n", generator.getAddedFileNum());
            writer.printf("\t-\u524a\u9664\u30d5\u30a1\u30a4\u30eb\u6570\uff1a%d\r\n", generator.getDeletedFileNum());
            writer.printf("\t-\u30af\u30ed\u30fc\u30f3\u3092\u542b\u3080\u30d5\u30a1\u30a4\u30eb\u6570\uff1a%d\r\n", generator.getCloneFileNum());
            writer.println();
            writer.println("\u25a0\u30af\u30ed\u30fc\u30f3\u30bb\u30c3\u30c8\u5206\u985e\u6570");
            writer.printf("\t-STABLE Clone Set\uff1a%d\r\n", generator.getStableCloneSetNum());
            writer.printf("\t-CHANGED Clone Set\uff1a%d\r\n", generator.getChangedCloneSetNum());
            writer.printf("\t-NEW Clone Set\uff1a%d\r\n", generator.getNewCloneSetNum());
            writer.printf("\t-DELETED Clone Set\uff1a%d\r\n", generator.getDeletedCloneSetNum());
            writer.println();
            writer.println("\u25a0\u30af\u30ed\u30fc\u30f3\u5206\u985e");
            writer.printf("\t-STABLE Clone\uff1a%d\r\n", generator.getStableCloneNum());
            writer.printf("\t-MODIFIED Clone:%d\r\n", generator.getModifiedCloneNum());
            writer.printf("\t-MOVED Clone\uff1a%d\r\n", generator.getMovedCloneNum());
            writer.printf("\t-ADDED Clone\uff1a%d\r\n", generator.getAddedCloneNum());
            writer.printf("\t-DELETED Clone\uff1a%d\r\n", generator.getDeletedCloneNum());
            writer.println();
            writer.println("###################################################################");
            writer.println("    New Clone Set \u4e00\u89a7");
            writer.println("###################################################################");
            if (generator.getNewCloneSetNum() > 0) {
                for (CloneSet cloneSet : project.getCloneSetList()) {
                    if (cloneSet.getCategory() != 0) continue;
                    TextFileGenerator.outputCloneSet(cloneSet);
                }
            } else {
                writer.println("New Clone Set \u306f\u691c\u51fa\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f");
                writer.println();
            }
            writer.println("###################################################################");
            writer.println("    Changed Clone Set \u4e00\u89a7");
            writer.println("###################################################################");
            if (generator.getChangedCloneSetNum() > 0) {
                for (CloneSet cloneSet : project.getCloneSetList()) {
                    if (cloneSet.getCategory() != 1) continue;
                    TextFileGenerator.outputCloneSet(cloneSet);
                }
            } else {
                writer.println("Changed Clone Set \u306f\u691c\u51fa\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f");
                writer.println();
            }
            writer.println("###################################################################");
            writer.println("    Deleted Clone Set \u4e00\u89a7");
            writer.println("###################################################################");
            if (generator.getDeletedCloneSetNum() > 0) {
                for (CloneSet cloneSet : project.getCloneSetList()) {
                    if (cloneSet.getCategory() != 2) continue;
                    TextFileGenerator.outputCloneSet(cloneSet);
                }
            } else {
                writer.println("Deleted Clone Set \u306f\u691c\u51fa\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f");
                writer.println();
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }

    private static void outputCloneSet(CloneSet cloneSet) throws IOException {
        writer.printf("*************************************************************\r\n", new Object[0]);
        writer.printf("  @CloneSet%d\r\n", cloneSet.getOutputId());
        writer.printf("*************************************************************\r\n", new Object[0]);
        for (Clone clone : cloneSet.getNewCloneList()) {
            writer.printf("@%d.%d", clone.getCloneSet().getOutputId(), clone.getOutputId());
            writer.printf("\t%s\t%s\t%d.%d-%d.%d\r\n", clone.getCategoryString(), clone.getFile().getName(), clone.getStartLine(), clone.getStartColumn(), clone.getEndLine(), clone.getEndColumn());
        }
        if (!cloneSet.containsOldClone()) {
            writer.println("----Previous Version----");
        }
        for (Clone clone : cloneSet.getOldCloneList()) {
            if (clone.getCategory() != 2 && clone.getCategory() != 4) continue;
            if (clone.getCategory() == 2) {
                clone = clone.getChildClone();
            }
            writer.printf("@%d.%d", clone.getCloneSet().getOutputId(), clone.getOutputId());
            writer.printf("\t%s\t%s\t%d.%d-%d.%d\r\n", clone.getCategoryString(), clone.getFile().getName(), clone.getStartLine(), clone.getStartColumn(), clone.getEndLine(), clone.getEndColumn());
        }
        boolean stableFlg = true;
        for (Clone clone : cloneSet.getNewCloneList()) {
            writer.println("-------------------------------------------------");
            if (clone.getCategory() == 0) {
                writer.println("Stable Clone \u306e\u30b5\u30f3\u30d7\u30eb");
                stableFlg = false;
            }
            writer.printf("@%d.%d\r\n", clone.getCloneSet().getOutputId(), clone.getOutputId());
            writer.printf("%s\r\n", clone.getFile().getName());
            TextFileGenerator.outputCloneCode(clone);
            if (!stableFlg) break;
        }
        for (Clone clone : cloneSet.getOldCloneList()) {
            if (clone.getCategory() == 2) {
                clone = clone.getChildClone();
            }
            writer.println("-------------------------------------------------");
            writer.printf("@%d.%d\r\n", clone.getCloneSet().getOutputId(), clone.getOutputId());
            writer.printf("%s\r\n", clone.getFile().getName());
            TextFileGenerator.outputCloneCode(clone);
        }
        writer.println();
    }

    /*
     * Unable to fully structure code
     */
    private static void outputCloneCode(Clone clone) throws IOException {
        block39: {
            block42: {
                block41: {
                    block40: {
                        block38: {
                            if (clone.getFile().getState() != 1) break block38;
                            reader = new BufferedReader(new InputStreamReader(new FileInputStream(clone.getFile().getNewPath())));
                            lineNum = 0;
                            while ((line = reader.readLine()) != null) {
                                if (clone.getStartLine() == ++lineNum) {
                                    TextFileGenerator.outputCloneStartSign(clone);
                                }
                                if (lineNum >= clone.getStartLine() - TextFileGenerator.EXTRA_LINE && lineNum <= clone.getEndLine() + TextFileGenerator.EXTRA_LINE) {
                                    TextFileGenerator.writer.printf("%-4d", new Object[]{lineNum});
                                    TextFileGenerator.writer.println("+ " + line);
                                }
                                if (clone.getEndLine() != lineNum) continue;
                                TextFileGenerator.outputCloneEndSign();
                            }
                            reader.close();
                            break block39;
                        }
                        if (clone.getFile().getState() != 2) break block40;
                        reader = new BufferedReader(new InputStreamReader(new FileInputStream(clone.getFile().getOldPath())));
                        lineNum = 0;
                        while ((line = reader.readLine()) != null) {
                            if (clone.getStartLine() == ++lineNum) {
                                TextFileGenerator.outputCloneStartSign(clone);
                            }
                            if (lineNum >= clone.getStartLine() - TextFileGenerator.EXTRA_LINE && lineNum <= clone.getEndLine() + TextFileGenerator.EXTRA_LINE) {
                                TextFileGenerator.writer.printf("%-4d", new Object[]{lineNum});
                                TextFileGenerator.writer.println("- " + line);
                            }
                            if (clone.getEndLine() != lineNum) continue;
                            TextFileGenerator.outputCloneEndSign();
                        }
                        reader.close();
                        break block39;
                    }
                    addCodeId = 0;
                    deleteCodeId = 0;
                    lineNumA = 0;
                    lineNumB = 0;
                    readerA = new BufferedReader(new InputStreamReader(new FileInputStream(clone.getFile().getNewPath())));
                    readerB = new BufferedReader(new InputStreamReader(new FileInputStream(clone.getFile().getOldPath())));
                    outputStart = clone.getStartLine() - TextFileGenerator.EXTRA_LINE;
                    outputEnd = clone.getEndLine() + TextFileGenerator.EXTRA_LINE;
                    cloneFlg = false;
                    if (clone.getCategory() == 4) break block41;
                    while (true) {
                        if ((lineA = readerA.readLine()) != null) {
                            ++lineNumA;
                        }
                        if ((lineB = readerB.readLine()) != null) {
                            ++lineNumB;
                        }
                        if (lineA != null || lineB != null) ** GOTO lbl67
                        break;
lbl-1000:
                        // 1 sources

                        {
                            ++addCodeId;
                            if (lineNumA >= outputStart && lineNumA <= outputEnd && lineA != null) {
                                cloneFlg = true;
                            } else if (lineNumA > outputEnd) {
                                cloneFlg = false;
                                break;
                            }
                            if (cloneFlg) {
                                if (clone.getStartLine() == lineNumA) {
                                    TextFileGenerator.outputCloneStartSign(clone);
                                }
                                TextFileGenerator.writer.printf("%-4d", new Object[]{lineNumA});
                                TextFileGenerator.writer.println("+ " + lineA);
                                if (clone.getEndLine() == lineNumA) {
                                    TextFileGenerator.outputCloneEndSign();
                                }
                            }
                            if ((lineA = readerA.readLine()) == null) continue;
                            ++lineNumA;
lbl67:
                            // 3 sources

                            ** while (addCodeId < clone.getFile().getAddedCodeList().size() && lineNumA == clone.getFile().getAddedCodeList().get((int)addCodeId).intValue())
                        }
lbl68:
                        // 4 sources

                        while (deleteCodeId < clone.getFile().getDeletedCodeList().size() && lineNumB == clone.getFile().getDeletedCodeList().get(deleteCodeId)) {
                            ++deleteCodeId;
                            if (cloneFlg) {
                                TextFileGenerator.writer.printf("%-4s", new Object[]{" "});
                                TextFileGenerator.writer.println("- " + lineB);
                            }
                            if ((lineB = readerB.readLine()) == null) continue;
                            ++lineNumB;
                        }
                        if (lineNumA >= outputStart && lineNumA <= outputEnd && lineA != null) {
                            cloneFlg = true;
                        } else if (lineNumA > outputEnd) {
                            cloneFlg = false;
                            break;
                        }
                        if (!cloneFlg) continue;
                        if (clone.getStartLine() == lineNumA) {
                            TextFileGenerator.outputCloneStartSign(clone);
                        }
                        TextFileGenerator.writer.printf("%-4d", new Object[]{lineNumA});
                        TextFileGenerator.writer.println("\u3000 " + lineA);
                        if (clone.getEndLine() != lineNumA) continue;
                        TextFileGenerator.outputCloneEndSign();
                    }
                }
                if (clone.getCategory() != 4) break block42;
                while (true) {
                    if ((lineA = readerA.readLine()) != null) {
                        ++lineNumA;
                    }
                    if ((lineB = readerB.readLine()) != null) {
                        ++lineNumB;
                    }
                    if (lineA != null || lineB != null) ** GOTO lbl108
                    break;
lbl-1000:
                    // 1 sources

                    {
                        ++addCodeId;
                        if (cloneFlg) {
                            TextFileGenerator.writer.printf("%-4s", new Object[]{" "});
                            TextFileGenerator.writer.println("+ " + lineA);
                        }
                        if ((lineA = readerA.readLine()) == null) continue;
                        ++lineNumA;
lbl108:
                        // 3 sources

                        ** while (addCodeId < clone.getFile().getAddedCodeList().size() && lineNumA == clone.getFile().getAddedCodeList().get((int)addCodeId).intValue())
                    }
lbl109:
                    // 3 sources

                    while (deleteCodeId < clone.getFile().getDeletedCodeList().size() && lineNumB == clone.getFile().getDeletedCodeList().get(deleteCodeId)) {
                        ++deleteCodeId;
                        if (lineNumB >= outputStart && lineNumB <= outputEnd && lineB != null) {
                            cloneFlg = true;
                        } else if (lineNumB > outputEnd) {
                            cloneFlg = false;
                            break;
                        }
                        if (cloneFlg) {
                            if (clone.getStartLine() == lineNumB) {
                                TextFileGenerator.outputCloneStartSign(clone);
                            }
                            TextFileGenerator.writer.printf("%-4d", new Object[]{lineNumB});
                            TextFileGenerator.writer.println("- " + lineB);
                            if (clone.getEndLine() == lineNumB) {
                                TextFileGenerator.outputCloneEndSign();
                            }
                        }
                        if ((lineB = readerB.readLine()) == null) continue;
                        ++lineNumB;
                    }
                    if (lineNumB >= outputStart && lineNumB <= outputEnd && lineB != null) {
                        cloneFlg = true;
                    } else if (lineNumB > outputEnd) {
                        cloneFlg = false;
                        break;
                    }
                    if (!cloneFlg) continue;
                    if (clone.getStartLine() == lineNumB) {
                        TextFileGenerator.outputCloneStartSign(clone);
                    }
                    TextFileGenerator.writer.printf("%-4d", new Object[]{lineNumB});
                    TextFileGenerator.writer.println("  " + lineB);
                    if (clone.getEndLine() != lineNumB) continue;
                    TextFileGenerator.outputCloneEndSign();
                }
            }
            readerA.close();
            readerB.close();
        }
    }

    private static void outputCloneStartSign(Clone clone) {
        writer.println("    <START " + clone.getCategoryString() + "Clone>");
    }

    private static void outputCloneEndSign() {
        writer.println("    <END>");
    }
}

