/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.y_yuuki.cn.generate;

import java.io.File;
import java.util.Calendar;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.Logger;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Clone;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.CloneSet;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Project;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.SourceFile;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.generate.CSVGenerator;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.generate.HTMLFileGenerater;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.generate.TextFileGenerator;

public class OutputGenerator {
    private int fileNum = 0;
    private int addedFileNum = 0;
    private int deletedFileNum = 0;
    private int cloneFileNum = 0;
    private int cloneSetNum = 0;
    private int stableCloneNum = 0;
    private int addedCloneNum = 0;
    private int deletedCloneNum = 0;
    private int modifiedCloneNum = 0;
    private int movedCloneNum = 0;
    private int cloneNum = 0;
    private int stableCloneSetNum = 0;
    private int newCloneSetNum = 0;
    private int deletedCloneSetNum = 0;
    private int changedCloneSetNum = 0;
    private String year;
    private String month;
    private String day;
    private Project project = null;

    public OutputGenerator(Project project) {
        this.project = project;
        if (project.getTool().equals("CCFinderX")) {
            project.sortCloneSetListbyLEN();
        }
        project.sortCloneSetListbyCategory();
        int cloneSetId = 0;
        for (CloneSet cloneSet : project.getCloneSetList()) {
            cloneSet.setOutputId(cloneSetId++);
            int cloneId = 0;
            for (Clone clone : cloneSet.getNewCloneList()) {
                clone.setOutputId(cloneId++);
            }
            for (Clone clone : cloneSet.getOldCloneList()) {
                if (clone.getCategory() != 4) continue;
                clone.setOutputId(cloneId++);
            }
        }
        for (SourceFile file : project.getFileList()) {
            switch (file.getState()) {
                case 1: {
                    ++this.addedFileNum;
                    ++this.fileNum;
                    break;
                }
                case 2: {
                    ++this.deletedFileNum;
                    break;
                }
                case 0: {
                    ++this.fileNum;
                }
            }
            if (file.getNewCloneList().isEmpty()) continue;
            ++this.cloneFileNum;
        }
        for (CloneSet cloneSet : project.getCloneSetList()) {
            switch (cloneSet.getCategory()) {
                case 3: {
                    ++this.stableCloneSetNum;
                    ++this.cloneSetNum;
                    break;
                }
                case 1: {
                    ++this.changedCloneSetNum;
                    ++this.cloneSetNum;
                    break;
                }
                case 0: {
                    ++this.newCloneSetNum;
                    ++this.cloneSetNum;
                    break;
                }
                case 2: {
                    ++this.deletedCloneSetNum;
                }
            }
            for (Clone clone : cloneSet.getNewCloneList()) {
                ++this.cloneNum;
                switch (clone.getCategory()) {
                    case 0: {
                        ++this.stableCloneNum;
                        break;
                    }
                    case 1: {
                        ++this.modifiedCloneNum;
                        break;
                    }
                    case 2: {
                        ++this.movedCloneNum;
                        break;
                    }
                    case 3: {
                        ++this.addedCloneNum;
                    }
                }
            }
            for (Clone clone : cloneSet.getOldCloneList()) {
                if (clone.getCategory() != 4) continue;
                ++this.deletedCloneNum;
            }
        }
        Calendar now = Calendar.getInstance();
        this.year = Integer.toString(now.get(1));
        this.month = Integer.toString(now.get(2) + 1);
        if (this.month.length() == 1) {
            this.month = "0" + this.month;
        }
        this.day = Integer.toString(now.get(5));
        if (this.day.length() == 1) {
            this.day = "0" + this.day;
        }
    }

    public boolean generateTextFile() {
        this.project.setGenerateTextFileName(String.valueOf(this.project.getName()) + this.year + this.month + this.day + ".txt");
        File file = new File(this.project.getGenerateTextDir());
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!TextFileGenerator.generateTextFile(this, this.project)) {
            Logger.writeln("Can't generate text file.", 2);
            return false;
        }
        Logger.writeln("<Success> Generate text file.", 4);
        return true;
    }

    public boolean generateCSVFile() {
        this.project.setGenerateCSVFileName(String.valueOf(this.project.getName()) + this.year + this.month + this.day + ".csv");
        File file = new File(this.project.getGenerateCSVDir());
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!CSVGenerator.generateCSVFile(this, this.project)) {
            Logger.writeln("Can't generate CSV file.", 2);
            return false;
        }
        Logger.writeln("<Success> Generate CSV file.", 4);
        return true;
    }

    public boolean generateHTMLFile() {
        File file = new File(this.project.getGenerateHTMLDir());
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!HTMLFileGenerater.generateHTMLFile(this, this.project)) {
            Logger.writeln("Can't generate HTML files.", 2);
            return false;
        }
        Logger.writeln("<Success> Generate HTML files.", 4);
        return true;
    }

    public int getFileNum() {
        return this.fileNum;
    }

    public int getAddedFileNum() {
        return this.addedFileNum;
    }

    public int getDeletedFileNum() {
        return this.deletedFileNum;
    }

    public int getCloneFileNum() {
        return this.cloneFileNum;
    }

    public int getStableCloneNum() {
        return this.stableCloneNum;
    }

    public int getAddedCloneNum() {
        return this.addedCloneNum;
    }

    public int getDeletedCloneNum() {
        return this.deletedCloneNum;
    }

    public int getModifiedCloneNum() {
        return this.modifiedCloneNum;
    }

    public int getMovedCloneNum() {
        return this.movedCloneNum;
    }

    public int getCloneNum() {
        return this.cloneNum;
    }

    public int getStableCloneSetNum() {
        return this.stableCloneSetNum;
    }

    public int getNewCloneSetNum() {
        return this.newCloneSetNum;
    }

    public int getDeletedCloneSetNum() {
        return this.deletedCloneSetNum;
    }

    public int getChangedCloneSetNum() {
        return this.changedCloneSetNum;
    }

    public int getCloneSetNum() {
        return this.cloneSetNum;
    }

    public String getYear() {
        return this.year;
    }

    public String getMonth() {
        return this.month;
    }

    public String getDay() {
        return this.day;
    }
}

