/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.y_yuuki.cn.analyze;

import java.util.ArrayList;
import java.util.Iterator;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Clone;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.SourceFile;

public class CloneCategorizer {
    public static void categorizeClone(ArrayList<SourceFile> fileList) {
        for (SourceFile file : fileList) {
            if (file.getState() == 0) {
                CloneCategorizer.categorizeStableModified(file);
                CloneCategorizer.categorizeMoved(file);
            }
            CloneCategorizer.categorizeAddedDeleted(file);
        }
    }

    private static void categorizeStableModified(SourceFile file) {
        block0: for (Clone cloneA : file.getNewCloneList()) {
            int addedLineStart = 0;
            int addedLineEnd = 0;
            Iterator<Object> iterator = file.getAddedCodeList().iterator();
            while (iterator.hasNext()) {
                int line = iterator.next();
                if (line < cloneA.getStartLine()) {
                    ++addedLineStart;
                }
                if (line > cloneA.getEndLine()) break;
                ++addedLineEnd;
            }
            for (Clone cloneB : file.getOldCloneList()) {
                if (cloneB.getCategory() != -1) continue;
                int deletedLineStart = 0;
                int deletedLineEnd = 0;
                for (int line : file.getDeletedCodeList()) {
                    if (line < cloneB.getStartLine()) {
                        ++deletedLineStart;
                    }
                    if (line > cloneB.getEndLine()) break;
                    ++deletedLineEnd;
                }
                if (cloneA.getStartLine() - addedLineStart != cloneB.getStartLine() - deletedLineStart || cloneA.getEndLine() - addedLineEnd != cloneB.getEndLine() - deletedLineEnd || cloneA.getCloneSet() != cloneB.getCloneSet()) continue;
                if (addedLineStart == addedLineEnd && deletedLineStart == deletedLineEnd) {
                    cloneA.setCategory(0);
                    cloneB.setCategory(0);
                } else {
                    cloneA.setCategory(1);
                    cloneB.setCategory(1);
                }
                cloneA.setParentClone(cloneB);
                cloneB.setChildClone(cloneA);
                continue block0;
            }
        }
    }

    private static void categorizeMoved(SourceFile file) {
        block0: for (Clone cloneA : file.getNewCloneList()) {
            int addedLineStart = 0;
            int addedLineEnd = 0;
            Iterator<Object> iterator = file.getAddedCodeList().iterator();
            while (iterator.hasNext()) {
                int line = iterator.next();
                if (line < cloneA.getStartLine()) {
                    ++addedLineStart;
                }
                if (line > cloneA.getEndLine()) break;
                ++addedLineEnd;
            }
            for (Clone cloneB : file.getOldCloneList()) {
                if (cloneB.getCategory() != -1) continue;
                int deletedLineStart = 0;
                int deletedLineEnd = 0;
                for (int line : file.getDeletedCodeList()) {
                    if (line < cloneB.getStartLine()) {
                        ++deletedLineStart;
                    }
                    if (line > cloneB.getEndLine()) break;
                    ++deletedLineEnd;
                }
                if (cloneA.getStartLine() - addedLineStart != cloneB.getStartLine() - deletedLineStart || cloneA.getEndLine() - addedLineEnd != cloneB.getEndLine() - deletedLineEnd) continue;
                cloneA.setCategory(2);
                cloneB.setCategory(2);
                cloneA.setParentClone(cloneB);
                cloneB.setChildClone(cloneA);
                continue block0;
            }
        }
    }

    private static void categorizeAddedDeleted(SourceFile file) {
        for (Clone clone : file.getNewCloneList()) {
            if (clone.getCategory() != -1) continue;
            clone.setCategory(3);
        }
        for (Clone clone : file.getOldCloneList()) {
            if (clone.getCategory() != -1) continue;
            clone.setCategory(4);
        }
    }
}

