/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.y_yuuki.cn.analyze;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Pattern;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Clone;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.CloneSet;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Project;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.SourceFile;

public class CCFXController {
    private Project project = null;

    public CCFXController(Project project) {
        this.project = project;
    }

    public boolean execute() {
        String[] cmdArray1 = new String[]{"ccfx/bin/ccfx.exe", "d", this.project.getLang(), "-b", Integer.toString(this.project.getTokenTh()), "-dn", String.valueOf(this.project.getNewDir()) + "\\src", "-is", "-dn", String.valueOf(this.project.getOldDir()) + "\\src"};
        String[] cmdArray2 = new String[]{"ccfx/bin/ccfx.exe", "p", "a.ccfxd", "-o", "file/result.txt"};
        String[] cmdArray3 = new String[]{"ccfx/bin/ccfx.exe", "m", "a.ccfxd", "-c", "-o", "file/metrics.txt"};
        Runtime rt = Runtime.getRuntime();
        try {
            rt.exec(cmdArray1).waitFor();
            rt.exec(cmdArray2).waitFor();
            rt.exec(cmdArray3).waitFor();
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return new File("a.ccfxd").exists();
    }

    public boolean readCloneDataFile() {
        BufferedReader readFile = null;
        String line = null;
        int boundary = this.getFileNum(new File(String.valueOf(this.project.getNewDir()) + "\\src\\.ccfxprepdir"));
        ArrayList<SourceFile> fileList = new ArrayList<SourceFile>();
        ArrayList<CloneSet> cloneSetList = new ArrayList<CloneSet>();
        ArrayList<String> newFileList = new ArrayList<String>();
        ArrayList<String> oldFileList = new ArrayList<String>();
        try {
            try {
                readFile = new BufferedReader(new InputStreamReader(new FileInputStream("file/result.txt")));
                while (!(line = readFile.readLine()).equals("source_files {")) {
                }
                while (!(line = readFile.readLine()).equals("}")) {
                    String[] str = line.split("\t");
                    if (Integer.valueOf(str[0]) <= boundary) {
                        newFileList.add(str[1].substring(this.project.getNewDir().length() + 1));
                        continue;
                    }
                    oldFileList.add(str[1].substring(this.project.getOldDir().length() + 1));
                }
                readFile.close();
                readFile = new BufferedReader(new InputStreamReader(new FileInputStream("file/result.txt")));
                while (!readFile.readLine().equals("source_files {")) {
                }
                int fileId = 0;
                while (!(line = readFile.readLine()).equals("}")) {
                    String[] str = line.split("\t");
                    String fileName = Integer.valueOf(str[0]) <= boundary ? str[1].substring(this.project.getNewDir().length() + 1) : str[1].substring(this.project.getOldDir().length() + 1);
                    SourceFile file = new SourceFile();
                    file.setName(fileName);
                    file.setNewPath(String.valueOf(this.project.getNewDir()) + "\\" + fileName);
                    file.setOldPath(String.valueOf(this.project.getOldDir()) + "\\" + fileName);
                    if (Integer.valueOf(str[0]) <= boundary) {
                        file.setId(fileId++);
                        if (oldFileList.contains(fileName)) {
                            file.setState(0);
                        } else {
                            file.setState(1);
                        }
                        fileList.add(file);
                        continue;
                    }
                    if (newFileList.contains(fileName)) continue;
                    file.setId(fileId++);
                    file.setState(2);
                    fileList.add(file);
                }
                while (!readFile.readLine().equals("clone_pairs {")) {
                }
                int cloneId = 0;
                while (!(line = readFile.readLine()).equals("}")) {
                    String[] str = Pattern.compile("[\t|.|-]").split(line);
                    CloneSet cloneSet = null;
                    for (CloneSet pCloneSet : cloneSetList) {
                        if (pCloneSet.getId() != Integer.valueOf(str[0]).intValue()) continue;
                        cloneSet = pCloneSet;
                    }
                    if (cloneSet == null) {
                        cloneSet = new CloneSet();
                        cloneSet.setId(Integer.valueOf(str[0]));
                        cloneSetList.add(cloneSet);
                    }
                    Clone clone = new Clone();
                    clone.setCloneSet(cloneSet);
                    clone.setStartToken(Integer.valueOf(str[2]));
                    clone.setEndToken(Integer.valueOf(str[3]));
                    clone.setId(cloneId++);
                    if (Integer.valueOf(str[1]) <= boundary) {
                        clone.setFile(Project.getFileObj(fileList, (String)newFileList.get(Integer.valueOf(str[1]) - 1)));
                        if (!this.addClone(cloneSet.getNewCloneList(), clone)) {
                            // empty if block
                        }
                    } else {
                        clone.setFile(Project.getFileObj(fileList, (String)oldFileList.get(Integer.valueOf(str[1]) - 1 - boundary)));
                        if (!this.addClone(cloneSet.getOldCloneList(), clone)) {
                            --cloneId;
                        }
                    }
                    clone = new Clone();
                    clone.setCloneSet(cloneSet);
                    clone.setStartToken(Integer.valueOf(str[5]));
                    clone.setEndToken(Integer.valueOf(str[6]));
                    int n = --cloneId;
                    ++cloneId;
                    clone.setId(n);
                    if (Integer.valueOf(str[4]) <= boundary) {
                        clone.setFile(Project.getFileObj(fileList, (String)newFileList.get(Integer.valueOf(str[4]) - 1)));
                        if (this.addClone(cloneSet.getNewCloneList(), clone)) continue;
                        --cloneId;
                        continue;
                    }
                    clone.setFile(Project.getFileObj(fileList, (String)oldFileList.get(Integer.valueOf(str[4]) - 1 - boundary)));
                    if (this.addClone(cloneSet.getOldCloneList(), clone)) continue;
                    --cloneId;
                }
            }
            catch (FileNotFoundException e) {
                if (readFile != null) {
                    try {
                        readFile.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                return false;
            }
            catch (IOException e) {
                if (readFile != null) {
                    try {
                        readFile.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
                return false;
            }
        }
        finally {
            if (readFile != null) {
                try {
                    readFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        ArrayList tmpCloneSetList = (ArrayList)cloneSetList.clone();
        for (CloneSet cloneSet : tmpCloneSetList) {
            if (cloneSet.getNewCloneList().size() == 1) {
                cloneSet.getNewCloneList().remove(0);
            }
            if (cloneSet.getOldCloneList().size() == 1) {
                cloneSet.getOldCloneList().remove(0);
            }
            if (cloneSet.getNewCloneList().isEmpty() && cloneSet.getOldCloneList().isEmpty()) {
                cloneSetList.remove(cloneSet);
            }
            if (!this.project.isOlFilter() || !this.isOverlapping(cloneSet.getNewCloneList()) && !this.isOverlapping(cloneSet.getOldCloneList())) continue;
            cloneSetList.remove(cloneSet);
        }
        for (CloneSet cloneSet : cloneSetList) {
            for (Clone clone : cloneSet.getNewCloneList()) {
                clone.getFile().getNewCloneList().add(clone);
            }
            for (Clone clone : cloneSet.getOldCloneList()) {
                clone.getFile().getOldCloneList().add(clone);
            }
        }
        for (SourceFile file : fileList) {
            file.sortCloneListbyToken();
        }
        this.project.getCloneSetList().addAll(cloneSetList);
        this.project.getFileList().addAll(fileList);
        return true;
    }

    private int getFileNum(File dir) {
        if (!dir.exists()) {
            return 0;
        }
        File[] fileList = dir.listFiles();
        int count = 0;
        File[] fileArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                count += this.getFileNum(f);
            }
            if (f.isFile()) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public boolean readPrepFile() throws Exception {
        BufferedReader readFile = null;
        for (SourceFile file : this.project.getFileList()) {
            String[] str;
            String line;
            ArrayList<Integer> columns;
            int i;
            File[] prepList;
            String prepDir;
            String prepFile;
            if (file.getState() != 2) {
                prepFile = null;
                prepDir = String.valueOf(this.project.getNewDir()) + "\\src\\.ccfxprepdir\\";
                if (!new File(file.getNewPath()).getParentFile().getAbsolutePath().equals(String.valueOf(this.project.getNewDir()) + "\\src")) {
                    prepDir = String.valueOf(prepDir) + new File(file.getNewPath()).getParentFile().getAbsolutePath().substring(new File(String.valueOf(this.project.getNewDir()) + "\\src").getAbsolutePath().length() + 1);
                }
                if (!new File(prepDir).exists()) {
                    return false;
                }
                prepList = new File(prepDir).listFiles();
                i = 0;
                while (i < prepList.length) {
                    if (prepList[i].getName().startsWith(new File(file.getNewPath()).getName())) {
                        prepFile = prepList[i].getAbsolutePath();
                        break;
                    }
                    ++i;
                }
                if (prepFile != null) {
                    ArrayList<Integer> lines = new ArrayList<Integer>();
                    columns = new ArrayList<Integer>();
                    try {
                        try {
                            readFile = new BufferedReader(new InputStreamReader(new FileInputStream(prepFile)));
                            while ((line = readFile.readLine()) != null) {
                                str = Pattern.compile("[\t|.]").split(line);
                                lines.add(Integer.decode("0x" + str[0]));
                                columns.add(Integer.decode("0x" + str[1]));
                            }
                            for (Clone clone : file.getNewCloneList()) {
                                clone.setStartLine((Integer)lines.get(clone.getStartToken()));
                                clone.setStartColumn((Integer)columns.get(clone.getStartToken()));
                                clone.setEndLine((Integer)lines.get(clone.getEndToken()));
                                clone.setEndColumn((Integer)columns.get(clone.getEndToken()));
                            }
                        }
                        catch (FileNotFoundException e) {
                            if (readFile != null) {
                                try {
                                    readFile.close();
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                }
                            }
                            return false;
                        }
                        catch (IOException e) {
                            if (readFile != null) {
                                try {
                                    readFile.close();
                                }
                                catch (IOException e3) {
                                    e3.printStackTrace();
                                }
                            }
                            return false;
                        }
                    }
                    finally {
                        if (readFile != null) {
                            try {
                                readFile.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
            if (file.getState() == 1) continue;
            prepFile = null;
            prepDir = String.valueOf(this.project.getOldDir()) + "\\src\\.ccfxprepdir\\";
            if (!new File(file.getOldPath()).getParentFile().getAbsolutePath().equals(String.valueOf(this.project.getOldDir()) + "\\src")) {
                prepDir = String.valueOf(prepDir) + new File(file.getOldPath()).getParentFile().getAbsolutePath().substring(new File(String.valueOf(this.project.getOldDir()) + "\\src").getAbsolutePath().length() + 1);
            }
            if (!new File(prepDir).exists()) {
                return false;
            }
            prepList = new File(prepDir).listFiles();
            i = 0;
            while (i < prepList.length) {
                if (prepList[i].getName().startsWith(new File(file.getOldPath()).getName())) {
                    prepFile = prepList[i].getAbsolutePath();
                    break;
                }
                ++i;
            }
            if (prepFile == null) continue;
            ArrayList<Integer> lines = new ArrayList<Integer>();
            columns = new ArrayList();
            try {
                try {
                    readFile = new BufferedReader(new InputStreamReader(new FileInputStream(prepFile)));
                    while ((line = readFile.readLine()) != null) {
                        str = Pattern.compile("[\t|.]").split(line);
                        lines.add(Integer.decode("0x" + str[0]));
                        columns.add(Integer.decode("0x" + str[1]));
                    }
                    for (Clone clone : file.getOldCloneList()) {
                        clone.setStartLine((Integer)lines.get(clone.getStartToken()));
                        clone.setStartColumn((Integer)columns.get(clone.getStartToken()));
                        clone.setEndLine((Integer)lines.get(clone.getEndToken()));
                        clone.setEndColumn((Integer)columns.get(clone.getEndToken()));
                    }
                }
                catch (FileNotFoundException e) {
                    if (readFile != null) {
                        try {
                            readFile.close();
                        }
                        catch (IOException e4) {
                            e4.printStackTrace();
                        }
                    }
                    return false;
                }
                catch (IOException e) {
                    if (readFile != null) {
                        try {
                            readFile.close();
                        }
                        catch (IOException e5) {
                            e5.printStackTrace();
                        }
                    }
                    return false;
                }
            }
            finally {
                if (readFile != null) {
                    try {
                        readFile.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return true;
    }

    public boolean getCloneMetrics() {
        BufferedReader readFile = null;
        try {
            try {
                readFile = new BufferedReader(new InputStreamReader(new FileInputStream("file/metrics.txt")));
                String line = null;
                readFile.readLine();
                while ((line = readFile.readLine()) != null) {
                    String[] str = line.split("\t");
                    for (CloneSet cloneSet : this.project.getCloneSetList()) {
                        if (str.length != 10 || cloneSet.getId() != Integer.valueOf(str[0]).intValue()) continue;
                        cloneSet.setLEN(Integer.valueOf(str[1]));
                        cloneSet.setPOP(Integer.valueOf(str[2]));
                        cloneSet.setNIF(Integer.valueOf(str[3]));
                        cloneSet.setRAD(Integer.valueOf(str[4]));
                        cloneSet.setRNR(Double.valueOf(str[5]));
                        cloneSet.setTKS(Integer.valueOf(str[6]));
                        cloneSet.setLOOP(Integer.valueOf(str[7]));
                        cloneSet.setCOND(Integer.valueOf(str[8]));
                        cloneSet.setMcCabe(Integer.valueOf(str[9]));
                    }
                }
            }
            catch (FileNotFoundException e) {
                if (readFile != null) {
                    try {
                        readFile.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                return false;
            }
            catch (IOException e) {
                if (readFile != null) {
                    try {
                        readFile.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
                return false;
            }
        }
        finally {
            if (readFile != null) {
                try {
                    readFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean addClone(ArrayList<Clone> cloneList, Clone clone) {
        for (Clone pClone : cloneList) {
            if (!clone.equals(pClone)) continue;
            return false;
        }
        cloneList.add(clone);
        return true;
    }

    private boolean isOverlapping(ArrayList<Clone> cloneList) {
        int i = 0;
        while (cloneList.size() > i) {
            int j = i + 1;
            while (cloneList.size() > j) {
                Clone clone1 = cloneList.get(i);
                Clone clone2 = cloneList.get(j);
                if (clone1.getFile().getId() == clone2.getFile().getId() && (clone1.getStartToken() < clone2.getStartToken() && clone1.getEndToken() > clone2.getStartToken() || clone2.getStartToken() < clone1.getStartToken() && clone2.getEndToken() > clone1.getStartToken())) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

