/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.y_yuuki.cn;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;

public class Logger {
    private static PrintWriter logger;
    private static Calendar now;
    private static String hour;
    private static String minute;
    private static String second;
    public static final int DEBUG = -1;
    public static final int INFO = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int FATAL = 3;
    public static final int SYSTEM = 4;
    private static int level;

    static {
        now = Calendar.getInstance();
        level = 1;
    }

    public static void init() throws IOException {
        String day;
        logger = new PrintWriter(new BufferedWriter(new FileWriter(new File("ccm.log"), true)));
        String year = Integer.toString(now.get(1));
        String month = Integer.toString(now.get(2) + 1);
        if (month.length() == 1) {
            month = "0" + month;
        }
        if ((day = Integer.toString(now.get(5))).length() == 1) {
            day = "0" + day;
        }
        Logger.writeln("######  " + year + " / " + month + " / " + day + "  #####");
    }

    private static void writeln(String msg) {
        Logger.updateTime();
        logger.println(String.valueOf(msg) + " ( " + hour + ":" + minute + ":" + second + " )");
        logger.flush();
    }

    public static void writeln(String msg, int level) {
        if (level >= Logger.level) {
            String prefix = Logger.getLevelPrefix(level);
            Logger.writeln(String.valueOf(prefix) + msg);
        }
    }

    public static void finish(String msg, int level) {
        Logger.writeln(msg, level);
        logger.close();
        System.exit(0);
    }

    private static void updateTime() {
        now = Calendar.getInstance();
        hour = Integer.toString(now.get(11));
        if (hour.length() == 1) {
            hour = "0" + hour;
        }
        if ((minute = Integer.toString(now.get(12))).length() == 1) {
            minute = "0" + minute;
        }
        if ((second = Integer.toString(now.get(13))).length() == 1) {
            second = "0" + second;
        }
    }

    public static void printlnConsole(String mes, int loglevel) {
        if (loglevel >= level) {
            String prefix = Logger.getLevelPrefix(loglevel);
            System.err.println(String.valueOf(prefix) + mes);
        }
    }

    private static String getLevelPrefix(int level) {
        String prefix = "";
        switch (level) {
            case 0: {
                prefix = "INFO: ";
                break;
            }
            case 1: {
                prefix = "WARNING: ";
                break;
            }
            case 2: {
                prefix = "ERROR: ";
                break;
            }
            case 3: {
                prefix = "FATAL: ";
                break;
            }
            case -1: 
            case 4: {
                prefix = "";
                break;
            }
            default: {
                Logger.printlnConsole("Specified unknown log level. [getLevelPrefix]", 3);
            }
        }
        return prefix;
    }
}

