/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.m_sano.extractor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.ac.osaka_u.ist.sel.m_sano.extractor.data.Token;
import jp.ac.osaka_u.ist.sel.m_sano.extractor.data.TokenType;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.Logger;
import jp.ac.osaka_u.ist.sel.y_yuuki.cn.data.Method;

public class JavaMethodExtractor {
    public static final int TT_WORD = -3;
    public static final int TT_NUMBER = -2;
    public static final int TT_EOF = -1;
    public static final int TT_LF = 10;
    public static final int TT_DOT = 46;
    public static final int TT_CR = 13;
    public static final int TT_TAB = 9;
    public static final int TT_SPACE = 32;
    public static final ArrayList<String> keywords = new ArrayList<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "if", "goto", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"));
    private File targetFile;

    public JavaMethodExtractor(String path) {
        this.setTargetFile(path);
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    public void setTargetFile(File target) {
        this.targetFile = target;
    }

    public void setTargetFile(String targetPath) {
        this.setTargetFile(new File(targetPath));
    }

    public ArrayList<Method> extractMethod() throws FileNotFoundException, IOException {
        ArrayList<Method> methodList = new ArrayList<Method>();
        LinkedList<Token> tkList = this.tokenizeToToken();
        Iterator it = tkList.iterator();
        ArrayList<Token> sentence = new ArrayList<Token>();
        Method md = null;
        ArrayList<String> modifier = new ArrayList<String>();
        ArrayList<Integer> classStartBlacket = new ArrayList<Integer>();
        int blacketCnt = -1;
        int mdStartBlacket = -1;
        boolean isStaticInit = false;
        boolean enumMode = false;
        boolean inEnum = false;
        boolean instanceMethod = false;
        boolean isClassInit = false;
        while (it.hasNext()) {
            Token tk = (Token)it.next();
            if ((tk.getToken().equals("class") || tk.getToken().equals("interface")) && it.hasNext() && (tk = (Token)it.next()).getType() == TokenType.IDENTIFIER) {
                modifier.add(tk.getToken());
                classStartBlacket.add(blacketCnt + 1);
                isClassInit = true;
            }
            if (!isClassInit) continue;
            if (tk.getToken().equals("{")) {
                int index = -1;
                if (md == null && !isStaticInit) {
                    Iterator itStInd = sentence.iterator();
                    int k = 0;
                    boolean annotation = false;
                    while (itStInd.hasNext()) {
                        String parentk = ((Token)itStInd.next()).getToken();
                        if (parentk.equals("enum")) {
                            enumMode = true;
                            break;
                        }
                        if (parentk.equals("new")) {
                            instanceMethod = true;
                            break;
                        }
                        if (enumMode && !inEnum) {
                            inEnum = true;
                            break;
                        }
                        if (parentk.equals("@")) {
                            ++k;
                            parentk = ((Token)itStInd.next()).getToken();
                            ++k;
                            parentk = ((Token)itStInd.next()).getToken();
                            annotation = true;
                        }
                        if (parentk.equals("(")) {
                            if (annotation) {
                                while (!parentk.equals(")") && itStInd.hasNext()) {
                                    ++k;
                                    parentk = ((Token)itStInd.next()).getToken();
                                }
                                annotation = false;
                                if (!itStInd.hasNext()) {
                                    break;
                                }
                            } else {
                                index = k;
                                break;
                            }
                        }
                        annotation = false;
                        ++k;
                    }
                    if (index != -1 && index > 0 && ((Token)sentence.get(index - 1)).getType() == TokenType.IDENTIFIER) {
                        md = new Method();
                        md.setName(((Token)sentence.get(index - 1)).getToken());
                        md.setStartLine(((Token)sentence.get(0)).getLine());
                        md.setStartColumn(((Token)sentence.get(0)).getColumn());
                        String mod = null;
                        Iterator itMod = modifier.iterator();
                        while (itMod.hasNext()) {
                            mod = mod == null ? (String)itMod.next() : mod.concat("." + (String)itMod.next());
                        }
                        md.setModifiedName(String.valueOf(mod) + "." + md.getName());
                        int i = index + 1;
                        String paramStr = "(";
                        Logger.writeln("<JavaMethodExtractor> targetFile is " + this.targetFile.toString(), -1);
                        while (!((Token)sentence.get(i)).getToken().equals(")")) {
                            Token paramTk = (Token)sentence.get(i);
                            if (i == index + 1) {
                                paramStr = paramStr.concat(paramTk.getToken());
                            } else if (paramTk.getToken().equals("<")) {
                                paramStr = paramStr.concat("<");
                                while (!(paramTk = (Token)sentence.get(++i)).getToken().equals(">")) {
                                    paramStr = paramStr.concat(paramTk.getToken());
                                }
                                paramStr = paramStr.concat(">");
                            } else {
                                paramStr = paramStr.endsWith("...") ? paramStr.concat(" " + paramTk.getToken()) : (!(paramTk.getType() != TokenType.IDENTIFIER && paramTk.getType() != TokenType.RESERVED || ((Token)sentence.get(i - 1)).getType() != TokenType.IDENTIFIER && ((Token)sentence.get(i - 1)).getType() != TokenType.RESERVED && !((Token)sentence.get(i - 1)).getToken().equals(">") && !((Token)sentence.get(i - 1)).getToken().equals("]")) ? paramStr.concat(" " + paramTk.getToken()) : paramStr.concat(paramTk.getToken()));
                            }
                            ++i;
                        }
                        md.setParams(String.valueOf(paramStr) + ")");
                        mdStartBlacket = blacketCnt + 1;
                        Logger.writeln("<JavaMethodExtractor> Extract " + md.getModifiedName() + md.getParams(), -1);
                    }
                }
                if (sentence.size() == 1 && ((Token)sentence.get(0)).getToken().equals("static")) {
                    isStaticInit = true;
                    mdStartBlacket = blacketCnt + 1;
                }
                sentence.clear();
                ++blacketCnt;
                continue;
            }
            if (tk.getToken().equals("}")) {
                if (blacketCnt == mdStartBlacket) {
                    if (md != null) {
                        md.setEndLine(tk.getLine());
                        md.setEndColumn(tk.getColumn());
                        methodList.add(md);
                        md = null;
                    }
                    if (isStaticInit) {
                        isStaticInit = false;
                    }
                    mdStartBlacket = -1;
                } else {
                    if (instanceMethod) {
                        instanceMethod = false;
                    }
                    if (inEnum) {
                        inEnum = false;
                    } else if (enumMode) {
                        enumMode = false;
                    }
                }
                if ((Integer)classStartBlacket.get(classStartBlacket.size() - 1) == blacketCnt) {
                    classStartBlacket.remove(classStartBlacket.size() - 1);
                    modifier.remove(modifier.size() - 1);
                }
                sentence.clear();
                --blacketCnt;
                continue;
            }
            if (tk.getToken().equals(";")) {
                sentence.clear();
                continue;
            }
            sentence.add(tk);
        }
        return methodList;
    }

    /*
     * Unable to fully structure code
     */
    private LinkedList<Token> tokenizeToToken() throws FileNotFoundException, IOException {
        reader = new InputStreamReader((InputStream)new FileInputStream(this.targetFile), "JISAutoDetect");
        tokenizer = new StreamTokenizer(reader);
        this.setupTokenizer(tokenizer);
        tokenList = new LinkedList<Token>();
        line = 1;
        column = 1;
        startLine = -1;
        startColumn = -1;
        tkName = null;
        tkType = TokenType.UNKNOWN;
        while ((token = tokenizer.nextToken()) != -1) {
            switch (token) {
                case -3: {
                    tkName = tokenizer.sval;
                    tkType = JavaMethodExtractor.keywords.contains(tkName) != false ? TokenType.RESERVED : (this.isNumber(tkName) != false ? TokenType.NUMBER : TokenType.IDENTIFIER);
                    startLine = line;
                    startColumn = column;
                    column += tkName.length();
                    break;
                }
                case 9: 
                case 32: {
                    ++column;
                    break;
                }
                case 10: {
                    ++line;
                    column = 1;
                    break;
                }
                case 13: {
                    break;
                }
                case 47: {
                    next = tokenizer.nextToken();
                    tokenizer.ordinaryChar(39);
                    tokenizer.ordinaryChar(34);
                    ++column;
                    if (next != 47) ** GOTO lbl40
                    while ((token = tokenizer.nextToken()) != 10 && token != -1) {
                    }
                    ++line;
                    column = 1;
                    ** GOTO lbl55
lbl40:
                    // 1 sources

                    if (next != 42) ** GOTO lbl54
                    while ((token = tokenizer.nextToken()) != -1) {
                        column = token == -3 ? (column += tokenizer.sval.length()) : ++column;
                        if (token != 42) ** GOTO lbl49
                        ntk = tokenizer.nextToken();
                        if (ntk != 47) ** GOTO lbl48
                        ++column;
                        ** GOTO lbl55
lbl48:
                        // 1 sources

                        tokenizer.pushBack();
lbl49:
                        // 2 sources

                        if (token != 10) continue;
                        ++line;
                        column = 1;
                    }
                    ** GOTO lbl55
lbl54:
                    // 1 sources

                    tokenizer.pushBack();
lbl55:
                    // 4 sources

                    tokenizer.quoteChar(39);
                    tokenizer.quoteChar(34);
                    break;
                }
                default: {
                    tkName = String.valueOf(Character.toChars(token));
                    tkType = TokenType.SYMBOL;
                    startLine = line;
                    startColumn = column++;
                }
            }
            if (tkName == null) continue;
            tk = new Token(tkName, tkType);
            tk.setPositon(startLine, startColumn);
            tokenList.add(tk);
            tkName = null;
        }
        reader.close();
        return tokenList;
    }

    private boolean isNumber(String token) {
        String regex = "^[0-9]";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(token);
        return matcher.find();
    }

    private void setupTokenizer(StreamTokenizer tokenizer) {
        tokenizer.resetSyntax();
        tokenizer.wordChars(48, 57);
        tokenizer.wordChars(97, 122);
        tokenizer.wordChars(65, 90);
        tokenizer.wordChars(95, 95);
        tokenizer.quoteChar(39);
        tokenizer.quoteChar(34);
        tokenizer.eolIsSignificant(true);
    }
}

