/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.javacc.jjtree.ASTNodeDescriptorExpression;
import org.javacc.jjtree.JJTreeNode;
import org.javacc.jjtree.JJTreeOptions;
import org.javacc.jjtree.JJTreeParserVisitor;
import org.javacc.jjtree.Token;

public class ASTNodeDescriptor
extends JJTreeNode {
    private boolean faked = false;
    static List nodeIds = new ArrayList();
    static List nodeNames = new ArrayList();
    static Hashtable nodeSeen = new Hashtable();
    String name;
    boolean isGT;
    ASTNodeDescriptorExpression expression;

    ASTNodeDescriptor(int n) {
        super(n);
    }

    static ASTNodeDescriptor indefinite(String string) {
        ASTNodeDescriptor aSTNodeDescriptor = new ASTNodeDescriptor(39);
        aSTNodeDescriptor.name = string;
        aSTNodeDescriptor.setNodeIdValue();
        aSTNodeDescriptor.faked = true;
        return aSTNodeDescriptor;
    }

    static List getNodeIds() {
        return nodeIds;
    }

    static List getNodeNames() {
        return nodeNames;
    }

    void setNodeIdValue() {
        String string = this.getNodeId();
        if (!nodeSeen.containsKey(string)) {
            nodeSeen.put(string, string);
            nodeNames.add(this.name);
            nodeIds.add(string);
        }
    }

    String getNodeId() {
        return "JJT" + this.name.toUpperCase().replace('.', '_');
    }

    boolean isVoid() {
        return this.name.equals("void");
    }

    public String toString() {
        if (this.faked) {
            return "(faked) " + this.name;
        }
        return super.toString() + ": " + this.name;
    }

    String getDescriptor() {
        if (this.expression == null) {
            return this.name;
        }
        return "#" + this.name + "(" + (this.isGT ? ">" : "") + this.expression_text() + ")";
    }

    String getNodeType() {
        if (JJTreeOptions.getMulti()) {
            return JJTreeOptions.getNodePrefix() + this.name;
        }
        return "SimpleNode";
    }

    String getNodeName() {
        return this.name;
    }

    String openNode(String string) {
        return "jjtree.openNodeScope(" + string + ");";
    }

    String expression_text() {
        if (this.expression.getFirstToken().image.equals(")") && this.expression.getLastToken().image.equals("(")) {
            return "true";
        }
        String string = "";
        Token token = this.expression.getFirstToken();
        while (true) {
            string = string + " " + token.image;
            if (token == this.expression.getLastToken()) break;
            token = token.next;
        }
        return string;
    }

    String closeNode(String string) {
        if (this.expression == null) {
            return "jjtree.closeNodeScope(" + string + ", true);";
        }
        if (this.isGT) {
            return "jjtree.closeNodeScope(" + string + ", jjtree.nodeArity() >" + this.expression_text() + ");";
        }
        return "jjtree.closeNodeScope(" + string + ", " + this.expression_text() + ");";
    }

    String translateImage(Token token) {
        return this.whiteOut(token);
    }

    public Object jjtAccept(JJTreeParserVisitor jJTreeParserVisitor, Object object) {
        return jJTreeParserVisitor.visit(this, object);
    }
}

