/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.clonedetector.evaluate;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import jp.ac.osaka_u.ist.sel.clonedetector.CloneDetector;
import jp.ac.osaka_u.ist.sel.clonedetector.data.ClonePair;
import jp.ac.osaka_u.ist.sel.clonedetector.data.CloneSet;
import jp.ac.osaka_u.ist.sel.clonedetector.data.Function;

public class Comparator {
    public static final String BENCHMARK = "mecc_python.txt";
    public static final String RECALL_RESULT = "recall_result.csv";

    public static void compareMeCC(ArrayList<CloneSet> cloneSetList) throws Exception {
        ArrayList<CloneSet> cloneSetListMeCC = Comparator.readMeCCBenchmark();
        ArrayList<ClonePair> clonePairListMeCC = Comparator.makeClonePairList(cloneSetListMeCC);
        ArrayList<ClonePair> clonePairList = Comparator.makeClonePairList(cloneSetList);
        Comparator.calcRecall(clonePairList, clonePairListMeCC);
    }

    private static ArrayList<CloneSet> readMeCCBenchmark() throws IOException {
        ArrayList<CloneSet> cloneSetList = new ArrayList<CloneSet>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(BENCHMARK)));
        String line = null;
        CloneSet cloneset = null;
        String backLine = null;
        while ((line = reader.readLine()) != null) {
            if (line.length() > 0 && '0' <= line.charAt(0) && '9' >= line.charAt(0)) {
                if (cloneset != null && cloneset.getCloneList().size() >= 2 && !backLine.contains("X")) {
                    cloneSetList.add(cloneset);
                }
                cloneset = new CloneSet();
            }
            if (line.contains("function : ") && cloneset != null) {
                Function method = new Function();
                line = line.replace("function : ", "");
                String[] tmp = line.split(" @ ");
                method.setName(tmp[0].replace(" ", ""));
                method.setFileName(tmp[1].replace(" ", "").replace("/", "\\").replace("\t", ""));
                for (Function m : CloneDetector.functionList) {
                    System.out.println(String.valueOf(m.getFileName()) + ":" + m.getName());
                    System.out.println(String.valueOf(method.getFileName()) + ":" + method.getName());
                    if (!m.getFileName().equals(method.getFileName()) || !m.getName().equals(method.getName())) continue;
                    cloneset.getCloneList().add(m);
                    break;
                }
            }
            backLine = line;
        }
        reader.close();
        return cloneSetList;
    }

    private static ArrayList<ClonePair> makeClonePairList(ArrayList<CloneSet> setList) {
        ArrayList<ClonePair> clonePairList = new ArrayList<ClonePair>();
        int set = 0;
        for (CloneSet cloneSet : setList) {
            int i = 0;
            while (i < cloneSet.getCloneList().size()) {
                int j = i + 1;
                while (j < cloneSet.getCloneList().size()) {
                    ClonePair clonePair = new ClonePair();
                    clonePair.setCloneA(cloneSet.getCloneList().get(i));
                    clonePair.setCloneB(cloneSet.getCloneList().get(j));
                    clonePair.set = set;
                    clonePairList.add(clonePair);
                    ++j;
                }
                ++i;
            }
            ++set;
        }
        return clonePairList;
    }

    private static void calcRecall(ArrayList<ClonePair> pairList, ArrayList<ClonePair> clonePairListMeCC) throws FileNotFoundException {
        int trueclone = 0;
        block0: for (ClonePair pairA : clonePairListMeCC) {
            for (ClonePair pairB : pairList) {
                if ((!pairA.getCloneA().getName().equals(pairB.getCloneA().getName()) || !pairA.getCloneA().getFileName().equals(pairB.getCloneA().getFileName()) || !pairA.getCloneB().getName().equals(pairB.getCloneB().getName()) || !pairA.getCloneB().getFileName().equals(pairB.getCloneB().getFileName())) && (!pairA.getCloneA().getName().equals(pairB.getCloneB().getName()) || !pairA.getCloneA().getFileName().equals(pairB.getCloneB().getFileName()) || !pairA.getCloneB().getName().equals(pairB.getCloneA().getName()) || !pairA.getCloneB().getFileName().equals(pairB.getCloneA().getFileName()))) continue;
                ++trueclone;
                pairA.check = true;
                continue block0;
            }
        }
        System.out.printf("True:%d\r\n", trueclone);
        System.out.printf("|B|:%d\r\n", clonePairListMeCC.size());
        System.out.printf("|A|:%d\r\n", pairList.size());
        System.out.printf("|A+B|:%d\r\n", pairList.size() + clonePairListMeCC.size() - trueclone);
        System.out.printf("Recall:%f\r\n", (double)pairList.size() / (double)(pairList.size() + clonePairListMeCC.size() - trueclone));
        PrintWriter writer = new PrintWriter(new FileOutputStream(RECALL_RESULT));
        for (ClonePair pair : clonePairListMeCC) {
            writer.printf("%d,%s,%s,%s\r\n", pair.set, String.valueOf(pair.getCloneA().getFileName()) + "." + pair.getCloneA().getName(), String.valueOf(pair.getCloneB().getFileName()) + "." + pair.getCloneB().getName(), pair.check);
        }
        writer.flush();
        writer.close();
    }
}

