/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.clonedetector;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import jp.ac.osaka_u.ist.sel.clonedetector.CloneDetector;
import jp.ac.osaka_u.ist.sel.clonedetector.Config;
import jp.ac.osaka_u.ist.sel.clonedetector.data.Function;
import jp.ac.osaka_u.ist.sel.clonedetector.data.Word;

public class VectorCalculator {
    public void filterFunction() {
        ArrayList<Function> newFunctionList = new ArrayList<Function>();
        int i = 0;
        for (Function method : CloneDetector.functionList) {
            if (method.getSize() < Config.sizeTh || 'A' <= method.getName().charAt(0) && method.getName().charAt(0) <= 'Z') continue;
            newFunctionList.add(method);
            for (Word word : method.getWordList()) {
                if (CloneDetector.wordMap.containsKey(word.getName())) continue;
                CloneDetector.wordMap.put(word.getName(), i++);
            }
        }
        CloneDetector.functionList = newFunctionList;
    }

    public void calculateVector() {
        int[] wordFreq = new int[CloneDetector.wordMap.size()];
        for (Function function : CloneDetector.functionList) {
            double wordCount = 0.0;
            int statementCount = 0;
            for (Word word : function.getWordList()) {
                switch (word.getType()) {
                    case 0: {
                        wordCount += word.getCount();
                        break;
                    }
                    case 1: {
                        statementCount = (int)((double)statementCount + word.getCount());
                    }
                }
                int n = CloneDetector.wordMap.get(word.getName());
                wordFreq[n] = wordFreq[n] + 1;
            }
            function.setWordNum(wordCount);
            function.setStatementNum(statementCount);
        }
        try {
            PrintWriter writer = new PrintWriter(new FileOutputStream("dataset.txt"));
            for (Function function : CloneDetector.functionList) {
                double[] vector = new double[CloneDetector.wordMap.size()];
                for (Word word : function.getWordList()) {
                    int id = CloneDetector.wordMap.get(word.getName());
                    double tf = 0.0;
                    switch (word.getType()) {
                        case 0: {
                            tf = word.getCount() / function.getWordNum();
                            break;
                        }
                        case 1: {
                            tf = word.getCount() / (double)function.getStatementNum();
                        }
                    }
                    double idf = 1.0 + Math.log((double)CloneDetector.functionList.size() / (double)wordFreq[id]);
                    vector[id] = tf * idf;
                }
                function.setVector(vector);
                double len = 0.0;
                double[] dArray = vector;
                int n = vector.length;
                int n2 = 0;
                while (n2 < n) {
                    double i = dArray[n2];
                    writer.printf("%f ", i);
                    len += i * i;
                    ++n2;
                }
                function.setLen(Math.sqrt(len));
                writer.println();
            }
            writer.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Error: can't convert function to characteristic vectors.");
            System.exit(1);
        }
    }
}

