/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.plugin.timecard.autojob;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.clearfy.datawrapper.Jdbc;
import org.clearfy.plugin.scheduler.Job;
import org.clearfy.plugin.timecard.autojob.WorkReportEditor;

public class WorkTimeCalculator
extends Job {
    private int currNormalizer = 1;
    public static final String INITIAL_DATETIME = "1900-01-01 00:00:00.0";
    public static final double BREAKPOINT_0 = 6.0;
    public static final double BREAKPOINT_1 = 8.0;
    public static final BigDecimal DIVIDE_SCALE = new BigDecimal(1800.0);

    public WorkTimeCalculator(Jdbc controller) {
        super(controller);
    }

    private ResultSet getRawData(int employeeId, String recDate) {
        ResultSet rvalue = null;
        String dtime = recDate;
        String cmd = "select EMPLOYEE_ID, CHECK_DATE, RECORD_DATETIME, ORGANIZATION_ID  from TIME_RECORD  where EMPLOYEE_ID = %d and CHECK_DATE = '%s' and DISABLE = 0  order by RECORD_DATETIME ";
        cmd = String.format(cmd, employeeId, dtime);
        rvalue = this.getDataController().select(cmd);
        return rvalue;
    }

    public void execute() {
        BigDecimal hdHour = new BigDecimal("3600000");
        ResultSet rs = this.getTargetWorkingReport();
        try {
            while (rs.next()) {
                System.out.println(String.format("%s %s", rs.getString("EMPLOYEE_ID"), rs.getString("REC_DATE")));
                int employeeId = rs.getInt("EMPLOYEE_ID");
                String recDate = rs.getString("REC_DATE");
                this.currNormalizer = this.getNormalizeTime(String.valueOf(employeeId));
                ResultSet row = this.getTargetRow(employeeId, recDate);
                if (row.next()) {
                    Timestamp startTime = row.getTimestamp("START_TIME");
                    Timestamp gooutTime = row.getTimestamp("GOOUT_TIME");
                    Timestamp returnTime = row.getTimestamp("RETURN_TIME");
                    Timestamp endTime = row.getTimestamp("END_TIME");
                    BigDecimal worktime = new BigDecimal("0.0");
                    BigDecimal breaktime = new BigDecimal("0.0");
                    if (startTime.toString().equals(INITIAL_DATETIME) || endTime.toString().equals(INITIAL_DATETIME)) {
                        String cmd = "merge into WORKTIME_REPORT (EMPLOYEE_ID, REC_DATE, STATUS) values (%d, '%s', 999)";
                        cmd = String.format(cmd, employeeId, recDate);
                        this.getDataController().execute(cmd);
                    } else {
                        int recordCount = this.getRawRecordCount(employeeId, recDate);
                        ResultSet rawDatas = this.getRawData(employeeId, recDate);
                        int count = 0;
                        while (rawDatas.next()) {
                            if (recordCount < 5) {
                                switch (count) {
                                    case 0: {
                                        startTime = this.getOddRecordModifier(rawDatas, count);
                                        break;
                                    }
                                    case 1: {
                                        if (recordCount < 3) {
                                            endTime = this.normalize(rawDatas.getTimestamp("RECORD_DATETIME"), count);
                                            break;
                                        }
                                        gooutTime = rawDatas.getTimestamp("RECORD_DATETIME");
                                        break;
                                    }
                                    case 2: {
                                        returnTime = rawDatas.getTimestamp("RECORD_DATETIME");
                                        break;
                                    }
                                    case 3: {
                                        endTime = this.normalize(rawDatas.getTimestamp("RECORD_DATETIME"), count);
                                    }
                                }
                            } else {
                                if (count == 0) {
                                    startTime = this.getOddRecordModifier(rawDatas, count);
                                }
                                if (count == recordCount - 1) {
                                    endTime = this.normalize(rawDatas.getTimestamp("RECORD_DATETIME"), count);
                                }
                            }
                            ++count;
                        }
                        long lstartTime = startTime.getTime();
                        long lendTime = endTime.getTime();
                        long diff = lendTime - lstartTime;
                        worktime = new BigDecimal(diff);
                        worktime = worktime.divide(hdHour, 3, 1);
                        if (gooutTime.toString().equals(INITIAL_DATETIME) || gooutTime.toString().equals(INITIAL_DATETIME)) {
                            if (worktime.doubleValue() > 8.0) {
                                breaktime = new BigDecimal("1.0");
                            } else if (worktime.doubleValue() > 6.0) {
                                breaktime = new BigDecimal("1.0");
                            }
                        } else {
                            long lgoout = gooutTime.getTime() / 1000L;
                            long lret = returnTime.getTime() / 1000L;
                            long bdiff = lret - lgoout;
                            BigDecimal restTime = new BigDecimal((double)bdiff * 1.0);
                            BigDecimal scaleCount = restTime.divide(DIVIDE_SCALE, 0, 1);
                            BigDecimal remainded = restTime.remainder(DIVIDE_SCALE);
                            if (remainded.compareTo(BigDecimal.ZERO) > 0) {
                                scaleCount = scaleCount.add(BigDecimal.ONE);
                            }
                            breaktime = scaleCount.multiply(DIVIDE_SCALE).divide(new BigDecimal(3600));
                        }
                        worktime = worktime.subtract(breaktime);
                        String cmd = "merge into WORKTIME_REPORT (EMPLOYEE_ID, REC_DATE,WORK_TIME , BREAKE_TIME , STATUS) values (%d, '%s', %s, %s, 2)";
                        cmd = String.format(cmd, employeeId, recDate, worktime.toString(), breaktime.toString());
                        this.getDataController().execute(cmd);
                    }
                }
                row.close();
            }
            rs.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(WorkTimeCalculator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public ResultSet getTargetRow(int employeeId, String recDate) {
        String cmd = "select START_TIME, GOOUT_TIME, RETURN_TIME, END_TIME from WORKTIME_REPORT where EMPLOYEE_ID = %d and REC_DATE = '%s'";
        cmd = String.format(cmd, employeeId, recDate);
        ResultSet rvalue = this.getDataController().select(cmd);
        return rvalue;
    }

    public ResultSet getTargetWorkingReport() {
        String cmd = "select EMPLOYEE_ID, REC_DATE from WORKTIME_REPORT where STATUS = 1 and DISABLE = 0";
        ResultSet rvalue = this.getDataController().select(cmd);
        return rvalue;
    }

    private Timestamp normalize(Timestamp time, int count) {
        Timestamp rvalue = time;
        LocalDateTime t = rvalue.toLocalDateTime();
        int min = t.getMinute();
        if (count != 2) {
            int amari = min % this.currNormalizer;
            if (count % 2 == 1) {
                min = min / this.currNormalizer * this.currNormalizer;
                t = t.withMinute(min).withSecond(0).withNano(0);
            } else {
                min = min / this.currNormalizer * this.currNormalizer;
                if (amari > 0) {
                    min += this.currNormalizer;
                }
                t = t.withMinute(0).withSecond(0).withNano(0);
                t = t.plusMinutes(min);
            }
        } else {
            int div = min / this.currNormalizer;
            int amari = min % this.currNormalizer;
            if (amari > 0) {
                ++div;
            }
            min = div * this.currNormalizer;
            t = t.withMinute(0).withSecond(0).withNano(0).plusMinutes(min);
        }
        rvalue = Timestamp.valueOf(t);
        return rvalue;
    }

    private int getNormalizeTime(String employeeId) {
        int rvalue = 1;
        String cmd = "select NORMALIZE_TIME from EMPLOYEE where EMPLOYEE_ID = %s ";
        cmd = String.format(cmd, employeeId);
        ResultSet rs = this.getDataController().select(cmd);
        try {
            if (rs.next()) {
                rvalue = rs.getInt("NORMALIZE_TIME");
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(WorkReportEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    private Timestamp getOddRecordModifier(ResultSet timeRecord, int count) {
        Timestamp rvalue = null;
        try {
            rvalue = timeRecord.getTimestamp("RECORD_DATETIME");
            Timestamp recDatetime = timeRecord.getTimestamp("RECORD_DATETIME");
            LocalDateTime targetDate = timeRecord.getTimestamp("CHECK_DATE").toLocalDateTime();
            LocalDateTime recLocDateTime = recDatetime.toLocalDateTime();
            int dayOfWeek = targetDate.getDayOfWeek().getValue();
            int orgId = timeRecord.getInt("ORGANIZATION_ID");
            String cmd = "select * from ORGANIZATION_BIZ_HOURS where ORGANIZATION_ID = %d and DAY_OF_WEEK = %d order by START_TIME ";
            cmd = String.format(cmd, orgId, dayOfWeek);
            System.out.println(cmd);
            ResultSet rs = this.getDataController().select(cmd);
            while (rs.next()) {
                Timestamp start = rs.getTimestamp("START_TIME");
                LocalDateTime lstart = start.toLocalDateTime();
                lstart = lstart.withYear(recLocDateTime.getYear()).withMonth(recLocDateTime.getMonthValue()).withDayOfMonth(recLocDateTime.getDayOfMonth());
                int eNum = rs.getInt("ENTRY_NUM");
                if (!recLocDateTime.isBefore(lstart)) continue;
                if (eNum == 1) {
                    recDatetime = Timestamp.valueOf(lstart);
                    continue;
                }
                long diff = recDatetime.getTime() - Timestamp.valueOf(lstart).getTime();
                if ((diff /= 3600000L) != 0L) continue;
                recDatetime = Timestamp.valueOf(lstart);
            }
            rs.close();
            rvalue = recDatetime = this.normalize(recDatetime, count);
        }
        catch (SQLException ex) {
            Logger.getLogger(WorkReportEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }

    private int getRawRecordCount(int employeeId, String checkDate) {
        int rvalue = 0;
        String cmd = "Select count(*) reccount from TIME_RECORD where EMPLOYEE_ID = %d and CHECK_DATE = '%s' and DISABLE = 0";
        cmd = String.format(cmd, employeeId, checkDate);
        ResultSet rs = this.getDataController().select(cmd);
        try {
            if (rs.next()) {
                rvalue = rs.getInt("reccount");
            }
            rs.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(WorkReportEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rvalue;
    }
}

