/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.plugin.timecard.autojob;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.clearfy.datawrapper.Jdbc;
import org.clearfy.plugin.scheduler.Job;

public class LateTimeCalculator
extends Job {
    public static final int LATE_TIME = 22;

    public LateTimeCalculator(Jdbc controller) {
        super(controller);
    }

    public void execute() {
        ResultSet targetEmployee = this.getTargetEmployee();
        BigDecimal standardWorktime = new BigDecimal("8.0");
        try {
            while (targetEmployee.next()) {
                BigDecimal overTime;
                Timestamp recDate = targetEmployee.getTimestamp("REC_DATE");
                LocalDateTime rdate = recDate.toLocalDateTime();
                LocalDateTime lateTime = rdate.withHour(22);
                BigDecimal workTime = targetEmployee.getBigDecimal("WORK_TIME");
                BigDecimal bdLateTime = new BigDecimal("0.0");
                Timestamp endTime = targetEmployee.getTimestamp("END_TIME");
                LocalDateTime eTime = endTime.toLocalDateTime();
                BigDecimal diff = new BigDecimal("0.0");
                if (eTime.isAfter(lateTime)) {
                    diff = new BigDecimal(Timestamp.valueOf(eTime).getTime() - Timestamp.valueOf(lateTime).getTime());
                    bdLateTime = diff.divide(new BigDecimal("3600000"), 5, 4);
                    workTime = workTime.subtract(bdLateTime);
                }
                if ((overTime = workTime.subtract(standardWorktime)).compareTo(new BigDecimal("0.0")) < 0) {
                    overTime = overTime.subtract(overTime);
                }
                workTime = workTime.subtract(overTime);
                String cmd = "update WORKTIME_REPORT  set      LATENIGHT_TIME = %s,      WORK_TIME = %s,      OVER_TIME = %s,      MDATE = CURRENT_TIMESTAMP, STATUS = 3 where EMPLOYEE_ID = %d and REC_DATE = '%s'";
                cmd = String.format(cmd, bdLateTime.toString(), workTime.toString(), overTime.toString(), targetEmployee.getInt("EMPLOYEE_ID"), targetEmployee.getString("REC_DATE"));
                this.getDataController().execute(cmd);
            }
            targetEmployee.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(LateTimeCalculator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private ResultSet getTargetEmployee() {
        String cmd = "select EMPLOYEE_ID, REC_DATE,  START_TIME, GOOUT_TIME, RETURN_TIME, END_TIME, WORK_TIME, BREAKE_TIME from WORKTIME_REPORT where STATUS = 2 and DISABLE = 0";
        ResultSet rs = this.getDataController().select(cmd);
        return rs;
    }
}

