/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.plugin.timecard;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyContentHolder;
import org.clearfy.ClearfyPage;
import org.clearfy.ClearfySection;
import org.clearfy.components.MonthPicker;
import org.clearfy.components.tableview.DataTableView;
import org.clearfy.components.tableview.Record;
import org.clearfy.components.tableview.ResultSetProvider;
import org.clearfy.components.tableview.SelectableColumn;
import org.clearfy.components.tableview.TableView;
import org.clearfy.datawrapper.IJdbcSupplier;
import org.clearfy.plugin.employee.EmployeePicker;
import org.clearfy.plugin.employee.EmployeeSelecter;
import org.clearfy.plugin.employee.data.Employee;
import org.clearfy.plugin.timecard.component.WorkTimeEdit;
import org.clearfy.plugin.timecard.component.WorkTimeSummary;
import org.clearfy.plugin.timecard.component.WorkingReportView;

public class TimeCardEmployeeRecordView
extends ClearfySection {
    private MonthPicker monthPicker;
    private EmployeeSelecter employeeSelecter;
    private Employee employee;
    private WorkingReportView workingReportView;
    private DataTableView rawDataView;
    private Label rawDate;
    private WorkTimeSummary workTimeSummary;
    private WorkTimeEdit workTimeEdit;

    public TimeCardEmployeeRecordView(String id, ClearfyPage page) {
        super(id, page);
    }

    public void drawContent() {
        this.employee = new Employee();
        this.employee.setJdbcSupplier((IJdbcSupplier)this.page);
        this.monthPicker = new MonthPicker("monthPicker", this.page){

            public void onYearMonthChanged(AjaxRequestTarget target) {
                TimeCardEmployeeRecordView.this.workingReportView.setYear(this.getYear());
                TimeCardEmployeeRecordView.this.workingReportView.setMonth(this.getMonth());
                TimeCardEmployeeRecordView.this.workingReportView.drawWorkingReport();
                target.add(new Component[]{TimeCardEmployeeRecordView.this.workingReportView});
                TimeCardEmployeeRecordView.this.workTimeSummary.drawSummary(TimeCardEmployeeRecordView.this.workingReportView.getEmployeeId(), this.getYear(), this.getMonth());
                target.add(new Component[]{TimeCardEmployeeRecordView.this.workTimeSummary});
            }
        };
        this.monthPicker.setOutputMarkupId(true);
        this.add(new ClearfyContentHolder[]{this.monthPicker});
        this.employeeSelecter = new EmployeeSelecter("employeeSelecter", this.page){

            public String getTitle() {
                return this.getSentence("\u5f93\u696d\u8005\u9078\u629e");
            }

            public void onEmployeeSelected(AjaxRequestTarget target, Record record) {
                int employeeId = this.getSelectedEmployeeId();
                TimeCardEmployeeRecordView.this.rawDataView.clear();
                target.add(new Component[]{TimeCardEmployeeRecordView.this.rawDataView});
                TimeCardEmployeeRecordView.this.rawDate.setDefaultModelObject((Object)"");
                target.add(new Component[]{TimeCardEmployeeRecordView.this.rawDate});
                TimeCardEmployeeRecordView.this.workingReportView.setYear(TimeCardEmployeeRecordView.this.monthPicker.getYear());
                TimeCardEmployeeRecordView.this.workingReportView.setMonth(TimeCardEmployeeRecordView.this.monthPicker.getMonth());
                TimeCardEmployeeRecordView.this.workingReportView.setEmployeeId(employeeId);
                TimeCardEmployeeRecordView.this.workingReportView.drawWorkingReport();
                target.add(new Component[]{TimeCardEmployeeRecordView.this.workingReportView});
                TimeCardEmployeeRecordView.this.workTimeSummary.drawSummary(employeeId, TimeCardEmployeeRecordView.this.monthPicker.getYear(), TimeCardEmployeeRecordView.this.monthPicker.getMonth());
                target.add(new Component[]{TimeCardEmployeeRecordView.this.workTimeSummary});
            }
        };
        this.employeeSelecter.setOutputMarkupId(true);
        this.add(new ClearfyContentHolder[]{this.employeeSelecter});
        this.rawDate = new Label("rawDate", (IModel)Model.of((Serializable)((Object)"")));
        this.rawDate.setOutputMarkupId(true);
        this.add(new Component[]{this.rawDate});
        this.workTimeEdit = new WorkTimeEdit("workTimeEdit", this.page){

            @Override
            public void afterUpdated(AjaxRequestTarget target) {
                TimeCardEmployeeRecordView.this.workingReportView.drawWorkingReport();
                target.add(new Component[]{TimeCardEmployeeRecordView.this.workingReportView});
                TimeCardEmployeeRecordView.this.workTimeSummary.drawSummary(TimeCardEmployeeRecordView.this.workingReportView.getEmployeeId(), TimeCardEmployeeRecordView.this.workingReportView.getYear(), TimeCardEmployeeRecordView.this.workingReportView.getMonth());
                target.add(new Component[]{TimeCardEmployeeRecordView.this.workTimeSummary});
            }
        };
        this.workTimeEdit.setOutputMarkupId(true);
        this.add(new ClearfyContentHolder[]{this.workTimeEdit});
        this.workingReportView = new WorkingReportView("workingReportView", this.page){

            @Override
            public void onRowClicked(AjaxRequestTarget target, Record row) {
                int date = Integer.parseInt(row.getField("\u65e5\u4ed8"));
                int year = this.getYear();
                int month = this.getMonth();
                LocalDate selectedDate = LocalDate.of(year, month, date);
                TimeCardEmployeeRecordView.this.rawDate.setDefaultModelObject((Object)selectedDate.toString());
                target.add(new Component[]{TimeCardEmployeeRecordView.this.rawDate});
                TimeCardEmployeeRecordView.this.rawDataView.clear();
                String cmd = "select TIME_RECORD_ID ID, RECORD_DATETIME \u6253\u523b\u6642\u523b, ORGANIZATION_NAME \u5834\u6240, \ncase WHEN EMPLOYEE_NAME is not null then EMPLOYEE_NAME else '' END \u627f\u8a8d\u8005 from TIME_RECORD TR\ninner join ORGANIZATION O on O.ORGANIZATION_ID = TR.ORGANIZATION_ID\nleft join EMPLOYEE on EMPLOYEE.EMPLOYEE_ID = MODIFIER_ID\n where TR.EMPLOYEE_ID = %d and CHECK_DATE = '%s' and TR.DISABLE = 0 order by RECORD_DATETIME";
                cmd = String.format(cmd, this.getEmployeeId(), selectedDate.toString());
                TimeCardEmployeeRecordView.this.rawDataView.select(cmd);
                target.add(new Component[]{TimeCardEmployeeRecordView.this.rawDataView});
                TimeCardEmployeeRecordView.this.workTimeEdit.clear();
                TimeCardEmployeeRecordView.this.workTimeEdit.setSelectedDate(selectedDate);
                TimeCardEmployeeRecordView.this.workTimeEdit.setEmployeeId(this.getEmployeeId());
                target.add(new Component[]{TimeCardEmployeeRecordView.this.workTimeEdit});
            }
        };
        this.workingReportView.setOutputMarkupId(true);
        this.add(new ClearfyContentHolder[]{this.workingReportView});
        this.rawDataView = new DataTableView("rawDataView", this.page){

            public void afterCreateColumns(List<IColumn<Record, String>> columns) {
            }

            public void beforeCreateColumns(List<IColumn<Record, String>> columns) {
                SelectableColumn controller = new SelectableColumn((IModel)new Model((Serializable)((Object)this.getSentence(""))), "\u9078\u629e", (TableView)TimeCardEmployeeRecordView.this.rawDataView){

                    public void onSelected(AjaxRequestTarget target, Record selected) {
                        this.onRecordSelected(target, selected);
                    }
                };
                columns.add((IColumn<Record, String>)controller);
            }

            public void defineSorter(ResultSetProvider resultSetProvider) {
            }

            public void initializeMenu() {
            }

            public void onRecordSelected(AjaxRequestTarget target, Record record) {
                String id = record.getField("ID");
                TimeCardEmployeeRecordView.this.clickRawData(target, Integer.valueOf(id));
            }
        };
        this.rawDataView.setOutputMarkupId(true);
        this.add(new ClearfyContentHolder[]{this.rawDataView});
        this.workTimeSummary = new WorkTimeSummary("workTimeSummary", this.page);
        this.workTimeSummary.setOutputMarkupId(true);
        this.add(new ClearfyContentHolder[]{this.workTimeSummary});
        if (this.getCurrentSession().getRoles().hasRole("USER") || this.getCurrentSession().getRoles().hasRole("MANAGEMENT_USER")) {
            String userId = this.getCurrentSession().getUserId();
            String empId = this.employeeSelecter.getEmployeeIdByUserId(userId);
            this.workingReportView.setEmployeeId(Integer.parseInt(empId));
            this.workingReportView.drawWorkingReport();
            int year = this.monthPicker.getYear();
            int month = this.monthPicker.getMonth();
            this.workTimeSummary.drawSummary(Integer.parseInt(empId), year, month);
        }
    }

    public String getTitle() {
        return this.getSentence("\u51fa\u52e4\u7c3f");
    }

    public void loadTimeRecords(EmployeePicker.EmployeeInfo info) {
        System.out.println(info.toString());
    }

    public void clickRawData(AjaxRequestTarget target, int id) {
        this.workTimeEdit.setSelectedId(id);
        target.add(new Component[]{this.workTimeEdit});
    }
}

