/*
 * Decompiled with CFR 0.152.
 */
package org.clearfy.plugin.timecard;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.clearfy.ClearfyPage;
import org.clearfy.ClearfySection;
import org.clearfy.components.MonthPicker;
import org.clearfy.components.tableview.Record;
import org.clearfy.components.tableview.ResultSetProvider;
import org.clearfy.components.tableview.SelectableColumn;
import org.clearfy.components.tableview.TableView;
import org.clearfy.datawrapper.ClearfyDatabaseException;
import org.clearfy.datawrapper.Condition;
import org.clearfy.datawrapper.IJdbcSupplier;
import org.clearfy.plugin.employee.data.Employee;
import org.clearfy.plugin.timecard.data.EventCheck;

public class EventRecordView
extends ClearfySection {
    private Form eventViewForm;
    private MonthPicker monthPicker;
    private TableView eventCalendar;
    private TableView eventResult;

    public EventRecordView(String id, ClearfyPage page) {
        super(id, page);
    }

    public void drawContent() {
        EventCheck eventCheck = new EventCheck();
        eventCheck.setJdbcSupplier((IJdbcSupplier)this.page);
        if (!eventCheck.isExist()) {
            eventCheck.createTable();
        }
        this.eventViewForm = new Form("eventViewForm");
        this.monthPicker = new MonthPicker("monthPicker", this.page){

            public void onYearMonthChanged(AjaxRequestTarget target) {
                EventRecordView.this.onYearMonthChanged(target);
            }
        };
        this.monthPicker.setOutputMarkupId(true);
        this.eventViewForm.add(new Component[]{this.monthPicker});
        this.eventCalendar = new TableView("eventCalendar", this.page){

            public void afterCreateColumns(List<IColumn<Record, String>> columns) {
            }

            public void beforeCreateColumns(List<IColumn<Record, String>> columns) {
                columns.add((IColumn<Record, String>)new SelectableColumn((IModel)Model.of((Serializable)((Object)"")), "\u9078\u629e", EventRecordView.this.eventCalendar){

                    public void onSelected(AjaxRequestTarget target, Record selected) {
                        EventRecordView.this.eventCalendar.onRecordSelected(target, selected);
                    }
                });
            }

            public void defineSorter(ResultSetProvider resultSetProvider) {
            }

            public void initializeMenu() {
            }

            public void onRecordSelected(AjaxRequestTarget target, Record record) {
                EventRecordView.this.onDateSelected(target, record);
            }
        };
        this.eventCalendar.setItemsPerPage(31L);
        this.eventCalendar.setOutputMarkupId(true);
        this.eventViewForm.add(new Component[]{this.eventCalendar});
        this.eventResult = new TableView("eventResult", this.page){

            public void afterCreateColumns(List<IColumn<Record, String>> columns) {
            }

            public void beforeCreateColumns(List<IColumn<Record, String>> columns) {
            }

            public void defineSorter(ResultSetProvider resultSetProvider) {
            }

            public void initializeMenu() {
            }

            public void onRecordSelected(AjaxRequestTarget target, Record record) {
            }
        };
        this.eventViewForm.add(new Component[]{this.eventResult});
        this.add(new Component[]{this.eventViewForm});
        this.updateEventCalendar();
    }

    public void onDateSelected(AjaxRequestTarget target, Record record) {
        try {
            String day = record.getField("\u958b\u50ac\u65e5");
            Employee emp = new Employee();
            emp.setJdbcSupplier((IJdbcSupplier)this.page);
            emp.setAlias("EMP");
            emp.unselectAllColumn();
            EventCheck e1 = new EventCheck();
            e1.setJdbcSupplier((IJdbcSupplier)this.page);
            e1.setAlias("E1");
            e1.unselectAllColumn();
            EventCheck e2 = new EventCheck();
            e2.setJdbcSupplier((IJdbcSupplier)this.page);
            e2.setAlias("E2");
            e2.unselectAllColumn();
            String cmd = e1.getSelectSentence(new Condition[]{e1.EmployeeId.setAlias("ID").setSelectable(true), emp.EmployeeName.setAlias("\u5f93\u696d\u8005").setSelectable(true), e1.RecordDateTime.setAlias("\u5165").setSelectable(true), e2.RecordDateTime.greater(e1.RecordDateTime).setColumnAlias("\u51fa").setSelectable(true), e1.CheckDate.sameValueOf("'" + day + "'"), e2.CheckDate.sameValueOf("'" + day + "'"), e1.EmployeeId.asc()});
            this.eventResult.select(cmd);
            target.add(new Component[]{this.eventResult});
        }
        catch (ClearfyDatabaseException ex) {
            Logger.getLogger(EventRecordView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void onYearMonthChanged(AjaxRequestTarget target) {
        this.eventResult.clear();
        target.add(new Component[]{this.eventResult});
        this.updateEventCalendar();
        target.add(new Component[]{this.eventCalendar});
    }

    public void updateEventCalendar() {
        LocalDate startDate = LocalDate.of(this.monthPicker.getYear(), this.monthPicker.getMonth(), 1);
        LocalDate endDate = startDate.withDayOfMonth(startDate.lengthOfMonth());
        String cmd = "select Check_Date \u958b\u50ac\u65e5, count(*) \u6253\u523b\u56de\u6570 from Event_Check where Check_Date >= '%s' and Check_Date <='%s' group by Check_Date";
        cmd = String.format(cmd, startDate.toString(), endDate.toString());
        this.eventCalendar.select(cmd);
    }

    public String getTitle() {
        return this.getSentence("\u30a4\u30d9\u30f3\u30c8\u53c2\u52a0\u8a18\u9332");
    }
}

