/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.TextFormat;
import com.google.appengine.repackaged.com.google.protobuf.UnknownFieldSet;
import com.google.appengine.tools.appstats.InternalProtos;
import com.google.appengine.tools.appstats.StatsProtos;
import com.google.apphosting.api.ApiProxy;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Recorder
implements ApiProxy.Delegate {
    private static final Pattern STACK_PATTERN = Pattern.compile("\\s*at\\s([^\\(]+)[^:]+:([^\\)]+)\\)\\s*");
    private final Clock clock;
    private final ApiProxy.Delegate wrappedDelegate;
    private final RecordWriter writer;

    private static <T> T checkNotNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    private static void createStackTrace(int numLinesToIgnore, StatsProtos.IndividualRpcStatsProto.Builder stats) {
        StringWriter stack = new StringWriter();
        new Exception().printStackTrace(new PrintWriter(stack));
        Matcher matcher = STACK_PATTERN.matcher(stack.toString());
        while (matcher.find()) {
            if (numLinesToIgnore > 0) {
                --numLinesToIgnore;
                continue;
            }
            String classAndMethod = matcher.group(1);
            int lastDot = classAndMethod.lastIndexOf(46);
            String lineNumber = matcher.group(2);
            StatsProtos.StackFrameProto.Builder builder = StatsProtos.StackFrameProto.newBuilder();
            builder.setClassOrFileName(classAndMethod.substring(0, lastDot));
            builder.setFunctionName(classAndMethod.substring(lastDot + 1));
            try {
                builder.setLineNumber(Integer.parseInt(lineNumber));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            stats.addCallStack(builder);
        }
    }

    private static String makeSummary(byte[] unknownProto) {
        try {
            InternalProtos.EmptyProto proto = ((InternalProtos.EmptyProto.Builder)InternalProtos.EmptyProto.newBuilder().mergeFrom(unknownProto)).build();
            return TextFormat.printToString((UnknownFieldSet)proto.getUnknownFields());
        }
        catch (InvalidProtocolBufferException e) {
            return "???";
        }
    }

    public Recorder(ApiProxy.Delegate<?> wrapThis, RecordWriter writer) {
        this(wrapThis, writer, Clock.INSTANCE);
    }

    Recorder(ApiProxy.Delegate<?> wrapThis, RecordWriter writer, Clock clock) {
        this.wrappedDelegate = Recorder.checkNotNull(wrapThis);
        this.clock = Recorder.checkNotNull(clock);
        this.writer = Recorder.checkNotNull(writer);
    }

    public void log(ApiProxy.Environment environment, ApiProxy.LogRecord record) {
        this.wrappedDelegate.log(environment, record);
    }

    public Future<byte[]> makeAsyncCall(ApiProxy.Environment environment, String packageName, String methodName, byte[] request, ApiProxy.ApiConfig apiConfig) {
        return this.wrappedDelegate.makeAsyncCall(environment, packageName, methodName, request, apiConfig);
    }

    public byte[] makeSyncCall(ApiProxy.Environment environment, String packageName, String methodName, byte[] request) throws ApiProxy.ApiProxyException {
        long preNow = this.clock.currentTimeMillis();
        StatsProtos.IndividualRpcStatsProto.Builder stats = this.newBuilder();
        stats.setServiceCallName(packageName + "." + methodName);
        if (environment.getRequestNamespace() != null) {
            stats.setNamespace(environment.getRequestNamespace());
        }
        stats.setRequestDataSummary(Recorder.makeSummary(request));
        stats.setStartOffsetMilliseconds(this.clock.currentTimeMillis());
        Recorder.createStackTrace(2, stats);
        long overhead = stats.getStartOffsetMilliseconds() - preNow;
        byte[] response = null;
        Throwable exceptionOrError = null;
        try {
            response = this.wrappedDelegate.makeSyncCall(environment, packageName, methodName, request);
            stats.setWasSuccessful(true);
        }
        catch (Throwable t) {
            exceptionOrError = t;
            stats.setWasSuccessful(false);
        }
        stats.setDurationMilliseconds(this.clock.currentTimeMillis() - stats.getStartOffsetMilliseconds());
        preNow = this.clock.currentTimeMillis();
        if (response != null) {
            stats.setResponseDataSummary(Recorder.makeSummary(response));
        }
        if (exceptionOrError != null) {
            StringWriter stackTrace = new StringWriter();
            exceptionOrError.printStackTrace(new PrintWriter(stackTrace));
            stats.setResponseDataSummary(stackTrace.toString());
        }
        this.writer.write(this.wrappedDelegate, environment, stats, overhead += this.clock.currentTimeMillis() - preNow, true);
        if (exceptionOrError != null) {
            if (exceptionOrError instanceof Error) {
                throw (Error)exceptionOrError;
            }
            if (exceptionOrError instanceof ApiProxy.ApiProxyException) {
                throw (ApiProxy.ApiProxyException)exceptionOrError;
            }
            if (exceptionOrError instanceof RuntimeException) {
                throw (RuntimeException)exceptionOrError;
            }
            throw new AssertionError((Object)exceptionOrError);
        }
        return response;
    }

    StatsProtos.IndividualRpcStatsProto.Builder newBuilder() {
        return StatsProtos.IndividualRpcStatsProto.newBuilder();
    }

    static class Clock {
        public static final Clock INSTANCE = new Clock();

        Clock() {
        }

        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RecordWriter {
        public Long begin(ApiProxy.Delegate<?> var1, ApiProxy.Environment var2, HttpServletRequest var3);

        public boolean commit(ApiProxy.Delegate<?> var1, ApiProxy.Environment var2, Integer var3);

        public void write(ApiProxy.Delegate<?> var1, ApiProxy.Environment var2, StatsProtos.IndividualRpcStatsProto.Builder var3, long var4, boolean var6);

        public List<StatsProtos.RequestStatProto> getSummaries();

        public StatsProtos.RequestStatProto getFull(long var1);
    }
}

