/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cabos;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UPnPManager;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import jp.sourceforge.cabos.AqDispatcher;
import jp.sourceforge.cabos.AqEvent;
import jp.sourceforge.cabos.AqEventHandler;
import jp.sourceforge.cabos.ConnectionUpdate;
import jp.sourceforge.cabos.TransferUpdate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AqMain {
    private static final Log LOG;
    private static InputStreamReader reader;
    private static OutputStreamWriter writer;
    private static boolean isShuttingdown;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.cabos.AqMain");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        reader = null;
        writer = null;
        isShuttingdown = false;
    }

    public static void main(String[] stringArray) {
        try {
            reader = new InputStreamReader(System.in, "UTF-8");
            writer = new OutputStreamWriter((OutputStream)System.out, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.exit(0);
        }
        if (CommonUtils.isWindows() && !CommonUtils.isJava15OrLater() || CommonUtils.isMacOSX() && !CommonUtils.isJava14OrLater()) {
            System.exit(0);
        }
        AqEvent.signalEvent(98);
        if (CommonUtils.getUserHomeDir().exists()) {
            FileUtils.setWriteable(CommonUtils.getUserHomeDir());
        } else {
            CommonUtils.getUserHomeDir().mkdirs();
        }
        if (CommonUtils.getUserSettingsDir().exists()) {
            FileUtils.setWriteable(CommonUtils.getUserSettingsDir());
        } else {
            CommonUtils.getUserSettingsDir().mkdirs();
        }
        if (!NIODispatcher.instance().isRunning()) {
            System.exit(0);
        }
        AqEvent.signalEvent(99);
        AqMain.readLoop();
        System.exit(0);
    }

    private static void readLoop() {
        LinkedList<String> linkedList = new LinkedList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (!isShuttingdown) {
                char c = (char)reader.read();
                if (c == '|' || c == '\n' || c == '\r') {
                    linkedList.add(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    if (c != '\n' && c != '\r') continue;
                    AqDispatcher.dispatchCommand(linkedList);
                    linkedList.clear();
                    continue;
                }
                stringBuffer.append(c);
            }
        }
        catch (IOException iOException) {
            LOG.error((Object)iOException);
        }
    }

    protected static void start() {
        if (!ConnectionSettings.DISABLE_UPNP.getValue()) {
            UPnPManager.instance().start();
        }
        RouterService routerService = new RouterService(new AqEventHandler());
        routerService.start();
        RouterService.schedule(new ConnectionUpdate(), 60000L, 60000L);
        RouterService.schedule(new TransferUpdate(), 1000L, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeEvent(String string) {
        OutputStreamWriter outputStreamWriter = writer;
        synchronized (outputStreamWriter) {
            try {
                writer.write(string);
                writer.flush();
            }
            catch (IOException iOException) {
                LOG.error((Object)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void shutdown() {
        OutputStreamWriter outputStreamWriter = writer;
        synchronized (outputStreamWriter) {
            try {
                reader.close();
                writer.close();
            }
            catch (IOException iOException) {
                LOG.error((Object)iOException);
            }
        }
        isShuttingdown = true;
    }
}

