/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.io.ConnectObserver;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.ThreadFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ProxyUtils {
    private static final Log LOG;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.util.ProxyUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    private ProxyUtils() {
    }

    static int getProxyType(InetAddress inetAddress) {
        boolean bl;
        int n = ConnectionSettings.CONNECTION_METHOD.getValue();
        boolean bl2 = bl = n != 0 && (!NetworkUtils.isPrivateAddress(inetAddress) || ConnectionSettings.USE_PROXY_FOR_PRIVATE.getValue());
        if (bl) {
            return n;
        }
        return 0;
    }

    static Socket establishProxy(int n, Socket socket, InetSocketAddress inetSocketAddress, int n2) throws IOException {
        switch (n) {
            case 1: {
                return ProxyUtils.establishHTTPProxy(socket, inetSocketAddress, n2);
            }
            case 4: {
                return ProxyUtils.establishSocksV4(socket, inetSocketAddress, n2);
            }
            case 5: {
                return ProxyUtils.establishSocksV5(socket, inetSocketAddress, n2);
            }
        }
        throw new IOException("Unknown proxy type.");
    }

    private static Socket establishSocksV4(Socket socket, InetSocketAddress inetSocketAddress, int n) throws IOException {
        byte[] byArray = inetSocketAddress.getAddress().getAddress();
        int n2 = inetSocketAddress.getPort();
        byte[] byArray2 = new byte[]{(byte)(n2 >> 8), (byte)n2};
        OutputStream outputStream = socket.getOutputStream();
        InputStream inputStream = socket.getInputStream();
        socket.setSoTimeout(n);
        outputStream.write(4);
        outputStream.write(1);
        outputStream.write(byArray2);
        outputStream.write(byArray);
        if (ConnectionSettings.PROXY_AUTHENTICATE.getValue()) {
            outputStream.write(ConnectionSettings.PROXY_USERNAME.getValue().getBytes());
        }
        outputStream.write(0);
        outputStream.flush();
        int n3 = inputStream.read();
        if (n3 != 0 && n3 != 4) {
            throw new IOException("Invalid version from socks proxy: " + n3 + " expected 0 or 4");
        }
        int n4 = inputStream.read();
        if (n4 != 90) {
            throw new IOException("Request rejected with status: " + n4);
        }
        byte[] byArray3 = new byte[2];
        byte[] byArray4 = new byte[4];
        if (inputStream.read(byArray3) == -1 || inputStream.read(byArray4) == -1) {
            throw new IOException("Connection failed");
        }
        socket.setSoTimeout(0);
        return socket;
    }

    private static Socket establishSocksV5(Socket socket, InetSocketAddress inetSocketAddress, int n) throws IOException {
        int n2;
        byte[] byArray = inetSocketAddress.getAddress().getAddress();
        int n3 = inetSocketAddress.getPort();
        byte[] byArray2 = new byte[]{(byte)(n3 >> 8), (byte)n3};
        OutputStream outputStream = socket.getOutputStream();
        InputStream inputStream = socket.getInputStream();
        socket.setSoTimeout(n);
        outputStream.write(5);
        if (ConnectionSettings.PROXY_AUTHENTICATE.getValue()) {
            outputStream.write(2);
            outputStream.write(0);
            outputStream.write(2);
        } else {
            outputStream.write(1);
            outputStream.write(0);
        }
        outputStream.flush();
        int n4 = inputStream.read();
        if (n4 != 5) {
            throw new IOException("Invalid version from socks proxy: " + n4 + " expected 5");
        }
        int n5 = inputStream.read();
        if (n5 != 0 && n5 == 2) {
            String string = ConnectionSettings.PROXY_USERNAME.getValue();
            String string2 = ConnectionSettings.PROXY_PASS.getValue();
            outputStream.write(1);
            outputStream.write((byte)string.length());
            outputStream.write(string.getBytes());
            outputStream.write((byte)string2.length());
            outputStream.write(string2.getBytes());
            outputStream.flush();
            n4 = inputStream.read();
            if (n4 != 1) {
                throw new IOException("Invalid version for authentication: " + n4 + " expected 1");
            }
            n2 = inputStream.read();
            if (n2 != 0) {
                throw new IOException("Authentication failed with status: " + n2);
            }
        }
        outputStream.write(5);
        outputStream.write(1);
        outputStream.write(0);
        outputStream.write(1);
        outputStream.write(byArray);
        outputStream.write(byArray2);
        outputStream.flush();
        n4 = inputStream.read();
        if (n4 != 5) {
            throw new IOException("Invalid version from socks proxy: " + n4 + " expected 5");
        }
        int n6 = inputStream.read();
        if (n6 != 0) {
            throw new IOException("Request rejected with status: " + n6);
        }
        inputStream.read();
        int n7 = inputStream.read();
        n2 = 0;
        if (n7 == 1) {
            n2 = 6;
        } else if (n7 == 3) {
            n2 = inputStream.read() + 2;
        } else if (n7 == 4) {
            n2 = 18;
        }
        int n8 = 0;
        while (n8 < n2) {
            if (inputStream.read() == -1) {
                throw new IOException("Connection failed");
            }
            ++n8;
        }
        socket.setSoTimeout(0);
        return socket;
    }

    /*
     * Unable to fully structure code
     */
    private static Socket establishHTTPProxy(Socket var0, InetSocketAddress var1_1, int var2_2) throws IOException {
        var0.setSoTimeout(var2_2);
        var3_3 = var0.getOutputStream();
        var4_4 = var0.getInputStream();
        var5_5 = "CONNECT " + var1_1.getAddress().getHostAddress() + ":" + var1_1.getPort() + " HTTP/1.0\r\n\r\n";
        var3_3.write(var5_5.getBytes());
        var3_3.flush();
        var6_6 = new BufferedReader(new InputStreamReader(var4_4));
        var7_7 = var6_6.readLine();
        if (var7_7 != null && var7_7.indexOf("200") != -1) ** GOTO lbl14
        throw new IOException("HTTP connection failed");
lbl-1000:
        // 1 sources

        {
            var7_7 = var6_6.readLine();
            if (var7_7 != null) continue;
            throw new IOException("end of stream");
lbl14:
            // 2 sources

            ** while (!var7_7.equals((Object)""))
        }
lbl15:
        // 1 sources

        var0.setSoTimeout(0);
        return var0;
    }

    static /* synthetic */ Log access$0() {
        return LOG;
    }

    static class ProxyConnector
    implements ConnectObserver {
        private final int proxyType;
        private final ConnectObserver delegate;
        private final InetSocketAddress addr;
        private final int timeout;

        ProxyConnector(int n, ConnectObserver connectObserver, InetSocketAddress inetSocketAddress, int n2) {
            this.proxyType = n;
            this.delegate = connectObserver;
            this.addr = inetSocketAddress;
            this.timeout = n2;
        }

        public void handleConnect(Socket socket) throws IOException {
            ThreadFactory.startThread(new Runnable(this, socket){
                final /* synthetic */ ProxyConnector this$1;
                private final /* synthetic */ Socket val$s;
                {
                    this.this$1 = proxyConnector;
                    this.val$s = socket;
                }

                public void run() {
                    try {
                        ProxyUtils.establishProxy(ProxyConnector.access$0(this.this$1), this.val$s, ProxyConnector.access$1(this.this$1), ProxyConnector.access$2(this.this$1));
                    }
                    catch (IOException iOException) {
                        ProxyUtils.access$0().warn((Object)"Error establishing proxy connection", (Throwable)iOException);
                        IOUtils.close(this.val$s);
                        this.this$1.shutdown();
                        return;
                    }
                    try {
                        ProxyConnector.access$3(this.this$1).handleConnect(this.val$s);
                    }
                    catch (IOException iOException) {
                        ProxyUtils.access$0().warn((Object)"Delegate IOX", (Throwable)iOException);
                        IOUtils.close(this.val$s);
                    }
                }
            }, "ProxyConnector");
        }

        public void shutdown() {
            this.delegate.shutdown();
        }

        public void handleIOException(IOException iOException) {
        }

        public ConnectObserver getDelegateObserver() {
            return this.delegate;
        }

        static /* synthetic */ int access$0(ProxyConnector proxyConnector) {
            return proxyConnector.proxyType;
        }

        static /* synthetic */ InetSocketAddress access$1(ProxyConnector proxyConnector) {
            return proxyConnector.addr;
        }

        static /* synthetic */ int access$2(ProxyConnector proxyConnector) {
            return proxyConnector.timeout;
        }

        static /* synthetic */ ConnectObserver access$3(ProxyConnector proxyConnector) {
            return proxyConnector.delegate;
        }
    }
}

