/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.io.ConnectObserver;
import com.limegroup.gnutella.io.NBSocket;
import com.limegroup.gnutella.io.Shutdownable;
import com.limegroup.gnutella.io.SocketFactory;
import com.limegroup.gnutella.util.ProxyUtils;
import com.limegroup.gnutella.util.SimpleSocketController;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class LimitedSocketController
extends SimpleSocketController {
    private final int MAX_CONNECTING_SOCKETS;
    private int _socketsConnecting = 0;
    private final List WAITING_REQUESTS = new LinkedList();

    LimitedSocketController(int n) {
        this.MAX_CONNECTING_SOCKETS = n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Socket connectPlain(InetSocketAddress inetSocketAddress, int n, ConnectObserver connectObserver) throws IOException {
        NBSocket nBSocket = SocketFactory.newSocket();
        if (connectObserver != null) {
            if (!this.addWaitingSocket(nBSocket, inetSocketAddress, n, connectObserver)) return nBSocket;
            nBSocket.connect(inetSocketAddress, n, new DelegateConnector(connectObserver));
            return nBSocket;
        }
        this.waitForSocket();
        try {
            nBSocket.connect(inetSocketAddress, n);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.releaseSocket();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.releaseSocket();
            return nBSocket;
        }
    }

    public synchronized boolean removeConnectObserver(ConnectObserver connectObserver) {
        Iterator iterator = this.WAITING_REQUESTS.iterator();
        while (iterator.hasNext()) {
            Requestor requestor = (Requestor)iterator.next();
            if (requestor.observer == connectObserver) {
                iterator.remove();
                return true;
            }
            if (!(requestor.observer instanceof ProxyUtils.ProxyConnector) || ((ProxyUtils.ProxyConnector)requestor.observer).getDelegateObserver() != connectObserver) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public int getNumAllowedSockets() {
        return this.MAX_CONNECTING_SOCKETS;
    }

    public synchronized int getNumWaitingSockets() {
        return this.WAITING_REQUESTS.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWaitingRequests() {
        Requestor requestor;
        ArrayList<Requestor> arrayList = new ArrayList<Requestor>(Math.min(this.WAITING_REQUESTS.size(), Math.max(0, this.MAX_CONNECTING_SOCKETS - this._socketsConnecting)));
        LimitedSocketController limitedSocketController = this;
        synchronized (limitedSocketController) {
            while (this._socketsConnecting < this.MAX_CONNECTING_SOCKETS && !this.WAITING_REQUESTS.isEmpty()) {
                requestor = (Requestor)this.WAITING_REQUESTS.remove(0);
                if (requestor.socket.isClosed()) continue;
                arrayList.add(requestor);
                ++this._socketsConnecting;
            }
        }
        int n = 0;
        while (n < arrayList.size()) {
            requestor = (Requestor)arrayList.get(n);
            requestor.socket.setShutdownObserver(null);
            requestor.socket.connect(requestor.addr, requestor.timeout, new DelegateConnector(requestor.observer));
            ++n;
        }
    }

    private synchronized boolean addWaitingSocket(NBSocket nBSocket, InetSocketAddress inetSocketAddress, int n, ConnectObserver connectObserver) {
        if (this._socketsConnecting >= this.MAX_CONNECTING_SOCKETS) {
            this.WAITING_REQUESTS.add(new Requestor(nBSocket, inetSocketAddress, n, connectObserver));
            nBSocket.setShutdownObserver(new RemovalObserver(connectObserver));
            return false;
        }
        ++this._socketsConnecting;
        return true;
    }

    private synchronized void waitForSocket() throws IOException {
        while (this._socketsConnecting >= this.MAX_CONNECTING_SOCKETS) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(interruptedException.getMessage());
            }
        }
        ++this._socketsConnecting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSocket() {
        LimitedSocketController limitedSocketController = this;
        synchronized (limitedSocketController) {
            --this._socketsConnecting;
        }
        this.runWaitingRequests();
        limitedSocketController = this;
        synchronized (limitedSocketController) {
            if (this._socketsConnecting < this.MAX_CONNECTING_SOCKETS) {
                this.notifyAll();
            }
        }
    }

    private class RemovalObserver
    implements Shutdownable {
        private final ConnectObserver delegate;

        RemovalObserver(ConnectObserver connectObserver) {
            this.delegate = connectObserver;
        }

        public void shutdown() {
            if (LimitedSocketController.this.removeConnectObserver(this.delegate)) {
                this.delegate.shutdown();
            }
        }
    }

    private class DelegateConnector
    implements ConnectObserver {
        private final ConnectObserver delegate;

        DelegateConnector(ConnectObserver connectObserver) {
            this.delegate = connectObserver;
        }

        public void handleConnect(Socket socket) throws IOException {
            LimitedSocketController.this.releaseSocket();
            this.delegate.handleConnect(socket);
        }

        public void shutdown() {
            LimitedSocketController.this.releaseSocket();
            this.delegate.shutdown();
        }

        public void handleIOException(IOException iOException) {
        }
    }

    private static class Requestor {
        private final InetSocketAddress addr;
        private final int timeout;
        private final NBSocket socket;
        private final ConnectObserver observer;

        Requestor(NBSocket nBSocket, InetSocketAddress inetSocketAddress, int n, ConnectObserver connectObserver) {
            this.socket = nBSocket;
            this.addr = inetSocketAddress;
            this.timeout = n;
            this.observer = connectObserver;
        }
    }
}

