/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.udpconnect.UDPConnectionProcessor;
import java.lang.ref.WeakReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class UDPTimerEvent
implements Comparable {
    private static final Log LOG;
    protected volatile long _eventTime;
    private volatile boolean _shouldUnregister;
    protected final WeakReference _udpCon;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.udpconnect.UDPTimerEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    UDPTimerEvent(long l, UDPConnectionProcessor uDPConnectionProcessor) {
        this._eventTime = l;
        this._udpCon = new WeakReference<UDPConnectionProcessor>(uDPConnectionProcessor);
    }

    final boolean shouldUnregister() {
        if (this._udpCon.get() == null || this._shouldUnregister) {
            LOG.debug((Object)"Event decided to unregister itself");
            return true;
        }
        return false;
    }

    protected final void unregister() {
        this._shouldUnregister = true;
        this._eventTime = 1L;
    }

    public void updateTime(long l) {
        if (!this._shouldUnregister) {
            this._eventTime = l;
        }
    }

    public long getEventTime() {
        return this._eventTime;
    }

    public final void handleEvent() {
        UDPConnectionProcessor uDPConnectionProcessor = (UDPConnectionProcessor)this._udpCon.get();
        if (uDPConnectionProcessor == null) {
            return;
        }
        this.doActualEvent(uDPConnectionProcessor);
    }

    protected abstract void doActualEvent(UDPConnectionProcessor var1);

    public int compareTo(Object object) {
        long l = ((UDPTimerEvent)object)._eventTime - this._eventTime;
        if (l > 0L) {
            return 1;
        }
        if (l < 0L) {
            return -1;
        }
        return 0;
    }
}

