/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.io.AbstractNBSocket;
import com.limegroup.gnutella.io.InterestReadChannel;
import com.limegroup.gnutella.io.InterestWriteChannel;
import com.limegroup.gnutella.udpconnect.UDPSelectorProvider;
import com.limegroup.gnutella.udpconnect.UDPSocketChannel;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;

public class UDPConnection
extends AbstractNBSocket {
    public static final byte VERSION = 1;
    private final UDPSocketChannel channel = (UDPSocketChannel)UDPSelectorProvider.instance().openSocketChannel();
    private int soTimeout = 60000;

    public UDPConnection() {
        this.channel.setSocket(this);
        this.setInitialReader();
        this.setInitialWriter();
    }

    public UDPConnection(String string, int n) throws IOException {
        this(InetAddress.getByName(string), n);
    }

    public UDPConnection(InetAddress inetAddress, int n) throws IOException {
        this();
        this.connect(new InetSocketAddress(inetAddress, n));
    }

    protected InterestReadChannel getBaseReadChannel() {
        return this.channel;
    }

    protected InterestWriteChannel getBaseWriteChannel() {
        return this.channel;
    }

    protected void shutdownImpl() {
    }

    public void setSoTimeout(int n) {
        this.soTimeout = n;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public InetAddress getLocalAddress() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(NetworkUtils.ip2string(RouterService.getNonForcedAddress()));
        }
        catch (UnknownHostException unknownHostException) {
            try {
                inetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException2) {
                inetAddress = null;
            }
        }
        return inetAddress;
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.channel.getRemoteSocketAddress();
    }

    public InetAddress getInetAddress() {
        return ((InetSocketAddress)this.getRemoteSocketAddress()).getAddress();
    }

    public int getPort() {
        return ((InetSocketAddress)this.getRemoteSocketAddress()).getPort();
    }

    public int getLocalPort() {
        return UDPService.instance().getStableUDPPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public String toString() {
        return "UDPConnection:" + this.channel;
    }

    public boolean isConnected() {
        return this.channel.isConnected();
    }

    public boolean isBound() {
        return true;
    }

    public boolean isClosed() {
        return !this.channel.isOpen();
    }

    public boolean isInputShutdown() {
        return !this.channel.isOpen();
    }

    public boolean isOutputShutdown() {
        return !this.channel.isOpen();
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        throw new IOException("not implemented");
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
    }

    public boolean getTcpNoDelay() throws SocketException {
        return true;
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
    }

    public int getSoLinger() throws SocketException {
        return -1;
    }

    public void sendUrgentData(int n) throws IOException {
        throw new IOException("not implemented");
    }

    public void setOOBInline(boolean bl) throws SocketException {
        throw new SocketException("not implemented");
    }

    public boolean getOOBInline() throws SocketException {
        throw new SocketException("not implemented");
    }

    public synchronized void setSendBufferSize(int n) throws SocketException {
        throw new SocketException("not implemented");
    }

    public synchronized int getSendBufferSize() throws SocketException {
        throw new SocketException("not implemented");
    }

    public synchronized void setReceiveBufferSize(int n) throws SocketException {
        throw new SocketException("not implemented");
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        throw new SocketException("not implemented");
    }

    public void setKeepAlive(boolean bl) throws SocketException {
    }

    public boolean getKeepAlive() throws SocketException {
        return true;
    }

    public void setTrafficClass(int n) throws SocketException {
        throw new SocketException("not implemented");
    }

    public int getTrafficClass() throws SocketException {
        throw new SocketException("not implemented");
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        throw new SocketException("not implemented");
    }

    public boolean getReuseAddress() throws SocketException {
        throw new SocketException("not implemented");
    }

    public void shutdownInput() throws IOException {
        throw new SocketException("not implemented");
    }

    public void shutdownOutput() throws IOException {
        throw new IOException("not implemented");
    }
}

