/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.messages.vendor.GiveStatsVendorMessage;
import com.limegroup.gnutella.messages.vendor.HeadPing;
import com.limegroup.gnutella.messages.vendor.HeadPong;
import com.limegroup.gnutella.messages.vendor.HeaderUpdateVendorMessage;
import com.limegroup.gnutella.messages.vendor.HopsFlowVendorMessage;
import com.limegroup.gnutella.messages.vendor.LimeACKVendorMessage;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;
import com.limegroup.gnutella.messages.vendor.PushProxyAcknowledgement;
import com.limegroup.gnutella.messages.vendor.PushProxyRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.messages.vendor.StatisticVendorMessage;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPing;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.statistics.ReceivedErrorStat;
import com.limegroup.gnutella.util.IntHashMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VendorMessageFactory {
    private static final Log LOG;
    private static final Comparator COMPARATOR;
    private static volatile Map VENDORS;
    private static final BadPacketException UNRECOGNIZED_EXCEPTION;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.messages.vendor.VendorMessageFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        COMPARATOR = new ByteArrayComparator();
        VENDORS = new TreeMap(COMPARATOR);
        UNRECOGNIZED_EXCEPTION = new BadPacketException("Unrecognized Vendor Message");
        VendorMessageFactory.setParser(4, VendorMessage.F_BEAR_VENDOR_ID, new HopsFlowVendorMessageParser());
        VendorMessageFactory.setParser(11, VendorMessage.F_LIME_VENDOR_ID, new LimeACKVendorMessageParser());
        VendorMessageFactory.setParser(12, VendorMessage.F_LIME_VENDOR_ID, new ReplyNumberVendorMessageParser());
        VendorMessageFactory.setParser(7, VendorMessage.F_BEAR_VENDOR_ID, new TCPConnectBackVendorMessageParser());
        VendorMessageFactory.setParser(0, VendorMessage.F_NULL_VENDOR_ID, new MessagesSupportedVendorMessageParser());
        VendorMessageFactory.setParser(7, VendorMessage.F_GTKG_VENDOR_ID, new UDPConnectBackVendorMessageParser());
        VendorMessageFactory.setParser(21, VendorMessage.F_LIME_VENDOR_ID, new PushProxyRequestParser());
        VendorMessageFactory.setParser(22, VendorMessage.F_LIME_VENDOR_ID, new PushProxyAcknowledgementParser());
        VendorMessageFactory.setParser(11, VendorMessage.F_BEAR_VENDOR_ID, new QueryStatusRequestParser());
        VendorMessageFactory.setParser(12, VendorMessage.F_BEAR_VENDOR_ID, new QueryStatusResponseParser());
        VendorMessageFactory.setParser(7, VendorMessage.F_LIME_VENDOR_ID, new TCPConnectBackRedirectParser());
        VendorMessageFactory.setParser(8, VendorMessage.F_LIME_VENDOR_ID, new UDPConnectBackRedirectParser());
        VendorMessageFactory.setParser(10, VendorMessage.F_NULL_VENDOR_ID, new CapabilitiesVMParser());
        VendorMessageFactory.setParser(14, VendorMessage.F_LIME_VENDOR_ID, new GiveStatsVendorMessageParser());
        VendorMessageFactory.setParser(15, VendorMessage.F_LIME_VENDOR_ID, new StatisticVendorMessageParser());
        VendorMessageFactory.setParser(5, VendorMessage.F_LIME_VENDOR_ID, new UDPCrawlerPingParser());
        VendorMessageFactory.setParser(23, VendorMessage.F_LIME_VENDOR_ID, new HeadPingParser());
        VendorMessageFactory.setParser(24, VendorMessage.F_LIME_VENDOR_ID, new HeadPongParser());
        VendorMessageFactory.setParser(25, VendorMessage.F_LIME_VENDOR_ID, new HeaderUpdateVendorMessageParser());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setParser(int n, byte[] byArray, VendorMessageParser vendorMessageParser) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Selector is out of range: " + n);
        }
        if (byArray == null) {
            throw new NullPointerException("Vendor ID is null");
        }
        if (byArray.length != 4) {
            throw new IllegalArgumentException("Vendor ID must be 4 bytes long");
        }
        if (vendorMessageParser == null) {
            throw new NullPointerException("VendorMessageParser is null");
        }
        Object object = null;
        Map map = VENDORS;
        synchronized (map) {
            Map map2 = VendorMessageFactory.copyVendors();
            IntHashMap intHashMap = (IntHashMap)map2.get(byArray);
            if (intHashMap == null) {
                intHashMap = new IntHashMap();
                map2.put(byArray, intHashMap);
            }
            object = intHashMap.put(n, vendorMessageParser);
            VENDORS = map2;
        }
        if (object != null && LOG.isErrorEnabled()) {
            LOG.error((Object)("There was already a VendorMessageParser of type " + object.getClass() + " registered for selector " + n));
        }
    }

    private static Map copyVendors() {
        TreeMap<byte[], IntHashMap> treeMap = new TreeMap<byte[], IntHashMap>(COMPARATOR);
        Iterator iterator = VENDORS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            byte[] byArray = (byte[])entry.getKey();
            IntHashMap intHashMap = (IntHashMap)entry.getValue();
            treeMap.put(byArray, new IntHashMap(intHashMap));
        }
        return treeMap;
    }

    public static VendorMessageParser getParser(int n, byte[] byArray) {
        IntHashMap intHashMap = (IntHashMap)VENDORS.get(byArray);
        if (intHashMap == null) {
            return null;
        }
        return (VendorMessageParser)intHashMap.get(n);
    }

    public static VendorMessage deriveVendorMessage(byte[] byArray, byte by, byte by2, byte[] byArray2, int n) throws BadPacketException {
        if (byArray2.length < 8) {
            ReceivedErrorStat.VENDOR_INVALID_PAYLOAD.incrementStat();
            throw new BadPacketException("Not enough bytes for a VM!!");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        int n2 = -1;
        int n3 = -1;
        try {
            byArray3 = new byte[4];
            byteArrayInputStream.read(byArray3, 0, byArray3.length);
            n2 = ByteOrder.ushort2int(ByteOrder.leb2short(byteArrayInputStream));
            n3 = ByteOrder.ushort2int(ByteOrder.leb2short(byteArrayInputStream));
            byArray4 = new byte[byteArrayInputStream.available()];
            byteArrayInputStream.read(byArray4, 0, byArray4.length);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        VendorMessageParser vendorMessageParser = VendorMessageFactory.getParser(n2, byArray3);
        if (vendorMessageParser == null) {
            ReceivedErrorStat.VENDOR_UNRECOGNIZED.incrementStat();
            throw UNRECOGNIZED_EXCEPTION;
        }
        return vendorMessageParser.parse(byArray, by, by2, n3, byArray4, n);
    }

    public static interface VendorMessageParser {
        public VendorMessage parse(byte[] var1, byte var2, byte var3, int var4, byte[] var5, int var6) throws BadPacketException;
    }

    private static class HopsFlowVendorMessageParser
    implements VendorMessageParser {
        private HopsFlowVendorMessageParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, int n2) throws BadPacketException {
            return new HopsFlowVendorMessage(byArray, by, by2, n, byArray2);
        }
    }

    private static class LimeACKVendorMessageParser
    implements VendorMessageParser {
        private LimeACKVendorMessageParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, int n2) throws BadPacketException {
            return new LimeACKVendorMessage(byArray, by, by2, n, byArray2);
        }
    }

    private static class ReplyNumberVendorMessageParser
    implements VendorMessageParser {
        private ReplyNumberVendorMessageParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, int n2) throws BadPacketException {
            return new ReplyNumberVendorMessage(byArray, by, by2, n, byArray2);
        }
    }

    private static class TCPConnectBackVendorMessageParser
    implements VendorMessageParser {
        private TCPConnectBackVendorMessageParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, int n2) throws BadPacketException {
            return new TCPConnectBackVendorMessage(byArray, by, by2, n, byArray2);
        }
    }

    private static class MessagesSupportedVendorMessageParser
    implements VendorMessageParser {
        private MessagesSupportedVendorMessageParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, int n2) throws BadPacketException {
            return new MessagesSupportedVendorMessage(byArray, by, by2, n, byArray2);
        }
    }

    private static class UDPConnectBackVendorMessageParser
    implements VendorMessageParser {
        private UDPConnectBackVendorMessageParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, int n2) throws BadPacketException {
            return new UDPConnectBackVendorMessage(byArray, by, by2, n, byArray2);
        }
    }

    private static class PushProxyRequestParser
    implements VendorMessageParser {
        private PushProxyRequestParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, int n2) throws BadPacketException {
            return new PushProxyRequest(byArray, by, by2, n, byArray2);
        }
    }

    private static class PushProxyAcknowledgementParser
    implements VendorMessageParser {
        private PushProxyAcknowledgementParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, int n2) throws BadPacketException {
            return new PushProxyAcknowledgement(byArray, by, by2, n, byArray2);
        }
    }

    private static class QueryStatusRequestParser
    implements VendorMessageParser {
        private QueryStatusRequestParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, int n2) throws BadPacketException {
            return new QueryStatusRequest(byArray, by, by2, n, byArray2);
        }
    }

    private static class QueryStatusResponseParser
    implements VendorMessageParser {
        private QueryStatusResponseParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, int n2) throws BadPacketException {
            return new QueryStatusResponse(byArray, by, by2, n, byArray2);
        }
    }

    private static class TCPConnectBackRedirectParser
    implements VendorMessageParser {
        private TCPConnectBackRedirectParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, int n2) throws BadPacketException {
            return new TCPConnectBackRedirect(byArray, by, by2, n, byArray2);
        }
    }

    private static class UDPConnectBackRedirectParser
    implements VendorMessageParser {
        private UDPConnectBackRedirectParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, int n2) throws BadPacketException {
            return new UDPConnectBackRedirect(byArray, by, by2, n, byArray2);
        }
    }

    private static class CapabilitiesVMParser
    implements VendorMessageParser {
        private CapabilitiesVMParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, int n2) throws BadPacketException {
            return new CapabilitiesVM(byArray, by, by2, n, byArray2);
        }
    }

    private static class GiveStatsVendorMessageParser
    implements VendorMessageParser {
        private GiveStatsVendorMessageParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, int n2) throws BadPacketException {
            return new GiveStatsVendorMessage(byArray, by, by2, n, byArray2, n2);
        }
    }

    private static class StatisticVendorMessageParser
    implements VendorMessageParser {
        private StatisticVendorMessageParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, int n2) throws BadPacketException {
            return new StatisticVendorMessage(byArray, by, by2, n, byArray2);
        }
    }

    private static class UDPCrawlerPingParser
    implements VendorMessageParser {
        private UDPCrawlerPingParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, int n2) throws BadPacketException {
            return new UDPCrawlerPing(byArray, by, by2, n, byArray2);
        }
    }

    private static class HeadPingParser
    implements VendorMessageParser {
        private HeadPingParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, int n2) throws BadPacketException {
            return new HeadPing(byArray, by, by2, n, byArray2);
        }
    }

    private static class HeadPongParser
    implements VendorMessageParser {
        private HeadPongParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, int n2) throws BadPacketException {
            return new HeadPong(byArray, by, by2, n, byArray2);
        }
    }

    private static class HeaderUpdateVendorMessageParser
    implements VendorMessageParser {
        private HeaderUpdateVendorMessageParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, int n2) throws BadPacketException {
            return new HeaderUpdateVendorMessage(byArray, by, by2, n, byArray2);
        }
    }

    private static class ByteArrayComparator
    implements Comparator {
        private ByteArrayComparator() {
        }

        public int compare(Object object, Object object2) {
            byte[] byArray = (byte[])object;
            byte[] byArray2 = (byte[])object2;
            int n = 0;
            int n2 = 0;
            while (n2 < byArray.length) {
                n = (byArray[n2] & 0xFF) - (byArray2[n2] & 0xFF);
                if (n < 0) {
                    return -1;
                }
                if (n > 0) {
                    return 1;
                }
                ++n2;
            }
            return 0;
        }
    }
}

