/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.io.Throttle;
import com.limegroup.gnutella.io.ThrottleListener;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NBThrottle
implements Throttle {
    private static final Log LOG;
    private static final int DEFAULT_TICK_TIME = 100;
    private final int MILLIS_PER_TICK;
    private final int MAXIMUM_TO_GIVE;
    private final int MINIMUM_TO_GIVE;
    private final boolean _write;
    private final int _processOp;
    private int _bytesPerTick;
    private int _available;
    private long _nextTickTime = -1L;
    private Set _requests = new HashSet();
    private Map _interested = new LinkedHashMap();
    private Map _ready = new HashMap();
    private boolean _active = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.io.NBThrottle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public NBThrottle(boolean bl, float f) {
        this(bl, f, true, 100);
    }

    public NBThrottle(boolean bl, float f, int n, int n2) {
        this(bl, f, true, n == 0 ? 100 : n2 / n);
    }

    protected NBThrottle(boolean bl, float f, boolean bl2, int n) {
        this.MILLIS_PER_TICK = Math.min(100, Math.max(50, n));
        int n2 = 1000 / this.MILLIS_PER_TICK;
        this._write = bl;
        this._processOp = bl ? 4 : 1;
        this._bytesPerTick = (int)(f / (float)n2);
        if (bl2) {
            NIODispatcher.instance().addThrottle(this);
        }
        if (bl) {
            this.MAXIMUM_TO_GIVE = 1400;
            this.MINIMUM_TO_GIVE = 30;
        } else {
            this.MAXIMUM_TO_GIVE = Integer.MAX_VALUE;
            this.MINIMUM_TO_GIVE = 0;
        }
    }

    public void setRate(float f) {
        int n = 1000 / this.MILLIS_PER_TICK;
        this._bytesPerTick = (int)(f / (float)n);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void selectableKeys(Collection collection) {
        if (this._available >= this.MINIMUM_TO_GIVE && !this._interested.isEmpty()) {
            Object object;
            long l;
            Iterator iterator = collection.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this._active = true;
                    l = System.currentTimeMillis();
                    object = this._interested.entrySet().iterator();
                    break;
                }
                SelectionKey selectionKey = (SelectionKey)iterator.next();
                try {
                    if (!selectionKey.isValid() || !(this._write ? selectionKey.isWritable() : selectionKey.isReadable()) || !this._interested.containsKey(object = NIODispatcher.instance().attachment(selectionKey.attachment()))) continue;
                    this._ready.put(object, selectionKey);
                }
                catch (CancelledKeyException cancelledKeyException) {
                    iterator.remove();
                }
            }
            while (!this._ready.isEmpty() && object.hasNext()) {
                Object var9_10;
                Map.Entry entry = object.next();
                ThrottleListener throttleListener = (ThrottleListener)entry.getValue();
                Object k = entry.getKey();
                SelectionKey selectionKey = (SelectionKey)this._ready.remove(k);
                if (!throttleListener.isOpen()) {
                    object.remove();
                    continue;
                }
                if (selectionKey == null) continue;
                throttleListener.requestBandwidth();
                try {
                    NIODispatcher.instance().process(l, selectionKey, selectionKey.attachment(), this._processOp);
                }
                catch (Throwable throwable) {
                    var9_10 = null;
                    throttleListener.releaseBandwidth();
                    throw throwable;
                }
                {
                    var9_10 = null;
                    throttleListener.releaseBandwidth();
                    object.remove();
                    if (this._available >= this.MINIMUM_TO_GIVE) continue;
                }
            }
            this._active = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interest(ThrottleListener throttleListener) {
        Set set = this._requests;
        synchronized (set) {
            this._requests.add(throttleListener);
        }
    }

    public int request() {
        if (!this._active) {
            return 0;
        }
        int n = Math.min(this._available, this.MAXIMUM_TO_GIVE);
        this._available -= n;
        return n;
    }

    public void release(int n) {
        if (this._active) {
            this._available += n;
        }
    }

    void tick(long l) {
        if (l >= this._nextTickTime) {
            this._available = this._bytesPerTick;
            this._nextTickTime = l + (long)this.MILLIS_PER_TICK;
            this.spreadBandwidth();
        } else if (this._available > this.MINIMUM_TO_GIVE) {
            this.spreadBandwidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spreadBandwidth() {
        Set set = this._requests;
        synchronized (set) {
            if (!this._requests.isEmpty()) {
                Iterator iterator = this._requests.iterator();
                while (iterator.hasNext()) {
                    ThrottleListener throttleListener = (ThrottleListener)iterator.next();
                    Object object = throttleListener.getAttachment();
                    if (object == null) {
                        throw new IllegalStateException("must have an attachment");
                    }
                    if (this._interested.containsKey(object) || !throttleListener.bandwidthAvailable()) continue;
                    this._interested.put(object, throttleListener);
                }
                this._requests.clear();
            }
        }
    }
}

